/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.config;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class ConfigStringArray
implements ElementoConfig<List<String>> {
    private final String clave;
    public Supplier<String> nombre;
    public List<String> def;

    private ConfigStringArray(String clave, List<String> def) {
        this.clave = clave;
        this.def = def;
    }

    @Override
    public String clave() {
        return this.clave;
    }

    @Override
    public List<String> obtener() {
        String valor = Config.obtenerInstancia().propiedadesConfig.getProperty(this.clave);
        if (valor == null) {
            throw new IllegalArgumentException("La clave de configuraci\u00f3n no existe: " + this.clave);
        }
        if (valor.isEmpty()) {
            return new ArrayList<String>();
        }
        return ConfigStringArray.decodeLista(valor);
    }

    @Override
    public void escribir(List<String> valores) {
        String joined = ConfigStringArray.encodeLista(valores);
        Config.obtenerInstancia().propiedadesConfig.setProperty(this.clave, joined);
        Config.obtenerInstancia().guardar();
    }

    public static ConfigStringArray de(String clave, List<String> valoresPorDefecto) {
        Config config = Config.obtenerInstancia();
        String existente = config.propiedadesConfig.getProperty(clave);
        if (existente == null) {
            String joined = ConfigStringArray.encodeLista(valoresPorDefecto);
            config.propiedadesConfig.setProperty(clave, joined);
            config.guardar();
        }
        return new ConfigStringArray(clave, valoresPorDefecto);
    }

    @Override
    public String obtenerNombreParaMostrar() {
        if (this.nombre != null && this.nombre.get() != null) {
            return this.nombre.get();
        }
        return this.clave;
    }

    @Override
    public void establecerNombreParaMostrar(Supplier<String> nombre) {
        this.nombre = nombre;
    }

    private static String encodeLista(List<String> valores) {
        if (valores == null || valores.isEmpty()) {
            return "";
        }
        ArrayList<String> partes = new ArrayList<String>(valores.size());
        for (String s : valores) {
            partes.add(ConfigStringArray.escape(s == null ? "" : s));
        }
        return String.join((CharSequence)";", partes);
    }

    private static List<String> decodeLista(String valor) {
        if (valor.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> resultado = new ArrayList<String>();
        StringBuilder actual = new StringBuilder();
        boolean escapando = false;
        for (int i = 0; i < valor.length(); ++i) {
            char c = valor.charAt(i);
            if (escapando) {
                actual.append(c);
                escapando = false;
                continue;
            }
            if (c == '\\') {
                escapando = true;
                continue;
            }
            if (c == ';') {
                resultado.add(actual.toString());
                actual.setLength(0);
                continue;
            }
            actual.append(c);
        }
        resultado.add(actual.toString());
        return resultado;
    }

    private static String escape(String s) {
        StringBuilder out = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                out.append("\\\\");
                continue;
            }
            if (c == ';') {
                out.append("\\;");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    @Override
    public List<String> obtenerValorPorDefecto() {
        return this.def;
    }
}

