/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.detectorlanzer;

import com.asbestosstar.crashdetector.App;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorATLauncher;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorBattly;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorCrystalLauncher;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorCurseForgeApp;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorCurseMojang;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorFTBApp;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorFeather;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorGDL;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorHMCL;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorHeliosLauncher;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorKLauncher;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorLabyMod;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorLanzerCreativeMode;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorLauncherFenix;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorLunar;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorMinecraftLauncher;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorMinecraftServer;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorMultiMC;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorNightWorld;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorNoRiskClient;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorPCL;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorPCLCE;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorPolyMC;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorPrismLauncher;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorSKLauncher;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorTL;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorTLLegacy;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorTLLegacyFlatpak;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorTLMods;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorTheseus;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorXMLC;
import com.asbestosstar.crashdetector.detectorlanzer.LanzerOtra;
import java.util.ArrayList;
import java.util.List;

public interface DetectorLanzer {
    public static final List<DetectorLanzer> DETECTORES_DE_LANZERES = new ArrayList<DetectorLanzer>();
    public static final DetectorLanzer OTRA = new LanzerOtra();

    public static void registrarLanzeresDefectos() {
        DETECTORES_DE_LANZERES.add(new DetectorTLMods());
        DETECTORES_DE_LANZERES.add(new DetectorTLLegacyFlatpak());
        DETECTORES_DE_LANZERES.add(new DetectorTLLegacy());
        DETECTORES_DE_LANZERES.add(new DetectorTL());
        DETECTORES_DE_LANZERES.add(new DetectorHMCL());
        DETECTORES_DE_LANZERES.add(new DetectorPrismLauncher());
        DETECTORES_DE_LANZERES.add(new DetectorATLauncher());
        DETECTORES_DE_LANZERES.add(new DetectorGDL());
        DETECTORES_DE_LANZERES.add(new DetectorCurseForgeApp());
        DETECTORES_DE_LANZERES.add(new DetectorCurseMojang());
        DETECTORES_DE_LANZERES.add(new DetectorKLauncher());
        DETECTORES_DE_LANZERES.add(new DetectorPCLCE());
        DETECTORES_DE_LANZERES.add(new DetectorPCL());
        DETECTORES_DE_LANZERES.add(new DetectorNightWorld());
        DETECTORES_DE_LANZERES.add(new DetectorFTBApp());
        DETECTORES_DE_LANZERES.add(new DetectorXMLC());
        DETECTORES_DE_LANZERES.add(new DetectorHeliosLauncher());
        DETECTORES_DE_LANZERES.add(new DetectorMinecraftServer());
        DETECTORES_DE_LANZERES.add(new DetectorSKLauncher());
        DETECTORES_DE_LANZERES.add(new DetectorFeather());
        DETECTORES_DE_LANZERES.add(new DetectorLunar());
        DETECTORES_DE_LANZERES.add(new DetectorLabyMod());
        DETECTORES_DE_LANZERES.add(new DetectorNoRiskClient());
        DETECTORES_DE_LANZERES.add(new DetectorTheseus());
        DETECTORES_DE_LANZERES.add(new DetectorCrystalLauncher());
        DETECTORES_DE_LANZERES.add(new DetectorMultiMC());
        DETECTORES_DE_LANZERES.add(new DetectorPolyMC());
        DETECTORES_DE_LANZERES.add(new DetectorLanzerCreativeMode());
        DETECTORES_DE_LANZERES.add(new DetectorMinecraftLauncher());
        DETECTORES_DE_LANZERES.add(new DetectorBattly());
        DETECTORES_DE_LANZERES.add(new DetectorLauncherFenix());
    }

    public static String detectarLanzer(App app, String cmd) {
        if (!app.equals(App.MINECRAFT)) {
            return OTRA.id();
        }
        for (DetectorLanzer detector : DETECTORES_DE_LANZERES) {
            if (!detector.detectar(app, cmd)) continue;
            return detector.id();
        }
        return OTRA.id();
    }

    public String id();

    public boolean animado();

    public boolean desanimado();

    public boolean detectar(App var1, String var2);

    default public boolean buscarClase(String className) {
        if (this.cargarClase(className, this.getClass().getClassLoader())) {
            return true;
        }
        ClassLoader parentLoader = this.getClass().getClassLoader().getParent();
        if (this.cargarClase(className, parentLoader)) {
            return true;
        }
        return this.buscarEnTodosLosClassLoaders(className);
    }

    default public boolean cargarClase(String className, ClassLoader classLoader) {
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    default public boolean buscarEnTodosLosClassLoaders(String className) {
        for (ClassLoader loader = ClassLoader.getSystemClassLoader(); loader != null; loader = loader.getParent()) {
            if (!this.cargarClase(className, loader)) continue;
            return true;
        }
        return false;
    }
}

