/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.detectorlanzer;

import com.asbestosstar.crashdetector.App;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorLanzer;
import java.io.File;

public class DetectorLauncherFenix
implements DetectorLanzer {
    private static final long OCHO_HORAS_EN_MILISEGUNDOS = 28800000L;

    @Override
    public String id() {
        return "launcherfenix";
    }

    @Override
    public boolean animado() {
        return false;
    }

    @Override
    public boolean desanimado() {
        return true;
    }

    @Override
    public boolean detectar(App app, String cmd) {
        if (!app.equals(App.MINECRAFT)) {
            return false;
        }
        String directorioMinecraft = DetectorLauncherFenix.obtenerDirectorioMinecraftPredeterminado();
        if (directorioMinecraft == null) {
            return false;
        }
        File archivoLauncherFenix = new File(directorioMinecraft, "launcherfenix.jar");
        if (!archivoLauncherFenix.exists() || !archivoLauncherFenix.isFile()) {
            return false;
        }
        long ultimaModificacion = archivoLauncherFenix.lastModified();
        long ahora = System.currentTimeMillis();
        return ahora - ultimaModificacion <= 28800000L;
    }

    private static String obtenerDirectorioMinecraftPredeterminado() {
        String sistemaOperativo = System.getProperty("os.name", "").toLowerCase();
        if (sistemaOperativo.contains("win")) {
            String appData = System.getenv("APPDATA");
            if (appData != null) {
                return new File(appData, ".minecraft").getAbsolutePath();
            }
        } else if (sistemaOperativo.contains("mac")) {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                return new File(userHome, "Library/Application Support/minecraft").getAbsolutePath();
            }
        } else {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                return new File(userHome, ".minecraft").getAbsolutePath();
            }
        }
        return null;
    }
}

