/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.detectorlanzer;

import com.asbestosstar.crashdetector.App;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorLanzer;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class DetectorMinecraftLauncher
implements DetectorLanzer {
    private static final long horaInicioJvm = DetectorMinecraftLauncher.obtenerHoraInicioJvm();

    private static long obtenerHoraInicioJvm() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        return bean.getStartTime();
    }

    @Override
    public String id() {
        return "minecraft_launcher";
    }

    @Override
    public boolean animado() {
        return true;
    }

    @Override
    public boolean desanimado() {
        return false;
    }

    @Override
    public boolean detectar(App app, String cmd) {
        if (!app.equals(App.MINECRAFT)) {
            return false;
        }
        if (!cmd.contains("-Dminecraft.launcher.brand=minecraft-launcher")) {
            return false;
        }
        String directorioUsuario = System.getProperty("user.dir", "");
        File archivoLog = new File(directorioUsuario, "launcher_log.txt");
        if (!archivoLog.exists() || !archivoLog.isFile()) {
            return false;
        }
        long ultimaModificacion = archivoLog.lastModified();
        return ultimaModificacion > horaInicioJvm;
    }
}

