/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.detectorlanzer;

import com.asbestosstar.crashdetector.App;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorLanzer;

public class DetectorTLLegacyFlatpak
implements DetectorLanzer {
    @Override
    public String id() {
        return "tl_legacy_flatpak";
    }

    @Override
    public boolean animado() {
        return false;
    }

    @Override
    public boolean desanimado() {
        return true;
    }

    @Override
    public boolean detectar(App app, String cmd) {
        if (!app.equals(App.MINECRAFT)) {
            return false;
        }
        String userDir = System.getProperty("user.dir", "");
        boolean enFlatpak = userDir.contains(".var/app/");
        if (!enFlatpak) {
            return false;
        }
        String normalizedCmd = cmd.replace('\\', '/');
        return normalizedCmd.contains(".tlauncher/legacy/Minecraft/game/");
    }
}

