/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.divisor;

import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.divisor.DivisorDeArchivos;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class HolaMundoConsolaDivisidor
implements DivisorDeArchivos {
    public static String HOLA_MUNDO = "HOLA MUNDO DESDE CRASHDETECTOR";
    public static List<String> lista_denegar = new ArrayList<String>();

    @Override
    public int obtenerLineaOriginal(String contentido_existente) {
        String[] lineas = contentido_existente.split(Verificaciones.nl);
        int ultima = 0;
        for (int i = 0; i < lineas.length - 1; ++i) {
            String lin = lineas[i];
            if (!lin.contains(HOLA_MUNDO)) continue;
            ultima = i;
        }
        return ultima;
    }

    @Override
    public boolean predicado(Path archivo, String contento_existe) {
        String completa = archivo.toAbsolutePath().toString();
        for (String denegar : lista_denegar) {
            if (!completa.toLowerCase().contains(denegar.toLowerCase())) continue;
            return false;
        }
        return contento_existe.contains(HOLA_MUNDO);
    }

    static {
        lista_denegar.add("cd_launcherlog");
        lista_denegar.add("latest.log");
        lista_denegar.add("debug.log");
        lista_denegar.add("tlauncher");
        lista_denegar.add("hs_");
    }
}

