/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.dto.modpack.curseforge;

import com.asbestosstar.crashdetector.dto.modpack.InternetMod;
import com.asbestosstar.crashdetector.dto.modpack.VersionJuego;
import com.asbestosstar.crashdetector.dto.modpack.curseforge.VersionJuegoCurseForge;
import com.asbestosstar.crashdetector.json.Json;
import java.time.Instant;

public class ModCurseForge
extends InternetMod {
    private final long identificador;
    private final String nombre;
    private final String autor;
    private final String enlaceProyecto;
    private final String descripcionCorta;
    private final boolean favorito;
    private final String nombreLocalizado;
    private final VersionJuegoCurseForge ultimaVersionJuego;
    private final long actualizado;
    private final long descargasTotales;
    private final boolean disponible;
    private final boolean analizable;
    private final String urlIcono;

    public ModCurseForge(Json.Nodo nodo) {
        Json.Nodo primerArchivo;
        Json.Nodo versionesJuego;
        this.identificador = nodo.obtener("id").comoLargo();
        this.nombre = nodo.obtener("name").comoCadena();
        this.descripcionCorta = nodo.obtener("summary").comoCadena();
        String autorTmp = "";
        Json.Nodo autores = nodo.obtener("authors");
        if (autores.esArreglo() && autores.tamano() > 0) {
            autorTmp = autores.en(0).obtener("name").comoCadena();
        }
        this.autor = autorTmp;
        this.enlaceProyecto = nodo.obtener("links").obtener("websiteUrl").comoCadena();
        String fechaStr = nodo.obtener("dateModified").comoCadena();
        this.actualizado = fechaStr.isEmpty() ? 0L : Instant.parse(fechaStr).toEpochMilli();
        this.descargasTotales = nodo.obtener("downloadCount").comoLargo();
        this.disponible = nodo.obtener("isAvailable").comoBooleano();
        String iconoTmp = null;
        Json.Nodo logo = nodo.obtener("logo");
        if (logo != null) {
            String thumb = logo.obtener("thumbnailUrl").comoCadena();
            if (thumb != null && !thumb.isEmpty()) {
                iconoTmp = thumb;
            } else {
                String url = logo.obtener("url").comoCadena();
                if (url != null && !url.isEmpty()) {
                    iconoTmp = url;
                }
            }
        }
        VersionJuegoCurseForge ultimaTmp = null;
        Json.Nodo latestFiles = nodo.obtener("latestFiles");
        if (latestFiles.esArreglo() && latestFiles.tamano() > 0 && (versionesJuego = (primerArchivo = latestFiles.en(0)).obtener("gameVersions")).esArreglo() && versionesJuego.tamano() > 0) {
            String nombreVersion = versionesJuego.en(0).comoCadena();
            ultimaTmp = new VersionJuegoCurseForge(nombreVersion);
        }
        this.urlIcono = iconoTmp;
        this.ultimaVersionJuego = ultimaTmp;
        this.favorito = false;
        this.nombreLocalizado = this.nombre;
        this.analizable = false;
    }

    @Override
    public long obtenerIdentificador() {
        return this.identificador;
    }

    @Override
    public String obtenerNombre() {
        return this.nombre;
    }

    @Override
    public String obtenerAutor() {
        return this.autor;
    }

    @Override
    public String obtenerEnlaceProyecto() {
        return this.enlaceProyecto;
    }

    @Override
    public String obtenerDescripcionCorta() {
        return this.descripcionCorta;
    }

    @Override
    public boolean esFavorito() {
        return this.favorito;
    }

    @Override
    public String obtenerNombreLocalizado() {
        return this.nombreLocalizado;
    }

    @Override
    public VersionJuego obtenerUltimaVersionJuego() {
        return this.ultimaVersionJuego;
    }

    @Override
    public long obtenerActualizado() {
        return this.actualizado;
    }

    @Override
    public long obtenerDescargasTotales() {
        return this.descargasTotales;
    }

    @Override
    public boolean esDisponible() {
        return this.disponible;
    }

    @Override
    public boolean esAnalizable() {
        return this.analizable;
    }

    @Override
    public String urlIcon() {
        return this.urlIcono;
    }
}

