/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.dto.modpack.tlmods;

import com.asbestosstar.crashdetector.dto.modpack.PaginaMods;
import com.asbestosstar.crashdetector.dto.modpack.tlmods.RespuestaPaginadaModsTlmods;
import com.asbestosstar.crashdetector.json.Json;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class SolicitudBusquedaModsTlmods {
    private static final String URL_BASE = "https://tlmods.org/api/client/gameentities";
    private static final String AGENTE_USUARIO = "TLauncher/2.88";

    public static PaginaMods buscarMods(String idioma, int pagina, String termino) throws IOException {
        StringBuilder constructorUrl = new StringBuilder(URL_BASE);
        constructorUrl.append("?type=MOD").append("&lang=").append(idioma).append("&page=").append(pagina).append("&sort=POPULAR").append("&lv=2.88");
        if (termino != null && !termino.trim().isEmpty()) {
            String codificado = URLEncoder.encode(termino.trim());
            constructorUrl.append("&search=").append(codificado);
        }
        String urlCompleta = constructorUrl.toString();
        URL url = new URL(urlCompleta);
        HttpURLConnection conexion = (HttpURLConnection)url.openConnection();
        conexion.setRequestMethod("GET");
        conexion.setRequestProperty("Accept", "application/json");
        conexion.setRequestProperty("User-Agent", AGENTE_USUARIO);
        int codigo = conexion.getResponseCode();
        if (codigo != 200) {
            throw new IOException("HTTP " + codigo + " desde " + urlCompleta);
        }
        try {
            RespuestaPaginadaModsTlmods respuestaPaginadaModsTlmods;
            try (BufferedReader lector = new BufferedReader(new InputStreamReader(conexion.getInputStream(), StandardCharsets.UTF_8));){
                String linea;
                StringBuilder contenido = new StringBuilder();
                while ((linea = lector.readLine()) != null) {
                    contenido.append(linea);
                }
                Json.Nodo raiz = Json.leer(contenido.toString());
                respuestaPaginadaModsTlmods = new RespuestaPaginadaModsTlmods(raiz);
            }
            return respuestaPaginadaModsTlmods;
        }
        finally {
            conexion.disconnect();
        }
    }
}

