/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.grepr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class BusquedaArchivos {
    private static final Set<String> EXT_COMPRIMIDOS_ZIP = new HashSet<String>(Arrays.asList(".zip", ".jar", ".war", ".ear", ".fpm", ".litemod"));
    private static final String EXT_RAR = ".rar";
    private static final int PROFUNDIDAD_MAX_ANIDADO = 2;

    public static List<String> buscar(String directorio, String cadenaBusqueda, boolean usarRegex, boolean ignorarMayusculas) {
        return BusquedaArchivos.buscar(directorio, cadenaBusqueda, usarRegex, ignorarMayusculas, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> buscar(String directorio, String cadenaBusqueda, boolean usarRegex, final boolean ignorarMayusculas, final boolean buscarEnComprimidos) {
        List archivos;
        String literalTextoISO;
        byte[] literalBytes;
        Pattern patron;
        final ConcurrentLinkedQueue<String> resultados = new ConcurrentLinkedQueue<String>();
        if (usarRegex) {
            int flags = ignorarMayusculas ? 66 : 0;
            patron = Pattern.compile(cadenaBusqueda, flags);
            literalBytes = null;
            literalTextoISO = null;
        } else {
            patron = null;
            literalBytes = cadenaBusqueda.getBytes(StandardCharsets.ISO_8859_1);
            literalTextoISO = ignorarMayusculas ? cadenaBusqueda.toLowerCase(Locale.ROOT) : cadenaBusqueda;
        }
        try (Stream<Path> stream = Files.walk(Paths.get(directorio, new String[0]), new FileVisitOption[0]);){
            archivos = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Arrays.asList("Error al recorrer directorio " + e.getMessage());
        }
        int hilos = Math.max(1, Runtime.getRuntime().availableProcessors());
        ExecutorService pool = Executors.newFixedThreadPool(hilos);
        try {
            ArrayList futures = new ArrayList(archivos.size());
            for (final Path path : archivos) {
                futures.add(pool.submit(new Runnable(){

                    @Override
                    public void run() {
                        String nombre = path.getFileName().toString();
                        String lower = nombre.toLowerCase(Locale.ROOT);
                        try {
                            if (buscarEnComprimidos && BusquedaArchivos.terminaCon(lower, EXT_COMPRIMIDOS_ZIP)) {
                                BusquedaArchivos.buscarDentroDeZip(path, resultados, patron, literalBytes, literalTextoISO, ignorarMayusculas, 0, path.toAbsolutePath().toString());
                                return;
                            }
                            if (buscarEnComprimidos && lower.endsWith(BusquedaArchivos.EXT_RAR)) {
                                if (BusquedaArchivos.cabeceraPareceZip(path)) {
                                    BusquedaArchivos.buscarDentroDeZip(path, resultados, patron, literalBytes, literalTextoISO, ignorarMayusculas, 0, path.toAbsolutePath().toString());
                                } else if (BusquedaArchivos.cabeceraPareceRar(path)) {
                                    resultados.add(path.toAbsolutePath() + " [OMITIDO rar real no soportado]");
                                } else {
                                    BusquedaArchivos.procesarArchivoPlano(path, resultados, patron, literalBytes, literalTextoISO, ignorarMayusculas);
                                }
                                return;
                            }
                            BusquedaArchivos.procesarArchivoPlano(path, resultados, patron, literalBytes, literalTextoISO, ignorarMayusculas);
                        }
                        catch (IOException e) {
                            resultados.add(path.toAbsolutePath() + " [ERROR " + e.getMessage() + "]");
                        }
                    }
                }));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    resultados.add("Busqueda interrumpida");
                }
                catch (ExecutionException ee) {
                    resultados.add("Error en tarea " + ee.getCause());
                }
            }
        }
        finally {
            pool.shutdown();
        }
        return new ArrayList<String>(resultados);
    }

    private static boolean coincideContenido(byte[] contenidoBytes, Pattern patron, byte[] literalBytes, String literalTextoISO, boolean ignorarMayusculas) {
        if (patron != null) {
            String texto = new String(contenidoBytes, StandardCharsets.ISO_8859_1);
            return patron.matcher(texto).find();
        }
        if (ignorarMayusculas) {
            String texto = new String(contenidoBytes, StandardCharsets.ISO_8859_1);
            return texto.toLowerCase(Locale.ROOT).contains(literalTextoISO);
        }
        return BusquedaArchivos.indexOf(contenidoBytes, literalBytes) >= 0;
    }

    private static int indexOf(byte[] data, byte[] pattern) {
        if (pattern.length == 0) {
            return 0;
        }
        int[] lps = BusquedaArchivos.buildLps(pattern);
        int i = 0;
        int j = 0;
        while (i < data.length) {
            if (data[i] == pattern[j]) {
                ++i;
                if (++j != pattern.length) continue;
                return i - j;
            }
            if (j != 0) {
                j = lps[j - 1];
                continue;
            }
            ++i;
        }
        return -1;
    }

    private static int[] buildLps(byte[] pat) {
        int[] lps = new int[pat.length];
        int len = 0;
        int i = 1;
        while (i < pat.length) {
            if (pat[i] == pat[len]) {
                lps[i] = ++len;
                ++i;
                continue;
            }
            if (len != 0) {
                len = lps[len - 1];
                continue;
            }
            lps[i] = 0;
            ++i;
        }
        return lps;
    }

    private static void procesarArchivoPlano(Path ruta, ConcurrentLinkedQueue<String> resultados, Pattern patron, byte[] literalBytes, String literalTextoISO, boolean ignorarMayusculas) throws IOException {
        byte[] bytes = Files.readAllBytes(ruta);
        if (bytes.length == 0) {
            return;
        }
        if (BusquedaArchivos.coincideContenido(bytes, patron, literalBytes, literalTextoISO, ignorarMayusculas)) {
            resultados.add(ruta.toAbsolutePath().toString());
        }
    }

    private static boolean terminaCon(String lowerName, Set<String> extensiones) {
        for (String ext : extensiones) {
            if (!lowerName.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cabeceraPareceZip(Path ruta) {
        InputStream in = null;
        try {
            in = Files.newInputStream(ruta, new OpenOption[0]);
            byte[] sig = new byte[4];
            int r = in.read(sig);
            if (r >= 2) {
                boolean bl = sig[0] == 80 && sig[1] == 75;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cabeceraPareceRar(Path ruta) {
        InputStream in = null;
        try {
            in = Files.newInputStream(ruta, new OpenOption[0]);
            byte[] sig = new byte[7];
            int r = in.read(sig);
            if (r >= 7) {
                boolean bl = sig[0] == 82 && sig[1] == 97 && sig[2] == 114 && sig[3] == 33 && sig[4] == 26 && sig[5] == 7;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buscarDentroDeZip(Path rutaZip, ConcurrentLinkedQueue<String> resultados, Pattern patron, byte[] literalBytes, String literalTextoISO, boolean ignorarMayusculas, int profundidad, String rutaVisual) throws IOException {
        try (ZipFile zip = new ZipFile(rutaZip.toFile());){
            Enumeration<? extends ZipEntry> entradas = zip.entries();
            while (entradas.hasMoreElements()) {
                ZipEntry entrada = entradas.nextElement();
                if (entrada.isDirectory()) continue;
                String nombreEntrada = entrada.getName();
                String lower = nombreEntrada.toLowerCase(Locale.ROOT);
                if (profundidad < 2 && BusquedaArchivos.terminaCon(lower, EXT_COMPRIMIDOS_ZIP)) {
                    byte[] bytesAnidado = BusquedaArchivos.leerEntrada(zip, entrada);
                    ZipInputStream zin = null;
                    try {
                        zin = new ZipInputStream(new ByteArrayInputStream(bytesAnidado));
                        BusquedaArchivos.procesarZipAnidado(zin, resultados, patron, literalBytes, literalTextoISO, ignorarMayusculas, profundidad + 1, rutaVisual + "!" + nombreEntrada);
                        continue;
                    }
                    finally {
                        if (zin == null) continue;
                        try {
                            zin.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                }
                byte[] bytes = BusquedaArchivos.leerEntrada(zip, entrada);
                if (bytes.length == 0 || !BusquedaArchivos.coincideContenido(bytes, patron, literalBytes, literalTextoISO, ignorarMayusculas)) continue;
                resultados.add(rutaZip.toAbsolutePath() + "!" + nombreEntrada);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void procesarZipAnidado(ZipInputStream zin, ConcurrentLinkedQueue<String> resultados, Pattern patron, byte[] literalBytes, String literalTextoISO, boolean ignorarMayusculas, int profundidad, String rutaVisual) throws IOException {
        ZipEntry e;
        while ((e = zin.getNextEntry()) != null) {
            if (e.isDirectory()) {
                zin.closeEntry();
                continue;
            }
            String nombreEntrada = e.getName();
            String lower = nombreEntrada.toLowerCase(Locale.ROOT);
            if (profundidad < 2 && BusquedaArchivos.terminaCon(lower, EXT_COMPRIMIDOS_ZIP)) {
                byte[] nested = BusquedaArchivos.leerTodo(zin);
                ZipInputStream zin2 = null;
                try {
                    zin2 = new ZipInputStream(new ByteArrayInputStream(nested));
                    BusquedaArchivos.procesarZipAnidado(zin2, resultados, patron, literalBytes, literalTextoISO, ignorarMayusculas, profundidad + 1, rutaVisual + "!" + nombreEntrada);
                }
                finally {
                    if (zin2 != null) {
                        try {
                            zin2.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            byte[] bytes = BusquedaArchivos.leerTodo(zin);
            if (bytes.length == 0) {
                zin.closeEntry();
                continue;
            }
            if (BusquedaArchivos.coincideContenido(bytes, patron, literalBytes, literalTextoISO, ignorarMayusculas)) {
                resultados.add(rutaVisual + "!" + nombreEntrada);
            }
            zin.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] leerEntrada(ZipFile zip, ZipEntry entrada) throws IOException {
        InputStream in = null;
        try {
            in = zip.getInputStream(entrada);
            byte[] byArray = BusquedaArchivos.leerTodo(in);
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static byte[] leerTodo(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(Math.max(32768, in.available()));
        byte[] buf = new byte[65536];
        while ((r = in.read(buf)) != -1) {
            bos.write(buf, 0, r);
        }
        return bos.toByteArray();
    }
}

