/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.cfr.CfrBase;
import com.asbestosstar.crashdetector.gui.tipos.cfr.CfrSakuraRiddle;
import com.asbestosstar.crashdetector.gui.tipos.lectador.LectadorDeConsolasGUI;
import com.asbestosstar.crashdetector.gui.tipos.lectador.LectadorDeConsolasHoloTalk;
import com.asbestosstar.crashdetector.gui.tipos.quickfix.ElementoQuickFixDemonSlayers;
import com.asbestosstar.crashdetector.gui.tipos.quickfix.QuickFixGUI;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.event.HyperlinkEvent;

public interface CrashDetectorGUI {
    public String id();

    public TipoGUI tipo();

    public void recargarApariencia();

    default public void recargar() {
        MonitorDePID.recargar(false, null);
        this.recargarApariencia();
    }

    default public boolean puedeEditarApariencia() {
        return true;
    }

    default public LinkedHashMap<String, String> mapaParaComboBoxIdiomas() {
        LinkedHashMap<String, String> idiomas = new LinkedHashMap<String, String>();
        idiomas.put("Espa\u00f1ol", "imagenes/bandera_mexico.png");
        idiomas.put("English", "imagenes/bandera_inglaterra.png");
        idiomas.put("\u0627\u0644\u0639\u0631\u0628\u064a\u0629", "imagenes/bandera_arabia.png");
        idiomas.put("Portugu\u00eas", "imagenes/bandera_brasil.png");
        idiomas.put("\u0641\u0627\u0631\u0633\u06cc", "imagenes/bandera_iran.png");
        idiomas.put("\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "imagenes/bandera_rusia.png");
        idiomas.put("\u7b80\u4f53\u4e2d\u6587", "imagenes/bandera_china.png");
        idiomas.put("Esperanto", "imagenes/bandera_esperanto.png");
        idiomas.put("\u65e5\u672c\u8a9e", "imagenes/bandera_japon.png");
        idiomas.put("\ud55c\uad6d\uc5b4", "imagenes/bandera_corea.png");
        return idiomas;
    }

    public static String obtenerCodigoIdioma(String nombreIdioma) {
        switch (nombreIdioma) {
            case "Espa\u00f1ol": {
                return "es";
            }
            case "English": {
                return "en";
            }
            case "\u0627\u0644\u0639\u0631\u0628\u064a\u0629": {
                return "ar";
            }
            case "Portugu\u00eas": {
                return "pt";
            }
            case "\u0641\u0627\u0631\u0633\u06cc": {
                return "fa";
            }
            case "\u0420\u0443\u0441\u0441\u043a\u0438\u0439": {
                return "ru";
            }
            case "\u7b80\u4f53\u4e2d\u6587": {
                return "zh";
            }
            case "Esperanto": {
                return "eo";
            }
            case "\u65e5\u672c\u8a9e": {
                return "ja";
            }
            case "\ud55c\uad6d\uc5b4": {
                return "ko";
            }
        }
        return "es";
    }

    default public String nombreDeIdiomaDesdeCondigo(String codigoActual) {
        switch (codigoActual) {
            case "es": {
                return "Espa\u00f1ol";
            }
            case "en": {
                return "English";
            }
            case "ar": {
                return "\u0627\u0644\u0639\u0631\u0628\u064a\u0629";
            }
            case "pt": {
                return "Portugu\u00eas";
            }
            case "fa": {
                return "\u0641\u0627\u0631\u0633\u06cc";
            }
            case "ru": {
                return "\u0420\u0443\u0441\u0441\u043a\u0438\u0439";
            }
            case "zh": {
                return "\u7b80\u4f53\u4e2d\u6587";
            }
            case "eo": {
                return "Esperanto";
            }
            case "ja": {
                return "\u65e5\u672c\u8a9e";
            }
            case "ko": {
                return "\ud55c\uad6d\uc5b4";
            }
        }
        return "Espa\u00f1ol";
    }

    public static void abrirDirectorioEnExplorador() {
        File directorio = new File(System.getProperty("user.dir"));
        if (directorio.exists() && directorio.isDirectory()) {
            try {
                Desktop.getDesktop().open(directorio);
            }
            catch (IOException e) {
                CrashDetectorLogger.logException(e);
            }
        }
    }

    public static boolean esMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    default public void enlanceEvento(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.abrirURL(e.getDescription());
        }
    }

    default public void abrirURL(String url) {
        try {
            if (url != null && url.startsWith("lectador://")) {
                CrashDetectorLogger.log(url + " (lectador url)");
                LectadorDeConsolasGUI lectador = TipoGUI.LECTADOR_DE_CONSOLAS.obtenerGUIPredeterminado(LectadorDeConsolasHoloTalk.ID, () -> new LectadorDeConsolasHoloTalk());
                lectador.procesarHipervinculo(url);
            } else if (url.startsWith("cfr://")) {
                CrashDetectorLogger.log(url + " (cfr url)");
                CfrBase gui = TipoGUI.CFR.obtenerGUIPredeterminado("sakura_riddle", CfrSakuraRiddle::new);
                gui.procesarHipervinculo(url);
            } else if (url.startsWith("quickfix://")) {
                CrashDetectorLogger.log(url + " (quickfix url)");
                QuickFixGUI gui = TipoGUI.QUICKFIX.obtenerGUIPredeterminado("demonslayers_elemento", ElementoQuickFixDemonSlayers::new);
                gui.constructir(MonitorDePID.analizador.obtenerQuickFixConEnlace(url));
            } else if (url != null) {
                CrashDetectorLogger.log(url);
                Desktop.getDesktop().browse(new URI(url));
            }
        }
        catch (Exception ex) {
            CrashDetectorLogger.logException(ex);
        }
    }

    public void init();

    public List<ElementoConfig> obtenerElementosConfigs();
}

