/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.elementos;

import com.asbestosstar.crashdetector.Statics;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ComboIdiomasConIcono
extends JComboBox<String> {
    private final Map<String, Icon> iconosPorEtiqueta = new LinkedHashMap<String, Icon>();
    private int anchoIcono = 18;
    private int altoIcono = 12;
    private int separacionIconoTexto = 8;

    public ComboIdiomasConIcono(LinkedHashMap<String, String> etiquetaARuta) {
        super(etiquetaARuta.keySet().toArray(new String[0]));
        for (Map.Entry<String, String> e : etiquetaARuta.entrySet()) {
            this.iconosPorEtiqueta.put(e.getKey(), this.cargarIconoLocal(e.getValue(), this.anchoIcono, this.altoIcono));
        }
        this.setRenderer(new Renderizador());
        this.setFocusable(true);
    }

    public void aplicarColores(Color fondo, Color texto) {
        Component c;
        this.setBackground(fondo);
        this.setForeground(texto);
        Component component = c = this.getEditor() != null ? this.getEditor().getEditorComponent() : null;
        if (c != null) {
            c.setBackground(fondo);
            c.setForeground(texto);
        }
    }

    private Icon cargarIconoLocal(String rutaRelativa, int w, int h) {
        try {
            File archivo = Statics.carpeta.resolve(rutaRelativa).toFile();
            if (!archivo.exists()) {
                return null;
            }
            ImageIcon base = new ImageIcon(archivo.getAbsolutePath());
            if (base.getIconWidth() <= 0 || base.getIconHeight() <= 0) {
                return base;
            }
            Image img = base.getImage().getScaledInstance(w, h, 4);
            return new ImageIcon(img);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private class Renderizador
    extends BasicComboBoxRenderer {
        private Renderizador() {
        }

        @Override
        public Component getListCellRendererComponent(JList lista, Object valor, int indice, boolean seleccionado, boolean foco) {
            JLabel lbl = (JLabel)super.getListCellRendererComponent((JList<?>)lista, valor, indice, seleccionado, foco);
            String etiqueta = valor != null ? valor.toString() : "";
            Icon icono = (Icon)ComboIdiomasConIcono.this.iconosPorEtiqueta.get(etiqueta);
            lbl.setIcon(icono);
            lbl.setText(etiqueta);
            lbl.setIconTextGap(ComboIdiomasConIcono.this.separacionIconoTexto);
            lbl.setHorizontalAlignment(2);
            lbl.setOpaque(true);
            if (seleccionado) {
                lbl.setBackground(lista.getSelectionBackground());
                lbl.setForeground(lista.getSelectionForeground());
            } else {
                lbl.setBackground(lista.getBackground());
                lbl.setForeground(lista.getForeground());
            }
            int altoFila = Math.max(lista.getFixedCellHeight() > 0 ? lista.getFixedCellHeight() : 0, Math.max(lbl.getFontMetrics(lbl.getFont()).getHeight(), ComboIdiomasConIcono.this.altoIcono) + 4);
            if (lista.getFixedCellHeight() <= 0) {
                lista.setFixedCellHeight(altoFila);
            }
            return lbl;
        }
    }
}

