/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.elementos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class NumeradorDeLineas
extends JPanel {
    private final JList<String> lista;
    private int anchoCache = -1;

    public NumeradorDeLineas(JList<String> lista) {
        this.lista = lista;
        this.setBackground(new Color(25, 25, 25));
        this.setForeground(Color.LIGHT_GRAY);
        this.setFont(lista.getFont());
        lista.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                NumeradorDeLineas.this.recalcularYActualizar();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                NumeradorDeLineas.this.recalcularYActualizar();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                NumeradorDeLineas.this.recalcularYActualizar();
            }
        });
        lista.addPropertyChangeListener("font", evt -> {
            this.setFont(lista.getFont());
            this.recalcularYActualizar();
        });
        this.recalcularYActualizar();
    }

    private void recalcularYActualizar() {
        this.anchoCache = -1;
        this.revalidate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        int lineas = this.lista.getModel().getSize();
        int digitos = Math.min(6, Math.max(3, String.valueOf(Math.max(1, lineas)).length()));
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int ancho = fm.charWidth('0') * digitos + 10;
        return new Dimension(ancho, Integer.MAX_VALUE);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle r;
        super.paintComponent(g);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int primero = this.lista.getFirstVisibleIndex();
        int ultimo = this.lista.getLastVisibleIndex();
        if (primero == -1 || ultimo == -1) {
            return;
        }
        FontMetrics fm = g.getFontMetrics(this.lista.getFont());
        int fixedH = this.lista.getFixedCellHeight();
        int alturaLinea = fixedH > 0 ? fixedH : ((r = this.lista.getCellBounds(primero, primero)) != null ? r.height : fm.getHeight());
        int anchoPreferido = this.getPreferredSize().width;
        int baseX = anchoPreferido - 5;
        for (int i = primero; i <= ultimo; ++i) {
            Rectangle bounds = this.lista.getCellBounds(i, i);
            if (bounds == null) continue;
            int y = bounds.y + (bounds.height + fm.getAscent() - fm.getDescent()) / 2;
            String texto = String.valueOf(i + 1);
            int textWidth = fm.stringWidth(texto);
            g.setColor(this.getForeground());
            g.drawString(texto, baseX - textWidth, y);
        }
    }
}

