/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.antimanipulacion;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.json.Json;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public abstract class AntiManipulacionGUI
extends JDialog
implements CrashDetectorGUI {
    private static final long serialVersionUID = 1L;
    public static final Map<String, Supplier<AntiManipulacionGUI>> GUIS = new HashMap<String, Supplier<AntiManipulacionGUI>>();
    protected static final Path ARCHIVO = Statics.carpeta.resolve("antimanipulacion.json");
    protected final Path baseDir = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath();
    protected final Set<String> rutasProtegidas = new LinkedHashSet<String>();
    protected JTable tabla;
    protected DefaultTableModel modelo;

    protected void inicializarModeloTabla() {
        this.modelo = new DefaultTableModel(new Object[]{MonitorDePID.idioma.rutaArchivo()}, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int r, int c) {
                return false;
            }
        };
        this.tabla = new JTable(this.modelo);
        this.tabla.setRowHeight(24);
    }

    protected void seleccionar(boolean carpeta) {
        JFileChooser fc = new JFileChooser(this.baseDir.toFile());
        fc.setFileSelectionMode(carpeta ? 1 : 0);
        if (fc.showOpenDialog(this) != 0) {
            return;
        }
        Path seleccionado = fc.getSelectedFile().toPath().toAbsolutePath();
        if (!seleccionado.startsWith(this.baseDir)) {
            JOptionPane.showMessageDialog(this, MonitorDePID.idioma.errorRutaFueraDirectorio(), MonitorDePID.idioma.error(), 0);
            return;
        }
        try {
            if (carpeta) {
                Files.walk(seleccionado, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> this.rutasProtegidas.add(this.baseDir.relativize((Path)p).toString()));
            } else {
                this.rutasProtegidas.add(this.baseDir.relativize(seleccionado).toString());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
        this.recargarTabla();
    }

    protected void quitarSeleccionado() {
        int fila = this.tabla.getSelectedRow();
        if (fila < 0) {
            return;
        }
        Object val = this.modelo.getValueAt(fila, 0);
        if (val != null) {
            this.rutasProtegidas.remove(val.toString());
        }
        this.recargarTabla();
    }

    protected void recargarTabla() {
        this.modelo.setRowCount(0);
        for (String r : this.rutasProtegidas) {
            this.modelo.addRow(new Object[]{r});
        }
    }

    protected void cargarDatos() {
        this.rutasProtegidas.clear();
        if (!Files.exists(ARCHIVO, new LinkOption[0])) {
            return;
        }
        try {
            String json = new String(Files.readAllBytes(ARCHIVO), StandardCharsets.UTF_8);
            if (json.trim().isEmpty()) {
                return;
            }
            Json.Nodo raiz = Json.leer(json);
            if (!raiz.esArreglo()) {
                return;
            }
            for (int i = 0; i < raiz.tamano(); ++i) {
                String v;
                Json.Nodo r;
                Json.Nodo n = raiz.en(i);
                if (n == null || !n.esObjeto() || (r = n.obtener("ruta")) == null || r.esObjeto() || r.esArreglo() || (v = r.comoCadena()) == null || v.isEmpty()) continue;
                this.rutasProtegidas.add(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void guardarDatos() {
        try {
            Json.Nodo raiz = Json.leer("[]");
            for (String r : this.rutasProtegidas) {
                Json.Nodo obj = Json.crearObjeto();
                obj.obtener("ruta").poner(r);
                raiz.agregar(obj);
            }
            Files.write(ARCHIVO, raiz.aBytesUtf8(), new OpenOption[0]);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), MonitorDePID.idioma.error(), 0);
        }
    }

    @Override
    public TipoGUI tipo() {
        return TipoGUI.ANTI_MANIPULACION;
    }
}

