/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.antimanipulacion;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.antimanipulacion.AntiManipulacionGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AntiManipulacionGUIPanko
extends AntiManipulacionGUI {
    private static final long serialVersionUID = 1L;
    public static final String ID = "komachi_panko";
    public static final File IMAGEN = Statics.carpeta.resolve("imagenes/panko.png").toFile();
    private ConfigColor colorFondo;
    private ConfigColor colorTexto;
    private ConfigColor colorCaja;
    private ConfigColor colorBorde;

    public AntiManipulacionGUIPanko() {
        this.crearColoresTema();
    }

    @Override
    public void init() {
        this.crearColoresTema();
        this.cargarDatos();
        this.setTitle(MonitorDePID.idioma.nombre_antimanipulacion());
        this.setSize(960, 640);
        this.setModal(true);
        this.setLayout(new BorderLayout(8, 8));
        this.setDefaultCloseOperation(2);
        this.inicializarModeloTabla();
        this.recargarTabla();
        this.add((Component)this.crearPanelIzquierdo(), "West");
        this.add((Component)new JScrollPane(this.tabla), "Center");
        this.add((Component)this.crearPanelBotones(), "South");
        this.recargarApariencia();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void crearColoresTema() {
        this.colorFondo = ConfigColor.de("tema.panko.fondo", new Color(252, 245, 230));
        this.colorTexto = ConfigColor.de("tema.panko.texto", new Color(80, 60, 40));
        this.colorCaja = ConfigColor.de("tema.panko.caja", new Color(255, 250, 240));
        this.colorBorde = ConfigColor.de("tema.panko.borde", new Color(210, 170, 120));
    }

    private JPanel crearPanelIzquierdo() {
        JPanel p = new JPanel(new BorderLayout(8, 8));
        p.setPreferredSize(new Dimension(180, 0));
        JLabel img = new JLabel();
        if (IMAGEN.exists()) {
            ImageIcon ic = new ImageIcon(IMAGEN.getAbsolutePath());
            Image im = ic.getImage().getScaledInstance(163, -1, 4);
            img.setIcon(new ImageIcon(im));
            img.setHorizontalAlignment(0);
            img.setVerticalAlignment(1);
        }
        JLabel aviso = new JLabel("<html><div style='width:140px; text-align:left;'>" + MonitorDePID.idioma.advertenciaHashLento() + "</div></html>");
        aviso.setVerticalAlignment(1);
        p.add((Component)img, "North");
        p.add((Component)aviso, "South");
        return p;
    }

    private JPanel crearPanelBotones() {
        JPanel p = new JPanel();
        JButton archivo = new JButton(MonitorDePID.idioma.agregarArchivo());
        JButton carpeta = new JButton(MonitorDePID.idioma.agregarCarpeta());
        JButton quitar = new JButton(MonitorDePID.idioma.quitar());
        JButton guardar = new JButton(MonitorDePID.idioma.guardarCambios());
        archivo.addActionListener(e -> this.seleccionar(false));
        carpeta.addActionListener(e -> this.seleccionar(true));
        quitar.addActionListener(e -> this.quitarSeleccionado());
        guardar.addActionListener(e -> this.guardarDatos());
        p.add(archivo);
        p.add(carpeta);
        p.add(quitar);
        p.add(guardar);
        return p;
    }

    @Override
    public void recargarApariencia() {
        this.getContentPane().setBackground(this.colorFondo.obtener());
        this.tabla.setBackground(this.colorCaja.obtener());
        this.tabla.setForeground(this.colorTexto.obtener());
        this.tabla.setGridColor(this.colorBorde.obtener());
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> l = new ArrayList<ElementoConfig>();
        this.colorFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        l.add(this.colorFondo);
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        l.add(this.colorTexto);
        this.colorCaja.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorCajaTexto());
        l.add(this.colorCaja);
        this.colorBorde.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
        l.add(this.colorBorde);
        return l;
    }
}

