/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.aplic;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.aplic.ActaDeProteccionDelIdiomaCulturalDePyongyangGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;

public class ActaDeProteccionDelIdiomaCulturalDePyongyangGUIKimJongUn
extends ActaDeProteccionDelIdiomaCulturalDePyongyangGUI {
    private static final long serialVersionUID = 1L;
    public static String ID = "kimjongun";
    protected ConfigColor colorFondoVentana = ConfigColor.de("tema.pyongyang.color.fondo.ventana", new Color(25, 25, 25));
    protected ConfigColor colorTexto = ConfigColor.de("tema.pyongyang.color.texto", new Color(220, 220, 220));
    protected ConfigColor colorBoton = ConfigColor.de("tema.pyongyang.color.boton", new Color(50, 60, 150));
    protected ConfigColor colorCajaTexto = ConfigColor.de("tema.pyongyang.color.caja_texto", new Color(40, 40, 40));
    protected ConfigColor colorEnlace = ConfigColor.de("tema.pyongyang.color.enlace", new Color(100, 150, 255));
    protected ConfigColor colorBordePanel = ConfigColor.de("tema.pyongyang.color.borde_panel", new Color(60, 60, 60));
    protected JPanel raizPanel;
    protected JPanel panelIzquierdo;
    protected JPanel panelDerecho;
    protected JPanel panelContenido;
    protected JLabel imagenDPRK;
    protected JLabel imagenKimJongUn;
    protected JTextPane textoContenido;
    protected JButton botonLeerLey;

    @Override
    public void init() {
        this.setTitle(MonitorDePID.idioma.actaProteccionIdiomaCultural());
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(true);
        this.setMinimumSize(new Dimension(800, 600));
        this.raizPanel = new JPanel(new BorderLayout(10, 10));
        this.raizPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panelIzquierdo = new JPanel(new BorderLayout());
        this.panelIzquierdo.setPreferredSize(new Dimension(250, 0));
        this.imagenDPRK = new JLabel();
        this.imagenDPRK.setPreferredSize(new Dimension(250, 300));
        this.imagenDPRK.setHorizontalAlignment(0);
        this.imagenDPRK.setVerticalAlignment(0);
        this.imagenKimJongUn = new JLabel();
        this.imagenKimJongUn.setPreferredSize(new Dimension(192, 192));
        this.imagenKimJongUn.setHorizontalAlignment(0);
        this.imagenKimJongUn.setVerticalAlignment(0);
        this.panelDerecho = new JPanel(new BorderLayout(10, 10));
        this.panelContenido = new JPanel(new GridBagLayout());
        this.panelContenido.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.colorBordePanel.obtener(), 1), MonitorDePID.idioma.informacion()));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(8, 8, 8, 8);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.textoContenido = new JTextPane();
        this.textoContenido.setContentType("text/html");
        this.textoContenido.setEditable(false);
        this.textoContenido.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.botonLeerLey = new JButton(MonitorDePID.idioma.leerLeyCompleta());
        this.panelIzquierdo.add((Component)this.imagenDPRK, "North");
        this.panelIzquierdo.add((Component)this.imagenKimJongUn, "Center");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        this.panelContenido.add((Component)new JScrollPane(this.textoContenido), gbc);
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        this.panelContenido.add((Component)this.botonLeerLey, gbc);
        this.panelDerecho.add((Component)this.panelContenido, "Center");
        this.raizPanel.add((Component)this.panelIzquierdo, "West");
        this.raizPanel.add((Component)this.panelDerecho, "Center");
        this.getContentPane().add(this.raizPanel);
        this.cargarDatos();
        this.aplicarApariencia();
        this.setLocationRelativeTo(null);
        this.cargarImagenDPRK();
        this.agregarListeners();
        this.setVisible(true);
    }

    private void cargarImagenDPRK() {
        try {
            URL url = Statics.carpeta.resolve("imagenes/dprk.png").toFile().toURI().toURL();
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                Image img = icon.getImage().getScaledInstance(250, 300, 4);
                this.imagenDPRK.setIcon(new ImageIcon(img));
            } else {
                this.imagenDPRK.setText(MonitorDePID.idioma.imagenNoEncontrada());
                this.imagenDPRK.setHorizontalAlignment(0);
                this.imagenDPRK.setVerticalAlignment(0);
                this.imagenDPRK.setForeground(this.colorTexto.obtener());
            }
        }
        catch (Exception e) {
            this.imagenDPRK.setText(MonitorDePID.idioma.errorCargandoImagen());
            this.imagenDPRK.setHorizontalAlignment(0);
            this.imagenDPRK.setVerticalAlignment(0);
            this.imagenDPRK.setForeground(this.colorTexto.obtener());
        }
    }

    private void cargarImagenKimJongUn() {
        try {
            URL url = Statics.carpeta.resolve("imagenes/kimjongun.png").toFile().toURI().toURL();
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                Image img = icon.getImage().getScaledInstance(192, 192, 4);
                this.imagenKimJongUn.setIcon(new ImageIcon(img));
            } else {
                this.imagenKimJongUn.setText(MonitorDePID.idioma.imagenNoEncontrada());
                this.imagenKimJongUn.setHorizontalAlignment(0);
                this.imagenKimJongUn.setVerticalAlignment(0);
                this.imagenKimJongUn.setForeground(this.colorTexto.obtener());
            }
        }
        catch (Exception e) {
            this.imagenKimJongUn.setText(MonitorDePID.idioma.errorCargandoImagen());
            this.imagenKimJongUn.setHorizontalAlignment(0);
            this.imagenKimJongUn.setVerticalAlignment(0);
            this.imagenKimJongUn.setForeground(this.colorTexto.obtener());
        }
    }

    private void agregarListeners() {
        this.botonLeerLey.addActionListener(e -> {
            try {
                Desktop.getDesktop().browse(new URI("https://www.dailynk.com/english/wp-content/uploads/sites/2/2023/03/Pyongyang-Cultural-Language-Protection-Act_English-and-Korean-Versions_Daily-NK.pdf"));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.errorAbriendoEnlace(), MonitorDePID.idioma.error(), 0);
            }
        });
    }

    @Override
    public String id() {
        return ID;
    }

    protected void cargarDatos() {
        String contenido = "<html><body style='color: #" + Integer.toHexString(this.colorTexto.obtener().getRGB()).substring(2) + "; background-color: #" + Integer.toHexString(this.colorCajaTexto.obtener().getRGB()).substring(2) + "; font-family: Arial, sans-serif; margin: 10px;'>";
        contenido = contenido + "<h2>" + MonitorDePID.idioma.advertencia() + "</h2>";
        contenido = contenido + "<p>" + MonitorDePID.idioma.mensajeAdvertenciaIdiomaCoreano() + "</p>";
        contenido = contenido + "<p>" + MonitorDePID.idioma.enlaceDocumentacionIdiomaCoreano() + "</p>";
        contenido = contenido + "</body></html>";
        this.textoContenido.setText(contenido);
    }

    public void aplicarApariencia() {
        this.getContentPane().setBackground(this.colorFondoVentana.obtener());
        this.raizPanel.setBackground(this.colorFondoVentana.obtener());
        this.panelIzquierdo.setBackground(this.colorFondoVentana.obtener());
        this.panelDerecho.setBackground(this.colorFondoVentana.obtener());
        this.panelContenido.setBackground(this.colorFondoVentana.obtener());
        this.estilizarBoton(this.botonLeerLey);
        TitledBorder contentBorder = (TitledBorder)this.panelContenido.getBorder();
        contentBorder.setTitleColor(this.colorTexto.obtener());
        this.revalidate();
        this.repaint();
    }

    @Override
    public void recargarApariencia() {
        this.aplicarApariencia();
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorFondoVentana.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoVentana());
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        this.colorCajaTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorCajaTexto());
        this.colorEnlace.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorEnlace());
        this.colorBordePanel.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
        elementos.add(this.colorFondoVentana);
        elementos.add(this.colorTexto);
        elementos.add(this.colorBoton);
        elementos.add(this.colorCajaTexto);
        elementos.add(this.colorEnlace);
        elementos.add(this.colorBordePanel);
        return elementos;
    }

    protected void estilizarBoton(JButton btn) {
        btn.setBackground(this.colorBoton.obtener());
        btn.setForeground(Color.WHITE);
        btn.setFocusPainted(false);
        btn.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        btn.setFont(new Font("Segoe UI", 1, 13));
    }
}

