/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.arbol;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.arbol.ArchivoDeModFake;
import com.asbestosstar.crashdetector.gui.tipos.arbol.PathDescriptor;
import com.asbestosstar.crashdetector.gui.tipos.cfr.CfrBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class ArbolDeModsGUI
extends JFrame
implements BotonDeBarraLateralDerecha {
    public static Map<String, Supplier<ArbolDeModsGUI>> GUIS = new HashMap<String, Supplier<ArbolDeModsGUI>>();
    public JTree arbolModulos;
    public DefaultTreeModel modeloArbol;
    public JTextField campoBuscar;
    public JComboBox<String> comboFiltro;
    public JTextArea areaContenido;
    public JButton botonReset;
    public JLabel imagenHamu;
    public ImageIcon iconoMod;
    public ImageIcon iconoClase;
    public ImageIcon iconoMetodo;
    public ImageIcon iconoCampo;
    public ImageIcon iconoPaquete;
    public ImageIcon iconoReferenciaMetodo;
    public ImageIcon iconoReferenciaCampo;
    public ImageIcon iconoConstante;
    public JPanel overlayCarga;
    public JLabel gifCarga;
    public volatile boolean cargando = false;
    public SwingWorker<Void, Void> workerConstruir;
    public SwingWorker<DefaultMutableTreeNode, Void> workerBuscar;
    public Map<String, List<PathDescriptor>> indiceBusqueda = new ConcurrentHashMap<String, List<PathDescriptor>>();
    private static final int NUCLEOS = Math.max(1, Runtime.getRuntime().availableProcessors());
    private static final int TAM_POOL = Math.max(2, NUCLEOS * 4);
    private static final ExecutorService POOL_BG = Executors.newFixedThreadPool(TAM_POOL, new ThreadFactory(){
        private final AtomicInteger n = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "ArbolMods-BG-" + this.n.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    });

    private static String normalizarNombreClaseInterno(String nombre) {
        if (nombre == null) {
            return null;
        }
        String s = nombre.trim();
        if (s.isEmpty()) {
            return s;
        }
        if (s.length() >= 2 && s.charAt(0) == 'L' && s.endsWith(";")) {
            s = s.substring(1, s.length() - 1);
        }
        if (s.toLowerCase().endsWith(".class")) {
            s = s.substring(0, s.length() - ".class".length());
        }
        if (s.indexOf(46) >= 0) {
            s = s.replace('.', '/');
        }
        return s;
    }

    public void construirIndice() {
        this.indiceBusqueda.clear();
        int totalMods = Buscardor.mods.size();
        if (totalMods == 0) {
            CrashDetectorLogger.log("\u2705 No hay mods para indexar.");
            return;
        }
        int numHilos = Math.max(1, Runtime.getRuntime().availableProcessors() * 2);
        ExecutorService executor = Executors.newFixedThreadPool(numHilos, r -> {
            Thread hilo = new Thread(r, "Indexador-" + r.hashCode());
            hilo.setDaemon(true);
            return hilo;
        });
        ArrayList<Future<Map>> futuros = new ArrayList<Future<Map>>(totalMods);
        AtomicInteger completados = new AtomicInteger(0);
        for (ArchivoDeMod mod : Buscardor.mods) {
            futuros.add(executor.submit(() -> {
                try {
                    HashMap<String, List<PathDescriptor>> mapaLocal = new HashMap<String, List<PathDescriptor>>();
                    this.indexarModConcurrente(mod, mapaLocal);
                    int ya = completados.incrementAndGet();
                    CrashDetectorLogger.log(String.format("\u2705 Mod indexado: %s (%d/%d)", mod.ubicacion_para_publicar(), ya, totalMods));
                    return mapaLocal;
                }
                catch (Throwable t) {
                    CrashDetectorLogger.logException(t);
                    return new HashMap();
                }
            }));
        }
        executor.shutdown();
        try {
            if (!executor.awaitTermination(120L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        int totalTerminos = 0;
        for (Future future : futuros) {
            try {
                Map mapa = (Map)future.get();
                for (Map.Entry entry : mapa.entrySet()) {
                    String termino = (String)entry.getKey();
                    List descriptores = (List)entry.getValue();
                    if (termino == null || descriptores == null || descriptores.isEmpty()) continue;
                    this.indiceBusqueda.computeIfAbsent(termino, k -> new ArrayList()).addAll(descriptores);
                    totalTerminos += descriptores.size();
                }
            }
            catch (Exception e) {
                CrashDetectorLogger.log("Error al fusionar mapa de mod: " + e.getMessage());
            }
        }
        CrashDetectorLogger.log(String.format("\u2705 \u00cdndice construido con %d t\u00e9rminos \u00fanicos y ~%d entradas totales, usando %d hilos.", this.indiceBusqueda.size(), totalTerminos, numHilos));
    }

    public void indexarModConcurrente(ArchivoDeMod mod, Map<String, List<PathDescriptor>> indiceLocal) {
        String modUbicacion = mod.ubicacion_para_publicar();
        String modUbicacionLower = modUbicacion.toLowerCase();
        PathDescriptor descMod = new PathDescriptor(modUbicacion, null, null, null, null, "MOD");
        this.indexarTerminoConcurrente(modUbicacionLower, descMod, indiceLocal);
        for (ArchivoDeMod submod : mod.mods_en_mods()) {
            this.indexarModConcurrente(submod, indiceLocal);
        }
        for (String clasePuntos : mod.clases()) {
            String paquete = this.paqueteDe(clasePuntos);
            String claseInterna = ArbolDeModsGUI.normalizarNombreClaseInterno(clasePuntos);
            if (!paquete.isEmpty()) {
                PathDescriptor descPaq = new PathDescriptor(modUbicacion, paquete, null, null, null, "PAQUETE");
                this.indexarTerminoConcurrente(paquete.toLowerCase(), descPaq, indiceLocal);
            }
            PathDescriptor descClase = new PathDescriptor(modUbicacion, paquete, clasePuntos, null, null, "CLASE");
            this.indexarTerminoConcurrente(clasePuntos.toLowerCase(), descClase, indiceLocal);
            if (Buscardor.puedeAnalizarElContentidoDeClase() && mod.existeClase(claseInterna)) continue;
        }
    }

    public void indexarTerminoConcurrente(String textoOriginal, PathDescriptor desc, Map<String, List<PathDescriptor>> indice) {
        if (textoOriginal == null || textoOriginal.isEmpty()) {
            return;
        }
        for (String clave : ArbolDeModsGUI.extraerClavesIndice(textoOriginal)) {
            this.agregarAlIndiceLocal(clave, desc, indice);
        }
    }

    public void agregarAlIndiceLocal(String termino, PathDescriptor descriptor, Map<String, List<PathDescriptor>> indice) {
        if (termino == null || termino.isEmpty()) {
            return;
        }
        indice.computeIfAbsent(termino, k -> new ArrayList()).add(descriptor);
    }

    private static Set<String> extraerClavesIndice(String texto) {
        LinkedHashSet<String> claves = new LinkedHashSet<String>();
        if (texto == null) {
            return claves;
        }
        String lower = texto.toLowerCase();
        String[] tokens = lower.split("[^a-z0-9]+");
        int LIMITE_CLAVES = 256;
        for (String token : tokens) {
            if (token == null || token.length() < 3) continue;
            claves.add(token);
            int i = 0;
            while (i + 3 <= token.length()) {
                claves.add(token.substring(i, i + 3));
                if (claves.size() >= 256) {
                    return claves;
                }
                ++i;
            }
            if (claves.size() < 256) continue;
            return claves;
        }
        return claves;
    }

    private static Set<String> extraerClavesConsulta(String consulta) {
        String[] tokens;
        LinkedHashSet<String> claves = new LinkedHashSet<String>();
        if (consulta == null) {
            return claves;
        }
        String lower = consulta.toLowerCase();
        for (String token : tokens = lower.split("[^a-z0-9]+")) {
            if (token == null || token.isEmpty()) continue;
            if (token.length() < 3) {
                claves.add(token);
                continue;
            }
            claves.add(token);
            int i = 0;
            while (i + 3 <= token.length()) {
                claves.add(token.substring(i, i + 3));
                ++i;
            }
        }
        return claves;
    }

    public void indexarTermino(String textoOriginal, PathDescriptor desc) {
        if (textoOriginal == null || textoOriginal.isEmpty()) {
            return;
        }
        for (String clave : ArbolDeModsGUI.extraerClavesIndice(textoOriginal)) {
            this.agregarAlIndice(clave, desc);
        }
    }

    public void agregarAlIndice(String termino, PathDescriptor descriptor) {
        this.indiceBusqueda.computeIfAbsent(termino, k -> new ArrayList()).add(descriptor);
    }

    public void descompilarElementoSeleccionado() {
        Object[] datos;
        Object objetoReal;
        TreePath rutaSeleccionada = this.arbolModulos.getSelectionPath();
        if (rutaSeleccionada == null) {
            return;
        }
        DefaultMutableTreeNode nodo = (DefaultMutableTreeNode)rutaSeleccionada.getLastPathComponent();
        Object objetoUsuario = nodo.getUserObject();
        if (objetoUsuario instanceof NodoConTexto && (objetoReal = ((NodoConTexto)objetoUsuario).objeto()) instanceof Object[] && ((Object[])objetoReal).length >= 2 && (datos = (Object[])objetoReal)[0] instanceof ArchivoDeMod && datos[1] instanceof String) {
            ArchivoDeMod mod = (ArchivoDeMod)datos[0];
            String nombreClase = (String)datos[1];
            this.mostrarCodigoDescompilado(mod, nombreClase);
        }
    }

    public void exportarEstructura() {
        JFileChooser selectorArchivo = new JFileChooser();
        selectorArchivo.setSelectedFile(new File("arbol_mods.arbolmods"));
        int resultado = selectorArchivo.showSaveDialog(this);
        if (resultado == 0) {
            File archivo = selectorArchivo.getSelectedFile();
            if (!archivo.getName().toLowerCase().endsWith(".arbolmods")) {
                archivo = new File(archivo.getParentFile(), archivo.getName() + ".arbolmods");
            }
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(archivo));){
                NodoArbolExportable estructuraSerializable = this.convertirArbolASerializable();
                oos.writeObject(estructuraSerializable);
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.estructuraExportada() + ": " + archivo.getAbsolutePath(), MonitorDePID.idioma.exito(), 1);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.errorExportar() + ": " + ex.getMessage(), MonitorDePID.idioma.error(), 0);
            }
        }
    }

    public void importarEstructura() {
        JFileChooser selectorArchivo = new JFileChooser();
        selectorArchivo.setFileFilter(new FileNameExtensionFilter("Archivos de \u00e1rbol de mods", "arbolmods"));
        int resultado = selectorArchivo.showOpenDialog(this);
        if (resultado == 0) {
            File archivo = selectorArchivo.getSelectedFile();
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(archivo));){
                NodoArbolExportable estructuraSerializable = (NodoArbolExportable)ois.readObject();
                DefaultMutableTreeNode nuevaRaiz = this.convertirSerializableAArbol(estructuraSerializable);
                this.modeloArbol = new ModeloArbolConExpandibleMods(nuevaRaiz);
                this.arbolModulos.setModel(this.modeloArbol);
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.estructuraImportada(), MonitorDePID.idioma.exito(), 1);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.errorImportar() + ": " + ex.getMessage(), MonitorDePID.idioma.error(), 0);
            }
        }
    }

    public NodoArbolExportable convertirArbolASerializable() {
        DefaultMutableTreeNode raiz = (DefaultMutableTreeNode)this.modeloArbol.getRoot();
        return this.convertirNodoASerializable(raiz);
    }

    public NodoArbolExportable convertirNodoASerializable(DefaultMutableTreeNode nodo) {
        Object userObject = nodo.getUserObject();
        String texto = "";
        String tipo = "";
        if (userObject instanceof NodoConTexto) {
            texto = ((NodoConTexto)userObject).texto();
            Object objetoReal = ((NodoConTexto)userObject).objeto();
            if (objetoReal instanceof ArchivoDeMod) {
                tipo = "MOD";
            } else if (objetoReal instanceof String) {
                tipo = "PAQUETE";
            } else if (objetoReal instanceof Object[]) {
                ArchivoDeMod.Referencia ref;
                Object[] datos = (Object[])objetoReal;
                tipo = datos.length >= 3 && datos[2] instanceof ArchivoDeMod.InfoMetodo ? "METODO" : (datos.length >= 3 && datos[2] instanceof ArchivoDeMod.InfoCampo ? "CAMPO" : (datos.length >= 4 && datos[3] instanceof ArchivoDeMod.Referencia ? ((ref = (ArchivoDeMod.Referencia)datos[3]).esMetodo() ? "REFERENCIA_METODO" : "REFERENCIA_CAMPO") : "CLASE"));
            }
        } else {
            texto = nodo.toString();
            tipo = "RAIZ";
        }
        NodoArbolExportable nodoSerializable = new NodoArbolExportable(texto, tipo);
        for (int i = 0; i < nodo.getChildCount(); ++i) {
            DefaultMutableTreeNode hijo = (DefaultMutableTreeNode)nodo.getChildAt(i);
            nodoSerializable.agregarHijo(this.convertirNodoASerializable(hijo));
        }
        return nodoSerializable;
    }

    public DefaultMutableTreeNode convertirSerializableAArbol(NodoArbolExportable nodoSerializable) {
        DefaultMutableTreeNode nodo = new DefaultMutableTreeNode(new NodoConTexto(nodoSerializable.texto(), nodoSerializable.tipo()));
        for (NodoArbolExportable serializable : nodoSerializable.sub()) {
            nodo.add(this.convertirSerializableAArbol(serializable));
        }
        return nodo;
    }

    @Override
    public void init() {
        this.setTitle(MonitorDePID.idioma.tituloArbolDeMods());
        this.setSize(1200, 800);
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        this.getContentPane().setBackground(new Color(144, 203, 239));
        this.iconoMod = this.crearIcono(Statics.carpeta.resolve("imagenes/mod.png").toString(), "M");
        this.iconoClase = this.crearIcono(Statics.carpeta.resolve("imagenes/clase.png").toString(), "C");
        this.iconoMetodo = this.crearIcono(Statics.carpeta.resolve("imagenes/metodo.png").toString(), "m");
        this.iconoCampo = this.crearIcono(Statics.carpeta.resolve("imagenes/campo.png").toString(), "f");
        this.iconoPaquete = this.crearIcono(Statics.carpeta.resolve("imagenes/paquete.png").toString(), "P");
        this.iconoReferenciaMetodo = this.crearIcono(Statics.carpeta.resolve("imagenes/referencia_metodo.png").toString(), "RM");
        this.iconoReferenciaCampo = this.crearIcono(Statics.carpeta.resolve("imagenes/referencia_campo.png").toString(), "RC");
        this.iconoConstante = this.crearIcono(Statics.carpeta.resolve("imagenes/referencia_campo.png").toString(), "K");
        JPanel barraSuperior = new JPanel(new BorderLayout());
        barraSuperior.setOpaque(false);
        barraSuperior.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelBusqueda = new JPanel(new FlowLayout(0));
        panelBusqueda.setOpaque(false);
        JLabel etiquetaTipo = new JLabel(MonitorDePID.idioma.tipoBusqueda() + ":");
        String[] opcionesFiltro = new String[]{"*", MonitorDePID.idioma.filtroPaquetes(), MonitorDePID.idioma.filtroClases(), MonitorDePID.idioma.filtroMetodos(), MonitorDePID.idioma.filtroCampos(), MonitorDePID.idioma.filtroReferenciasCampo(), MonitorDePID.idioma.filtroReferenciasMetodo(), MonitorDePID.idioma.filtroReferenciasClase(), "Constantes"};
        this.comboFiltro = new JComboBox<String>(opcionesFiltro);
        this.campoBuscar = new JTextField(30);
        this.campoBuscar.setToolTipText(MonitorDePID.idioma.tipBuscar());
        JButton botonBuscar = new JButton(MonitorDePID.idioma.botonBuscar());
        panelBusqueda.add(etiquetaTipo);
        panelBusqueda.add(this.comboFiltro);
        panelBusqueda.add(this.campoBuscar);
        panelBusqueda.add(botonBuscar);
        this.imagenHamu = new JLabel(new ImageIcon(Statics.carpeta.resolve("imagenes/hamu.png").toString()));
        this.botonReset = new JButton(MonitorDePID.idioma.botonResetearArbol());
        this.botonReset.addActionListener(e -> {
            this.construirArbolInicialAsync();
            this.areaContenido.setText("");
            this.campoBuscar.setText("");
        });
        JButton botonVerCodigo = new JButton("Ver C\u00f3digo");
        botonVerCodigo.addActionListener(e -> this.mostrarCodigoClaseSeleccionada());
        this.arbolModulos = new JTree();
        this.arbolModulos.setRootVisible(false);
        this.arbolModulos.setShowsRootHandles(true);
        this.arbolModulos.setCellRenderer(new RenderizadorCeldasArbol());
        this.arbolModulos.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                DefaultMutableTreeNode nodo = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object userObj = nodo.getUserObject();
                CrashDetectorLogger.log("\ud83d\udd0d [EXPAND] Nodo: " + nodo + ", hijos=" + nodo.getChildCount());
                if (userObj instanceof NodoConTexto) {
                    Object real = ((NodoConTexto)userObj).objeto();
                    CrashDetectorLogger.log("\ud83d\udd0d [EXPAND] Objeto real: " + (real != null ? real.getClass().getSimpleName() : "null"));
                    if (real instanceof ArchivoDeMod && nodo.getChildCount() == 0) {
                        CrashDetectorLogger.log("\u2705 [EXPAND] Cargando contenido para mod: " + real);
                        ArbolDeModsGUI.this.cargarContenidoModuloAsync(nodo, (ArchivoDeMod)real);
                    } else {
                        CrashDetectorLogger.log("\u26a0\ufe0f [EXPAND] No cumple: ArchivoDeMod=" + (real instanceof ArchivoDeMod) + ", hijos=" + nodo.getChildCount());
                    }
                } else {
                    CrashDetectorLogger.log("\u26a0\ufe0f [EXPAND] No es NodoConTexto: " + (userObj != null ? userObj.getClass().getSimpleName() : "null"));
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
            }
        });
        this.arbolModulos.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ArbolDeModsGUI.this.mostrarMenuContexto(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ArbolDeModsGUI.this.mostrarMenuContexto(e);
                }
            }
        });
        this.arbolModulos.addTreeSelectionListener(e -> {
            TreePath ruta = this.arbolModulos.getSelectionPath();
            if (ruta == null) {
                return;
            }
            DefaultMutableTreeNode nodo = (DefaultMutableTreeNode)ruta.getLastPathComponent();
            if (nodo == null) {
                return;
            }
            Object user = nodo.getUserObject();
            Object objReal = user instanceof NodoConTexto ? ((NodoConTexto)user).objeto() : user;
            this.mostrarDetallesNodo(objReal);
        });
        this.areaContenido = new JTextArea();
        this.areaContenido.setEditable(false);
        this.areaContenido.setLineWrap(true);
        this.areaContenido.setWrapStyleWord(true);
        this.areaContenido.setFont(new Font("Monospaced", 0, 12));
        JPanel panelInferior = new JPanel(new BorderLayout());
        panelInferior.setOpaque(false);
        panelInferior.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelIzquierdo = new JPanel(new FlowLayout(0));
        panelIzquierdo.setOpaque(false);
        panelIzquierdo.add(this.imagenHamu);
        JPanel panelDerecho = new JPanel(new FlowLayout(2));
        panelDerecho.setOpaque(false);
        JButton botonExportar = new JButton(MonitorDePID.idioma.exportar());
        JButton botonImportar = new JButton(MonitorDePID.idioma.importar());
        botonExportar.addActionListener(e -> this.exportarEstructura());
        botonImportar.addActionListener(e -> this.importarEstructura());
        panelDerecho.add(botonExportar);
        panelDerecho.add(botonImportar);
        panelDerecho.add(botonVerCodigo);
        panelInferior.add((Component)panelIzquierdo, "West");
        panelInferior.add((Component)panelDerecho, "East");
        this.add((Component)panelInferior, "South");
        this.add((Component)this.botonReset, "North");
        this.add((Component)barraSuperior, "Center");
        JSplitPane panelDividido = new JSplitPane(1, new JScrollPane(this.arbolModulos), new JScrollPane(this.areaContenido));
        panelDividido.setDividerLocation(500);
        barraSuperior.add((Component)panelBusqueda, "North");
        barraSuperior.add((Component)panelDividido, "Center");
        this.campoBuscar.addActionListener(e -> this.buscarEnIndiceAsync());
        botonBuscar.addActionListener(e -> this.buscarEnIndiceAsync());
        this.comboFiltro.addActionListener(e -> this.buscarEnIndiceAsync());
        this.initOverlayCarga();
        this.setCargando(false);
        DefaultMutableTreeNode placeholder = new DefaultMutableTreeNode(MonitorDePID.idioma.cargando());
        this.modeloArbol = new ModeloArbolConExpandibleMods(placeholder);
        this.arbolModulos.setModel(this.modeloArbol);
        this.setVisible(true);
        this.iniciarCargaPesada();
    }

    private void mostrarCodigoClaseSeleccionada() {
        Object[] datos;
        Object objetoReal;
        TreePath rutaSeleccionada = this.arbolModulos.getSelectionPath();
        if (rutaSeleccionada == null) {
            return;
        }
        DefaultMutableTreeNode nodo = (DefaultMutableTreeNode)rutaSeleccionada.getLastPathComponent();
        Object objetoUsuario = nodo.getUserObject();
        if (objetoUsuario instanceof NodoConTexto && (objetoReal = ((NodoConTexto)objetoUsuario).objeto()) instanceof Object[] && (datos = (Object[])objetoReal)[0] instanceof ArchivoDeMod && datos[1] instanceof String) {
            ArchivoDeMod mod = (ArchivoDeMod)datos[0];
            String nombreClase = (String)datos[1];
            this.mostrarCodigoDescompilado(mod, nombreClase);
        }
    }

    private void mostrarCodigoDescompilado(ArchivoDeMod mod, String nombreClase) {
        try {
            String codigoDescompilado = CfrBase.descompilarClase(nombreClase);
            this.areaContenido.setText(codigoDescompilado);
        }
        catch (Exception e) {
            this.areaContenido.setText("Error al obtener el c\u00f3digo: " + e.getMessage());
        }
    }

    public void mostrarDetallesNodo(Object nodo) {
        Object[] datos;
        if (nodo == null) {
            this.areaContenido.setText("");
            return;
        }
        StringBuilder detalles = new StringBuilder();
        Object objetoReal = nodo;
        if (nodo instanceof DefaultMutableTreeNode) {
            Object objetoUsuario = ((DefaultMutableTreeNode)nodo).getUserObject();
            if (objetoUsuario == null) {
                this.areaContenido.setText("");
                return;
            }
            objetoReal = objetoUsuario instanceof NodoConTexto ? ((NodoConTexto)objetoUsuario).objeto() : objetoUsuario;
        }
        if (objetoReal instanceof ArchivoDeMod) {
            ArchivoDeMod mod = (ArchivoDeMod)objetoReal;
            detalles.append(MonitorDePID.idioma.detalleMod()).append("\n").append(MonitorDePID.idioma.ubicacion()).append(": ").append(mod.ubicacion_para_publicar()).append("\n\n");
            if (!mod.nombre().isEmpty()) {
                detalles.append(MonitorDePID.idioma.nombres()).append(":\n");
                for (String string : mod.nombre()) {
                    detalles.append("- ").append(string).append("\n");
                }
                detalles.append("\n");
            }
            Map<String, List<String>> clasesPorPaquete = this.agruparClasesPorPaquete(mod.clases());
            for (Map.Entry<String, List<String>> entrada : clasesPorPaquete.entrySet()) {
                String paquete = entrada.getKey();
                List<String> clases = entrada.getValue();
                if (paquete.isEmpty()) {
                    detalles.append(MonitorDePID.idioma.clases()).append(" (").append(clases.size()).append("):\n");
                    for (String nombreClase : clases) {
                        detalles.append("- ").append(nombreClase).append("\n");
                    }
                } else {
                    detalles.append(paquete).append(" (").append(clases.size()).append("):\n");
                    for (String nombreClase : clases) {
                        detalles.append("  - ").append(nombreClase).append("\n");
                    }
                }
                detalles.append("\n");
            }
        } else if (objetoReal instanceof String) {
            int indiceUltimoPunto;
            String paqueteClase;
            String paquete = (String)objetoReal;
            detalles.append(MonitorDePID.idioma.paquete()).append(" ").append(paquete).append("\n");
            ArrayList<ArchivoDeMod> modsConPaquete = new ArrayList<ArchivoDeMod>();
            block4: for (ArchivoDeMod mod : Buscardor.mods) {
                for (String clase : mod.clases()) {
                    paqueteClase = "";
                    indiceUltimoPunto = clase.lastIndexOf(46);
                    if (indiceUltimoPunto > 0) {
                        paqueteClase = clase.substring(0, indiceUltimoPunto);
                    }
                    if (!paqueteClase.equals(paquete)) continue;
                    modsConPaquete.add(mod);
                    continue block4;
                }
            }
            detalles.append(MonitorDePID.idioma.modulos()).append(" (").append(modsConPaquete.size()).append("):\n");
            for (ArchivoDeMod mod : modsConPaquete) {
                detalles.append("- ").append(mod.ubicacion_para_publicar()).append("\n");
            }
            detalles.append("\n");
            detalles.append(MonitorDePID.idioma.clases()).append(":\n");
            for (ArchivoDeMod mod : modsConPaquete) {
                for (String clase : mod.clases()) {
                    paqueteClase = "";
                    indiceUltimoPunto = clase.lastIndexOf(46);
                    if (indiceUltimoPunto > 0) {
                        paqueteClase = clase.substring(0, indiceUltimoPunto);
                    }
                    if (!paqueteClase.equals(paquete)) continue;
                    String nombreClase = clase.substring(indiceUltimoPunto + 1);
                    detalles.append("  - ").append(nombreClase).append("\n");
                }
            }
        } else if (objetoReal instanceof Object[] && (datos = (Object[])objetoReal).length >= 2 && datos[0] instanceof ArchivoDeMod) {
            String string;
            ArchivoDeMod mod = (ArchivoDeMod)datos[0];
            String string2 = string = datos[1] instanceof String ? (String)datos[1] : null;
            if (string != null) {
                String claseInterna = this.convertirFormatoClase(string);
                boolean claseExiste = mod.existeClase(claseInterna);
                if (datos.length == 2) {
                    String nombreClase = string;
                    String paquete = "";
                    int indicePunto = string.lastIndexOf(46);
                    if (indicePunto > 0) {
                        paquete = string.substring(0, indicePunto);
                        nombreClase = string.substring(indicePunto + 1);
                    }
                    detalles.append(MonitorDePID.idioma.detalleClase()).append(" ").append(nombreClase).append("\n");
                    if (!paquete.isEmpty()) {
                        detalles.append(MonitorDePID.idioma.paquete()).append(": ").append(paquete).append("\n\n");
                    }
                    detalles.append(MonitorDePID.idioma.modulo()).append(": ").append(mod.ubicacion_para_publicar()).append("\n\n");
                    if (Buscardor.puedeAnalizarElContentidoDeClase() && claseExiste) {
                        List<ArchivoDeMod.InfoMetodo> metodos = mod.obtenerMetodosConReferencias(claseInterna);
                        detalles.append(MonitorDePID.idioma.metodos()).append(" (").append(metodos.size()).append("):\n");
                        for (ArchivoDeMod.InfoMetodo infoMetodo : metodos) {
                            detalles.append("- ").append(infoMetodo.obtenerNombre()).append(infoMetodo.obtenerDescriptor()).append("\n");
                        }
                        detalles.append("\n");
                        List<ArchivoDeMod.InfoCampo> list = mod.obtenerCampos(claseInterna);
                        detalles.append(MonitorDePID.idioma.campos()).append(" (").append(list.size()).append("):\n");
                        for (ArchivoDeMod.InfoCampo campo : list) {
                            detalles.append("- ").append(campo.obtenerNombre()).append(" ").append(campo.obtenerDescriptor()).append("\n");
                        }
                    }
                } else if (datos.length >= 3 && datos[2] instanceof ArchivoDeMod.InfoMetodo) {
                    ArchivoDeMod.InfoMetodo metodo = (ArchivoDeMod.InfoMetodo)datos[2];
                    String nombreClase = (String)datos[1];
                    int indicePunto = nombreClase.lastIndexOf(46);
                    if (indicePunto > 0) {
                        nombreClase = nombreClase.substring(indicePunto + 1);
                    }
                    detalles.append(MonitorDePID.idioma.detalleMetodo()).append(" ").append(metodo.obtenerNombre()).append(metodo.obtenerDescriptor()).append("\n");
                    detalles.append(MonitorDePID.idioma.clase()).append(": ").append(nombreClase).append("\n");
                    detalles.append(MonitorDePID.idioma.modulo()).append(": ").append(mod.ubicacion_para_publicar()).append("\n\n");
                    detalles.append(MonitorDePID.idioma.referenciasAMetodos()).append(" (").append(metodo.obtenerReferenciasAMetodos().size()).append("):\n");
                    for (ArchivoDeMod.Referencia referencia : metodo.obtenerReferenciasAMetodos()) {
                        String string3 = this.convertirFormatoClasePuntos(referencia.obtenerClase());
                        detalles.append("- ").append(string3).append(".").append(referencia.obtenerNombre()).append(referencia.obtenerDescriptor()).append("\n");
                    }
                    detalles.append("\n");
                    detalles.append(MonitorDePID.idioma.referenciasACampos()).append(" (").append(metodo.obtenerReferenciasACampos().size()).append("):\n");
                    for (ArchivoDeMod.Referencia referencia : metodo.obtenerReferenciasACampos()) {
                        String string4 = this.convertirFormatoClasePuntos(referencia.obtenerClase());
                        detalles.append("- ").append(string4).append(".").append(referencia.obtenerNombre()).append(" ").append(referencia.obtenerDescriptor()).append("\n");
                    }
                    detalles.append("\n");
                    List<ArchivoDeMod.Constante> constantes = mod.buscarConstantesEnMetodo(this.convertirFormatoClase((String)datos[1]), metodo.obtenerNombre(), metodo.obtenerDescriptor());
                    detalles.append("Constantes (").append(String.valueOf(constantes.size())).append("):\n");
                    for (ArchivoDeMod.Constante constante : constantes) {
                        detalles.append("- ").append(this.formatearConstante(constante)).append("\n");
                    }
                } else if (datos.length >= 3 && datos[2] instanceof ArchivoDeMod.InfoCampo) {
                    ArchivoDeMod.InfoCampo campo = (ArchivoDeMod.InfoCampo)datos[2];
                    String nombreClase = (String)datos[1];
                    int indicePunto = nombreClase.lastIndexOf(46);
                    if (indicePunto > 0) {
                        nombreClase = nombreClase.substring(indicePunto + 1);
                    }
                    detalles.append(MonitorDePID.idioma.detalleCampo()).append(" ").append(campo.obtenerNombre()).append("\n");
                    detalles.append(MonitorDePID.idioma.clase()).append(": ").append(nombreClase).append("\n");
                    detalles.append(MonitorDePID.idioma.modulo()).append(": ").append(mod.ubicacion_para_publicar()).append("\n");
                    detalles.append(MonitorDePID.idioma.tipo()).append(": ").append(campo.obtenerDescriptor()).append("\n");
                } else if (datos.length >= 4 && datos[3] instanceof ArchivoDeMod.Referencia) {
                    ArchivoDeMod.InfoMetodo metodo = (ArchivoDeMod.InfoMetodo)datos[2];
                    ArchivoDeMod.Referencia referencia = (ArchivoDeMod.Referencia)datos[3];
                    String nombreClase = (String)datos[1];
                    int indicePunto = nombreClase.lastIndexOf(46);
                    if (indicePunto > 0) {
                        nombreClase = nombreClase.substring(indicePunto + 1);
                    }
                    String string5 = referencia.esMetodo() ? MonitorDePID.idioma.metodo() : MonitorDePID.idioma.campo();
                    String string6 = this.convertirFormatoClasePuntos(referencia.obtenerClase());
                    detalles.append(MonitorDePID.idioma.detalleMetodo()).append(" ").append(string5).append("\n");
                    detalles.append(MonitorDePID.idioma.nombres()).append(": ").append(referencia.obtenerNombre()).append("\n");
                    detalles.append("desc").append(": ").append(referencia.obtenerDescriptor()).append("\n");
                    detalles.append(MonitorDePID.idioma.clase()).append(": ").append(string6).append("\n\n");
                    detalles.append(MonitorDePID.idioma.referencias()).append(":\n");
                    detalles.append(MonitorDePID.idioma.metodo()).append(": ").append(nombreClase).append(".").append(metodo.obtenerNombre()).append(metodo.obtenerDescriptor()).append("\n");
                    detalles.append(MonitorDePID.idioma.modulo()).append(": ").append(mod.ubicacion_para_publicar()).append("\n");
                }
            }
        }
        this.areaContenido.setText(detalles.toString());
    }

    public String convertirFormatoClase(String nombreClase) {
        if (nombreClase.contains("/")) {
            return nombreClase;
        }
        if (nombreClase.contains(".")) {
            return nombreClase.replace('.', '/');
        }
        return nombreClase;
    }

    public String convertirFormatoClasePuntos(String nombreClase) {
        if (nombreClase.contains(".")) {
            return nombreClase;
        }
        if (nombreClase.contains("/")) {
            return nombreClase.replace('/', '.');
        }
        return nombreClase;
    }

    public void buscarEnIndiceAsync() {
        String filtro;
        if (this.workerBuscar != null && !this.workerBuscar.isDone()) {
            this.workerBuscar.cancel(true);
        }
        if ((filtro = this.campoBuscar.getText().trim()).isEmpty()) {
            this.construirArbolInicialAsync();
            return;
        }
        final String filtroLower = filtro.toLowerCase();
        String tipoFiltroUI = (String)this.comboFiltro.getSelectedItem();
        final String tipoFiltro = this.normalizarTipoFiltroUI(tipoFiltroUI);
        this.setCargando(true);
        this.workerBuscar = new SwingWorker<DefaultMutableTreeNode, Void>(){

            @Override
            protected DefaultMutableTreeNode doInBackground() {
                try {
                    List<PathDescriptor> coincidencias = new ArrayList<PathDescriptor>();
                    coincidencias.addAll(ArbolDeModsGUI.this.buscarEnIndiceCompacto(filtroLower, tipoFiltro));
                    if ("*".equals(tipoFiltro) || "METODO".equals(tipoFiltro) || "CAMPO".equals(tipoFiltro) || "CONSTANTE".equals(tipoFiltro) || tipoFiltro.startsWith("REFERENCIA")) {
                        coincidencias.addAll(this.buscarProfundoComoLista(filtroLower, tipoFiltro));
                    }
                    coincidencias = this.deduplicar(coincidencias);
                    return ArbolDeModsGUI.this.construirArbolResultadosJerarquico(coincidencias);
                }
                catch (CancellationException ce) {
                    return new DefaultMutableTreeNode(MonitorDePID.idioma.noSeEncontraronResultados());
                }
                catch (Throwable t) {
                    CrashDetectorLogger.logException(t);
                    DefaultMutableTreeNode raiz = new DefaultMutableTreeNode(MonitorDePID.idioma.resultadosBusqueda());
                    raiz.add(new DefaultMutableTreeNode("Error: " + t.getMessage()));
                    return raiz;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<PathDescriptor> buscarProfundoComoLista(String filtroLower2, String tipoFiltro2) {
                if (!Buscardor.puedeAnalizarElContentidoDeClase() || !ArchivoDeMod.esAnalisisDeBytecodeDisponible()) {
                    return new ArrayList<PathDescriptor>();
                }
                boolean incluirTodo = "*".equals(tipoFiltro2);
                int numHilos = Math.max(1, Runtime.getRuntime().availableProcessors());
                ExecutorService exec = Executors.newFixedThreadPool(numHilos, r -> {
                    Thread t = new Thread(r, "BusquedaProfunda-" + r.hashCode());
                    t.setDaemon(true);
                    return t;
                });
                ConcurrentLinkedQueue resultados = new ConcurrentLinkedQueue();
                ArrayList<Callable<Void>> tareas = new ArrayList<Callable<Void>>();
                List<ArchivoDeMod> mods = ArbolDeModsGUI.this.obtenerTodosLosMods();
                CrashDetectorLogger.log("\ud83d\udd0e Busqueda profunda: mods=" + mods.size());
                for (ArchivoDeMod mod : ArbolDeModsGUI.this.obtenerTodosLosMods()) {
                    for (String clasePuntos : mod.clases()) {
                        ArchivoDeMod modFinal = mod;
                        String claseFinalPuntos = clasePuntos;
                        tareas.add(() -> {
                            Object firma;
                            if (ArbolDeModsGUI.this.workerBuscar != null && ArbolDeModsGUI.this.workerBuscar.isCancelled()) {
                                return null;
                            }
                            String claseInterna = ArbolDeModsGUI.normalizarNombreClaseInterno(claseFinalPuntos);
                            if (!modFinal.existeClase(claseInterna)) {
                                return null;
                            }
                            String paquete = ArbolDeModsGUI.this.paqueteDe(claseFinalPuntos);
                            if (incluirTodo || "METODO".equals(tipoFiltro2)) {
                                for (ArchivoDeMod.InfoMetodo m : modFinal.obtenerMetodosConReferencias(claseInterna)) {
                                    firma = (m.obtenerNombre() + " " + m.obtenerDescriptor()).toLowerCase();
                                    if (!((String)firma).contains(filtroLower2)) continue;
                                    resultados.add(new PathDescriptor(modFinal.ubicacion_para_publicar(), paquete, claseFinalPuntos, m.obtenerNombre(), m.obtenerDescriptor(), "METODO"));
                                }
                            }
                            if (incluirTodo || "CAMPO".equals(tipoFiltro2)) {
                                for (ArchivoDeMod.InfoCampo f : modFinal.obtenerCampos(claseInterna)) {
                                    firma = (f.obtenerNombre() + " " + f.obtenerDescriptor()).toLowerCase();
                                    if (!((String)firma).contains(filtroLower2)) continue;
                                    resultados.add(new PathDescriptor(modFinal.ubicacion_para_publicar(), paquete, claseFinalPuntos, f.obtenerNombre(), f.obtenerDescriptor(), "CAMPO"));
                                }
                            }
                            if (incluirTodo || "CONSTANTE".equals(tipoFiltro2)) {
                                for (ArchivoDeMod.InfoMetodo m : modFinal.obtenerMetodosConReferencias(claseInterna)) {
                                    for (ArchivoDeMod.Constante c : modFinal.buscarConstantesEnMetodo(claseInterna, m.obtenerNombre(), m.obtenerDescriptor())) {
                                        String val = String.valueOf(c.obtenerValor()).toLowerCase();
                                        if (!val.contains(filtroLower2)) continue;
                                        resultados.add(new PathDescriptor(modFinal.ubicacion_para_publicar(), paquete, claseFinalPuntos, m.obtenerNombre(), String.valueOf(c.obtenerValor()), "CONSTANTE"));
                                    }
                                }
                            }
                            if (incluirTodo || tipoFiltro2.startsWith("REFERENCIA")) {
                                for (ArchivoDeMod.InfoMetodo m : modFinal.obtenerMetodosConReferencias(claseInterna)) {
                                    String s;
                                    if (incluirTodo || "REFERENCIA_METODO".equals(tipoFiltro2) || "REFERENCIA".equals(tipoFiltro2)) {
                                        for (ArchivoDeMod.Referencia ref : m.obtenerReferenciasAMetodos()) {
                                            s = (Buscardor.convertirFormatoClasePuntos(ref.obtenerClase()) + "." + ref.obtenerNombre() + ref.obtenerDescriptor()).toLowerCase();
                                            if (!s.contains(filtroLower2)) continue;
                                            resultados.add(new PathDescriptor(modFinal.ubicacion_para_publicar(), paquete, claseFinalPuntos, m.obtenerNombre(), m.obtenerDescriptor(), "REFERENCIA_METODO"));
                                            break;
                                        }
                                    }
                                    if (incluirTodo || "REFERENCIA_CAMPO".equals(tipoFiltro2) || "REFERENCIA".equals(tipoFiltro2)) {
                                        for (ArchivoDeMod.Referencia ref : m.obtenerReferenciasACampos()) {
                                            s = (Buscardor.convertirFormatoClasePuntos(ref.obtenerClase()) + "." + ref.obtenerNombre() + " " + ref.obtenerDescriptor()).toLowerCase();
                                            if (!s.contains(filtroLower2)) continue;
                                            resultados.add(new PathDescriptor(modFinal.ubicacion_para_publicar(), paquete, claseFinalPuntos, m.obtenerNombre(), m.obtenerDescriptor(), "REFERENCIA_CAMPO"));
                                            break;
                                        }
                                    }
                                    if (!incluirTodo && !"REFERENCIA_CLASE".equals(tipoFiltro2)) continue;
                                    boolean hit = false;
                                    for (ArchivoDeMod.Referencia ref : m.obtenerReferenciasAMetodos()) {
                                        if (!Buscardor.convertirFormatoClasePuntos(ref.obtenerClase()).toLowerCase().contains(filtroLower2)) continue;
                                        hit = true;
                                        break;
                                    }
                                    if (!hit) {
                                        for (ArchivoDeMod.Referencia ref : m.obtenerReferenciasACampos()) {
                                            if (!Buscardor.convertirFormatoClasePuntos(ref.obtenerClase()).toLowerCase().contains(filtroLower2)) continue;
                                            hit = true;
                                            break;
                                        }
                                    }
                                    if (!hit) continue;
                                    resultados.add(new PathDescriptor(modFinal.ubicacion_para_publicar(), paquete, claseFinalPuntos, m.obtenerNombre(), m.obtenerDescriptor(), "REFERENCIA_CLASE"));
                                }
                            }
                            return null;
                        });
                    }
                }
                try {
                    exec.invokeAll(tareas);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    exec.shutdownNow();
                }
                return new ArrayList<PathDescriptor>(resultados);
            }

            public List<PathDescriptor> deduplicar(List<PathDescriptor> in) {
                if (in == null || in.isEmpty()) {
                    return in;
                }
                LinkedHashSet<PathDescriptor> set = new LinkedHashSet<PathDescriptor>(in);
                return new ArrayList<PathDescriptor>(set);
            }

            @Override
            protected void done() {
                try {
                    if (this.isCancelled()) {
                        ArbolDeModsGUI.this.setCargando(false);
                        return;
                    }
                    DefaultMutableTreeNode raiz = (DefaultMutableTreeNode)this.get();
                    ArbolDeModsGUI.this.modeloArbol = new ModeloArbolConExpandibleMods(raiz);
                    ArbolDeModsGUI.this.arbolModulos.setModel(ArbolDeModsGUI.this.modeloArbol);
                }
                catch (Throwable t) {
                    CrashDetectorLogger.logException(t);
                }
                finally {
                    ArbolDeModsGUI.this.setCargando(false);
                }
            }
        };
        this.workerBuscar.execute();
    }

    public List<PathDescriptor> buscarEnIndiceCompacto(String filtroLower, String tipoFiltro) {
        Set<String> claves = ArbolDeModsGUI.extraerClavesConsulta(filtroLower);
        HashMap<PathDescriptor, Integer> puntuacion = new HashMap<PathDescriptor, Integer>();
        for (String clave : claves) {
            List<PathDescriptor> lista = this.indiceBusqueda.get(clave);
            if (lista == null) continue;
            for (PathDescriptor desc : lista) {
                String texto;
                if (!this.debeIncluirsePorTipoFiltro(desc, tipoFiltro) || (texto = this.textoBuscableDe(desc)) == null || !texto.contains(filtroLower)) continue;
                puntuacion.merge(desc, 1, Integer::sum);
            }
        }
        List<PathDescriptor> coincidencias = new ArrayList<PathDescriptor>(puntuacion.keySet());
        coincidencias.sort((a, b) -> Integer.compare(puntuacion.getOrDefault(b, 0), puntuacion.getOrDefault(a, 0)));
        int LIMITE_RESULTADOS = 5000;
        if (coincidencias.size() > 5000) {
            coincidencias = coincidencias.subList(0, 5000);
        }
        return coincidencias;
    }

    private DefaultMutableTreeNode construirArbolResultadosJerarquico(List<PathDescriptor> coincidencias) {
        DefaultMutableTreeNode raiz = new DefaultMutableTreeNode(MonitorDePID.idioma.resultadosBusqueda());
        if (coincidencias == null || coincidencias.isEmpty()) {
            raiz.add(new DefaultMutableTreeNode(MonitorDePID.idioma.noSeEncontraronResultados()));
            return raiz;
        }
        Map<String, ArchivoDeMod> modsPorUbicacion = this.obtenerMapaModsPorUbicacion();
        HashMap<String, DefaultMutableTreeNode> nodosMod = new HashMap<String, DefaultMutableTreeNode>();
        for (PathDescriptor d : coincidencias) {
            Object[] datos;
            Object info;
            String texto;
            String desc;
            String nombre;
            DefaultMutableTreeNode cont;
            String clase;
            String ub = d.obtenerModUbicacion();
            ArchivoDeMod modReal = modsPorUbicacion.get(ub);
            DefaultMutableTreeNode nodoMod = nodosMod.computeIfAbsent(ub, k -> new DefaultMutableTreeNode(new NodoConTexto((String)k, modReal != null ? modReal : new ArchivoDeModFake((String)k))));
            String tipo = d.obtenerTipo();
            if ("MOD".equals(tipo)) continue;
            String paquete = d.obtenerPaquete() == null ? "" : d.obtenerPaquete();
            DefaultMutableTreeNode nodoPaquete = this.asegurarNodoPaquete(nodoMod, paquete);
            if ("PAQUETE".equals(tipo) || (clase = d.obtenerClase()) == null) continue;
            DefaultMutableTreeNode nodoClase = this.asegurarNodoClase(nodoPaquete, modReal, clase);
            if ("CLASE".equals(tipo)) continue;
            if ("METODO".equals(tipo)) {
                cont = this.asegurarNodoContenedor(nodoClase, "contenedor_metodos", MonitorDePID.idioma.metodos());
                nombre = d.obtenerMetodo();
                desc = d.obtenerDescriptor();
                texto = nombre + (desc != null ? desc : "");
                info = this.resolverInfoMetodoReal(modReal, clase, nombre, desc);
                if (info == null) {
                    info = (ArchivoDeMod.InfoMetodo)this.crearPlaceholderInfo(nombre, desc, "METODO");
                }
                datos = new Object[]{modReal, clase, info};
                cont.add(new DefaultMutableTreeNode(new NodoConTexto(texto, datos)));
                continue;
            }
            if (tipo != null && tipo.startsWith("REFERENCIA")) {
                cont = this.asegurarNodoContenedor(nodoClase, "contenedor_referencias", MonitorDePID.idioma.referencias());
                nombre = d.obtenerMetodo();
                desc = d.obtenerDescriptor();
                texto = nombre + (desc != null ? desc : "");
                info = this.resolverInfoMetodoReal(modReal, clase, nombre, desc);
                if (info == null) {
                    info = (ArchivoDeMod.InfoMetodo)this.crearPlaceholderInfo(nombre, desc, "METODO");
                }
                datos = new Object[]{modReal, clase, info};
                cont.add(new DefaultMutableTreeNode(new NodoConTexto(texto, datos)));
                continue;
            }
            if ("CAMPO".equals(tipo)) {
                cont = this.asegurarNodoContenedor(nodoClase, "contenedor_campos", MonitorDePID.idioma.campos());
                nombre = d.obtenerMetodo();
                desc = d.obtenerDescriptor();
                texto = nombre + (desc != null ? desc : "");
                info = this.resolverInfoCampoReal(modReal, clase, nombre, desc);
                if (info == null) {
                    info = (ArchivoDeMod.InfoCampo)this.crearPlaceholderInfo(nombre, desc, "CAMPO");
                }
                datos = new Object[]{modReal, clase, info};
                cont.add(new DefaultMutableTreeNode(new NodoConTexto(texto, datos)));
                continue;
            }
            if (!"CONSTANTE".equals(tipo)) continue;
            cont = this.asegurarNodoContenedor(nodoClase, "contenedor_constantes", "CONSTANTE");
            String valor = d.obtenerDescriptor();
            String texto2 = String.valueOf(valor);
            Object[] datos2 = new Object[]{modReal, clase, this.crearPlaceholderInfo("const", valor, "CONSTANTE")};
            cont.add(new DefaultMutableTreeNode(new NodoConTexto(texto2, datos2)));
        }
        for (DefaultMutableTreeNode nm : nodosMod.values()) {
            if (nm.getChildCount() <= 0) continue;
            raiz.add(nm);
        }
        if (raiz.getChildCount() == 0) {
            raiz.add(new DefaultMutableTreeNode(MonitorDePID.idioma.noSeEncontraronResultados()));
        }
        return raiz;
    }

    private DefaultMutableTreeNode asegurarNodoPaquete(DefaultMutableTreeNode nodoMod, String paquete) {
        String etiqueta = paquete == null || paquete.isEmpty() ? "(paquete por defecto)" : paquete;
        for (int i = 0; i < nodoMod.getChildCount(); ++i) {
            Object obj;
            DefaultMutableTreeNode h = (DefaultMutableTreeNode)nodoMod.getChildAt(i);
            Object uo = h.getUserObject();
            if (!(uo instanceof NodoConTexto) || !((obj = ((NodoConTexto)uo).objeto()) instanceof String) || !((String)obj).equals(paquete == null ? "" : paquete)) continue;
            return h;
        }
        DefaultMutableTreeNode nuevo = new DefaultMutableTreeNode(new NodoConTexto(etiqueta, paquete == null ? "" : paquete));
        nodoMod.add(nuevo);
        return nuevo;
    }

    private String textoBuscableDe(PathDescriptor d) {
        if (d == null) {
            return null;
        }
        String tipo = d.obtenerTipo();
        if ("MOD".equals(tipo)) {
            return (d.obtenerModUbicacion() == null ? "" : d.obtenerModUbicacion()).toLowerCase();
        }
        if ("PAQUETE".equals(tipo)) {
            return (d.obtenerPaquete() == null ? "" : d.obtenerPaquete()).toLowerCase();
        }
        if ("CLASE".equals(tipo)) {
            return (d.obtenerClase() == null ? "" : d.obtenerClase()).toLowerCase();
        }
        if ("METODO".equals(tipo) || "CAMPO".equals(tipo)) {
            String n = d.obtenerMetodo() == null ? "" : d.obtenerMetodo();
            String desc = d.obtenerDescriptor() == null ? "" : d.obtenerDescriptor();
            return (n + " " + desc + " " + (d.obtenerClase() == null ? "" : d.obtenerClase())).toLowerCase();
        }
        if ("CONSTANTE".equals(tipo)) {
            return (d.obtenerDescriptor() == null ? "" : d.obtenerDescriptor()).toLowerCase();
        }
        return null;
    }

    private Map<String, ArchivoDeMod> obtenerMapaModsPorUbicacion() {
        HashMap<String, ArchivoDeMod> mapa = new HashMap<String, ArchivoDeMod>();
        for (ArchivoDeMod m : Buscardor.mods) {
            this.rellenarMapaModsRecursivo(m, mapa);
        }
        return mapa;
    }

    private void rellenarMapaModsRecursivo(ArchivoDeMod mod, Map<String, ArchivoDeMod> mapa) {
        if (mod == null) {
            return;
        }
        mapa.put(mod.ubicacion_para_publicar(), mod);
        for (ArchivoDeMod sub : mod.mods_en_mods()) {
            this.rellenarMapaModsRecursivo(sub, mapa);
        }
    }

    public void cargarContenidoModuloAsync(final DefaultMutableTreeNode nodoMod, final ArchivoDeMod mod) {
        this.setCargando(true);
        new SwingWorker<List<DefaultMutableTreeNode>, Void>(){

            @Override
            protected List<DefaultMutableTreeNode> doInBackground() {
                ArrayList<DefaultMutableTreeNode> hijos = new ArrayList<DefaultMutableTreeNode>();
                for (ArchivoDeMod submod : mod.mods_en_mods()) {
                    hijos.add(new DefaultMutableTreeNode(new NodoConTexto(submod.ubicacion_para_publicar(), submod)));
                }
                if (!mod.clases().isEmpty()) {
                    Map<String, List<String>> clasesPorPaquete = ArbolDeModsGUI.this.agruparClasesPorPaquete(mod.clases());
                    for (Map.Entry<String, List<String>> entrada : clasesPorPaquete.entrySet()) {
                        String paquete = entrada.getKey();
                        List<String> clasesEnPaquete = entrada.getValue();
                        DefaultMutableTreeNode nodoPaquete = paquete.isEmpty() ? new DefaultMutableTreeNode(new NodoConTexto("(paquete por defecto) (" + clasesEnPaquete.size() + " clases)", paquete)) : new DefaultMutableTreeNode(new NodoConTexto(paquete + " (" + clasesEnPaquete.size() + " clases)", paquete));
                        for (String nombreClase : clasesEnPaquete) {
                            String clasePuntos = paquete.isEmpty() ? nombreClase : paquete + "." + nombreClase;
                            String claseInterna = ArbolDeModsGUI.normalizarNombreClaseInterno(clasePuntos);
                            DefaultMutableTreeNode nodoClase = new DefaultMutableTreeNode(new NodoConTexto(nombreClase, new Object[]{mod, clasePuntos}));
                            if (Buscardor.puedeAnalizarElContentidoDeClase() && mod.existeClase(claseInterna)) {
                                List<ArchivoDeMod.InfoCampo> campos;
                                List<ArchivoDeMod.InfoMetodo> metodos = mod.obtenerMetodosConReferencias(claseInterna);
                                if (!metodos.isEmpty()) {
                                    DefaultMutableTreeNode nodoMetodos = new DefaultMutableTreeNode(new NodoConTexto(MonitorDePID.idioma.metodos() + " (" + metodos.size() + ")", "contenedor_metodos"));
                                    for (ArchivoDeMod.InfoMetodo metodo : metodos) {
                                        DefaultMutableTreeNode nodoMetodo = new DefaultMutableTreeNode(new NodoConTexto(metodo.obtenerNombre() + metodo.obtenerDescriptor(), new Object[]{mod, clasePuntos, metodo}));
                                        List<ArchivoDeMod.Constante> constantes = mod.buscarConstantesEnMetodo(claseInterna, metodo.obtenerNombre(), metodo.obtenerDescriptor());
                                        if (!constantes.isEmpty()) {
                                            DefaultMutableTreeNode nodoConstantes = new DefaultMutableTreeNode(new NodoConTexto("Constantes (" + constantes.size() + ")", "contenedor_constantes"));
                                            for (ArchivoDeMod.Constante k : constantes) {
                                                nodoConstantes.add(new DefaultMutableTreeNode(new NodoConTexto(ArbolDeModsGUI.this.formatearConstante(k), new Object[]{mod, clasePuntos, metodo, k})));
                                            }
                                            nodoMetodo.add(nodoConstantes);
                                        }
                                        if (!metodo.obtenerReferenciasAMetodos().isEmpty() || !metodo.obtenerReferenciasACampos().isEmpty()) {
                                            String claseMostrar;
                                            DefaultMutableTreeNode nodoReferencias = new DefaultMutableTreeNode(new NodoConTexto(MonitorDePID.idioma.referencias() + " (" + (metodo.obtenerReferenciasAMetodos().size() + metodo.obtenerReferenciasACampos().size()) + ")", "contenedor_referencias"));
                                            for (ArchivoDeMod.Referencia ref : metodo.obtenerReferenciasAMetodos()) {
                                                claseMostrar = Buscardor.convertirFormatoClasePuntos(ref.obtenerClase());
                                                nodoReferencias.add(new DefaultMutableTreeNode(new NodoConTexto(MonitorDePID.idioma.metodo() + ": " + claseMostrar + "." + ref.obtenerNombre() + ref.obtenerDescriptor(), new Object[]{mod, clasePuntos, metodo, ref})));
                                            }
                                            for (ArchivoDeMod.Referencia ref : metodo.obtenerReferenciasACampos()) {
                                                claseMostrar = Buscardor.convertirFormatoClasePuntos(ref.obtenerClase());
                                                nodoReferencias.add(new DefaultMutableTreeNode(new NodoConTexto(MonitorDePID.idioma.campo() + ": " + claseMostrar + "." + ref.obtenerNombre() + " " + ref.obtenerDescriptor(), new Object[]{mod, clasePuntos, metodo, ref})));
                                            }
                                            nodoMetodo.add(nodoReferencias);
                                        }
                                        nodoMetodos.add(nodoMetodo);
                                    }
                                    nodoClase.add(nodoMetodos);
                                }
                                if (!(campos = mod.obtenerCampos(claseInterna)).isEmpty()) {
                                    DefaultMutableTreeNode nodoCampos = new DefaultMutableTreeNode(new NodoConTexto(MonitorDePID.idioma.campos() + " (" + campos.size() + ")", "contenedor_campos"));
                                    for (ArchivoDeMod.InfoCampo campo : campos) {
                                        nodoCampos.add(new DefaultMutableTreeNode(new NodoConTexto(campo.obtenerNombre() + " " + campo.obtenerDescriptor(), new Object[]{mod, clasePuntos, campo})));
                                    }
                                    nodoClase.add(nodoCampos);
                                }
                            }
                            nodoPaquete.add(nodoClase);
                        }
                        hijos.add(nodoPaquete);
                    }
                }
                return hijos;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        List hijos = (List)this.get();
                        for (DefaultMutableTreeNode hijo : hijos) {
                            ArbolDeModsGUI.this.modeloArbol.insertNodeInto(hijo, nodoMod, nodoMod.getChildCount());
                        }
                        ArbolDeModsGUI.this.modeloArbol.nodeStructureChanged(nodoMod);
                        ArbolDeModsGUI.this.arbolModulos.expandPath(new TreePath(nodoMod.getPath()));
                        CrashDetectorLogger.log("\u2705 [EXPAND] Contenido cargado...");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    ArbolDeModsGUI.this.setCargando(false);
                }
            }
        }.execute();
    }

    public void iniciarCargaPesada() {
        this.setCargando(true);
        this.getRootPane().getGlassPane().setVisible(true);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Buscardor.cargarYPrecargarClasesEnCache();
                ArbolDeModsGUI.this.construirIndice();
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArbolDeModsGUI.this.construirArbolInicialAsync();
                ArbolDeModsGUI.this.setCargando(false);
                CrashDetectorLogger.log("iniciarCargaPesada done");
            }
        }.execute();
    }

    private String normalizarTipoFiltroUI(String seleccionado) {
        if (seleccionado == null) {
            return "*";
        }
        String s = seleccionado.trim();
        if (s.isEmpty() || "*".equals(s)) {
            return "*";
        }
        String sl = s.toLowerCase();
        if (sl.contains("refer")) {
            if (sl.contains("method") || sl.contains("m\u00e9tod") || sl.contains("metod")) {
                return "REFERENCIA_METODO";
            }
            if (sl.contains("field") || sl.contains("campo")) {
                return "REFERENCIA_CAMPO";
            }
            if (sl.contains("class") || sl.contains("clase")) {
                return "REFERENCIA_CLASE";
            }
            return "REFERENCIA";
        }
        if (sl.contains("paquet") || sl.contains("package")) {
            return "PAQUETE";
        }
        if (sl.contains("class") || sl.contains("clase")) {
            return "CLASE";
        }
        if (sl.contains("method") || sl.contains("m\u00e9tod") || sl.contains("metod")) {
            return "METODO";
        }
        if (sl.contains("field") || sl.contains("campo")) {
            return "CAMPO";
        }
        if (sl.contains("const")) {
            return "CONSTANTE";
        }
        return "*";
    }

    public boolean debeIncluirsePorTipoFiltro(PathDescriptor desc, String tipoFiltro) {
        String tf = this.normalizarTipoFiltroUI(tipoFiltro);
        if (desc == null) {
            return false;
        }
        if ("*".equals(tf)) {
            return true;
        }
        String tipoDesc = desc.obtenerTipo();
        if (tipoDesc == null) {
            return false;
        }
        switch (tf) {
            case "PAQUETE": {
                return "PAQUETE".equals(tipoDesc);
            }
            case "CLASE": {
                return "CLASE".equals(tipoDesc);
            }
            case "METODO": {
                return "METODO".equals(tipoDesc);
            }
            case "CAMPO": {
                return "CAMPO".equals(tipoDesc);
            }
            case "CONSTANTE": {
                return "CONSTANTE".equals(tipoDesc);
            }
            case "REFERENCIA_METODO": {
                return "REFERENCIA_METODO".equals(tipoDesc) || "REFERENCIA".equals(tipoDesc);
            }
            case "REFERENCIA_CAMPO": {
                return "REFERENCIA_CAMPO".equals(tipoDesc) || "REFERENCIA".equals(tipoDesc);
            }
            case "REFERENCIA_CLASE": {
                return "REFERENCIA_CLASE".equals(tipoDesc) || "REFERENCIA".equals(tipoDesc);
            }
        }
        return true;
    }

    public Object crearPlaceholderInfo(String nombre, String descriptor, String tipo) {
        if ("METODO".equals(tipo) || "CONSTANTE".equals(tipo)) {
            return new ArchivoDeMod.InfoMetodo(nombre, descriptor, new ArrayList<ArchivoDeMod.Referencia>(), new ArrayList<ArchivoDeMod.Referencia>());
        }
        return new ArchivoDeMod.InfoCampo(nombre, descriptor);
    }

    private ArchivoDeMod.InfoMetodo resolverInfoMetodoReal(ArchivoDeMod mod, String clasePuntos, String nombreMetodo, String descriptor) {
        if (mod == null || clasePuntos == null || nombreMetodo == null || descriptor == null) {
            return null;
        }
        try {
            String claseInterna = ArbolDeModsGUI.normalizarNombreClaseInterno(clasePuntos);
            if (!mod.existeClase(claseInterna)) {
                return null;
            }
            for (ArchivoDeMod.InfoMetodo m : mod.obtenerMetodosConReferencias(claseInterna)) {
                if (!nombreMetodo.equals(m.obtenerNombre()) || !descriptor.equals(m.obtenerDescriptor())) continue;
                return m;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private ArchivoDeMod.InfoCampo resolverInfoCampoReal(ArchivoDeMod mod, String clasePuntos, String nombreCampo, String descriptor) {
        if (mod == null || clasePuntos == null || nombreCampo == null) {
            return null;
        }
        try {
            String claseInterna = ArbolDeModsGUI.normalizarNombreClaseInterno(clasePuntos);
            if (!mod.existeClase(claseInterna)) {
                return null;
            }
            for (ArchivoDeMod.InfoCampo c : mod.obtenerCampos(claseInterna)) {
                if (!nombreCampo.equals(c.obtenerNombre()) || descriptor != null && !descriptor.equals(c.obtenerDescriptor())) continue;
                return c;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void construirArbolInicial() {
        DefaultMutableTreeNode raiz = new DefaultMutableTreeNode(MonitorDePID.idioma.modsCargados());
        for (ArchivoDeMod mod : Buscardor.mods) {
            this.agregarModuloARaiz(raiz, mod);
        }
        this.modeloArbol = new ModeloArbolConExpandibleMods(raiz);
        this.arbolModulos.setModel(this.modeloArbol);
    }

    public Map<String, List<String>> agruparClasesPorPaquete(List<String> clases) {
        TreeMap<String, List<String>> clasesPorPaquete = new TreeMap<String, List<String>>();
        for (String clase : clases) {
            String paquete = "";
            String nombreClase = clase;
            int indiceUltimoPunto = clase.lastIndexOf(46);
            if (indiceUltimoPunto > 0) {
                paquete = clase.substring(0, indiceUltimoPunto);
                nombreClase = clase.substring(indiceUltimoPunto + 1);
            } else {
                int idxBarra = clase.lastIndexOf(47);
                if (idxBarra > 0) {
                    paquete = clase.substring(0, idxBarra).replace('/', '.');
                    nombreClase = clase.substring(idxBarra + 1);
                }
            }
            clasesPorPaquete.computeIfAbsent(paquete, k -> new ArrayList()).add(nombreClase);
        }
        return clasesPorPaquete;
    }

    public void agregarModuloARaiz(DefaultMutableTreeNode padre, ArchivoDeMod mod) {
        String ubicacionPublica = mod.ubicacion_para_publicar();
        DefaultMutableTreeNode nodoModulo = new DefaultMutableTreeNode(new NodoConTexto(ubicacionPublica, mod));
        padre.add(nodoModulo);
        for (ArchivoDeMod submod : mod.mods_en_mods()) {
            this.agregarModuloARaiz(nodoModulo, submod);
        }
        if (!mod.clases().isEmpty()) {
            Map<String, List<String>> clasesPorPaquete = this.agruparClasesPorPaquete(mod.clases());
            for (Map.Entry<String, List<String>> entrada : clasesPorPaquete.entrySet()) {
                String paquete = entrada.getKey();
                List<String> clasesEnPaquete = entrada.getValue();
                DefaultMutableTreeNode nodoPaquete = paquete.isEmpty() ? new DefaultMutableTreeNode(new NodoConTexto("(paquete por defecto) (" + clasesEnPaquete.size() + " clases)", paquete)) : new DefaultMutableTreeNode(new NodoConTexto(paquete + " (" + clasesEnPaquete.size() + " clases)", paquete));
                for (String nombreClase : clasesEnPaquete) {
                    String clasePuntos = paquete.isEmpty() ? nombreClase : paquete + "." + nombreClase;
                    String claseInterna = ArbolDeModsGUI.normalizarNombreClaseInterno(clasePuntos);
                    DefaultMutableTreeNode nodoClase = new DefaultMutableTreeNode(new NodoConTexto(nombreClase, new Object[]{mod, clasePuntos}));
                    if (Buscardor.puedeAnalizarElContentidoDeClase() && mod.existeClase(claseInterna)) {
                        List<ArchivoDeMod.InfoCampo> campos;
                        List<ArchivoDeMod.InfoMetodo> metodos = mod.obtenerMetodosConReferencias(claseInterna);
                        if (!metodos.isEmpty()) {
                            DefaultMutableTreeNode nodoMetodos = new DefaultMutableTreeNode(new NodoConTexto(MonitorDePID.idioma.metodos() + " (" + metodos.size() + ")", "contenedor_metodos"));
                            for (ArchivoDeMod.InfoMetodo metodo : metodos) {
                                DefaultMutableTreeNode nodoMetodo = new DefaultMutableTreeNode(new NodoConTexto(metodo.obtenerNombre() + metodo.obtenerDescriptor(), new Object[]{mod, clasePuntos, metodo}));
                                String claseInterna2 = ArbolDeModsGUI.normalizarNombreClaseInterno(claseInterna);
                                List<ArchivoDeMod.Constante> constantes = mod.buscarConstantesEnMetodo(claseInterna2, metodo.obtenerNombre(), metodo.obtenerDescriptor());
                                if (!constantes.isEmpty()) {
                                    DefaultMutableTreeNode nodoConstantes = new DefaultMutableTreeNode(new NodoConTexto("Constantes (" + constantes.size() + ")", "contenedor_constantes"));
                                    for (ArchivoDeMod.Constante k : constantes) {
                                        nodoConstantes.add(new DefaultMutableTreeNode(new NodoConTexto(this.formatearConstante(k), new Object[]{mod, clasePuntos, metodo, k})));
                                    }
                                    nodoMetodo.add(nodoConstantes);
                                }
                                if (!metodo.obtenerReferenciasAMetodos().isEmpty() || !metodo.obtenerReferenciasACampos().isEmpty()) {
                                    String nombreClaseMostrar;
                                    DefaultMutableTreeNode nodoReferencias = new DefaultMutableTreeNode(new NodoConTexto(MonitorDePID.idioma.referencias() + " (" + (metodo.obtenerReferenciasAMetodos().size() + metodo.obtenerReferenciasACampos().size()) + ")", "contenedor_referencias"));
                                    for (ArchivoDeMod.Referencia refMetodo : metodo.obtenerReferenciasAMetodos()) {
                                        nombreClaseMostrar = Buscardor.convertirFormatoClasePuntos(refMetodo.obtenerClase());
                                        DefaultMutableTreeNode nodoRefMetodo = new DefaultMutableTreeNode(new NodoConTexto(MonitorDePID.idioma.metodo() + ": " + nombreClaseMostrar + "." + refMetodo.obtenerNombre() + refMetodo.obtenerDescriptor(), new Object[]{mod, clasePuntos, metodo, refMetodo}));
                                        nodoReferencias.add(nodoRefMetodo);
                                    }
                                    for (ArchivoDeMod.Referencia refCampo : metodo.obtenerReferenciasACampos()) {
                                        nombreClaseMostrar = Buscardor.convertirFormatoClasePuntos(refCampo.obtenerClase());
                                        DefaultMutableTreeNode nodoRefCampo = new DefaultMutableTreeNode(new NodoConTexto(MonitorDePID.idioma.campo() + ": " + nombreClaseMostrar + "." + refCampo.obtenerNombre() + " " + refCampo.obtenerDescriptor(), new Object[]{mod, clasePuntos, metodo, refCampo}));
                                        nodoReferencias.add(nodoRefCampo);
                                    }
                                    nodoMetodo.add(nodoReferencias);
                                }
                                nodoMetodos.add(nodoMetodo);
                            }
                            nodoClase.add(nodoMetodos);
                        }
                        if (!(campos = mod.obtenerCampos(claseInterna)).isEmpty()) {
                            DefaultMutableTreeNode nodoCampos = new DefaultMutableTreeNode(new NodoConTexto(MonitorDePID.idioma.campos() + " (" + campos.size() + ")", "contenedor_campos"));
                            for (ArchivoDeMod.InfoCampo campo : campos) {
                                DefaultMutableTreeNode nodoCampo = new DefaultMutableTreeNode(new NodoConTexto(campo.obtenerNombre() + " " + campo.obtenerDescriptor(), new Object[]{mod, clasePuntos, campo}));
                                nodoCampos.add(nodoCampo);
                            }
                            nodoClase.add(nodoCampos);
                        }
                    }
                    nodoPaquete.add(nodoClase);
                }
                nodoModulo.add(nodoPaquete);
            }
        }
    }

    public List<ArchivoDeMod> obtenerTodosLosMods() {
        ArrayList<ArchivoDeMod> out = new ArrayList<ArchivoDeMod>();
        for (ArchivoDeMod m : Buscardor.mods) {
            this.recolectarModsRec(out, m);
        }
        return out;
    }

    public void recolectarModsRec(List<ArchivoDeMod> out, ArchivoDeMod m) {
        if (m == null) {
            return;
        }
        out.add(m);
        for (ArchivoDeMod sub : m.mods_en_mods()) {
            this.recolectarModsRec(out, sub);
        }
    }

    public void initOverlayCarga() {
        this.overlayCarga = new JPanel(new FlowLayout(1));
        this.overlayCarga.setOpaque(false);
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.setBackground(new Color(0, 0, 0, 120));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        ImageIcon icon = new ImageIcon(Statics.carpeta.resolve("imagenes/padoru.gif").toString());
        if (icon.getIconWidth() <= 0) {
            icon = this.crearIcono("", "\u2026");
        }
        this.gifCarga = new JLabel(icon);
        this.gifCarga.setText(MonitorDePID.idioma.cargando());
        this.gifCarga.setHorizontalTextPosition(0);
        this.gifCarga.setVerticalTextPosition(3);
        this.gifCarga.setForeground(Color.WHITE);
        this.gifCarga.setFont(this.gifCarga.getFont().deriveFont(1, 14.0f));
        panel.add(this.gifCarga);
        this.overlayCarga.add(panel);
        this.getRootPane().setGlassPane(this.overlayCarga);
    }

    public void setCargando(boolean on) {
        this.cargando = on;
        this.overlayCarga.setVisible(on);
        this.overlayCarga.setOpaque(false);
        this.overlayCarga.revalidate();
        this.overlayCarga.repaint();
    }

    public void construirArbolInicialAsync() {
        if (this.workerConstruir != null && !this.workerConstruir.isDone()) {
            this.workerConstruir.cancel(true);
        }
        this.setCargando(true);
        this.workerConstruir = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                ArrayList<DefaultMutableTreeNode> mods = new ArrayList<DefaultMutableTreeNode>();
                for (ArchivoDeMod mod : Buscardor.mods) {
                    mods.add(new DefaultMutableTreeNode(new NodoConTexto(mod.ubicacion_para_publicar(), mod)));
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        DefaultMutableTreeNode raizActual = (DefaultMutableTreeNode)ArbolDeModsGUI.this.modeloArbol.getRoot();
                        raizActual.removeAllChildren();
                        raizActual.setUserObject(MonitorDePID.idioma.modsCargados());
                        for (ArchivoDeMod mod : Buscardor.mods) {
                            DefaultMutableTreeNode nodoMod = new DefaultMutableTreeNode(new NodoConTexto(mod.ubicacion_para_publicar(), mod));
                            ArbolDeModsGUI.this.modeloArbol.insertNodeInto(nodoMod, raizActual, raizActual.getChildCount());
                        }
                        ArbolDeModsGUI.this.modeloArbol.nodeStructureChanged(raizActual);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    ArbolDeModsGUI.this.setCargando(false);
                    CrashDetectorLogger.log("no cargando completa");
                }
            }
        };
        this.workerConstruir.execute();
    }

    public String paqueteDe(String clase) {
        int iBarra;
        if (clase == null) {
            return "";
        }
        int iPunto = clase.lastIndexOf(46);
        int i = Math.max(iPunto, iBarra = clase.lastIndexOf(47));
        if (i > 0) {
            String p = clase.substring(0, i);
            return p.replace('/', '.');
        }
        return "";
    }

    public String nombreSimpleDe(String clase) {
        int iBarra;
        if (clase == null) {
            return "";
        }
        int iPunto = clase.lastIndexOf(46);
        int i = Math.max(iPunto, iBarra = clase.lastIndexOf(47));
        return i > 0 ? clase.substring(i + 1) : clase;
    }

    public DefaultMutableTreeNode asegurarNodoClase(DefaultMutableTreeNode nodoPaquete, ArchivoDeMod mod, String clasePuntos) {
        for (int i = 0; i < nodoPaquete.getChildCount(); ++i) {
            Object[] arr;
            Object obj;
            DefaultMutableTreeNode hijo = (DefaultMutableTreeNode)nodoPaquete.getChildAt(i);
            Object uo = hijo.getUserObject();
            if (!(uo instanceof NodoConTexto) || !((obj = ((NodoConTexto)uo).objeto()) instanceof Object[]) || (arr = (Object[])obj).length < 2 || arr[0] != mod || !clasePuntos.equals(arr[1])) continue;
            return hijo;
        }
        DefaultMutableTreeNode nodoClase = new DefaultMutableTreeNode(new NodoConTexto(this.nombreSimpleDe(clasePuntos), new Object[]{mod, clasePuntos}));
        nodoPaquete.add(nodoClase);
        return nodoClase;
    }

    public DefaultMutableTreeNode asegurarNodoContenedor(DefaultMutableTreeNode padre, String clave, String etiqueta) {
        for (int i = 0; i < padre.getChildCount(); ++i) {
            DefaultMutableTreeNode hijo = (DefaultMutableTreeNode)padre.getChildAt(i);
            Object uo = hijo.getUserObject();
            if (!(uo instanceof NodoConTexto) || !clave.equals(((NodoConTexto)uo).objeto())) continue;
            return hijo;
        }
        DefaultMutableTreeNode cont = new DefaultMutableTreeNode(new NodoConTexto(etiqueta, clave));
        padre.add(cont);
        return cont;
    }

    public String formatearConstante(ArchivoDeMod.Constante c) {
        String val;
        Object v = c.obtenerValor();
        if (v instanceof String) {
            String s = (String)v;
            s = s.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\"", "\\\"");
            val = "\"" + s + "\"";
        } else {
            val = String.valueOf(v);
        }
        return c.obtenerTipo() + ": " + val;
    }

    public boolean constanteCoincide(ArchivoDeMod.Constante c, String filtroLower) {
        return this.formatearConstante(c).toLowerCase().contains(filtroLower);
    }

    public void asegurarNodoConstantesPara(DefaultMutableTreeNode nodoMetodo) {
        Object uo = nodoMetodo.getUserObject();
        if (!(uo instanceof NodoConTexto)) {
            return;
        }
        Object payload = ((NodoConTexto)uo).objeto();
        if (!(payload instanceof Object[])) {
            return;
        }
        Object[] datos = (Object[])payload;
        if (!(datos.length == 3 && datos[0] instanceof ArchivoDeMod && datos[1] instanceof String && datos[2] instanceof ArchivoDeMod.InfoMetodo)) {
            return;
        }
        ArchivoDeMod mod = (ArchivoDeMod)datos[0];
        String clasePuntos = (String)datos[1];
        ArchivoDeMod.InfoMetodo metodo = (ArchivoDeMod.InfoMetodo)datos[2];
        for (int i = 0; i < nodoMetodo.getChildCount(); ++i) {
            Object uoH = ((DefaultMutableTreeNode)nodoMetodo.getChildAt(i)).getUserObject();
            if (!(uoH instanceof NodoConTexto) || !"contenedor_constantes".equals(((NodoConTexto)uoH).objeto())) continue;
            return;
        }
        String claseInterna = ArbolDeModsGUI.normalizarNombreClaseInterno(clasePuntos);
        List<ArchivoDeMod.Constante> constantes = mod.buscarConstantesEnMetodo(claseInterna, metodo.obtenerNombre(), metodo.obtenerDescriptor());
        if (constantes == null || constantes.isEmpty()) {
            return;
        }
        DefaultMutableTreeNode nodoConst = new DefaultMutableTreeNode(new NodoConTexto("Constantes (" + constantes.size() + ")", "contenedor_constantes"));
        for (ArchivoDeMod.Constante k : constantes) {
            nodoConst.add(new DefaultMutableTreeNode(new NodoConTexto(this.formatearConstante(k), new Object[]{mod, clasePuntos, metodo, k})));
        }
        this.modeloArbol.insertNodeInto(nodoConst, nodoMetodo, nodoMetodo.getChildCount());
        this.arbolModulos.expandPath(new TreePath(nodoMetodo.getPath()));
    }

    public ImageIcon crearIcono(String ruta, String textoAlternativo) {
        ImageIcon icono = new ImageIcon(ruta);
        if (icono.getIconWidth() <= 0) {
            int tamano = 16;
            BufferedImage imagen = new BufferedImage(tamano, tamano, 2);
            Graphics2D g2d = imagen.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(new Color(200, 200, 200, 150));
            g2d.fillOval(0, 0, tamano - 1, tamano - 1);
            g2d.setColor(Color.BLACK);
            g2d.setFont(new Font("Arial", 1, 10));
            FontMetrics fm = g2d.getFontMetrics();
            int x = (tamano - fm.stringWidth(textoAlternativo)) / 2;
            int y = (tamano - fm.getHeight()) / 2 + fm.getAscent();
            g2d.drawString(textoAlternativo, x, y);
            g2d.dispose();
            return new ImageIcon(imagen);
        }
        return icono;
    }

    public void mostrarMenuContexto(MouseEvent e) {
        TreePath seleccion = this.arbolModulos.getPathForLocation(e.getX(), e.getY());
        if (seleccion == null) {
            return;
        }
        Object nodo = seleccion.getLastPathComponent();
        if (!(nodo instanceof DefaultMutableTreeNode)) {
            return;
        }
        Object objetoUsuario = ((DefaultMutableTreeNode)nodo).getUserObject();
        if (objetoUsuario == null) {
            return;
        }
        Object objetoReal = objetoUsuario instanceof NodoConTexto ? ((NodoConTexto)objetoUsuario).objeto() : objetoUsuario;
        JPopupMenu menu = new JPopupMenu();
        JMenuItem itemBuscarRef = new JMenuItem(MonitorDePID.idioma.buscarReferencias());
        itemBuscarRef.addActionListener(ae -> {
            Object[] datos;
            if (objetoReal instanceof ArchivoDeMod) {
                ArrayList<ArchivoDeMod> mods = new ArrayList<ArchivoDeMod>();
                mods.add((ArchivoDeMod)objetoReal);
                List<String> ubicaciones = Buscardor.obtenerUbicaciones(mods);
                this.mostrarResultadosBusqueda(ubicaciones, MonitorDePID.idioma.referenciasMod());
            } else if (objetoReal instanceof String) {
                String paquete = (String)objetoReal;
                if (!(paquete.equals("contenedor_metodos") || paquete.equals("contenedor_campos") || paquete.equals("contenedor_referencias"))) {
                    List<String> ubicaciones = Buscardor.obtenerUbicaciones(Buscardor.buscarModsConTermino(paquete));
                    this.mostrarResultadosBusqueda(ubicaciones, MonitorDePID.idioma.referencias() + " " + paquete);
                }
            } else if (objetoReal instanceof Object[] && (datos = (Object[])objetoReal).length >= 2 && datos[0] instanceof ArchivoDeMod) {
                String clase;
                ArchivoDeMod mod = (ArchivoDeMod)datos[0];
                String string = clase = datos[1] instanceof String ? (String)datos[1] : null;
                if (clase != null) {
                    if (datos.length == 2) {
                        this.buscarReferenciasAClase(clase);
                    } else if (datos.length >= 3 && datos[2] instanceof ArchivoDeMod.InfoMetodo) {
                        ArchivoDeMod.InfoMetodo metodo = (ArchivoDeMod.InfoMetodo)datos[2];
                        String claseInterna = Buscardor.convertirFormatoClase(clase);
                        List<Buscardor.ReferenciaMod> referenciasHacia = Buscardor.buscarReferenciasHaciaMetodo(claseInterna, metodo.obtenerNombre(), metodo.obtenerDescriptor());
                        this.mostrarReferenciasHaciaMetodo(referenciasHacia, MonitorDePID.idioma.referenciasMetodo());
                    } else if (datos.length >= 3 && datos[2] instanceof ArchivoDeMod.InfoCampo) {
                        ArchivoDeMod.InfoCampo campo = (ArchivoDeMod.InfoCampo)datos[2];
                        String claseInterna = Buscardor.convertirFormatoClase(clase);
                        this.buscarReferenciasACampo(claseInterna, campo.obtenerNombre(), campo.obtenerDescriptor());
                    } else if (datos.length >= 4 && datos[3] instanceof ArchivoDeMod.Referencia) {
                        ArchivoDeMod.Referencia referencia = (ArchivoDeMod.Referencia)datos[3];
                        if (referencia.esMetodo()) {
                            List<Buscardor.ReferenciaMod> referenciasHacia = Buscardor.buscarReferenciasHaciaMetodo(referencia.obtenerClase(), referencia.obtenerNombre(), referencia.obtenerDescriptor());
                            String tituloReferencias = MonitorDePID.idioma.referencias() + " " + Buscardor.convertirFormatoClasePuntos(referencia.obtenerClase()) + "." + referencia.obtenerNombre();
                            this.mostrarReferenciasHaciaMetodo(referenciasHacia, tituloReferencias);
                        } else {
                            this.buscarReferenciasACampo(referencia.obtenerClase(), referencia.obtenerNombre(), referencia.obtenerDescriptor());
                        }
                    }
                }
            }
        });
        menu.add(itemBuscarRef);
        menu.show(this.arbolModulos, e.getX(), e.getY());
    }

    public void buscarReferenciasACampo(String claseObjetivo, String nombreCampo, String descriptorCampo) {
        if (!Buscardor.puedeAnalizarElContentidoDeClase()) {
            DefaultMutableTreeNode raiz = new DefaultMutableTreeNode(MonitorDePID.idioma.referenciasCampo() + " " + Buscardor.convertirFormatoClasePuntos(claseObjetivo) + "." + nombreCampo);
            raiz.add(new DefaultMutableTreeNode("ASM no disponible"));
            this.modeloArbol = new ModeloArbolConExpandibleMods(raiz);
            this.arbolModulos.setModel(this.modeloArbol);
            return;
        }
        DefaultMutableTreeNode raiz = new DefaultMutableTreeNode(MonitorDePID.idioma.referenciasCampo() + " " + Buscardor.convertirFormatoClasePuntos(claseObjetivo) + "." + nombreCampo);
        for (ArchivoDeMod mod : Buscardor.mods) {
            for (String nombreClase : mod.obtenerTodosLosNombresDeClases()) {
                String claseOrigenInterna = ArbolDeModsGUI.normalizarNombreClaseInterno(nombreClase);
                byte[] bytesClase = mod.obtenerBytesClase(claseOrigenInterna);
                if (bytesClase == null) continue;
                try {
                    List<ArchivoDeMod.InfoMetodo> metodos = mod.obtenerMetodosConReferencias(claseOrigenInterna);
                    for (ArchivoDeMod.InfoMetodo metodo : metodos) {
                        for (ArchivoDeMod.Referencia ref : metodo.obtenerReferenciasACampos()) {
                            String claseRefInterna = ArbolDeModsGUI.normalizarNombreClaseInterno(ref.obtenerClase());
                            if (!claseRefInterna.equals(ArbolDeModsGUI.normalizarNombreClaseInterno(claseObjetivo)) || !ref.obtenerNombre().equals(nombreCampo) || !ref.obtenerDescriptor().equals(descriptorCampo)) continue;
                            String claseOrigenMostrar = this.convertirFormatoClasePuntos(claseOrigenInterna);
                            String textoRef = MonitorDePID.idioma.metodo() + ": " + claseOrigenMostrar + "." + metodo.obtenerNombre() + metodo.obtenerDescriptor() + " (" + mod.ubicacion_para_publicar() + ")";
                            raiz.add(new DefaultMutableTreeNode(textoRef));
                        }
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
        if (raiz.getChildCount() == 0) {
            raiz.add(new DefaultMutableTreeNode(MonitorDePID.idioma.noSeEncontraronReferencias()));
        }
        this.modeloArbol = new ModeloArbolConExpandibleMods(raiz);
        this.arbolModulos.setModel(this.modeloArbol);
    }

    public void mostrarResultadosBusqueda(List<String> resultados, String titulo) {
        DefaultMutableTreeNode raiz = new DefaultMutableTreeNode(titulo);
        if (resultados.isEmpty()) {
            raiz.add(new DefaultMutableTreeNode(MonitorDePID.idioma.noSeEncontraronReferencias()));
        } else {
            for (String resultado : resultados) {
                raiz.add(new DefaultMutableTreeNode(resultado));
            }
        }
        this.modeloArbol = new ModeloArbolConExpandibleMods(raiz);
        this.arbolModulos.setModel(this.modeloArbol);
    }

    public void mostrarReferenciasHaciaMetodo(List<Buscardor.ReferenciaMod> referencias, String titulo) {
        DefaultMutableTreeNode raiz = new DefaultMutableTreeNode(titulo);
        if (referencias.isEmpty()) {
            raiz.add(new DefaultMutableTreeNode(MonitorDePID.idioma.noSeEncontraronReferencias()));
        } else {
            for (Buscardor.ReferenciaMod refMod : referencias) {
                String textoReferencia = "";
                if (refMod.obtenerReferencia() != null) {
                    ArchivoDeMod.Referencia ref = refMod.obtenerReferencia();
                    String nombreClaseMostrar = Buscardor.convertirFormatoClasePuntos(ref.obtenerClase());
                    String tipo = ref.esMetodo() ? MonitorDePID.idioma.metodo() : MonitorDePID.idioma.campo();
                    textoReferencia = tipo + ": " + nombreClaseMostrar + "." + ref.obtenerNombre() + " (" + refMod.obtenerMod().ubicacion_para_publicar() + ")";
                }
                raiz.add(new DefaultMutableTreeNode(textoReferencia));
            }
        }
        this.modeloArbol = new ModeloArbolConExpandibleMods(raiz);
        this.arbolModulos.setModel(this.modeloArbol);
    }

    public void buscarReferenciasAClase(String nombreClase) {
        if (!Buscardor.puedeAnalizarElContentidoDeClase()) {
            DefaultMutableTreeNode raiz = new DefaultMutableTreeNode(MonitorDePID.idioma.referenciasClase() + " " + nombreClase);
            raiz.add(new DefaultMutableTreeNode("ASM no disponible"));
            this.modeloArbol = new ModeloArbolConExpandibleMods(raiz);
            this.arbolModulos.setModel(this.modeloArbol);
            return;
        }
        DefaultMutableTreeNode raiz = new DefaultMutableTreeNode(MonitorDePID.idioma.referenciasClase() + " " + nombreClase);
        String claseInterna = Buscardor.convertirFormatoClase(nombreClase);
        ArrayList referencias = new ArrayList();
        String claseObjetivoInterna = ArbolDeModsGUI.normalizarNombreClaseInterno(nombreClase);
        for (ArchivoDeMod mod : Buscardor.mods) {
            for (String nombreClaseActual : mod.obtenerTodosLosNombresDeClases()) {
                byte[] bytesClase;
                String claseActualInterna = ArbolDeModsGUI.normalizarNombreClaseInterno(nombreClaseActual);
                if (claseActualInterna.equals(claseObjetivoInterna) || (bytesClase = mod.obtenerBytesClase(claseActualInterna)) == null) continue;
                try {
                    List<ArchivoDeMod.InfoMetodo> metodos = mod.obtenerMetodosConReferencias(claseActualInterna);
                    for (ArchivoDeMod.InfoMetodo metodo : metodos) {
                        String textoRef;
                        String origen;
                        for (ArchivoDeMod.Referencia ref : metodo.obtenerReferenciasAMetodos()) {
                            if (!ArbolDeModsGUI.normalizarNombreClaseInterno(ref.obtenerClase()).equals(claseObjetivoInterna)) continue;
                            origen = this.convertirFormatoClasePuntos(claseActualInterna);
                            textoRef = MonitorDePID.idioma.metodo() + ": " + origen + "." + metodo.obtenerNombre() + metodo.obtenerDescriptor() + " -> " + this.convertirFormatoClasePuntos(claseObjetivoInterna) + "." + ref.obtenerNombre() + " (" + mod.ubicacion_para_publicar() + ")";
                            raiz.add(new DefaultMutableTreeNode(textoRef));
                        }
                        for (ArchivoDeMod.Referencia ref : metodo.obtenerReferenciasACampos()) {
                            if (!ArbolDeModsGUI.normalizarNombreClaseInterno(ref.obtenerClase()).equals(claseObjetivoInterna)) continue;
                            origen = this.convertirFormatoClasePuntos(claseActualInterna);
                            textoRef = MonitorDePID.idioma.metodo() + ": " + origen + "." + metodo.obtenerNombre() + metodo.obtenerDescriptor() + " -> " + this.convertirFormatoClasePuntos(claseObjetivoInterna) + "." + ref.obtenerNombre() + " (" + mod.ubicacion_para_publicar() + ")";
                            raiz.add(new DefaultMutableTreeNode(textoRef));
                        }
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
        if (raiz.getChildCount() == 0) {
            raiz.add(new DefaultMutableTreeNode(MonitorDePID.idioma.noSeEncontraronReferencias()));
        }
        this.modeloArbol = new ModeloArbolConExpandibleMods(raiz);
        this.arbolModulos.setModel(this.modeloArbol);
    }

    @Override
    public TipoGUI tipo() {
        return TipoGUI.ARBOL_DE_MODS;
    }

    public static class NodoConTexto {
        public final String texto;
        public final Object objeto;

        public NodoConTexto(String texto, Object objeto) {
            this.texto = texto;
            this.objeto = objeto;
        }

        public String texto() {
            return this.texto;
        }

        public Object objeto() {
            return this.objeto;
        }

        public String toString() {
            return this.texto;
        }
    }

    public static class NodoArbolExportable
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public String texto;
        public String tipo;
        public List<NodoArbolExportable> hijos;

        public NodoArbolExportable(String texto, String tipo) {
            this.texto = texto;
            this.tipo = tipo;
            this.hijos = new ArrayList<NodoArbolExportable>();
        }

        public void agregarHijo(NodoArbolExportable hijo) {
            this.hijos.add(hijo);
        }

        public String texto() {
            return this.texto;
        }

        public String tipo() {
            return this.tipo;
        }

        public List<NodoArbolExportable> sub() {
            return this.hijos;
        }
    }

    public static class ModeloArbolConExpandibleMods
    extends DefaultTreeModel {
        public ModeloArbolConExpandibleMods(TreeNode root) {
            super(root);
        }

        @Override
        public boolean isLeaf(Object node) {
            Object real;
            Object userObj;
            if (node instanceof DefaultMutableTreeNode && (userObj = ((DefaultMutableTreeNode)node).getUserObject()) instanceof NodoConTexto && (real = ((NodoConTexto)userObj).objeto()) instanceof ArchivoDeMod) {
                return false;
            }
            return super.isLeaf(node);
        }
    }

    public class RenderizadorCeldasArbol
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                Object objetoUsuario = ((DefaultMutableTreeNode)value).getUserObject();
                if (objetoUsuario instanceof NodoConTexto) {
                    NodoConTexto nct = (NodoConTexto)objetoUsuario;
                    this.setText(nct.texto());
                    Object objeto = nct.objeto();
                    if (objeto instanceof ArchivoDeMod) {
                        this.setForeground(new Color(0, 0, 128));
                        this.setIcon(ArbolDeModsGUI.this.iconoMod);
                    } else if (objeto instanceof Object[]) {
                        Object[] datos = (Object[])objeto;
                        if (datos.length >= 3 && datos[2] instanceof ArchivoDeMod.InfoMetodo) {
                            this.setForeground(new Color(0, 0, 153));
                            this.setIcon(ArbolDeModsGUI.this.iconoMetodo);
                        } else if (datos.length >= 3 && datos[2] instanceof ArchivoDeMod.InfoCampo) {
                            this.setForeground(new Color(153, 0, 0));
                            this.setIcon(ArbolDeModsGUI.this.iconoCampo);
                        } else if (datos.length >= 4 && datos[3] instanceof ArchivoDeMod.Referencia) {
                            ArchivoDeMod.Referencia ref = (ArchivoDeMod.Referencia)datos[3];
                            this.setIcon(ref.esMetodo() ? ArbolDeModsGUI.this.iconoReferenciaMetodo : ArbolDeModsGUI.this.iconoReferenciaCampo);
                            this.setForeground(Color.DARK_GRAY);
                        } else {
                            this.setForeground(Color.DARK_GRAY);
                            this.setIcon(ArbolDeModsGUI.this.iconoClase);
                        }
                    } else if (objeto instanceof String) {
                        String str = (String)objeto;
                        if (str.equals("contenedor_metodos")) {
                            this.setText(MonitorDePID.idioma.metodos());
                            this.setIcon(ArbolDeModsGUI.this.iconoMetodo);
                        } else if (str.equals("contenedor_campos")) {
                            this.setText(MonitorDePID.idioma.campos());
                            this.setIcon(ArbolDeModsGUI.this.iconoCampo);
                        } else if (str.equals("contenedor_referencias")) {
                            this.setText(MonitorDePID.idioma.referencias());
                            this.setIcon(ArbolDeModsGUI.this.iconoReferenciaMetodo);
                        } else if (str.equals("contenedor_constantes")) {
                            this.setText("Constantes");
                            this.setIcon(ArbolDeModsGUI.this.iconoConstante);
                        } else if (!nct.texto().contains("(")) {
                            this.setForeground(new Color(0, 102, 0));
                            this.setIcon(ArbolDeModsGUI.this.iconoPaquete);
                        }
                    } else {
                        this.setForeground(Color.BLACK);
                    }
                } else {
                    this.setForeground(Color.BLACK);
                }
            }
            return this;
        }
    }
}

