/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.arbol;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.arbol.ArbolDeModsGUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class ArbolDeModsGUIHamu
extends ArbolDeModsGUI {
    public static String ID = "hamu";
    private ConfigColor colorFondoPrincipal = ConfigColor.de("tema.hamu.color.fondo", new Color(144, 203, 239));
    private ConfigColor colorTextoBotonReset = ConfigColor.de("tema.hamu.color.texto.boton.reset", Color.BLACK);
    private ConfigColor colorTextoCampoBuscar = ConfigColor.de("tema.hamu.color.texto.tooltip.buscar", Color.DARK_GRAY);
    private ConfigColor colorTextoComboFiltro = ConfigColor.de("tema.hamu.color.texto.combo.filtro", Color.BLACK);
    private ConfigColor colorTextoRenderer = ConfigColor.de("tema.hamu.color.texto.renderer", Color.BLACK);
    private ConfigColor colorTextoOverlayCarga = ConfigColor.de("tema.hamu.color.texto.overlay.carga", Color.WHITE);

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void recargarApariencia() {
        this.inicializarColoresConfiguracion();
        this.setTitle(MonitorDePID.idioma.tituloArbolDeMods());
        this.getContentPane().setBackground(this.colorFondoPrincipal.obtener());
        if (this.botonReset != null) {
            this.botonReset.setText(MonitorDePID.idioma.botonResetearArbol());
        }
        if (this.campoBuscar != null) {
            this.campoBuscar.setToolTipText(MonitorDePID.idioma.tipBuscar());
        }
        if (this.comboFiltro != null) {
            String[] opcionesFiltro;
            Object previa = this.comboFiltro.getSelectedItem();
            this.comboFiltro.removeAllItems();
            for (String op : opcionesFiltro = new String[]{"*", MonitorDePID.idioma.filtroPaquetes(), MonitorDePID.idioma.filtroClases(), MonitorDePID.idioma.filtroMetodos(), MonitorDePID.idioma.filtroCampos(), MonitorDePID.idioma.filtroReferenciasCampo(), MonitorDePID.idioma.filtroReferenciasMetodo(), MonitorDePID.idioma.filtroReferenciasClase(), "Constantes"}) {
                this.comboFiltro.addItem(op);
            }
            if (previa != null) {
                for (int i = 0; i < this.comboFiltro.getItemCount(); ++i) {
                    if (!previa.equals(this.comboFiltro.getItemAt(i))) continue;
                    this.comboFiltro.setSelectedIndex(i);
                    break;
                }
            }
        }
        this.iconoMod = this.crearIcono(Statics.carpeta.resolve("imagenes/mod.png").toString(), "M");
        this.iconoClase = this.crearIcono(Statics.carpeta.resolve("imagenes/clase.png").toString(), "C");
        this.iconoMetodo = this.crearIcono(Statics.carpeta.resolve("imagenes/metodo.png").toString(), "m");
        this.iconoCampo = this.crearIcono(Statics.carpeta.resolve("imagenes/campo.png").toString(), "f");
        this.iconoPaquete = this.crearIcono(Statics.carpeta.resolve("imagenes/paquete.png").toString(), "P");
        this.iconoReferenciaMetodo = this.crearIcono(Statics.carpeta.resolve("imagenes/referencia_metodo.png").toString(), "RM");
        this.iconoReferenciaCampo = this.crearIcono(Statics.carpeta.resolve("imagenes/referencia_campo.png").toString(), "RC");
        this.iconoConstante = this.crearIcono(Statics.carpeta.resolve("imagenes/constante.png").toString(), "K");
        if (this.iconoConstante.getIconWidth() <= 0) {
            this.iconoConstante = this.crearIcono(Statics.carpeta.resolve("imagenes/referencia_campo.png").toString(), "K");
        }
        if (this.imagenHamu != null) {
            this.imagenHamu.setIcon(new ImageIcon(Statics.carpeta.resolve("imagenes/hamu.png").toString()));
        }
        if (this.gifCarga != null) {
            ImageIcon icon = new ImageIcon(Statics.carpeta.resolve("imagenes/padoru.gif").toString());
            if (icon.getIconWidth() <= 0) {
                icon = this.crearIcono("", "\u2026");
            }
            this.gifCarga.setIcon(icon);
            this.gifCarga.setText(MonitorDePID.idioma.cargando());
        }
        if (this.arbolModulos != null) {
            this.arbolModulos.setCellRenderer(new ArbolDeModsGUI.RenderizadorCeldasArbol());
        }
        this.construirArbolInicialAsync();
        this.revalidate();
        this.repaint();
    }

    private void inicializarColoresConfiguracion() {
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorFondoPrincipal.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoPrincipal());
        this.colorTextoBotonReset.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTextoBotonReset());
        this.colorTextoCampoBuscar.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTextoCampoBuscar());
        this.colorTextoComboFiltro.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTextoComboFiltro());
        this.colorTextoRenderer.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTextoRenderer());
        this.colorTextoOverlayCarga.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTextoOverlayCarga());
        elementos.add(this.colorFondoPrincipal);
        elementos.add(this.colorTextoBotonReset);
        elementos.add(this.colorTextoCampoBuscar);
        elementos.add(this.colorTextoComboFiltro);
        elementos.add(this.colorTextoRenderer);
        elementos.add(this.colorTextoOverlayCarga);
        return elementos;
    }
}

