/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.canario;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.canario.CanarioDeOrdenJudicialGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class CanarioDeOrdenJudicialGUI1984
extends CanarioDeOrdenJudicialGUI {
    private static final long serialVersionUID = 1L;
    public static String ID = "1984";
    private ConfigColor colorFondo = ConfigColor.de("tema.canario1984.color.fondo", new Color(15, 15, 15));
    private ConfigColor colorTexto = ConfigColor.de("tema.canario1984.color.texto", new Color(220, 220, 220));
    private ConfigColor colorBoton = ConfigColor.de("tema.canario1984.color.boton", new Color(110, 0, 0));
    private ConfigColor colorAlerta = ConfigColor.de("tema.canario1984.color.alerta", new Color(200, 40, 40));
    private JPanel panelRaiz;
    private JLabel titulo;
    private JTextArea descripcion;
    private JTextArea resultado;
    private JButton botonRevisar;
    private JButton botonCerrar;

    @Override
    public void init() {
        this.setTitle(MonitorDePID.idioma.canarioTitulo());
        this.setModal(true);
        this.setResizable(false);
        this.setMinimumSize(new Dimension(640, 380));
        this.panelRaiz = new JPanel(new BorderLayout(10, 10));
        this.panelRaiz.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.getContentPane().add(this.panelRaiz);
        this.titulo = new JLabel(MonitorDePID.idioma.canario1984Titulo());
        this.titulo.setFont(new Font("Segoe UI", 1, 18));
        this.panelRaiz.add((Component)this.titulo, "North");
        this.descripcion = new JTextArea(MonitorDePID.idioma.canario1984Descripcion());
        this.descripcion.setEditable(false);
        this.descripcion.setLineWrap(true);
        this.descripcion.setWrapStyleWord(true);
        this.descripcion.setFont(new Font("Segoe UI", 0, 12));
        this.descripcion.setOpaque(false);
        this.descripcion.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 0));
        this.resultado = new JTextArea();
        this.resultado.setEditable(false);
        this.resultado.setLineWrap(true);
        this.resultado.setWrapStyleWord(true);
        this.resultado.setFont(new Font("Consolas", 0, 13));
        JPanel panelCentro = new JPanel(new BorderLayout(6, 6));
        panelCentro.setOpaque(false);
        panelCentro.add((Component)this.descripcion, "North");
        panelCentro.add((Component)this.resultado, "Center");
        this.panelRaiz.add((Component)panelCentro, "Center");
        JPanel panelBotones = new JPanel(new FlowLayout(2));
        this.botonRevisar = new JButton(MonitorDePID.idioma.revisar());
        this.botonCerrar = new JButton(MonitorDePID.idioma.cerrar());
        panelBotones.add(this.botonCerrar);
        panelBotones.add(this.botonRevisar);
        this.panelRaiz.add((Component)panelBotones, "South");
        this.aplicarApariencia();
        this.agregarListeners();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void agregarListeners() {
        this.botonRevisar.addActionListener(e -> this.revisarCanarios());
        this.botonCerrar.addActionListener(e -> this.dispose());
    }

    private void revisarCanarios() {
        StringBuilder sb = new StringBuilder();
        Map<String, Boolean> estados = CanarioDeOrdenJudicialGUI1984.obtenerEstados();
        int inseguros = 0;
        for (Map.Entry<String, Boolean> e : estados.entrySet()) {
            boolean seguro = e.getValue();
            if (!seguro) {
                ++inseguros;
            }
            sb.append(seguro ? "\u2714 " : "\u2716 ");
            sb.append(e.getKey());
            sb.append("\n");
        }
        sb.append("\n");
        if (inseguros == 0) {
            sb.append(MonitorDePID.idioma.canarioTodoSeguro());
        } else {
            sb.append(MonitorDePID.idioma.canarioComprometido(inseguros));
        }
        this.resultado.setText(sb.toString());
    }

    @Override
    public void aplicarApariencia() {
        this.panelRaiz.setBackground(this.colorFondo.obtener());
        this.resultado.setBackground(this.colorFondo.obtener());
        this.titulo.setForeground(this.colorTexto.obtener());
        this.resultado.setForeground(this.colorTexto.obtener());
        this.descripcion.setForeground(this.colorTexto.obtener());
        this.botonRevisar.setBackground(this.colorBoton.obtener());
        this.botonCerrar.setBackground(this.colorBoton.obtener());
        this.revalidate();
        this.repaint();
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoVentana());
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        this.colorAlerta.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorAlerta());
        elementos.add(this.colorFondo);
        elementos.add(this.colorTexto);
        elementos.add(this.colorBoton);
        elementos.add(this.colorAlerta);
        return elementos;
    }
}

