/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.cfr;

import java.io.File;
import java.util.Arrays;
import java.util.List;

public class BuscarParaCFR {
    private static final List<String> UBICACIONES_COMUNES = Arrays.asList("/usr/share/java/CFR/cfr.jar", "/usr/local/share/java/CFR/cfr.jar", "/opt/cfr/cfr.jar", "/usr/share/java/cfr.jar", "/usr/local/lib/cfr.jar");

    public static File encontrarCfr() {
        File[] archivosJar;
        for (String ruta : UBICACIONES_COMUNES) {
            File archivo = new File(ruta);
            if (!archivo.exists() || !archivo.isFile()) continue;
            return archivo;
        }
        File carpetaUsuario = new File(System.getProperty("user.home"), "crash_detector/cfr/");
        if (carpetaUsuario.exists() && carpetaUsuario.isDirectory() && (archivosJar = carpetaUsuario.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"))) != null && archivosJar.length > 0) {
            return archivosJar[0];
        }
        return null;
    }

    public static boolean estaInstalado() {
        return BuscarParaCFR.encontrarCfr() != null;
    }
}

