/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.cfr;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.tipos.cfr.BuscarParaCFR;
import com.asbestosstar.crashdetector.gui.tipos.cfr.DescompilarCFR;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class CfrBase
extends JFrame
implements CrashDetectorGUI {
    public static final Map<String, Supplier<CfrBase>> GUIS = new HashMap<String, Supplier<CfrBase>>();

    public abstract void procesarHipervinculo(String var1);

    public static boolean estaCfrInstalado() {
        return BuscarParaCFR.estaInstalado();
    }

    public static String descompilarClase(String nombreClase) {
        if (!CfrBase.estaCfrInstalado()) {
            CrashDetectorLogger.log("No Tienese CFR");
            String mensajeHtml = MonitorDePID.idioma.necesitasInstalarCfr() + "<br>" + MonitorDePID.idioma.noticiaLegalCFR();
            if (!GraphicsEnvironment.isHeadless()) {
                try {
                    CfrBase.mostrarDialogoInstalacionCFR(mensajeHtml);
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
            return null;
        }
        CrashDetectorLogger.log("Tienese CFR");
        return DescompilarCFR.descompilar(nombreClase);
    }

    private static void mostrarDialogoInstalacionCFR(String mensajeHtml) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JEditorPane editor = new JEditorPane("text/html", "<html>" + mensajeHtml + "</html>");
        editor.setEditable(false);
        editor.setOpaque(false);
        editor.setAlignmentX(0.0f);
        panel.add(editor);
        JDialog dialogo = new JDialog((Frame)null, MonitorDePID.idioma.tituloCfrSakura(), true);
        dialogo.setLayout(new BorderLayout());
        dialogo.add((Component)panel, "Center");
        JButton btnDescargar = new JButton(MonitorDePID.idioma.botonDescargarCfr());
        JButton btnAbrirCarpeta = new JButton(MonitorDePID.idioma.botonAbrirCarpetaCfr());
        btnDescargar.addActionListener(e -> {
            try {
                Desktop.getDesktop().browse(new URI("https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar"));
            }
            catch (Exception ex) {
                CrashDetectorLogger.logException(ex);
            }
        });
        btnAbrirCarpeta.addActionListener(e -> {
            Path carpeta = Paths.get(System.getProperty("user.home"), "crash_detector", "cfr");
            try {
                if (!Files.exists(carpeta, new LinkOption[0])) {
                    Files.createDirectories(carpeta, new FileAttribute[0]);
                }
                Desktop.getDesktop().open(carpeta.toFile());
            }
            catch (IOException | UnsupportedOperationException ex) {
                try {
                    Desktop.getDesktop().browse(carpeta.toUri());
                }
                catch (Exception ex2) {
                    CrashDetectorLogger.logException(ex2);
                }
            }
            catch (Exception ex) {
                CrashDetectorLogger.logException(ex);
            }
        });
        JPanel panelBotones = new JPanel();
        panelBotones.add(btnDescargar);
        panelBotones.add(btnAbrirCarpeta);
        dialogo.add((Component)panelBotones, "South");
        dialogo.pack();
        dialogo.setLocationRelativeTo(null);
        dialogo.setResizable(false);
        dialogo.setVisible(true);
    }

    public static File obtenerCfrJar() {
        return BuscarParaCFR.encontrarCfr();
    }
}

