/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.cfr;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigBoolean;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.cfr.CfrBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CfrSakuraRiddle
extends CfrBase {
    public static final String ID = "sakura_riddle";
    private static final long serialVersionUID = 1L;
    public ConfigColor colorFondo = ConfigColor.de("tema.sakura.cfr.fondo", new Color(20, 20, 30));
    public ConfigColor colorTexto = ConfigColor.de("tema.sakura.cfr.texto", Color.WHITE);
    public ConfigColor colorBorde = ConfigColor.de("tema.sakura.cfr.borde", new Color(100, 50, 100));
    public ConfigColor colorFondoRetrato = ConfigColor.de("tema.sakura.cfr.fondo.retrato", new Color(30, 20, 40));
    public ConfigBoolean usarSakuraOriginal = ConfigBoolean.de("tema.sakura.cfr.usaroriginal", false);
    private JEditorPane editorCodigo;
    private JPanel panelRetrato;
    private JLabel etiquetaRetrato;
    private JTextField campoClase;

    @Override
    public void procesarHipervinculo(String url) {
        if (!url.startsWith("cfr://")) {
            return;
        }
        String nombreClase = url.substring("cfr://".length()).trim();
        if (nombreClase.isEmpty()) {
            return;
        }
        this.inicializarVentana();
        this.campoClase.setText(nombreClase);
        new Thread(() -> {
            String codigo = CfrBase.descompilarClase(nombreClase);
            SwingUtilities.invokeLater(() -> {
                if (codigo != null) {
                    this.editorCodigo.setText(codigo);
                } else {
                    this.editorCodigo.setText(MonitorDePID.idioma.cfrClaseNoEncontrada(nombreClase));
                }
                this.editorCodigo.setCaretPosition(0);
            });
        }).start();
        this.setVisible(true);
    }

    private void inicializarVentana() {
        if (this.isDisplayable()) {
            return;
        }
        this.setTitle(MonitorDePID.idioma.tituloCfrSakura());
        this.setSize(1000, 600);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.editorCodigo = new JEditorPane();
        this.editorCodigo.setEditable(false);
        this.editorCodigo.setContentType("text/plain");
        this.editorCodigo.setBackground(this.colorFondo.obtener());
        this.editorCodigo.setForeground(this.colorTexto.obtener());
        JScrollPane scrollCodigo = new JScrollPane(this.editorCodigo);
        this.campoClase = new JTextField();
        this.campoClase.setEditable(false);
        this.campoClase.setBackground(this.colorFondo.obtener().darker());
        this.campoClase.setForeground(this.colorTexto.obtener());
        this.campoClase.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.colorBorde.obtener()), MonitorDePID.idioma.cfrClaseActual()));
        this.panelRetrato = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(CfrSakuraRiddle.this.colorFondoRetrato.obtener());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        this.panelRetrato.setLayout(new BorderLayout());
        this.panelRetrato.setPreferredSize(new Dimension(220, 0));
        this.panelRetrato.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.colorBorde.obtener()), MonitorDePID.idioma.cfrRetratoDeSakura(), 2, 2, null, this.colorTexto.obtener()));
        this.etiquetaRetrato = new JLabel("", 0);
        this.panelRetrato.add((Component)this.etiquetaRetrato, "Center");
        this.cargarRetrato();
        JPanel panelCentral = new JPanel(new BorderLayout());
        panelCentral.add((Component)this.campoClase, "North");
        panelCentral.add((Component)scrollCodigo, "Center");
        this.add((Component)panelCentral, "Center");
        this.add((Component)this.panelRetrato, "East");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                CfrSakuraRiddle.this.dispose();
            }
        });
        this.setLocationRelativeTo(null);
    }

    private void cargarRetrato() {
        new Thread(() -> {
            try {
                File archivo = this.usarSakuraOriginal.obtener() != false ? Statics.carpeta.resolve("imagenes/sakura_riddle_original.png").toFile() : Statics.carpeta.resolve("imagenes/sakura_riddle.png").toFile();
                if (archivo.exists()) {
                    BufferedImage img = ImageIO.read(archivo);
                    SwingUtilities.invokeLater(() -> this.etiquetaRetrato.setIcon(new ImageIcon(img)));
                } else {
                    SwingUtilities.invokeLater(() -> {
                        this.etiquetaRetrato.setText(MonitorDePID.idioma.cfrNoHayRetrato());
                        this.etiquetaRetrato.setForeground(Color.GRAY);
                    });
                }
            }
            catch (IOException ex) {
                CrashDetectorLogger.log("Error al cargar retrato de Sakura Riddle: " + ex.getMessage());
                SwingUtilities.invokeLater(() -> {
                    this.etiquetaRetrato.setText(MonitorDePID.idioma.cfrErrorCargarRetrato());
                    this.etiquetaRetrato.setForeground(Color.RED);
                });
            }
        }).start();
    }

    @Override
    public TipoGUI tipo() {
        return TipoGUI.CFR;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void init() {
    }

    @Override
    public void recargarApariencia() {
        this.editorCodigo.setBackground(this.colorFondo.obtener());
        this.editorCodigo.setForeground(this.colorTexto.obtener());
        this.campoClase.setBackground(this.colorFondo.obtener().darker());
        this.campoClase.setForeground(this.colorTexto.obtener());
        this.panelRetrato.repaint();
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> ret = new ArrayList<ElementoConfig>();
        this.colorFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.colorBorde.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
        this.colorFondoRetrato.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoRetrato());
        this.usarSakuraOriginal.establecerNombreParaMostrar(() -> MonitorDePID.idioma.usarSakuraOriginal());
        ret.add(this.colorFondo);
        ret.add(this.colorTexto);
        ret.add(this.colorBorde);
        ret.add(this.colorFondoRetrato);
        ret.add(this.usarSakuraOriginal);
        return ret;
    }
}

