/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.cfr;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.benf.cfr.reader.api.CfrDriver;
import org.benf.cfr.reader.api.ClassFileSource;
import org.benf.cfr.reader.api.OutputSinkFactory;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;

public class DescompilarCFR {
    public static String descompilar(String clase) {
        if (clase == null || clase.trim().isEmpty()) {
            CrashDetectorLogger.log("no clase");
            return null;
        }
        final String claseInterna = DescompilarCFR.normalizarNombreClaseInterno(clase);
        String rutaClase = claseInterna + ".class";
        byte[] bytesObjetivo = Buscardor.obtenerBytesDeClase(claseInterna);
        if (bytesObjetivo == null) {
            CrashDetectorLogger.log("No obj");
            byte[] b2 = Buscardor.obtenerBytesDeClase(clase);
            if (b2 == null) {
                CrashDetectorLogger.log("no b2 CFR " + clase);
                return null;
            }
        }
        final StringBuilder salida = new StringBuilder();
        try {
            HashMap<String, String> opciones = new HashMap<String, String>();
            opciones.put("hideutf", "true");
            opciones.put("comments", "false");
            ClassFileSource source = new ClassFileSource(){

                private String normalizarRutaClass(String path) {
                    if (path == null) {
                        return null;
                    }
                    String p = path.trim();
                    if (p.startsWith("L") && p.endsWith(";")) {
                        p = p.substring(1, p.length() - 1);
                    }
                    if (p.toLowerCase().endsWith(".class")) {
                        p = p.substring(0, p.length() - 6);
                    }
                    p = p.replace('.', '/');
                    return p;
                }

                @Override
                public Pair<byte[], String> getClassFileContent(String path) throws IOException {
                    byte[] b;
                    String interna = this.normalizarRutaClass(path);
                    if (claseInterna.equals(interna) && (b = Buscardor.obtenerBytesDeClase(claseInterna)) != null) {
                        return Pair.make(b, "in-mem");
                    }
                    byte[] dep = Buscardor.obtenerBytesDeClase(interna);
                    if (dep != null) {
                        return Pair.make(dep, "in-mem-dep");
                    }
                    throw new IOException("Clase no disponible: " + path);
                }

                @Override
                public String getPossiblyRenamedPath(String path) {
                    return path;
                }

                @Override
                public void informAnalysisRelativePathDetail(String usePath, String classFilePath) {
                }

                @Override
                public Collection<String> addJar(String jarPath) {
                    return Collections.emptyList();
                }
            };
            OutputSinkFactory sinkFactory = new OutputSinkFactory(){

                @Override
                public List<OutputSinkFactory.SinkClass> getSupportedSinks(OutputSinkFactory.SinkType sinkType, Collection<OutputSinkFactory.SinkClass> collection) {
                    if (sinkType == OutputSinkFactory.SinkType.JAVA) {
                        return Collections.singletonList(OutputSinkFactory.SinkClass.STRING);
                    }
                    return Collections.singletonList(OutputSinkFactory.SinkClass.EXCEPTION_MESSAGE);
                }

                @Override
                public <T> OutputSinkFactory.Sink<T> getSink(OutputSinkFactory.SinkType sinkType, OutputSinkFactory.SinkClass sinkClass) {
                    return t -> {
                        if (sinkType == OutputSinkFactory.SinkType.JAVA && t != null) {
                            salida.append(t.toString());
                            if (!salida.toString().endsWith("\n")) {
                                salida.append('\n');
                            }
                        }
                    };
                }
            };
            CfrDriver driver = new CfrDriver.Builder().withOptions(opciones).withClassFileSource(source).withOutputSink(sinkFactory).build();
            driver.analyse(Collections.singletonList(rutaClase));
            String res = salida.toString().trim();
            CrashDetectorLogger.log("res " + res);
            return res.isEmpty() ? null : res;
        }
        catch (Throwable e) {
            CrashDetectorLogger.log("Error al descompilar con CFR: " + e.getMessage());
            CrashDetectorLogger.logException(e);
            return null;
        }
    }

    private static String normalizarNombreClaseInterno(String nombre) {
        if (nombre == null) {
            return null;
        }
        String s = nombre.trim();
        if (s.isEmpty()) {
            return s;
        }
        if (s.startsWith("L") && s.endsWith(";")) {
            s = s.substring(1, s.length() - 1);
        }
        if (s.toLowerCase().endsWith(".class")) {
            s = s.substring(0, s.length() - 6);
        }
        s = s.replace('.', '/');
        return s;
    }
}

