/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.compartir;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.GeneradorDeInformacion;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.api_sito_registro.APIdeSitioDeRegistro;
import com.asbestosstar.crashdetector.api_sito_registro.DemasiadoGrande;
import com.asbestosstar.crashdetector.api_sito_registro.ErrorConPublicar;
import com.asbestosstar.crashdetector.api_sito_registro.LimteDeTasa;
import com.asbestosstar.crashdetector.api_sito_registro.NoAPIdeRegistro;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public abstract class DialogoCompartir
extends JFrame
implements CrashDetectorGUI {
    public DefaultTableModel modeloTabla;
    public JTextField campoEndpoint;
    public JComboBox<String> comboAPI;
    public JComboBox<String> comboSitioRegistro;
    public JCheckBox checkAnonimizar;
    public Instant instant;
    public JTextField campoEnlaceReporte;
    public JButton botonCompartirTodos;
    public JButton botonCompartirMarkdown;
    protected JEditorPane textoExplicacion;
    protected JPanel panelPrincipal;
    protected JPanel panelSuperior;
    protected JPanel panelControles;
    protected JTable tabla;
    protected JPanel panelConfig;
    public static Map<String, Supplier<DialogoCompartir>> GUIS = new HashMap<String, Supplier<DialogoCompartir>>();

    public abstract void preperar(Instant var1);

    protected void setEnviando(boolean enviando) {
        try {
            if (this.botonCompartirTodos != null) {
                this.botonCompartirTodos.setEnabled(!enviando);
            }
            this.setCursor(enviando ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void mostrarError(String mensaje, Throwable t) {
        CrashDetectorLogger.logException(t);
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, mensaje + (t != null && t.getMessage() != null && !t.getMessage().isEmpty() ? "\n" + t.getMessage() : ""), "Error", 0));
    }

    protected void mostrarInfo(String mensaje) {
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, mensaje, "Informaci\u00f3n", 1));
    }

    protected static void copiarAlPortapapeles(String texto) {
        if (texto == null) {
            return;
        }
        try {
            StringSelection selection = new StringSelection(texto);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void cargarConsolas() {
        if (this.modeloTabla != null) {
            for (Consola consola : MonitorDePID.consolas) {
                this.modeloTabla.addRow(new Object[]{true, consola.archivo.getFileName().toString(), MonitorDePID.idioma.abrir(), MonitorDePID.idioma.texto_de_buton_compartir_enlace(), ""});
            }
        }
    }

    public void compartirSeleccionados(ActionEvent e) throws DemasiadoGrande, ErrorConPublicar, NoAPIdeRegistro {
        ArrayList<Consola> seleccionados = new ArrayList<Consola>();
        ArrayList<Integer> filasSel = new ArrayList<Integer>();
        if (this.modeloTabla != null) {
            for (int i = 0; i < this.modeloTabla.getRowCount(); ++i) {
                if (!Boolean.TRUE.equals(this.modeloTabla.getValueAt(i, 0))) continue;
                seleccionados.add(MonitorDePID.consolas.get(i));
                filasSel.add(i);
            }
        }
        if (!seleccionados.isEmpty()) {
            String enlace;
            try {
                enlace = GeneradorDeInformacion.compartir(seleccionados, this.instant);
            }
            catch (LimteDeTasa rl) {
                this.mostrarError(MonitorDePID.idioma.limite_de_solicitudes(), rl);
                return;
            }
            if (this.campoEnlaceReporte != null) {
                this.campoEnlaceReporte.setText(enlace);
            }
            MonitorDePID.enlace = enlace;
            if (this.modeloTabla != null) {
                for (int j = 0; j < filasSel.size(); ++j) {
                    int row = (Integer)filasSel.get(j);
                    Consola cons = MonitorDePID.consolas.get(row);
                    List<Object> urls = new ArrayList();
                    try {
                        urls = cons.obtainerEnlaces();
                    }
                    catch (DemasiadoGrande | ErrorConPublicar | LimteDeTasa | NoAPIdeRegistro e1) {
                        this.mostrarError(e1.getMessage(), e1);
                        return;
                    }
                    String concatenadas = String.join((CharSequence)" ", urls);
                    this.modeloTabla.setValueAt(concatenadas, row, 4);
                }
            }
            try {
                if (enlace != null && !enlace.isEmpty() && Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().browse(new URL(enlace).toURI());
                } else if (enlace != null) {
                    DialogoCompartir.copiarAlPortapapeles(enlace);
                    this.mostrarInfo(MonitorDePID.idioma.copiadoAlPortapapeles());
                }
            }
            catch (Exception ex) {
                DialogoCompartir.copiarAlPortapapeles(enlace);
                this.mostrarInfo(MonitorDePID.idioma.copiadoAlPortapapeles());
                CrashDetectorLogger.logException(ex);
            }
        }
    }

    protected void actualizarComboSitios(String apiNombre, Set<String> sitios, String sitioSeleccionado) {
        if (this.comboSitioRegistro != null) {
            this.comboSitioRegistro.removeAllItems();
            if (sitios != null) {
                for (String sitio : sitios) {
                    this.comboSitioRegistro.addItem(sitio);
                }
                if (sitioSeleccionado != null && sitios.contains(sitioSeleccionado)) {
                    this.comboSitioRegistro.setSelectedItem(sitioSeleccionado);
                } else if (this.comboSitioRegistro.getItemCount() > 0) {
                    this.comboSitioRegistro.setSelectedIndex(0);
                }
            }
        }
    }

    public void guardarConfig() {
        if (this.campoEndpoint != null) {
            Config.obtenerInstancia().guardarSitioDeInformes(this.campoEndpoint.getText());
        }
        if (this.comboAPI != null) {
            String api = (String)this.comboAPI.getSelectedItem();
            Config.obtenerInstancia().guardarApiSeleccionada(api);
        }
        if (this.comboSitioRegistro != null) {
            String sitio_registro = (String)this.comboSitioRegistro.getSelectedItem();
            Config.obtenerInstancia().guardarSitioRegistrosSeleccionado(sitio_registro);
        }
        if (this.checkAnonimizar != null) {
            boolean anonimizar = this.checkAnonimizar.isSelected();
            ConfigMundial.obtenerInstancia().guardarAnonimizarRegistros(anonimizar);
        }
        CrashDetectorLogger.log("Configuration saved.");
    }

    @Override
    public TipoGUI<DialogoCompartir> tipo() {
        return TipoGUI.DIALOGO_COMPARTIR;
    }

    @Override
    public abstract void recargarApariencia();

    @Override
    public void init() {
    }

    public APIdeSitioDeRegistro obtenerAPI() throws NoAPIdeRegistro {
        try {
            return APIdeSitioDeRegistro.obtenerAPIdeConfig();
        }
        catch (NoAPIdeRegistro e) {
            throw new NoAPIdeRegistro();
        }
    }

    public void compartirSoloEnlacesMarkdown(ActionEvent e) throws DemasiadoGrande, ErrorConPublicar, NoAPIdeRegistro {
        ArrayList<Integer> filasSel = new ArrayList<Integer>();
        ArrayList<Consola> seleccionados = new ArrayList<Consola>();
        if (this.modeloTabla != null) {
            for (int i = 0; i < this.modeloTabla.getRowCount(); ++i) {
                if (!Boolean.TRUE.equals(this.modeloTabla.getValueAt(i, 0))) continue;
                filasSel.add(i);
                seleccionados.add(MonitorDePID.consolas.get(i));
            }
        }
        if (seleccionados.isEmpty()) {
            return;
        }
        int MAX_HILOS = 6;
        ExecutorService pool = Executors.newFixedThreadPool(Math.min(6, Math.max(1, filasSel.size())));
        ArrayList<Future<Res>> tareas = new ArrayList<Future<Res>>(filasSel.size());
        for (int k = 0; k < filasSel.size(); ++k) {
            final int row = (Integer)filasSel.get(k);
            final Consola consola = MonitorDePID.consolas.get(row);
            tareas.add(pool.submit(new Callable<Res>(){

                @Override
                public Res call() throws Exception {
                    List<String> urls;
                    try {
                        urls = consola.obtainerEnlaces();
                    }
                    catch (Throwable t) {
                        if (t instanceof DemasiadoGrande) {
                            throw (DemasiadoGrande)t;
                        }
                        if (t instanceof ErrorConPublicar) {
                            throw (ErrorConPublicar)t;
                        }
                        if (t instanceof NoAPIdeRegistro) {
                            throw (NoAPIdeRegistro)t;
                        }
                        CrashDetectorLogger.logException(t);
                        urls = new ArrayList<String>();
                    }
                    String nombreArchivo = consola.archivo != null ? consola.archivo.getFileName().toString() : "log.txt";
                    final class Res {
                        final int rowIndex;
                        final String nombreArchivo;
                        final List<String> urls;

                        Res(int rowIndex, String nombreArchivo, List<String> urls) {
                            this.rowIndex = rowIndex;
                            this.nombreArchivo = nombreArchivo;
                            this.urls = urls;
                        }
                    }
                    return new Res(row, nombreArchivo, urls);
                }
            }));
        }
        pool.shutdown();
        final class Item {
            String archivoBase;
            String etiqueta;
            String url;
            int parteIndex;

            Item(String archivoBase, String etiqueta, String url, int parteIndex) {
                this.archivoBase = archivoBase;
                this.etiqueta = etiqueta;
                this.url = url;
                this.parteIndex = parteIndex;
            }
        }
        ArrayList<Item> items = new ArrayList<Item>();
        try {
            for (Future future : tareas) {
                String celda;
                Res r = (Res)future.get();
                String string = celda = r.urls == null || r.urls.isEmpty() ? "" : String.join((CharSequence)"\n", r.urls);
                if (this.modeloTabla != null) {
                    this.modeloTabla.setValueAt(celda, r.rowIndex, 4);
                }
                if (r.urls != null && !r.urls.isEmpty()) {
                    if (r.urls.size() == 1) {
                        items.add(new Item(r.nombreArchivo, r.nombreArchivo, r.urls.get(0), 1));
                        continue;
                    }
                    for (int i = 0; i < r.urls.size(); ++i) {
                        int parteN = i + 1;
                        String etiqueta = r.nombreArchivo + " (parte " + parteN + ")";
                        items.add(new Item(r.nombreArchivo, etiqueta, r.urls.get(i), parteN));
                    }
                    continue;
                }
                items.add(new Item(r.nombreArchivo, r.nombreArchivo, "", 1));
            }
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof DemasiadoGrande) {
                throw (DemasiadoGrande)throwable;
            }
            if (throwable instanceof ErrorConPublicar) {
                throw (ErrorConPublicar)throwable;
            }
            if (throwable instanceof NoAPIdeRegistro) {
                throw (NoAPIdeRegistro)throwable;
            }
            CrashDetectorLogger.logException(throwable);
            this.mostrarError(MonitorDePID.idioma.error_inesperado_al_generar_enlaces(), throwable);
            return;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.mostrarError(MonitorDePID.idioma.error_inesperado_al_generar_enlaces(), ie);
            return;
        }
        Function<String, Integer> peso = nombre -> {
            String n;
            String string = n = nombre == null ? "" : nombre.toLowerCase();
            if (n.equals("latest.log")) {
                return 0;
            }
            if (n.equals("debug.log")) {
                return 1;
            }
            if (n.equals("launcher.log")) {
                return 2;
            }
            return 3;
        };
        items.sort((a, b) -> {
            int pb;
            int pa = (Integer)peso.apply(a.archivoBase);
            if (pa != (pb = ((Integer)peso.apply(b.archivoBase)).intValue())) {
                return Integer.compare(pa, pb);
            }
            int cmp = a.archivoBase.compareToIgnoreCase(b.archivoBase);
            if (cmp != 0) {
                return cmp;
            }
            return Integer.compare(a.parteIndex, b.parteIndex);
        });
        StringBuilder stringBuilder = new StringBuilder();
        for (Item it : items) {
            if (it.url != null && !it.url.isEmpty()) {
                stringBuilder.append('[').append(it.etiqueta).append(']').append('(').append(it.url).append(')').append(' ');
                continue;
            }
            stringBuilder.append(it.etiqueta).append(' ');
        }
        String markdown = stringBuilder.toString().trim();
        if (this.campoEnlaceReporte != null) {
            this.campoEnlaceReporte.setText(markdown);
        }
        DialogoCompartir.copiarAlPortapapeles(markdown);
        this.mostrarInfo(MonitorDePID.idioma.copiadoAlPortapapeles());
    }
}

