/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.compartir;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.api_sito_registro.APIdeSitioDeRegistro;
import com.asbestosstar.crashdetector.api_sito_registro.DemasiadoGrande;
import com.asbestosstar.crashdetector.api_sito_registro.ErrorConPublicar;
import com.asbestosstar.crashdetector.api_sito_registro.LimteDeTasa;
import com.asbestosstar.crashdetector.api_sito_registro.NoAPIdeRegistro;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.canario.CanarioDeOrdenJudicialGUI1984;
import com.asbestosstar.crashdetector.gui.tipos.compartir.DialogoCompartir;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class DialogoCompartirLegacy
extends DialogoCompartir {
    public static String ID = "dialogo_compartir_legacy";

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void preperar(Instant instant) {
        this.setSize(900, 725);
        this.setDefaultCloseOperation(2);
        this.instant = instant;
        this.panelPrincipal = new JPanel(new BorderLayout(10, 10));
        this.panelSuperior = new JPanel(new BorderLayout(0, 10));
        this.panelSuperior.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.textoExplicacion = new JEditorPane("text/html", MonitorDePID.idioma.arco());
        this.textoExplicacion.setEditable(false);
        this.textoExplicacion.setOpaque(false);
        this.textoExplicacion.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (Exception ex) {
                    CrashDetectorLogger.logException(ex);
                }
            }
        });
        JScrollPane scrollTexto = new JScrollPane(this.textoExplicacion);
        scrollTexto.setPreferredSize(new Dimension(10, 180));
        scrollTexto.setMaximumSize(new Dimension(Integer.MAX_VALUE, 180));
        this.panelControles = new JPanel();
        this.panelControles.setLayout(new BoxLayout(this.panelControles, 1));
        this.botonCompartirTodos = new JButton(MonitorDePID.idioma.botonDeCompartirInforme());
        this.botonCompartirTodos.addActionListener(e -> {
            this.setEnviando(true);
            try {
                this.compartirSeleccionados(e);
            }
            catch (Throwable t) {
                this.mostrarError(MonitorDePID.idioma.error_inesperado_al_compartir(), t);
            }
            finally {
                this.setEnviando(false);
            }
        });
        int h1 = this.botonCompartirTodos.getPreferredSize().height;
        this.botonCompartirTodos.setMaximumSize(new Dimension(Integer.MAX_VALUE, h1));
        this.botonCompartirTodos.setAlignmentX(0.0f);
        this.panelControles.add(this.botonCompartirTodos);
        this.panelControles.add(Box.createVerticalStrut(8));
        this.botonCompartirMarkdown = new JButton(MonitorDePID.idioma.texto_de_boton_compartir_markdown());
        this.botonCompartirMarkdown.addActionListener(e -> {
            this.setEnviando(true);
            try {
                this.compartirSoloEnlacesMarkdown(e);
            }
            catch (Throwable t) {
                this.mostrarError(MonitorDePID.idioma.error_inesperado_al_generar_enlaces(), t);
            }
            finally {
                this.setEnviando(false);
            }
        });
        int h2 = this.botonCompartirMarkdown.getPreferredSize().height;
        this.botonCompartirMarkdown.setMaximumSize(new Dimension(Integer.MAX_VALUE, h2));
        this.botonCompartirMarkdown.setAlignmentX(0.0f);
        this.panelControles.add(this.botonCompartirMarkdown);
        this.panelControles.add(Box.createVerticalStrut(10));
        this.campoEnlaceReporte = new JTextField();
        this.campoEnlaceReporte.setEditable(false);
        int hf = 28;
        this.campoEnlaceReporte.setMaximumSize(new Dimension(Integer.MAX_VALUE, hf));
        this.campoEnlaceReporte.setAlignmentX(0.0f);
        this.panelControles.add(this.campoEnlaceReporte);
        this.panelSuperior.add((Component)scrollTexto, "Center");
        this.panelSuperior.add((Component)this.panelControles, "South");
        this.inicializarTabla();
        this.inicializarPanelConfiguracion();
        this.panelPrincipal.add((Component)this.panelSuperior, "North");
        this.panelPrincipal.add((Component)new JScrollPane(this.tabla), "Center");
        this.panelPrincipal.add((Component)this.panelConfig, "South");
        this.add(this.panelPrincipal);
        this.cargarConsolas();
        this.setVisible(true);
    }

    private void inicializarTabla() {
        this.modeloTabla = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0 || column == 2 || column == 3;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return columnIndex == 0 ? Boolean.class : String.class;
            }
        };
        this.modeloTabla.addColumn(MonitorDePID.idioma.incluir());
        this.modeloTabla.addColumn(MonitorDePID.idioma.archivo());
        this.modeloTabla.addColumn(MonitorDePID.idioma.abrir());
        this.modeloTabla.addColumn(MonitorDePID.idioma.texto_de_boton_compartir_enlace());
        this.modeloTabla.addColumn(MonitorDePID.idioma.columna_url());
        this.tabla = new JTable(this.modeloTabla);
        this.tabla.setRowHeight(30);
        this.tabla.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxRenderer());
        this.tabla.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tabla.getColumnModel().getColumn(2).setCellRenderer(new ButtonRenderer(MonitorDePID.idioma.abrir()));
        this.tabla.getColumnModel().getColumn(2).setCellEditor(new ButtonEditor(MonitorDePID.idioma.abrir()));
        this.tabla.getColumnModel().getColumn(3).setCellRenderer(new ButtonRenderer(MonitorDePID.idioma.texto_de_boton_compartir_enlace()));
        this.tabla.getColumnModel().getColumn(3).setCellEditor(new ButtonEditor(MonitorDePID.idioma.texto_de_boton_compartir_enlace()));
        this.tabla.getColumnModel().getColumn(4).setCellRenderer(new URLEditorRenderer());
        this.tabla.getColumnModel().getColumn(4).setCellEditor(new URLEditor());
    }

    private void inicializarPanelConfiguracion() {
        boolean error_de_api;
        APIdeSitioDeRegistro api_def;
        this.panelConfig = new JPanel(new GridBagLayout());
        this.panelConfig.setBorder(BorderFactory.createTitledBorder(MonitorDePID.idioma.titulo_configuracion()));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.panelConfig.add((Component)new JLabel(MonitorDePID.idioma.endpointDeInforme()), gbc);
        ++gbc.gridx;
        gbc.weightx = 3.0;
        this.campoEndpoint = new JTextField(Config.obtenerInstancia().obtenerSitoDeInformes(), 50);
        this.campoEndpoint.setMinimumSize(new Dimension(400, 25));
        this.panelConfig.add((Component)this.campoEndpoint, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        this.panelConfig.add((Component)new JLabel(MonitorDePID.idioma.apiDeLogging()), gbc);
        ++gbc.gridx;
        String sito_actual = Config.obtenerInstancia().obtenerSitioDeRegistrosSeleccionado();
        try {
            api_def = this.obtenerAPI();
            error_de_api = false;
        }
        catch (NoAPIdeRegistro e2) {
            this.mostrarError(MonitorDePID.idioma.apiDeRegistroNoExiste(), e2);
            api_def = Consola.secure_logger_api;
            sito_actual = "https://securelogger.net/save/log?";
            error_de_api = true;
        }
        HashMap apis = new HashMap();
        for (APIdeSitioDeRegistro api : APIdeSitioDeRegistro.APIS) {
            LinkedHashSet<String> sits = new LinkedHashSet<String>();
            if (api != null && api.equals(api_def) && !error_de_api && sito_actual != null) {
                sits.add(sito_actual);
            }
            sits.addAll(api.sitiosPorDefecto());
            apis.put(api.nombre(), sits);
        }
        this.comboAPI = new JComboBox<String>(apis.keySet().toArray(new String[0]));
        this.comboAPI.setSelectedItem(api_def.nombre());
        this.comboAPI.setPreferredSize(new Dimension(300, 25));
        this.panelConfig.add((Component)this.comboAPI, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.panelConfig.add((Component)new JLabel(MonitorDePID.idioma.sitoDeLogging()), gbc);
        ++gbc.gridx;
        this.comboSitioRegistro = new JComboBox<String>(new String[0]);
        this.comboSitioRegistro.setPreferredSize(new Dimension(300, 25));
        this.panelConfig.add((Component)this.comboSitioRegistro, gbc);
        this.actualizarComboSitios(api_def.nombre(), (Set)apis.get(api_def.nombre()), sito_actual);
        this.comboAPI.addActionListener(e -> {
            String apiSeleccionada = (String)this.comboAPI.getSelectedItem();
            Set sitios = (Set)apis.get(apiSeleccionada);
            this.actualizarComboSitios(apiSeleccionada, sitios, null);
        });
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.checkAnonimizar = new JCheckBox(MonitorDePID.idioma.anonimizarRegistros());
        this.checkAnonimizar.setSelected(ConfigMundial.obtenerInstancia().esAnonimizarRegistros());
        this.panelConfig.add((Component)this.checkAnonimizar, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        JButton boton_guardar_de_config = new JButton(MonitorDePID.idioma.guardarConfigDeCompartir());
        boton_guardar_de_config.addActionListener(e -> this.guardarConfig());
        this.panelConfig.add((Component)boton_guardar_de_config, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        JButton botonCanario = new JButton(MonitorDePID.idioma.buscador_canario_de_orden_label());
        botonCanario.addActionListener(e -> TipoGUI.CANARIO.obtenerGUIPredeterminado(CanarioDeOrdenJudicialGUI1984.ID, () -> new CanarioDeOrdenJudicialGUI1984()).init());
        this.panelConfig.add((Component)botonCanario, gbc);
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> ret = new ArrayList<ElementoConfig>();
        ConfigColor colorEnlace = ConfigColor.de("dialogo_compartir_enlace", Color.BLUE.darker());
        colorEnlace.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorEnlaceCompartir());
        ret.add(colorEnlace);
        ConfigColor colorFondoCampo = ConfigColor.de("dialogo_compartir_campo_fondo", Color.YELLOW);
        colorFondoCampo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoCampoCompartir());
        ret.add(colorFondoCampo);
        return ret;
    }

    @Override
    public void recargarApariencia() {
        if (this.campoEnlaceReporte != null) {
            this.campoEnlaceReporte.setBackground(ConfigColor.de("dialogo_compartir_campo_fondo", Color.YELLOW).obtener());
        }
    }

    private static class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }

    private static class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        public ButtonRenderer(String texto) {
            this.setText(texto);
            this.setMargin(new Insets(2, 5, 2, 5));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    private class ButtonEditor
    extends DefaultCellEditor {
        private final String accion;
        private final JButton button;
        private int currentRow;

        public ButtonEditor(String accion) {
            super(new JCheckBox());
            this.currentRow = -1;
            this.accion = accion;
            this.button = new JButton(accion);
            this.button.addActionListener(e -> {
                try {
                    this.button.setEnabled(false);
                    DialogoCompartirLegacy.this.setCursor(Cursor.getPredefinedCursor(3));
                    if (this.currentRow < 0) {
                        return;
                    }
                    Consola cons = MonitorDePID.consolas.get(this.currentRow);
                    if (accion.equals(MonitorDePID.idioma.abrir())) {
                        block55: {
                            if (cons == null || cons.archivo == null) {
                                DialogoCompartirLegacy.this.mostrarError(MonitorDePID.idioma.sin_archivo_para_abrir(), null);
                                return;
                            }
                            File f = cons.archivo.toFile();
                            if (!f.exists()) {
                                DialogoCompartirLegacy.this.mostrarError(MonitorDePID.idioma.archivo_no_existe_prefijo() + f.getAbsolutePath(), null);
                                return;
                            }
                            if (Desktop.isDesktopSupported()) {
                                Desktop d = Desktop.getDesktop();
                                try {
                                    if (d.isSupported(Desktop.Action.EDIT)) {
                                        d.edit(f);
                                        break block55;
                                    }
                                    if (d.isSupported(Desktop.Action.OPEN)) {
                                        d.open(f);
                                        break block55;
                                    }
                                    File parent = f.getParentFile();
                                    if (parent != null && parent.exists() && d.isSupported(Desktop.Action.OPEN)) {
                                        d.open(parent);
                                        break block55;
                                    }
                                    DialogoCompartir.copiarAlPortapapeles(f.getAbsolutePath());
                                    DialogoCompartirLegacy.this.mostrarInfo(MonitorDePID.idioma.no_se_pudo_abrir_se_copia_ruta());
                                }
                                catch (Exception ex) {
                                    CrashDetectorLogger.logException(ex);
                                    DialogoCompartirLegacy.this.mostrarError(MonitorDePID.idioma.no_se_pudo_editar_se_copia_ruta(), ex);
                                    DialogoCompartir.copiarAlPortapapeles(f.getAbsolutePath());
                                }
                            } else {
                                DialogoCompartir.copiarAlPortapapeles(f.getAbsolutePath());
                                DialogoCompartirLegacy.this.mostrarInfo(MonitorDePID.idioma.escritorio_no_soportado_se_copia_ruta());
                            }
                        }
                        return;
                    }
                    if (accion.equals(MonitorDePID.idioma.texto_de_boton_compartir_enlace())) {
                        List<String> urls = cons.obtainerEnlaces();
                        String celda = urls == null || urls.isEmpty() ? "" : String.join((CharSequence)"\n", urls);
                        DialogoCompartirLegacy.this.modeloTabla.setValueAt(celda, this.currentRow, 4);
                        if (DialogoCompartirLegacy.this.campoEnlaceReporte != null) {
                            DialogoCompartirLegacy.this.campoEnlaceReporte.setText(celda);
                        }
                        if (celda != null && !celda.isEmpty()) {
                            DialogoCompartir.copiarAlPortapapeles(celda);
                            DialogoCompartirLegacy.this.mostrarInfo(MonitorDePID.idioma.copiadoAlPortapapeles());
                        }
                        return;
                    }
                }
                catch (DemasiadoGrande ex) {
                    DialogoCompartirLegacy.this.mostrarError(MonitorDePID.idioma.registroDemasiadoGrande(), ex);
                }
                catch (ErrorConPublicar ex) {
                    DialogoCompartirLegacy.this.mostrarError(MonitorDePID.idioma.errorConPublicarRegistro(ex.problema), ex);
                }
                catch (NoAPIdeRegistro ex) {
                    DialogoCompartirLegacy.this.mostrarError(MonitorDePID.idioma.apiDeRegistroNoExiste(), ex);
                }
                catch (LimteDeTasa ex) {
                    DialogoCompartirLegacy.this.mostrarError(MonitorDePID.idioma.limite_de_solicitudes(), ex);
                }
                catch (Exception ex) {
                    CrashDetectorLogger.logException(ex);
                    DialogoCompartirLegacy.this.mostrarError(MonitorDePID.idioma.error_inesperado_al_procesar_boton(), ex);
                }
                finally {
                    try {
                        this.fireEditingStopped();
                    }
                    catch (Throwable ex) {}
                    this.button.setEnabled(true);
                    DialogoCompartirLegacy.this.setCursor(Cursor.getDefaultCursor());
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentRow = row;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.accion;
        }
    }

    private static class URLEditorRenderer
    extends JLabel
    implements TableCellRenderer {
        public URLEditorRenderer() {
            this.setCursor(Cursor.getPredefinedCursor(2));
            this.setForeground(ConfigColor.de("dialogo_compartir_enlace", Color.BLUE.darker()).obtener());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        DialogoCompartir.copiarAlPortapapeles(this.getText());
                    }
                }
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    private static class URLEditor
    extends DefaultCellEditor {
        private final JTextField textField = (JTextField)this.getComponent();

        public URLEditor() {
            super(new JTextField());
            this.textField.setEditable(false);
            this.textField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        DialogoCompartir.copiarAlPortapapeles(textField.getText());
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.textField.setText(value == null ? "" : value.toString());
            return this.textField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.textField.getText();
        }
    }
}

