/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.config;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ConfigString;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.editor_plantilla.EditorPlantilla;
import com.asbestosstar.crashdetector.gui.tipos.editor_plantilla.EditorPlantillaPredeterminado;
import com.asbestosstar.crashdetector.gui.tipos.editorgui.CDSkinCape;
import com.asbestosstar.crashdetector.gui.tipos.editorgui.EditorGUI;
import com.asbestosstar.crashdetector.gui.tipos.principal.PrincipalGUI;
import com.asbestosstar.crashdetector.parches.ConfigDeParches;
import com.asbestosstar.crashdetector.parches.Parche;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class ConfigPanel<PrincipalGUI>
extends JPanel
implements CrashDetectorGUI {
    public PrincipalGUI cdgui;
    public JTabbedPane tabbedPane;
    public static Map<String, Supplier<ConfigPanel>> GUIS = new HashMap<String, Supplier<ConfigPanel>>();
    public ConfigColor colorFondo;
    public ConfigColor colorTexto;
    public ConfigColor colorBoton;
    public ConfigColor colorCajaTexto;
    public Color colorFondoPestanias;

    public void constructir(PrincipalGUI principal_gui) {
        this.cdgui = principal_gui;
        CrashDetectorLogger.log("configpanel const");
        this.setLayout(new BorderLayout());
        this.inicializarColores();
        this.tabbedPane = new JTabbedPane();
        if (!CrashDetectorGUI.esMac()) {
            this.colorFondoPestanias = this.colorFondo.obtener().darker().darker();
            this.tabbedPane.setBackground(this.colorFondoPestanias);
            this.tabbedPane.setOpaque(true);
        }
        this.configurarPestanas();
        this.add((Component)this.tabbedPane, "Center");
        this.configurarBotonGuardar();
    }

    public void inicializarColores() {
        this.colorFondo = ConfigColor.de("config.color.fondo", Config.convertirAColor(Config.obtenerInstancia().obtenerColorFondo()));
        this.colorTexto = ConfigColor.de("config.color.texto", Config.convertirAColor(Config.obtenerInstancia().obtenerColorTexto()));
        this.colorBoton = ConfigColor.de("config.color.boton", Config.convertirAColor(Config.obtenerInstancia().obtenerColorBoton()));
        this.colorCajaTexto = ConfigColor.de("config.color.cajaTexto", Config.convertirAColor(Config.obtenerInstancia().obtenerColorCajaTexto()));
    }

    public void configurarPestanas() {
        Color colorTextoPestanias = CrashDetectorGUI.esMac() ? null : this.colorTexto.obtener();
        JLabel incicio_del_juego = new JLabel(MonitorDePID.idioma.inicioApp());
        if (colorTextoPestanias != null) {
            incicio_del_juego.setForeground(colorTextoPestanias);
        }
        this.tabbedPane.addTab("", null, this.tabDelJuego(), MonitorDePID.idioma.tooltip());
        this.tabbedPane.setTabComponentAt(0, this.crearComponentePestania(incicio_del_juego));
        JLabel cdajustes = new JLabel(MonitorDePID.idioma.ajustesCrashDetector());
        if (colorTextoPestanias != null) {
            cdajustes.setForeground(colorTextoPestanias);
        }
        this.tabbedPane.addTab("", null, this.tabCrashDetector(), MonitorDePID.idioma.tooltip());
        this.tabbedPane.setTabComponentAt(1, this.crearComponentePestania(cdajustes));
        JLabel confidencialidad = new JLabel(MonitorDePID.idioma.confidencialidad());
        if (colorTextoPestanias != null) {
            confidencialidad.setForeground(colorTextoPestanias);
        }
        this.tabbedPane.addTab("", null, this.tabConfidentialidad(), MonitorDePID.idioma.tooltip());
        this.tabbedPane.setTabComponentAt(2, this.crearComponentePestania(confidencialidad));
    }

    public void configurarBotonGuardar() {
        JButton guardarButon = new JButton(MonitorDePID.idioma.guardarYCerrar());
        if (CrashDetectorGUI.esMac()) {
            guardarButon.setContentAreaFilled(false);
        } else {
            guardarButon.setForeground(this.colorTexto.obtener());
            guardarButon.setBackground(this.colorBoton.obtener());
            guardarButon.setFont(new Font("Segoe UI", 0, 14));
            guardarButon.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        }
        guardarButon.setFocusPainted(false);
        guardarButon.addActionListener(e -> ((PrincipalGUI)this.cdgui).volver());
        JPanel butonPanel = new JPanel(new BorderLayout());
        if (!CrashDetectorGUI.esMac()) {
            butonPanel.setBackground(this.colorFondo.obtener());
        } else {
            butonPanel.setOpaque(false);
        }
        butonPanel.add((Component)guardarButon, "Center");
        this.add((Component)butonPanel, "South");
    }

    public Component crearComponentePestania(JLabel etiqueta) {
        if (CrashDetectorGUI.esMac()) {
            return etiqueta;
        }
        JPanel envoltura = new JPanel(new BorderLayout());
        envoltura.setOpaque(true);
        envoltura.setBackground(this.colorFondoPestanias != null ? this.colorFondoPestanias : this.colorFondo.obtener().darker());
        etiqueta.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 12));
        etiqueta.setOpaque(false);
        envoltura.add((Component)etiqueta, "Center");
        return envoltura;
    }

    public JPanel tabDelJuego() {
        JPanel panel = new JPanel();
        panel.setBackground(this.colorFondo.obtener());
        panel.setLayout(new GridLayout(0, 1, 5, 5));
        CrashDetectorLogger.log("Tab Del Juego ");
        for (Parche<?> parche : Parche.parches) {
            CrashDetectorLogger.log("Parche " + parche.nombre_de_gui());
            JPanel parchePanel = new JPanel(new BorderLayout());
            parchePanel.setBackground(this.colorFondo.obtener());
            JCheckBox checkBox = new JCheckBox();
            checkBox.setBackground(this.colorFondo.obtener());
            checkBox.setForeground(this.colorTexto.obtener());
            checkBox.setSelected(ConfigDeParches.obtenerInstancia().estaActivo(parche.id()));
            checkBox.addActionListener(e -> ConfigDeParches.obtenerInstancia().establecerActivo(parche.id(), checkBox.isSelected()));
            JLabel label = new JLabel(parche.nombre_de_gui());
            label.setForeground(this.colorTexto.obtener());
            label.setFont(new Font("Segoe UI", 0, 14));
            parchePanel.add((Component)checkBox, "West");
            parchePanel.add((Component)label, "Center");
            panel.add(parchePanel);
        }
        return panel;
    }

    public static JTextField crearCampoTextoConfig(String valorInicial, final Consumer<String> onChange) {
        final JTextField field = new JTextField(valorInicial);
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                onChange.accept(field.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                onChange.accept(field.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                onChange.accept(field.getText());
            }
        });
        return field;
    }

    public JPanel tabCrashDetector() {
        JPanel panel = new JPanel();
        panel.setBackground(this.colorFondo.obtener());
        panel.setLayout(new GridLayout(0, 2, 5, 5));
        Config config = Config.obtenerInstancia();
        ConfigMundial munidial = ConfigMundial.obtenerInstancia();
        boolean esMac = CrashDetectorGUI.esMac();
        Color colorDeTextoDeGui = this.colorTexto.obtener();
        JLabel labelDev = new JLabel(MonitorDePID.idioma.consolaDesarrollo());
        labelDev.setForeground(colorDeTextoDeGui);
        panel.add(labelDev);
        JComboBox<String> comboDev = new JComboBox<String>(new String[]{MonitorDePID.idioma.mundial(), MonitorDePID.idioma.ningun()});
        comboDev.setSelectedItem(munidial.obtenerConsolaDesarrollo() ? MonitorDePID.idioma.mundial() : MonitorDePID.idioma.ningun());
        comboDev.addActionListener(e -> {
            boolean valor = comboDev.getSelectedItem().equals(MonitorDePID.idioma.mundial());
            munidial.guardarConsolaDesarrollo(valor);
            if (valor) {
                MonitorDePID.abrirConsola();
            }
        });
        if (!esMac) {
            comboDev.setBackground(this.colorCajaTexto.obtener());
            comboDev.setForeground(colorDeTextoDeGui);
        }
        panel.add(comboDev);
        JLabel labelSitio = new JLabel(MonitorDePID.idioma.endpointDeInforme());
        labelSitio.setForeground(colorDeTextoDeGui);
        panel.add(labelSitio);
        JTextField sitioDeInformesField = ConfigPanel.crearCampoTextoConfig(config.obtenerSitoDeInformes(), config::guardarSitioDeInformes);
        if (!esMac) {
            sitioDeInformesField.setBackground(this.colorCajaTexto.obtener());
            sitioDeInformesField.setForeground(colorDeTextoDeGui);
        }
        panel.add(sitioDeInformesField);
        JLabel labelHMCL = new JLabel(MonitorDePID.idioma.carpetaHMCL());
        labelHMCL.setForeground(colorDeTextoDeGui);
        panel.add(labelHMCL);
        JTextField carpetaHMCL = ConfigPanel.crearCampoTextoConfig(config.obtenerCarpetaHMCL(), config::guardarCarpetaHMCL);
        if (!esMac) {
            carpetaHMCL.setBackground(this.colorCajaTexto.obtener());
            carpetaHMCL.setForeground(colorDeTextoDeGui);
        }
        panel.add(carpetaHMCL);
        JLabel labelEditarColores = new JLabel("HTML WYSIWYG PLANTILLA:");
        labelEditarColores.setForeground(colorDeTextoDeGui);
        panel.add(labelEditarColores);
        JButton botonEditarColores = new JButton("HTML WYSIWYG PLANTILLA");
        if (!esMac) {
            botonEditarColores.setForeground(this.colorTexto.obtener());
            botonEditarColores.setBackground(this.colorBoton.obtener());
            botonEditarColores.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        }
        botonEditarColores.setFocusPainted(false);
        botonEditarColores.addActionListener(e -> {
            JDialog dialogo = new JDialog(SwingUtilities.getWindowAncestor(this), "HTML WYSIWYG PLANTILLA");
            dialogo.setDefaultCloseOperation(2);
            EditorPlantilla editor = TipoGUI.EDITOR_PLANTILLA.obtenerGUIPredeterminado("editor_plantilla_predeterminado", () -> new EditorPlantillaPredeterminado());
            editor.init();
            dialogo.setContentPane(editor);
            dialogo.pack();
            dialogo.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
            dialogo.setVisible(true);
        });
        panel.add(botonEditarColores);
        JLabel labelEditarGUI = new JLabel("Editar GUIs:");
        labelEditarGUI.setForeground(colorDeTextoDeGui);
        panel.add(labelEditarGUI);
        JButton botonEditarGUIs = new JButton("Editar GUIs");
        if (!esMac) {
            botonEditarGUIs.setForeground(this.colorTexto.obtener());
            botonEditarGUIs.setBackground(this.colorBoton.obtener());
            botonEditarGUIs.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        }
        botonEditarGUIs.setFocusPainted(false);
        botonEditarGUIs.addActionListener(e -> {
            EditorGUI editor_gui = TipoGUI.EDITOR_GUI.obtenerGUIPredeterminado(CDSkinCape.ID, () -> new CDSkinCape());
            editor_gui.init();
        });
        panel.add(botonEditarGUIs);
        JLabel labelGuiDefault = new JLabel("GUIs por defecto:");
        labelGuiDefault.setForeground(colorDeTextoDeGui);
        panel.add(labelGuiDefault);
        panel.add(new JLabel());
        for (TipoGUI tipo : TipoGUI.TIPOS_DE_GUI) {
            Map guis = tipo.obtenerGUIs();
            if (guis.size() <= 1) continue;
            JLabel label = new JLabel(tipo.etiquetaDelBoton() + ":");
            label.setForeground(colorDeTextoDeGui);
            panel.add(label);
            JComboBox<String> dropdown = new JComboBox<String>(guis.keySet().toArray(new String[0]));
            String valorActual = ConfigString.de("guitipo_" + tipo.id(), "ningun").obtener();
            dropdown.setSelectedItem(valorActual);
            dropdown.addActionListener(e -> {
                String seleccionado = (String)dropdown.getSelectedItem();
                ConfigString.de("guitipo_" + tipo.id(), "ningun").escribir(seleccionado);
            });
            if (!esMac) {
                dropdown.setBackground(this.colorCajaTexto.obtener());
                dropdown.setForeground(colorDeTextoDeGui);
            }
            panel.add(dropdown);
        }
        JLabel labelProxy = new JLabel("proxySysOutSysErr");
        labelProxy.setForeground(colorDeTextoDeGui);
        panel.add(labelProxy);
        JCheckBox proxySysOutSysErrCheckBox = new JCheckBox();
        proxySysOutSysErrCheckBox.setBackground(this.colorFondo.obtener());
        proxySysOutSysErrCheckBox.setSelected(config.obtenerProxySysOutSysErr());
        proxySysOutSysErrCheckBox.addItemListener(e -> config.guardarProxySysOutSysErr(proxySysOutSysErrCheckBox.isSelected()));
        panel.add(proxySysOutSysErrCheckBox);
        panel.setPreferredSize(new Dimension(600, 400));
        return panel;
    }

    public JPanel tabConfidentialidad() {
        ConfigMundial munidial = ConfigMundial.obtenerInstancia();
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBackground(this.colorFondo.obtener());
        JEditorPane areaTexto = new JEditorPane();
        areaTexto.setContentType("text/html");
        areaTexto.setText(MonitorDePID.idioma.arco());
        areaTexto.setEditable(false);
        areaTexto.setOpaque(true);
        areaTexto.setBackground(this.colorFondo.obtener());
        areaTexto.setForeground(this.colorTexto.obtener());
        areaTexto.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        areaTexto.setFont(new Font("Monospaced", 0, 13));
        areaTexto.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JScrollPane scroll = new JScrollPane(areaTexto);
        scroll.setPreferredSize(new Dimension(10, 180));
        panel.add((Component)scroll, "North");
        JPanel panelOpciones = new JPanel(new GridLayout(0, 2, 8, 8));
        panelOpciones.setBackground(this.colorFondo.obtener());
        panelOpciones.setBorder(BorderFactory.createTitledBorder(MonitorDePID.idioma.opcionesMunidiales()));
        JLabel labelAnon = new JLabel(MonitorDePID.idioma.anonimizarRegistros());
        labelAnon.setForeground(this.colorTexto.obtener());
        panelOpciones.add(labelAnon);
        JCheckBox checkAnon = new JCheckBox();
        checkAnon.setBackground(this.colorFondo.obtener());
        checkAnon.setSelected(munidial.esAnonimizarRegistros());
        checkAnon.addActionListener(e -> munidial.guardarAnonimizarRegistros(checkAnon.isSelected()));
        panelOpciones.add(checkAnon);
        JLabel labelConsent = new JLabel(MonitorDePID.idioma.consentimientoLFPDPPP());
        labelConsent.setForeground(this.colorTexto.obtener());
        panelOpciones.add(labelConsent);
        JCheckBox checkConsent = new JCheckBox();
        checkConsent.setBackground(this.colorFondo.obtener());
        checkConsent.setSelected(munidial.obtenerConsentimientoLFPDPPP());
        checkConsent.addActionListener(e -> munidial.guardarConsentimientoLFPDPPP(checkConsent.isSelected()));
        panelOpciones.add(checkConsent);
        JLabel labelToken = new JLabel(MonitorDePID.idioma.habilitarTokenAccesoEnEntregar());
        labelToken.setForeground(this.colorTexto.obtener());
        panelOpciones.add(labelToken);
        JCheckBox checkToken = new JCheckBox();
        checkToken.setBackground(this.colorFondo.obtener());
        checkToken.setSelected(munidial.obtenerHabilitarTokenDeAccesoEnLaEntregaDelMonitorDePID());
        checkToken.addActionListener(e -> munidial.guardarHabilitarTokenDeAccesoEnLaEntregaDelMonitorDePID(checkToken.isSelected()));
        panelOpciones.add(checkToken);
        panel.add((Component)panelOpciones, "Center");
        JPanel placeholderImagen = new JPanel();
        placeholderImagen.setBackground(this.colorFondo.obtener());
        JLabel etiquetaImagen = new JLabel();
        etiquetaImagen.setHorizontalAlignment(0);
        try {
            ImageIcon iconoImagen = new ImageIcon(Statics.carpeta.resolve("imagenes/profeco.jpg").toString());
            etiquetaImagen.setIcon(iconoImagen);
        }
        catch (Exception e2) {
            etiquetaImagen.setText(MonitorDePID.idioma.errorCargandoImagen());
            etiquetaImagen.setForeground(this.colorTexto.obtener());
        }
        placeholderImagen.add(etiquetaImagen);
        panel.add((Component)placeholderImagen, "South");
        return panel;
    }

    @Override
    public TipoGUI tipo() {
        return TipoGUI.CONFIG_PANEL;
    }

    @Override
    public void init() {
    }
}

