/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.config;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.config.ConfigPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConfigPanelEstiloTL<PrincipalGUI>
extends ConfigPanel<PrincipalGUI> {
    public static String ID = "tl_estilo_config";

    public ConfigPanelEstiloTL() {
        this.colorFondo = ConfigColor.de("config.color.fondo", Config.convertirAColor(Config.obtenerInstancia().obtenerColorFondo()));
        this.colorTexto = ConfigColor.de("config.color.texto", Config.convertirAColor(Config.obtenerInstancia().obtenerColorTexto()));
        this.colorBoton = ConfigColor.de("config.color.boton", Config.convertirAColor(Config.obtenerInstancia().obtenerColorBoton()));
        this.colorCajaTexto = ConfigColor.de("config.color.cajaTexto", Config.convertirAColor(Config.obtenerInstancia().obtenerColorCajaTexto()));
    }

    @Override
    public void recargarApariencia() {
        Component[] components;
        this.setBackground(this.colorFondo.obtener());
        if (this.tabbedPane != null) {
            this.tabbedPane.setBackground(this.colorFondo.obtener().darker());
            this.tabbedPane.setForeground(this.colorTexto.obtener());
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                Component comp = this.tabbedPane.getTabComponentAt(i);
                if (!(comp instanceof JPanel)) continue;
                ((JPanel)comp).setBackground(this.colorFondo.obtener().darker());
            }
        }
        for (Component comp : components = this.getComponents()) {
            if (!(comp instanceof JPanel)) continue;
            JPanel panel = (JPanel)comp;
            for (Component child : panel.getComponents()) {
                if (child instanceof JButton) {
                    JButton btn = (JButton)child;
                    btn.setForeground(this.colorTexto.obtener());
                    btn.setBackground(this.colorBoton.obtener());
                }
                if (!(child instanceof JTextField)) continue;
                JTextField field = (JTextField)child;
                field.setBackground(this.colorCajaTexto.obtener());
                field.setForeground(this.colorTexto.obtener());
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        this.colorCajaTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorCajaTexto());
        elementos.add(this.colorFondo);
        elementos.add(this.colorTexto);
        elementos.add(this.colorBoton);
        elementos.add(this.colorCajaTexto);
        return elementos;
    }
}

