/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.consola;

import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.api_sito_registro.APIdeSitioDeRegistro;
import com.asbestosstar.crashdetector.api_sito_registro.DemasiadoGrande;
import com.asbestosstar.crashdetector.api_sito_registro.ErrorConPublicar;
import com.asbestosstar.crashdetector.api_sito_registro.LimteDeTasa;
import com.asbestosstar.crashdetector.api_sito_registro.NoAPIdeRegistro;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.consola.ConsolaDesarrolladorGUI;
import com.asbestosstar.crashdetector.gui.tipos.lfpdppp.LeyFederalDeProteccionDeDatosPersonalesEnPosesionDeLosParticularesGUI;
import com.asbestosstar.crashdetector.gui.tipos.lfpdppp.LeyFederalDeProteccionDeDatosPersonalesEnPosesionDeLosParticularesGUIConLogos;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ConsolaDesarrolladorGUITL
extends ConsolaDesarrolladorGUI {
    public static String ID = "consola_dev_tl";
    private JTextArea area;
    private JScrollPane scroll;
    private JPanel barra;
    private JButton bajar;
    private JButton logs;
    private JButton stop;
    private boolean autoScroll = true;
    private boolean consentimientoTemporal = false;
    private ConfigColor fondo = ConfigColor.de("consola.dev.fondo", Color.BLACK);
    private ConfigColor texto = ConfigColor.de("consola.dev.texto", Color.WHITE);
    private ConfigColor barraInferior = ConfigColor.de("consola.dev.barra", Color.decode("#404040"));

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void init() {
        this.setTitle(MonitorDePID.idioma.consolaDesarrollo());
        this.setSize(900, 600);
        this.setLayout(new BorderLayout());
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ConfigMundial.obtenerInstancia().guardarConsolaDesarrollo(false);
                MonitorDePID.consola_des = null;
            }
        });
        this.area = new JTextArea();
        this.area.setEditable(false);
        this.area.setBackground(this.fondo.obtener());
        this.area.setForeground(this.texto.obtener());
        this.area.setFont(new Font("Monospaced", 0, 14));
        this.scroll = new JScrollPane(this.area);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.add((Component)this.scroll, "Center");
        this.scroll.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar sb = ConsolaDesarrolladorGUITL.this.scroll.getVerticalScrollBar();
                int max = sb.getMaximum();
                int extent = sb.getModel().getExtent();
                int value = sb.getValue();
                ConsolaDesarrolladorGUITL.this.autoScroll = value + extent + 4 >= max;
            }
        });
        this.barra = new JPanel();
        this.barra.setLayout(new BoxLayout(this.barra, 0));
        this.barra.setBackground(this.barraInferior.obtener());
        this.barra.setPreferredSize(new Dimension(10, 46));
        this.bajar = new JButton("\u2b07");
        this.logs = new JButton("\u00a7");
        this.stop = new JButton("\u25a0");
        for (JButton b : new JButton[]{this.bajar, this.logs, this.stop}) {
            b.setFocusPainted(false);
            b.setBackground(this.barraInferior.obtener());
            b.setForeground(this.texto.obtener());
            b.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 16));
            b.setOpaque(true);
            b.setContentAreaFilled(true);
            b.setBorderPainted(false);
        }
        this.barra.add(Box.createHorizontalGlue());
        this.barra.add(this.bajar);
        this.barra.add(Box.createHorizontalStrut(8));
        this.barra.add(this.logs);
        this.barra.add(Box.createHorizontalStrut(8));
        this.barra.add(this.stop);
        this.barra.add(Box.createHorizontalStrut(8));
        this.add((Component)this.barra, "South");
        this.bajar.addActionListener(e -> {
            this.autoScroll = true;
            this.area.setCaretPosition(this.area.getDocument().getLength());
        });
        this.logs.addActionListener(e -> this.compartirLogs());
        this.stop.addActionListener(e -> {
            long pid = MonitorDePID.pid;
            if (pid <= 0L) {
                return;
            }
            try {
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("win")) {
                    Runtime.getRuntime().exec("taskkill /PID " + pid + " /F");
                } else {
                    Runtime.getRuntime().exec("kill -9 " + pid);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        final JPopupMenu menu = new JPopupMenu();
        menu.add(this.crearItem(MonitorDePID.idioma.copiarSeleccion(), () -> this.area.copy()));
        menu.add(this.crearItem(MonitorDePID.idioma.seleccionarTodo(), () -> this.area.selectAll()));
        menu.add(this.crearItem(MonitorDePID.idioma.copiarTodo(), () -> {
            this.area.selectAll();
            this.area.copy();
        }));
        menu.add(this.crearItem(MonitorDePID.idioma.guardarTodoComoArchivo(), this::guardarComoArchivo));
        menu.add(this.crearItem(MonitorDePID.idioma.obtenerEnlaceSoporte(), this::compartirLogs));
        menu.add(this.crearItem(MonitorDePID.idioma.borrarTodo(), () -> this.area.setText("")));
        this.area.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    menu.show(ConsolaDesarrolladorGUITL.this.area, e.getX(), e.getY());
                }
            }
        });
        this.setVisible(true);
    }

    private JMenuItem crearItem(String nombre, Runnable accion) {
        JMenuItem it = new JMenuItem(nombre);
        it.addActionListener(e -> accion.run());
        return it;
    }

    @Override
    public void agregarLinea(String linea) {
        if (this.area != null) {
            this.area.append(linea + "\n");
            if (this.autoScroll) {
                this.area.setCaretPosition(this.area.getDocument().getLength());
            }
        }
    }

    private void compartirLogs() {
        block13: {
            try {
                String enlace;
                ConfigMundial cfg = ConfigMundial.obtenerInstancia();
                if (!cfg.obtenerConsentimientoLFPDPPP() && !this.consentimientoTemporal) {
                    LeyFederalDeProteccionDeDatosPersonalesEnPosesionDeLosParticularesGUI gui = TipoGUI.LFPDPPP.obtenerGUIPredeterminado(LeyFederalDeProteccionDeDatosPersonalesEnPosesionDeLosParticularesGUIConLogos.ID, () -> new LeyFederalDeProteccionDeDatosPersonalesEnPosesionDeLosParticularesGUIConLogos());
                    gui.setDespuesDeAceptar(() -> {
                        this.consentimientoTemporal = true;
                        SwingUtilities.invokeLater(() -> this.compartirLogs());
                    });
                    gui.init();
                    return;
                }
                if (this.area == null) {
                    return;
                }
                String contenido = this.area.getText();
                if (contenido == null || contenido.trim().isEmpty()) {
                    return;
                }
                Path tmp = Files.createTempFile("devconsole-", ".log", new FileAttribute[0]);
                Consola consola = new Consola(tmp);
                consola.finalizarContenidoInyectado(contenido);
                APIdeSitioDeRegistro api = APIdeSitioDeRegistro.obtenerAPIdeConfig();
                List<String> urls = api.publicarRegistroEnPartes(consola);
                if (urls == null || urls.isEmpty()) {
                    return;
                }
                MonitorDePID.enlace = enlace = urls.get(0);
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().browse(new URL(enlace).toURI());
                        break block13;
                    }
                    ConsolaDesarrolladorGUITL.copiar(enlace);
                    JOptionPane.showMessageDialog(this, MonitorDePID.idioma.copiadoAlPortapapeles());
                }
                catch (Exception ex) {
                    ConsolaDesarrolladorGUITL.copiar(enlace);
                    JOptionPane.showMessageDialog(this, MonitorDePID.idioma.copiadoAlPortapapeles());
                }
            }
            catch (DemasiadoGrande e) {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.registroDemasiadoGrande());
            }
            catch (ErrorConPublicar e) {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.errorConPublicarRegistro(e.problema));
            }
            catch (NoAPIdeRegistro e) {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.apiDeRegistroNoExiste());
            }
            catch (LimteDeTasa e) {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.limite_de_solicitudes());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void guardarComoArchivo() {
        try {
            JFileChooser fc = new JFileChooser();
            if (fc.showSaveDialog(this) == 0) {
                File f = fc.getSelectedFile();
                Files.write(f.toPath(), this.area.getText().getBytes("UTF-8"), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void recargarApariencia() {
        if (this.area != null) {
            this.area.setBackground(this.fondo.obtener());
            this.area.setForeground(this.texto.obtener());
        }
        if (this.scroll != null) {
            this.scroll.getViewport().setBackground(this.fondo.obtener());
        }
        if (this.barra != null) {
            this.barra.setBackground(this.barraInferior.obtener());
        }
        for (JButton b : new JButton[]{this.bajar, this.logs, this.stop}) {
            if (b == null) continue;
            b.setBackground(this.barraInferior.obtener());
            b.setForeground(this.texto.obtener());
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> ret = new ArrayList<ElementoConfig>();
        this.fondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        this.texto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.barraInferior.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorPanel());
        ret.add(this.fondo);
        ret.add(this.texto);
        ret.add(this.barraInferior);
        return ret;
    }
}

