/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.corpo;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.ComboIdiomasConIcono;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.corpo.CorpoBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class CorpoSAO
extends CorpoBase {
    private static final long serialVersionUID = 1L;
    public static String ID = "sao";
    private ConfigColor colorFondoVentana = ConfigColor.de("tema.corpo.sao.color.fondo.ventana", new Color(212, 204, 198));
    private ConfigColor colorTexto = ConfigColor.de("tema.corpo.sao.color.texto", new Color(29, 30, 35));
    private ConfigColor colorBoton = ConfigColor.de("tema.corpo.sao.color.boton", new Color(124, 119, 119));
    private ConfigColor colorCajaTexto = ConfigColor.de("tema.corpo.sao.color.caja_texto", new Color(236, 230, 226));
    private ConfigColor colorEnlace = ConfigColor.de("tema.corpo.sao.color.enlace", new Color(89, 72, 84));
    private ConfigColor colorBordePanel = ConfigColor.de("tema.corpo.sao.color.borde_panel", new Color(188, 179, 173));
    private JPanel raizPanel;
    private JPanel panelIzquierdo;
    private JPanel panelDerecho;
    private JPanel panelConfiguracion;
    private JPanel panelBotones;
    private JLabel imagenSAO;
    private JComboBox<String> comboIdiomaRespaldo;
    private JCheckBox checkBuscardor;
    private JTextField campoNombreHerramienta;
    private JCheckBox checkCondenarPirata;
    private JButton botonLanzadoresRecomendados;
    private JButton botonLanzadoresDesaconsejados;
    private JButton botonModsRecomendados;
    private JButton botonModsDesaconsejados;
    private JButton botonAntiTamper;
    private JButton botonFirmas;
    private JButton botonDerechosMaranda;
    private JButton botonVerificaciones;
    private JPanel panelDerechos;

    @Override
    public void init() {
        this.setTitle(MonitorDePID.idioma.configuracionCorporativa());
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setMinimumSize(new Dimension(800, 600));
        this.setPreferredSize(new Dimension(850, 600));
        this.setAlwaysOnTop(false);
        this.setModal(false);
        this.raizPanel = new JPanel(new BorderLayout(10, 10));
        this.raizPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panelIzquierdo = new JPanel(new BorderLayout());
        this.panelIzquierdo.setPreferredSize(new Dimension(244, 338));
        this.panelIzquierdo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.imagenSAO = new JLabel();
        this.imagenSAO.setPreferredSize(new Dimension(244, 338));
        this.imagenSAO.setHorizontalAlignment(0);
        this.imagenSAO.setVerticalAlignment(0);
        this.panelIzquierdo.add((Component)this.imagenSAO, "Center");
        this.panelDerecho = new JPanel(new BorderLayout(10, 10));
        this.panelDerecho.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.panelConfiguracion = new JPanel(new GridBagLayout());
        this.panelConfiguracion.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.colorBordePanel.obtener(), 1), MonitorDePID.idioma.configuracionBasica()));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(8, 8, 8, 8);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.3;
        JLabel labelIdioma = new JLabel(MonitorDePID.idioma.idiomaRespaldo());
        labelIdioma.setForeground(this.colorTexto.obtener());
        this.panelConfiguracion.add((Component)labelIdioma, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.7;
        this.comboIdiomaRespaldo = new ComboIdiomasConIcono(this.getMapaIdiomas());
        this.comboIdiomaRespaldo.setPreferredSize(new Dimension(150, 30));
        this.panelConfiguracion.add(this.comboIdiomaRespaldo, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.3;
        JLabel labelBuscardor = new JLabel(MonitorDePID.idioma.buscardorHabilitado());
        labelBuscardor.setForeground(this.colorTexto.obtener());
        this.panelConfiguracion.add((Component)labelBuscardor, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.7;
        this.checkBuscardor = new JCheckBox();
        this.panelConfiguracion.add((Component)this.checkBuscardor, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.3;
        JLabel labelNombre = new JLabel(MonitorDePID.idioma.nombreHerramienta());
        labelNombre.setForeground(this.colorTexto.obtener());
        this.panelConfiguracion.add((Component)labelNombre, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.7;
        this.campoNombreHerramienta = new JTextField();
        this.panelConfiguracion.add((Component)this.campoNombreHerramienta, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.3;
        JLabel labelPirateria = new JLabel(MonitorDePID.idioma.condenarPirateria());
        labelPirateria.setForeground(this.colorTexto.obtener());
        this.panelConfiguracion.add((Component)labelPirateria, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 0.7;
        this.checkCondenarPirata = new JCheckBox();
        this.panelConfiguracion.add((Component)this.checkCondenarPirata, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        this.panelDerechos = new JPanel(new FlowLayout(0));
        this.panelDerechos.setOpaque(false);
        this.botonDerechosMaranda = new JButton(MonitorDePID.idioma.derechosMiranda());
        this.botonDerechosMaranda.setVisible(false);
        this.panelDerechos.add(this.botonDerechosMaranda);
        this.panelConfiguracion.add((Component)this.panelDerechos, gbc);
        this.panelDerecho.add((Component)this.panelConfiguracion, "North");
        this.panelBotones = new JPanel(new GridBagLayout());
        this.panelBotones.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.colorBordePanel.obtener(), 1), MonitorDePID.idioma.funcionalidades()));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(8, 8, 8, 8);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        this.botonLanzadoresRecomendados = new JButton(MonitorDePID.idioma.lanzadoresRecomendados());
        this.panelBotones.add((Component)this.botonLanzadoresRecomendados, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        this.botonLanzadoresDesaconsejados = new JButton(MonitorDePID.idioma.lanzadoresDesaconsejados());
        this.panelBotones.add((Component)this.botonLanzadoresDesaconsejados, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        this.botonModsRecomendados = new JButton(MonitorDePID.idioma.modsRecomendados());
        this.panelBotones.add((Component)this.botonModsRecomendados, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        this.botonModsDesaconsejados = new JButton(MonitorDePID.idioma.modsDesaconsejados());
        this.panelBotones.add((Component)this.botonModsDesaconsejados, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.5;
        this.botonAntiTamper = new JButton(MonitorDePID.idioma.antiTamper());
        this.panelBotones.add((Component)this.botonAntiTamper, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.5;
        this.botonFirmas = new JButton(TipoGUI.EDITOR_FIRMAS.etiquetaDelBoton());
        this.panelBotones.add((Component)this.botonFirmas, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        this.botonVerificaciones = new JButton(TipoGUI.DESHABLICAR_VERIFICACIONES.etiquetaDelBoton());
        this.panelBotones.add((Component)this.botonVerificaciones, gbc);
        this.panelDerecho.add((Component)this.panelBotones, "Center");
        this.raizPanel.add((Component)this.panelIzquierdo, "West");
        this.raizPanel.add((Component)this.panelDerecho, "Center");
        this.getContentPane().add(this.raizPanel);
        this.cargarImagenSAO();
        this.aplicarApariencia();
        this.actualizarValores();
        this.agregarListeners();
        this.pack();
        this.setSize(850, 600);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void cargarImagenSAO() {
        try {
            URL url = Statics.carpeta.resolve("imagenes/sao.png").toFile().toURL();
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                Image img = icon.getImage().getScaledInstance(244, 338, 4);
                this.imagenSAO.setIcon(new ImageIcon(img));
            } else {
                this.imagenSAO.setText(MonitorDePID.idioma.imagenNoEncontrada());
                this.imagenSAO.setHorizontalAlignment(0);
                this.imagenSAO.setVerticalAlignment(0);
                this.imagenSAO.setForeground(this.colorTexto.obtener());
            }
        }
        catch (Exception e) {
            CrashDetectorLogger.logException(e);
            this.imagenSAO.setText(MonitorDePID.idioma.errorCargandoImagen());
            this.imagenSAO.setHorizontalAlignment(0);
            this.imagenSAO.setVerticalAlignment(0);
            this.imagenSAO.setForeground(this.colorTexto.obtener());
        }
    }

    @Override
    public void aplicarApariencia() {
        this.getContentPane().setBackground(this.colorFondoVentana.obtener());
        this.raizPanel.setBackground(this.colorFondoVentana.obtener());
        this.panelIzquierdo.setBackground(this.colorFondoVentana.obtener());
        this.panelDerecho.setBackground(this.colorFondoVentana.obtener());
        this.panelConfiguracion.setBackground(this.colorFondoVentana.obtener());
        this.panelBotones.setBackground(this.colorFondoVentana.obtener());
        this.panelDerechos.setBackground(this.colorFondoVentana.obtener());
        this.estilizarBoton(this.botonLanzadoresRecomendados);
        this.estilizarBoton(this.botonLanzadoresDesaconsejados);
        this.estilizarBoton(this.botonModsRecomendados);
        this.estilizarBoton(this.botonModsDesaconsejados);
        this.estilizarBoton(this.botonAntiTamper);
        this.estilizarBoton(this.botonFirmas);
        this.estilizarBoton(this.botonDerechosMaranda);
        this.estilizarBoton(this.botonVerificaciones);
        this.estilizarCampo(this.campoNombreHerramienta);
        this.checkBuscardor.setForeground(this.colorTexto.obtener());
        this.checkCondenarPirata.setForeground(this.colorTexto.obtener());
        TitledBorder configBorder = (TitledBorder)this.panelConfiguracion.getBorder();
        configBorder.setTitleColor(this.colorTexto.obtener());
        configBorder.setBorder(BorderFactory.createLineBorder(this.colorBordePanel.obtener(), 1));
        TitledBorder funcBorder = (TitledBorder)this.panelBotones.getBorder();
        funcBorder.setTitleColor(this.colorTexto.obtener());
        funcBorder.setBorder(BorderFactory.createLineBorder(this.colorBordePanel.obtener(), 1));
        this.revalidate();
        this.repaint();
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorFondoVentana.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoVentana());
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        this.colorCajaTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorCajaTexto());
        this.colorEnlace.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorEnlace());
        this.colorBordePanel.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
        elementos.add(this.colorFondoVentana);
        elementos.add(this.colorTexto);
        elementos.add(this.colorBoton);
        elementos.add(this.colorCajaTexto);
        elementos.add(this.colorEnlace);
        elementos.add(this.colorBordePanel);
        return elementos;
    }

    private void actualizarValores() {
        this.comboIdiomaRespaldo.setSelectedItem(Idioma.nombreDeIdiomaDesdeCondigo(CorpoSAO.obtenerIdiomaRespaldo()));
        this.checkBuscardor.setSelected(CorpoSAO.obtenerBuscardorHablicar());
        this.campoNombreHerramienta.setText(CorpoSAO.obtenerNombreCD());
        this.checkCondenarPirata.setSelected(CorpoSAO.obtenerCondenarPirata());
        this.botonDerechosMaranda.setVisible(CorpoSAO.obtenerCondenarPirata());
    }

    private void agregarListeners() {
        this.comboIdiomaRespaldo.addActionListener(e -> {
            String selected = (String)this.comboIdiomaRespaldo.getSelectedItem();
            String codigo = CrashDetectorGUI.obtenerCodigoIdioma(selected);
            CorpoSAO.escribirIdiomaRespaldo(codigo);
        });
        this.checkBuscardor.addActionListener(e -> CorpoSAO.escribirBuscardorHablicar(this.checkBuscardor.isSelected()));
        this.campoNombreHerramienta.addActionListener(e -> CorpoSAO.escribirNombreCD(this.campoNombreHerramienta.getText()));
        this.checkCondenarPirata.addActionListener(e -> {
            CorpoSAO.escribirCondenarPirata(this.checkCondenarPirata.isSelected());
            this.botonDerechosMaranda.setVisible(this.checkCondenarPirata.isSelected());
        });
        ActionListener proximamenteListener = e -> JOptionPane.showMessageDialog(this, MonitorDePID.idioma.proximamente(), MonitorDePID.idioma.informacion(), 1);
        this.botonLanzadoresRecomendados.addActionListener(e -> CorpoSAO.abrirLanzeresBuenos());
        this.botonLanzadoresDesaconsejados.addActionListener(e -> CorpoSAO.abrirLanzeresMalos());
        this.botonModsRecomendados.addActionListener(e -> CorpoSAO.abrirModsBuenas());
        this.botonModsDesaconsejados.addActionListener(e -> CorpoSAO.abrirModsMalas());
        this.botonAntiTamper.addActionListener(e -> CorpoSAO.abrirAntiManipulacion());
        this.botonFirmas.addActionListener(e -> CorpoSAO.abrirEditorCodice());
        this.botonVerificaciones.addActionListener(e -> CorpoSAO.abrirVerificaciones());
        this.botonDerechosMaranda.addActionListener(e -> CorpoSAO.abrirMiranda());
    }

    private void estilizarBoton(JButton btn) {
        this.estilizarBoton(btn, 10);
    }

    private void estilizarBoton(JButton btn, int paddingV) {
        if (!CrashDetectorGUI.esMac()) {
            btn.setBackground(this.colorBoton.obtener());
            btn.setForeground(Color.WHITE);
            btn.setFocusPainted(false);
            btn.setBorder(BorderFactory.createEmptyBorder(paddingV, 18, paddingV, 18));
        } else {
            btn.setContentAreaFilled(false);
        }
        btn.setFont(new Font("Segoe UI", 0, 14));
    }

    private void estilizarCampo(JTextField campo) {
        campo.setBackground(this.colorCajaTexto.obtener());
        campo.setForeground(Color.WHITE);
        campo.setBorder(BorderFactory.createLineBorder(this.colorBoton.obtener().darker(), 1));
        campo.setFont(new Font("Segoe UI", 0, 14));
    }

    private LinkedHashMap<String, String> getMapaIdiomas() {
        LinkedHashMap<String, String> idiomas = new LinkedHashMap<String, String>();
        idiomas.put("Espa\u00f1ol", "imagenes/bandera_mexico.png");
        idiomas.put("English", "imagenes/bandera_inglaterra.png");
        idiomas.put("\u0627\u0644\u0639\u0631\u0628\u064a\u0629", "imagenes/bandera_arabia.png");
        idiomas.put("Portugu\u00eas", "imagenes/bandera_brasil.png");
        idiomas.put("\u0641\u0627\u0631\u0633\u06cc", "imagenes/bandera_iran.png");
        idiomas.put("\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "imagenes/bandera_rusia.png");
        idiomas.put("\u7b80\u4f53\u4e2d\u6587", "imagenes/bandera_china.png");
        idiomas.put("Esperanto", "imagenes/bandera_esperanto.png");
        idiomas.put("\u65e5\u672c\u8a9e", "imagenes/bandera_japon.png");
        idiomas.put("\ud55c\uad6d\uc5b4", "imagenes/bandera_corea.png");
        return idiomas;
    }
}

