/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.deshablicarverificaciones;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.tipos.deshablicarverificaciones.DeshablicarVerificaciones;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class DeshabilitarVerificacionesAmaneKanata
extends DeshablicarVerificaciones {
    private static final long serialVersionUID = 1L;
    public static String ID = "amane_kanata";
    public static File imagen = Statics.carpeta.resolve("imagenes/amane_kanata.png").toFile();
    private ConfigColor colorFondoVentana = ConfigColor.de("tema.amane_kanata.color.fondo.ventana", new Color(245, 252, 255));
    private ConfigColor colorTexto = ConfigColor.de("tema.amane_kanata.color.texto", new Color(45, 56, 72));
    private ConfigColor colorBoton = ConfigColor.de("tema.amane_kanata.color.boton", new Color(95, 170, 230));
    private ConfigColor colorCajaTexto = ConfigColor.de("tema.amane_kanata.color.caja_texto", new Color(255, 255, 255));
    private ConfigColor colorBordePanel = ConfigColor.de("tema.amane_kanata.color.borde_panel", new Color(204, 220, 235));
    private ConfigColor colorVerificacionCorporativa = ConfigColor.de("tema.amane_kanata.color.verificacion_corporativa", new Color(120, 210, 170));
    private JTable tablaHabilitadas;
    private JTable tablaDeshabilitadas;
    private DefaultTableModel modeloHabilitadas;
    private DefaultTableModel modeloDeshabilitadas;
    private JButton botonMoverDerecha;
    private JButton botonMoverIzquierda;
    private JButton botonDeshabilitarNoCorporativas;
    private JPanel panelPrincipal;
    private JLabel imagenLabel;
    private JLabel etiquetaHabilitadas;
    private JLabel etiquetaDeshabilitadas;
    private JLabel etiquetaMensajeAmaneKanata;

    @Override
    public void init() {
        this.setTitle(MonitorDePID.idioma.gestionVerificaciones());
        this.setModal(true);
        this.setResizable(true);
        this.setSize(900, 680);
        this.setDefaultCloseOperation(2);
        this.modeloHabilitadas = new DefaultTableModel(new Object[]{MonitorDePID.idioma.idVerificacion(), MonitorDePID.idioma.nombreVerificacion(), MonitorDePID.idioma.codigoVerificacion(), MonitorDePID.idioma.documentacionVerificacion()}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.modeloDeshabilitadas = new DefaultTableModel(new Object[]{MonitorDePID.idioma.idVerificacion(), MonitorDePID.idioma.nombreVerificacion(), MonitorDePID.idioma.codigoVerificacion(), MonitorDePID.idioma.documentacionVerificacion()}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tablaHabilitadas = new JTable(this.modeloHabilitadas);
        this.tablaDeshabilitadas = new JTable(this.modeloDeshabilitadas);
        this.configurarTabla(this.tablaHabilitadas);
        this.configurarTabla(this.tablaDeshabilitadas);
        this.panelPrincipal = new JPanel(new GridBagLayout());
        this.panelPrincipal.setBorder(BorderFactory.createEmptyBorder(8, 4, 8, 8));
        this.panelPrincipal.setBackground(this.colorFondoVentana.obtener());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        JPanel panelIzquierdo = new JPanel(new BorderLayout());
        panelIzquierdo.setPreferredSize(new Dimension(170, 0));
        panelIzquierdo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panelIzquierdo.setBackground(this.colorFondoVentana.obtener());
        this.imagenLabel = new JLabel();
        this.imagenLabel.setHorizontalAlignment(0);
        this.cargarImagen();
        this.etiquetaMensajeAmaneKanata = new JLabel(MonitorDePID.idioma.mensajeAmaneKanata(), 0);
        this.etiquetaMensajeAmaneKanata.setFont(new Font("Segoe UI", 2, 12));
        panelIzquierdo.add((Component)this.imagenLabel, "Center");
        panelIzquierdo.add((Component)this.etiquetaMensajeAmaneKanata, "South");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 6;
        gbc.weightx = 0.2;
        gbc.weighty = 1.0;
        this.panelPrincipal.add((Component)panelIzquierdo, gbc);
        this.etiquetaHabilitadas = new JLabel(MonitorDePID.idioma.verificacionesHabilitadas());
        this.etiquetaHabilitadas.setFont(new Font("Segoe UI", 1, 14));
        this.etiquetaDeshabilitadas = new JLabel(MonitorDePID.idioma.verificacionesDeshabilitadas());
        this.etiquetaDeshabilitadas.setFont(new Font("Segoe UI", 1, 14));
        JScrollPane scrollHabilitadas = new JScrollPane(this.tablaHabilitadas);
        scrollHabilitadas.setPreferredSize(new Dimension(520, 230));
        JScrollPane scrollDeshabilitadas = new JScrollPane(this.tablaDeshabilitadas);
        scrollDeshabilitadas.setPreferredSize(new Dimension(520, 170));
        JPanel panelBotonesMovimiento = new JPanel(new FlowLayout(1, 8, 0));
        panelBotonesMovimiento.setOpaque(false);
        this.botonMoverIzquierda = new JButton("<<");
        this.botonMoverDerecha = new JButton(">>");
        panelBotonesMovimiento.add(this.botonMoverIzquierda);
        panelBotonesMovimiento.add(this.botonMoverDerecha);
        this.botonDeshabilitarNoCorporativas = new JButton(MonitorDePID.idioma.deshabilitarNoCorporativas());
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.8;
        gbc.gridy = 0;
        gbc.weighty = 0.0;
        this.panelPrincipal.add((Component)this.etiquetaHabilitadas, gbc);
        gbc.gridy = 1;
        gbc.weighty = 0.45;
        this.panelPrincipal.add((Component)scrollHabilitadas, gbc);
        gbc.gridy = 2;
        gbc.weighty = 0.0;
        this.panelPrincipal.add((Component)panelBotonesMovimiento, gbc);
        gbc.gridy = 3;
        gbc.weighty = 0.0;
        this.panelPrincipal.add((Component)this.etiquetaDeshabilitadas, gbc);
        gbc.gridy = 4;
        gbc.weighty = 0.35;
        this.panelPrincipal.add((Component)scrollDeshabilitadas, gbc);
        gbc.gridy = 5;
        gbc.weighty = 0.0;
        this.panelPrincipal.add((Component)this.botonDeshabilitarNoCorporativas, gbc);
        this.getContentPane().add((Component)this.panelPrincipal, "Center");
        this.cargarDatos();
        this.agregarListeners();
        this.recargarApariencia();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void cargarImagen() {
        try {
            if (imagen.exists()) {
                ImageIcon icon = new ImageIcon(imagen.getAbsolutePath());
                Image img = icon.getImage();
                int newWidth = 160;
                int newHeight = (int)((double)img.getHeight(null) / (double)img.getWidth(null) * (double)newWidth);
                img = img.getScaledInstance(newWidth, newHeight, 4);
                this.imagenLabel.setIcon(new ImageIcon(img));
            } else {
                this.imagenLabel.setText(MonitorDePID.idioma.imagenNoEncontrada());
            }
        }
        catch (Exception e) {
            this.imagenLabel.setText(MonitorDePID.idioma.errorCargandoImagen());
        }
    }

    private void configurarTabla(final JTable tabla) {
        tabla.setRowHeight(26);
        tabla.setSelectionMode(0);
        tabla.setFillsViewportHeight(true);
        TableColumnModel cols = tabla.getColumnModel();
        cols.getColumn(0).setPreferredWidth(120);
        cols.getColumn(1).setPreferredWidth(260);
        cols.getColumn(2).setPreferredWidth(90);
        cols.getColumn(3).setPreferredWidth(110);
        tabla.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = new JLabel(value != null ? value.toString() : "");
                lbl.setOpaque(true);
                lbl.setHorizontalAlignment(0);
                String id = table.getValueAt(row, 0).toString();
                Verificaciones ver = DeshabilitarVerificacionesAmaneKanata.this.obtenerVerificacionPorId(id);
                if (isSelected) {
                    lbl.setBackground(DeshabilitarVerificacionesAmaneKanata.this.colorBoton.obtener());
                    lbl.setForeground(Color.WHITE);
                } else if (ver != null && DeshablicarVerificaciones.recomendadoParaCorperata(ver)) {
                    lbl.setBackground(DeshabilitarVerificacionesAmaneKanata.this.colorVerificacionCorporativa.obtener());
                    lbl.setForeground(Color.WHITE);
                } else {
                    lbl.setBackground(DeshabilitarVerificacionesAmaneKanata.this.colorCajaTexto.obtener());
                    lbl.setForeground(DeshabilitarVerificacionesAmaneKanata.this.colorTexto.obtener());
                }
                return lbl;
            }
        });
        tabla.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String url;
                int fila = tabla.rowAtPoint(e.getPoint());
                int col = tabla.columnAtPoint(e.getPoint());
                if (fila < 0 || col < 0) {
                    return;
                }
                if (col != 2 && col != 3) {
                    return;
                }
                String id = tabla.getValueAt(fila, 0).toString();
                Verificaciones ver = DeshabilitarVerificacionesAmaneKanata.this.obtenerVerificacionPorId(id);
                if (ver == null) {
                    return;
                }
                String string = url = col == 2 ? DeshablicarVerificaciones.enlaceACodigo(ver) : DeshablicarVerificaciones.enlaceDocs(ver);
                if (url != null && !url.isEmpty()) {
                    DeshabilitarVerificacionesAmaneKanata.this.abrirURL(url);
                }
            }
        });
    }

    private void cargarDatos() {
        HashSet<Verificaciones> todasVerificaciones = DeshabilitarVerificacionesAmaneKanata.verificaciones();
        List<String> verificacionesDeshabilitadas = DeshabilitarVerificacionesAmaneKanata.configValor();
        this.modeloHabilitadas.setRowCount(0);
        this.modeloDeshabilitadas.setRowCount(0);
        for (Verificaciones ver : todasVerificaciones) {
            Object[] rowData = new Object[]{DeshabilitarVerificacionesAmaneKanata.id(ver), DeshabilitarVerificacionesAmaneKanata.nombre(ver), DeshabilitarVerificacionesAmaneKanata.enlaceACodigo(ver) != null ? MonitorDePID.idioma.verCodigo() : "", DeshabilitarVerificacionesAmaneKanata.enlaceDocs(ver) != null ? MonitorDePID.idioma.verDocumentacion() : ""};
            if (verificacionesDeshabilitadas.contains(DeshabilitarVerificacionesAmaneKanata.id(ver))) {
                this.modeloDeshabilitadas.addRow(rowData);
                continue;
            }
            this.modeloHabilitadas.addRow(rowData);
        }
    }

    private void agregarListeners() {
        this.botonMoverDerecha.addActionListener(e -> {
            int filaSeleccionada = this.tablaHabilitadas.getSelectedRow();
            if (filaSeleccionada >= 0) {
                Object[] fila = new Object[4];
                for (int i = 0; i < 4; ++i) {
                    fila[i] = this.modeloHabilitadas.getValueAt(filaSeleccionada, i);
                }
                this.modeloDeshabilitadas.addRow(fila);
                this.modeloHabilitadas.removeRow(filaSeleccionada);
                this.actualizarConfiguracion();
            } else {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.seleccionaVerificacionDeshabilitar(), MonitorDePID.idioma.informacion(), 1);
            }
        });
        this.botonMoverIzquierda.addActionListener(e -> {
            int filaSeleccionada = this.tablaDeshabilitadas.getSelectedRow();
            if (filaSeleccionada >= 0) {
                Object[] fila = new Object[4];
                for (int i = 0; i < 4; ++i) {
                    fila[i] = this.modeloDeshabilitadas.getValueAt(filaSeleccionada, i);
                }
                this.modeloHabilitadas.addRow(fila);
                this.modeloDeshabilitadas.removeRow(filaSeleccionada);
                this.actualizarConfiguracion();
            } else {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.seleccionaVerificacionHabilitar(), MonitorDePID.idioma.informacion(), 1);
            }
        });
        this.botonDeshabilitarNoCorporativas.addActionListener(e -> {
            int count = 0;
            for (int i = this.modeloHabilitadas.getRowCount() - 1; i >= 0; --i) {
                String id = (String)this.modeloHabilitadas.getValueAt(i, 0);
                Verificaciones ver = this.obtenerVerificacionPorId(id);
                if (ver == null || DeshabilitarVerificacionesAmaneKanata.recomendadoParaCorperata(ver)) continue;
                Object[] fila = new Object[4];
                for (int j = 0; j < 4; ++j) {
                    fila[j] = this.modeloHabilitadas.getValueAt(i, j);
                }
                this.modeloDeshabilitadas.addRow(fila);
                this.modeloHabilitadas.removeRow(i);
                ++count;
            }
            if (count > 0) {
                JOptionPane.showMessageDialog(this, String.format(MonitorDePID.idioma.verificacionesNoCorporativasDeshabilitadas(), count), MonitorDePID.idioma.operacionCompletada(), 1);
                this.actualizarConfiguracion();
            } else {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.noVerificacionesNoCorporativas(), MonitorDePID.idioma.informacion(), 1);
            }
        });
    }

    private void actualizarConfiguracion() {
        ArrayList<String> idsDeshabilitadas = new ArrayList<String>();
        for (int i = 0; i < this.modeloDeshabilitadas.getRowCount(); ++i) {
            idsDeshabilitadas.add((String)this.modeloDeshabilitadas.getValueAt(i, 0));
        }
        DeshabilitarVerificacionesAmaneKanata.escribirConfig(idsDeshabilitadas);
    }

    private Verificaciones obtenerVerificacionPorId(String id) {
        for (Verificaciones ver : DeshabilitarVerificacionesAmaneKanata.verificaciones()) {
            if (!DeshabilitarVerificacionesAmaneKanata.id(ver).equals(id)) continue;
            return ver;
        }
        return null;
    }

    @Override
    public void recargarApariencia() {
        this.getContentPane().setBackground(this.colorFondoVentana.obtener());
        this.panelPrincipal.setBackground(this.colorFondoVentana.obtener());
        this.etiquetaHabilitadas.setForeground(this.colorTexto.obtener());
        this.etiquetaDeshabilitadas.setForeground(this.colorTexto.obtener());
        this.etiquetaMensajeAmaneKanata.setForeground(this.colorTexto.obtener());
        this.tablaHabilitadas.setBackground(this.colorCajaTexto.obtener());
        this.tablaHabilitadas.setForeground(this.colorTexto.obtener());
        this.tablaHabilitadas.setGridColor(this.colorBordePanel.obtener());
        this.tablaDeshabilitadas.setBackground(this.colorCajaTexto.obtener());
        this.tablaDeshabilitadas.setForeground(this.colorTexto.obtener());
        this.tablaDeshabilitadas.setGridColor(this.colorBordePanel.obtener());
        this.estilizarBoton(this.botonMoverDerecha);
        this.estilizarBoton(this.botonMoverIzquierda);
        this.estilizarBoton(this.botonDeshabilitarNoCorporativas);
        this.revalidate();
        this.repaint();
    }

    private void estilizarBoton(JButton btn) {
        if (!CrashDetectorGUI.esMac()) {
            btn.setBackground(this.colorBoton.obtener());
            btn.setForeground(Color.WHITE);
            btn.setFocusPainted(false);
            btn.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        } else {
            btn.setContentAreaFilled(false);
        }
        btn.setFont(new Font("Segoe UI", 0, 14));
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorFondoVentana.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoVentana());
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        this.colorCajaTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorCajaTexto());
        this.colorBordePanel.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
        this.colorVerificacionCorporativa.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorVerificacionCorporativa());
        elementos.add(this.colorFondoVentana);
        elementos.add(this.colorTexto);
        elementos.add(this.colorBoton);
        elementos.add(this.colorCajaTexto);
        elementos.add(this.colorBordePanel);
        elementos.add(this.colorVerificacionCorporativa);
        return elementos;
    }
}

