/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.editor;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.Criticalidad;
import com.asbestosstar.crashdetector.analizador.firmas.CargadorDeCodice;
import com.asbestosstar.crashdetector.analizador.firmas.FiltrodeCodice;
import com.asbestosstar.crashdetector.analizador.firmas.v0.FirmasV0;
import com.asbestosstar.crashdetector.analizador.firmas.v0.VerificacionFirmasV0;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.idioma.cumplimiento.ActaDeProteccionDelIdiomaCulturalDePyongyang;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public abstract class EditorFirmasGUI
extends JFrame
implements BotonDeBarraLateralDerecha {
    public static Map<String, Supplier<EditorFirmasGUI>> GUIS = new HashMap<String, Supplier<EditorFirmasGUI>>();
    public JTextField fId;
    public JTextField fParaBuscar;
    public JComboBox<String> cbFiltro;
    public JComboBox<String> cbCriticalidad;
    public JSpinner spPrioridad;
    public JButton btnElegirFiltro;
    public JTextArea vistaJson;
    public ConfigColor rosaFondo;
    public ConfigColor rosaSuave;
    public ConfigColor moradoAcento;
    public ConfigColor textoOscuro;
    public ConfigColor bordeSuave;
    public ConfigColor fondoCampo;
    public ConfigColor textoCampo;
    public DefaultListModel<VerificacionFirmasV0> modeloLista = new DefaultListModel();
    public JList<VerificacionFirmasV0> lista;
    public final Map<String, JTextField[]> camposIdiomas = new LinkedHashMap<String, JTextField[]>();
    public final Map<String, ImageIcon> iconos = new LinkedHashMap<String, ImageIcon>();
    public JLabel etiquetaIronmouse;
    public JButton btnNuevo;
    public JButton btnActualizar;
    public JButton btnEliminar;
    public JButton btnExportar;
    public JButton btnGuardar;
    public final Path rutaCodice = Statics.carpeta.resolve("firmas.json");
    public VerificacionFirmasV0 verificacionCargadaEnFormulario = null;

    @Override
    public TipoGUI<EditorFirmasGUI> tipo() {
        return TipoGUI.EDITOR_FIRMAS;
    }

    public void aplicarEstilos() {
        this.getContentPane().setBackground(this.rosaFondo.obtener());
        this.setLayout(new BorderLayout(10, 10));
        this.cargarIconos();
        this.add((Component)this.crearEncabezado(), "North");
        this.add((Component)this.crearSplit(), "Center");
        this.asegurarArchivo();
        this.recargarDesdeDisco();
        this.actualizarVistaJson();
    }

    @Override
    public void init() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (EditorFirmasGUI.this.hayCambiosNoGuardados()) {
                    int resp = JOptionPane.showConfirmDialog(EditorFirmasGUI.this, MonitorDePID.idioma.guardarAntesDeSalir(), MonitorDePID.idioma.salirSinGuardar(), 1, 2);
                    if (resp == 0) {
                        EditorFirmasGUI.this.guardarTodo();
                        EditorFirmasGUI.this.dispose();
                    } else if (resp == 1) {
                        EditorFirmasGUI.this.dispose();
                    }
                } else {
                    EditorFirmasGUI.this.dispose();
                }
            }
        });
        this.setSize(1120, 740);
        this.setLocationRelativeTo(null);
    }

    public JPanel crearEncabezado() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBackground(this.rosaFondo.obtener());
        p.setBorder(BorderFactory.createEmptyBorder(8, 12, 0, 12));
        JLabel titulo = new JLabel(MonitorDePID.idioma.tituloEditorCodice());
        titulo.setFont(new Font("Segoe UI", 1, 20));
        titulo.setForeground(this.moradoAcento.obtener());
        p.add(titulo);
        JPanel descRow = new JPanel();
        descRow.setLayout(new BoxLayout(descRow, 0));
        descRow.setOpaque(false);
        descRow.setAlignmentX(0.0f);
        String descText = "<html><body style='width: 600px;'>" + MonitorDePID.idioma.descripcionEditorCodice() + "</body></html>";
        JLabel descripcion = new JLabel(descText);
        descripcion.setFont(new Font("Segoe UI", 0, 13));
        descripcion.setForeground(this.textoOscuro.obtener());
        descripcion.setAlignmentY(0.5f);
        descRow.add(descripcion);
        descRow.add(Box.createHorizontalStrut(20));
        this.etiquetaIronmouse = this.cargarImagen("imagenes/ironmouse.png", 240, 130);
        if (this.etiquetaIronmouse != null) {
            JPanel imgPanel = new JPanel(new BorderLayout());
            imgPanel.setOpaque(false);
            imgPanel.add((Component)this.etiquetaIronmouse, "Center");
            imgPanel.setAlignmentY(0.5f);
            descRow.add(imgPanel);
        }
        p.add(descRow);
        return p;
    }

    public JSplitPane crearSplit() {
        JSplitPane split = new JSplitPane(1, this.crearPanelIzquierdoCentro(), this.crearPanelDerecho());
        split.setDividerLocation(720);
        split.setResizeWeight(0.72);
        split.setBorder(BorderFactory.createEmptyBorder());
        return split;
    }

    public Component crearPanelIzquierdoCentro() {
        JPanel cont = new JPanel(new BorderLayout(10, 10));
        cont.setBackground(this.rosaFondo.obtener());
        cont.setBorder(BorderFactory.createEmptyBorder(8, 12, 12, 6));
        this.lista = new JList<VerificacionFirmasV0>(this.modeloLista);
        this.lista.setSelectionMode(0);
        this.lista.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
            JLabel l = new JLabel(value.id + " \u00b7 " + this.nz(value.nombre_es));
            l.setOpaque(true);
            l.setForeground(isSelected ? Color.WHITE : this.textoOscuro.obtener());
            l.setBackground(isSelected ? this.moradoAcento.obtener() : Color.WHITE);
            l.setFont(new Font("Segoe UI", 0, 13));
            l.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
            return l;
        });
        this.lista.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            VerificacionFirmasV0 nuevaSeleccion = this.lista.getSelectedValue();
            if (this.verificacionCargadaEnFormulario != null && this.esFormularioModificado()) {
                int respuesta = JOptionPane.showConfirmDialog(this, MonitorDePID.idioma.descartarCambios(), MonitorDePID.idioma.confirmacion(), 0, 3);
                if (respuesta == 0) {
                    if (nuevaSeleccion != null) {
                        this.cargarEnFormulario(nuevaSeleccion);
                    } else {
                        this.verificacionCargadaEnFormulario = null;
                    }
                } else {
                    this.lista.setSelectedValue(this.verificacionCargadaEnFormulario, true);
                }
            } else if (nuevaSeleccion != null) {
                this.cargarEnFormulario(nuevaSeleccion);
            } else {
                this.verificacionCargadaEnFormulario = null;
            }
        });
        JScrollPane spLista = new JScrollPane(this.lista);
        spLista.setPreferredSize(new Dimension(260, 520));
        spLista.setBorder(this.titulo("lista", MonitorDePID.idioma.lista()));
        cont.add((Component)spLista, "West");
        JPanel formulario = this.crearFormularioSinPestanas();
        cont.add((Component)formulario, "Center");
        JPanel barra = new JPanel();
        barra.setBackground(this.rosaFondo.obtener());
        barra.setLayout(new BoxLayout(barra, 0));
        this.btnNuevo = this.boton(MonitorDePID.idioma.nuevo(), this::limpiarFormulario);
        this.btnActualizar = this.boton(MonitorDePID.idioma.actualizarSeleccionado(), this::actualizarSeleccionado);
        this.btnEliminar = this.boton(MonitorDePID.idioma.eliminarSeleccionado(), this::eliminarSeleccionado);
        this.btnExportar = this.boton(MonitorDePID.idioma.exportarJSON(), this::exportarArchivo);
        this.btnGuardar = this.boton(MonitorDePID.idioma.guardarTodo(), this::guardarTodo);
        barra.add(this.btnNuevo);
        barra.add(Box.createHorizontalStrut(8));
        barra.add(this.btnActualizar);
        barra.add(Box.createHorizontalStrut(8));
        barra.add(this.btnEliminar);
        barra.add(Box.createHorizontalGlue());
        barra.add(this.btnExportar);
        barra.add(Box.createHorizontalStrut(8));
        barra.add(this.btnGuardar);
        cont.add((Component)barra, "South");
        return cont;
    }

    public JPanel crearFormularioSinPestanas() {
        JPanel form = new JPanel(new BorderLayout(8, 8));
        form.setBackground(this.rosaFondo.obtener());
        JPanel general = new JPanel(new GridBagLayout());
        general.setOpaque(true);
        general.setBackground(this.fondoCampo.obtener());
        general.setBorder(this.titulo("general", MonitorDePID.idioma.general()));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(6, 8, 6, 8);
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        this.fId = this.campo(general, c, MonitorDePID.idioma.id());
        this.fParaBuscar = this.campo(general, c, MonitorDePID.idioma.paraBuscar());
        this.etiqueta(general, c, MonitorDePID.idioma.filtro());
        GridBagConstraints c2 = (GridBagConstraints)c.clone();
        c2.gridx = 1;
        c2.weightx = 1.0;
        this.cbFiltro = new JComboBox();
        this.cbFiltro.addItem("");
        ArrayList<String> ids = new ArrayList<String>(FiltrodeCodice.filtros.keySet());
        ids.sort(String::compareToIgnoreCase);
        for (String id : ids) {
            this.cbFiltro.addItem(id);
        }
        this.estilizarCampo(this.cbFiltro);
        general.add(this.cbFiltro, c2);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.etiqueta(general, c, MonitorDePID.idioma.criticalidad());
        c2 = (GridBagConstraints)c.clone();
        c2.gridx = 1;
        c2.weightx = 1.0;
        this.cbCriticalidad = new JComboBox();
        this.cbCriticalidad.addItem(Criticalidad.ADVERTENCIA.nombre);
        this.cbCriticalidad.addItem(Criticalidad.ERROR.nombre);
        this.cbCriticalidad.addItem(Criticalidad.FATAL.nombre);
        this.estilizarCampo(this.cbCriticalidad);
        general.add(this.cbCriticalidad, c2);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.etiqueta(general, c, MonitorDePID.idioma.prioridad());
        c2 = (GridBagConstraints)c.clone();
        c2.gridx = 1;
        c2.weightx = 1.0;
        this.spPrioridad = new JSpinner(new SpinnerNumberModel(0, -1000, 1000, 1));
        this.estilizarCampo(this.spPrioridad);
        general.add((Component)this.spPrioridad, c2);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        form.add((Component)general, "North");
        JPanel idiomas = new JPanel(new BorderLayout());
        idiomas.setOpaque(false);
        JPanel cab = new JPanel(new GridLayout(1, 3, 8, 8));
        cab.setBackground(this.rosaFondo.obtener());
        cab.add(this.celdaCabecera(MonitorDePID.idioma.colIdioma()));
        cab.add(this.celdaCabecera(MonitorDePID.idioma.colNombre()));
        cab.add(this.celdaCabecera(MonitorDePID.idioma.colResultado()));
        idiomas.add((Component)cab, "North");
        JPanel grid = new JPanel(new GridLayout(10, 3, 8, 8));
        grid.setBackground(this.fondoCampo.obtener());
        grid.setBorder(this.bordeSuave());
        String[][] langs = new String[][]{{"es", "bandera_mexico.png", "Espa\u00f1ol"}, {"en", "bandera_inglaterra.png", "English"}, {"ar", "bandera_arabia.png", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629"}, {"pt", "bandera_brasil.png", "Portugu\u00eas"}, {"fa", "bandera_iran.png", "\u0641\u0627\u0631\u0633\u06cc"}, {"ru", "bandera_rusia.png", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439"}, {"zh", "bandera_china.png", "\u4e2d\u6587"}, {"eo", "bandera_esperanto.png", "Esperanto"}, {"jp", "bandera_japon.png", "\u65e5\u672c\u8a9e"}, {"kp", "bandera_corea.png", "\ud55c\uad6d\uc5b4"}};
        this.camposIdiomas.clear();
        for (String[] info : langs) {
            grid.add(this.celdaIdioma(info[2], info[1]));
            JTextField tNombre = new JTextField();
            this.estilizarCampo(tNombre);
            grid.add(tNombre);
            JTextField tResultado = new JTextField();
            this.estilizarCampo(tResultado);
            grid.add(tResultado);
            this.camposIdiomas.put(info[0], new JTextField[]{tNombre, tResultado});
        }
        idiomas.add((Component)grid, "Center");
        JScrollPane spIdiomas = new JScrollPane(idiomas);
        spIdiomas.setBorder(this.titulo("idiomas", MonitorDePID.idioma.idiomas()));
        form.add((Component)spIdiomas, "Center");
        return form;
    }

    public JPanel crearPanelDerecho() {
        JPanel p = new JPanel(new BorderLayout());
        p.setBackground(this.rosaFondo.obtener());
        p.setBorder(BorderFactory.createEmptyBorder(8, 6, 12, 12));
        this.vistaJson = new JTextArea();
        this.vistaJson.setEditable(false);
        this.vistaJson.setFont(new Font("Consolas", 0, 12));
        this.vistaJson.setForeground(this.textoOscuro.obtener());
        this.vistaJson.setBackground(this.fondoCampo.obtener());
        JScrollPane sp = new JScrollPane(this.vistaJson);
        sp.setBorder(this.titulo("vistaJson", MonitorDePID.idioma.vistaJson()));
        p.add((Component)sp, "Center");
        return p;
    }

    public JLabel cargarImagen(String relativa, int w, int h) {
        File f = Statics.carpeta.resolve(relativa).toFile();
        if (!f.exists()) {
            return null;
        }
        ImageIcon ic = new ImageIcon(f.getAbsolutePath());
        if (ic.getIconWidth() <= 0) {
            return null;
        }
        Image esc = ic.getImage().getScaledInstance(w, h, 4);
        return new JLabel(new ImageIcon(esc));
    }

    public void cargarIconos() {
        String[] archivos;
        for (String a : archivos = new String[]{"bandera_mexico.png", "bandera_inglaterra.png", "bandera_arabia.png", "bandera_brasil.png", "bandera_iran.png", "bandera_rusia.png", "bandera_china.png", "bandera_esperanto.png", "bandera_japon.png", "bandera_corea.png", "ironmouse.png"}) {
            File f = Statics.carpeta.resolve("imagenes").resolve(a).toFile();
            if (!f.exists()) continue;
            this.iconos.put(a, new ImageIcon(f.getAbsolutePath()));
        }
    }

    public JPanel celdaIdioma(String etiqueta, String archivoBandera) {
        JPanel p = new JPanel(new BorderLayout());
        p.setOpaque(false);
        JLabel l = new JLabel(etiqueta);
        l.setFont(new Font("Segoe UI", 1, 12));
        l.setForeground(this.moradoAcento.obtener());
        ImageIcon ic = this.iconos.get(archivoBandera);
        if (ic != null && ic.getIconWidth() > 0) {
            Image mini = ic.getImage().getScaledInstance(28, 18, 4);
            l.setIcon(new ImageIcon(mini));
            l.setIconTextGap(8);
        }
        p.add((Component)l, "West");
        return p;
    }

    public Component celdaCabecera(String titulo) {
        JLabel l = new JLabel(titulo);
        l.setFont(new Font("Segoe UI", 1, 12));
        l.setForeground(this.textoOscuro.obtener());
        l.setOpaque(false);
        return l;
    }

    public JTextField campo(JPanel p, GridBagConstraints base, String etiqueta) {
        this.etiqueta(p, base, etiqueta);
        GridBagConstraints c2 = (GridBagConstraints)base.clone();
        c2.gridx = 1;
        c2.weightx = 1.0;
        JTextField t = new JTextField();
        this.estilizarCampo(t);
        p.add((Component)t, c2);
        ++base.gridy;
        base.gridx = 0;
        base.weightx = 0.0;
        return t;
    }

    public void etiqueta(JPanel p, GridBagConstraints c, String txt) {
        JLabel l = new JLabel(txt);
        l.setFont(new Font("Segoe UI", 0, 12));
        l.setForeground(this.textoOscuro.obtener());
        p.add((Component)l, c);
    }

    public void estilizarCampo(Component comp) {
        comp.setFont(new Font("Segoe UI", 0, 12));
        if (comp instanceof JTextField) {
            ((JTextField)comp).setBackground(this.fondoCampo.obtener());
        }
        if (comp instanceof JComboBox) {
            ((JComboBox)comp).setBackground(this.fondoCampo.obtener());
        }
    }

    public JButton boton(String texto, Runnable r) {
        JButton b = new JButton(texto);
        b.setBackground(this.rosaSuave.obtener());
        b.setForeground(this.textoOscuro.obtener());
        b.setFocusPainted(false);
        b.setFont(new Font("Segoe UI", 1, 12));
        b.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.bordeSuave.obtener()), BorderFactory.createEmptyBorder(6, 12, 6, 12)));
        b.addActionListener(e -> r.run());
        return b;
    }

    public TitledBorder titulo(String key, String defecto) {
        TitledBorder t = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.bordeSuave.obtener()), defecto);
        t.setTitleColor(this.moradoAcento.obtener());
        t.setTitleFont(new Font("Segoe UI", 1, 12));
        return t;
    }

    public Border bordeSuave() {
        return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.bordeSuave.obtener()), BorderFactory.createEmptyBorder(8, 8, 8, 8));
    }

    public void asegurarArchivo() {
        try {
            if (!Files.exists(Statics.carpeta, new LinkOption[0])) {
                Files.createDirectories(Statics.carpeta, new FileAttribute[0]);
            }
            if (!Files.exists(this.rutaCodice, new LinkOption[0])) {
                String base = "{ \"schema\": 0, \"verificaciones\": [] }";
                Files.write(this.rutaCodice, base.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error creando codice.json: " + ex.getMessage(), "Error", 0);
        }
    }

    public void recargarDesdeDisco() {
        this.modeloLista.clear();
        List<VerificacionFirmasV0> datos = CargadorDeCodice.cargarVerificaciones();
        datos.sort(new Comparator<VerificacionFirmasV0>(){

            @Override
            public int compare(VerificacionFirmasV0 a, VerificacionFirmasV0 b) {
                int cmp = Integer.compare(b.prioridad, a.prioridad);
                return cmp != 0 ? cmp : EditorFirmasGUI.this.nz(a.id).compareToIgnoreCase(EditorFirmasGUI.this.nz(b.id));
            }
        });
        for (VerificacionFirmasV0 v : datos) {
            this.modeloLista.addElement(v);
        }
        if (!datos.isEmpty()) {
            this.lista.setSelectedIndex(0);
        }
    }

    public void cargarEnFormulario(VerificacionFirmasV0 v) {
        this.fId.setText(this.nz(v.id));
        this.fParaBuscar.setText(this.nz(v.para_buscar));
        if (v.filtro != null) {
            this.cbFiltro.setSelectedItem(v.filtro.id);
        } else {
            this.cbFiltro.setSelectedIndex(0);
        }
        if (v.criticalidad != null) {
            this.cbCriticalidad.setSelectedItem(v.criticalidad.nombre);
        } else {
            this.cbCriticalidad.setSelectedItem(Criticalidad.ADVERTENCIA.nombre);
        }
        this.spPrioridad.setValue(v.prioridad);
        this.establecerIdioma("es", v.nombre_es, v.resultado_es);
        this.establecerIdioma("en", v.nombre_en, v.resultado_en);
        this.establecerIdioma("ar", v.nombre_ar, v.resultado_ar);
        this.establecerIdioma("pt", v.nombre_pt, v.resultado_pt);
        this.establecerIdioma("fa", v.nombre_fa, v.resultado_fa);
        this.establecerIdioma("ru", v.nombre_ru, v.resultado_ru);
        this.establecerIdioma("zh", v.nombre_zh, v.resultado_zh);
        this.establecerIdioma("eo", v.nombre_eo, v.resultado_eo);
        this.establecerIdioma("jp", v.nombre_jp, v.resultado_jp);
        this.establecerIdioma("kp", v.nombre_kp, v.resultado_kp);
        this.actualizarVistaJson();
        this.verificacionCargadaEnFormulario = v;
    }

    public boolean esFormularioModificado() {
        if (this.verificacionCargadaEnFormulario == null) {
            return !this.isEmpty(this.fId.getText()) || !this.isEmpty(this.fParaBuscar.getText()) || this.cbFiltro.getSelectedIndex() != 0 || !Objects.equals(this.cbCriticalidad.getSelectedItem(), Criticalidad.ADVERTENCIA.nombre) || (Integer)this.spPrioridad.getValue() != 0 || this.camposIdiomas.values().stream().anyMatch(arr -> !this.isEmpty(arr[0].getText()) || !this.isEmpty(arr[1].getText()));
        }
        VerificacionFirmasV0 actual = this.verificacionCargadaEnFormulario;
        return !this.fId.getText().trim().equals(actual.id) || !this.fParaBuscar.getText().trim().equals(actual.para_buscar) || !Objects.equals(this.cbFiltro.getSelectedItem(), actual.filtro != null ? actual.filtro.id : "") || !Objects.equals(this.cbCriticalidad.getSelectedItem(), actual.criticalidad != null ? actual.criticalidad.nombre : Criticalidad.ADVERTENCIA.nombre) || (Integer)this.spPrioridad.getValue() != actual.prioridad || !this.val("es", 0).equals(actual.nombre_es) || !this.val("es", 1).equals(actual.resultado_es) || !this.val("en", 0).equals(actual.nombre_en) || !this.val("en", 1).equals(actual.resultado_en) || !this.val("ar", 0).equals(actual.nombre_ar) || !this.val("ar", 1).equals(actual.resultado_ar) || !this.val("pt", 0).equals(actual.nombre_pt) || !this.val("pt", 1).equals(actual.resultado_pt) || !this.val("fa", 0).equals(actual.nombre_fa) || !this.val("fa", 1).equals(actual.resultado_fa) || !this.val("ru", 0).equals(actual.nombre_ru) || !this.val("ru", 1).equals(actual.resultado_ru) || !this.val("zh", 0).equals(actual.nombre_zh) || !this.val("zh", 1).equals(actual.resultado_zh) || !this.val("eo", 0).equals(actual.nombre_eo) || !this.val("eo", 1).equals(actual.resultado_eo) || !this.val("jp", 0).equals(actual.nombre_jp) || !this.val("jp", 1).equals(actual.resultado_jp) || !this.val("kp", 0).equals(actual.nombre_kp) || !this.val("kp", 1).equals(actual.resultado_kp);
    }

    public void establecerIdioma(String code, String nombre, String resultado) {
        JTextField[] arr = this.camposIdiomas.get(code);
        if (arr != null) {
            arr[0].setText(this.nz(nombre));
            arr[1].setText(this.nz(resultado));
        }
    }

    public void limpiarFormulario() {
        if (!this.confirmarDescartarCambios()) {
            if (this.verificacionCargadaEnFormulario != null) {
                this.lista.setSelectedValue(this.verificacionCargadaEnFormulario, true);
            }
            return;
        }
        this.lista.clearSelection();
        this.fId.setText("");
        this.fParaBuscar.setText("");
        this.cbFiltro.setSelectedIndex(0);
        this.cbCriticalidad.setSelectedItem(Criticalidad.ADVERTENCIA.nombre);
        this.spPrioridad.setValue(0);
        for (JTextField[] arr : this.camposIdiomas.values()) {
            arr[0].setText("");
            arr[1].setText("");
        }
        this.verificacionCargadaEnFormulario = null;
        this.actualizarVistaJson();
    }

    public void elegirFiltro() {
    }

    public boolean validarFormulario() {
        if (this.vacio(this.fId) || this.vacio(this.fParaBuscar)) {
            JOptionPane.showMessageDialog(this, MonitorDePID.idioma.faltanCampos(), "Validaci\u00f3n", 2);
            return false;
        }
        if (this.cbFiltro.getSelectedItem() == null || "".equals(this.cbFiltro.getSelectedItem())) {
            JOptionPane.showMessageDialog(this, MonitorDePID.idioma.filtroNoExiste(), "Validaci\u00f3n", 2);
            return false;
        }
        if (this.cbCriticalidad.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, MonitorDePID.idioma.critInvalida(), "Validaci\u00f3n", 2);
            return false;
        }
        String idFiltro = (String)this.cbFiltro.getSelectedItem();
        if (FiltrodeCodice.filtros.get(idFiltro) == null) {
            JOptionPane.showMessageDialog(this, MonitorDePID.idioma.filtroNoExiste(), "Validaci\u00f3n", 2);
            return false;
        }
        for (Map.Entry<String, JTextField[]> e : this.camposIdiomas.entrySet()) {
            if (!this.vacio(e.getValue()[0]) && !this.vacio(e.getValue()[1])) continue;
            JOptionPane.showMessageDialog(this, MonitorDePID.idioma.faltanIdiomas() + " " + e.getKey(), "Validaci\u00f3n", 2);
            return false;
        }
        return true;
    }

    public VerificacionFirmasV0 construirDesdeFormulario() {
        String id = this.fId.getText().trim();
        String paraBuscar = this.fParaBuscar.getText().trim();
        String idFiltro = (String)this.cbFiltro.getSelectedItem();
        FiltrodeCodice filtro = FiltrodeCodice.filtros.get(idFiltro);
        String critLocalizado = (String)this.cbCriticalidad.getSelectedItem();
        Criticalidad criticalidad = critLocalizado.equals(Criticalidad.ERROR.nombre) ? Criticalidad.ERROR : (critLocalizado.equals(Criticalidad.FATAL.nombre) ? Criticalidad.FATAL : Criticalidad.ADVERTENCIA);
        int prio = ((Number)this.spPrioridad.getValue()).intValue();
        return new VerificacionFirmasV0(id, this.val("ar", 0), this.val("ar", 1), this.val("zh", 0), this.val("zh", 1), this.val("kp", 0), this.val("kp", 1), this.val("es", 0), this.val("es", 1), this.val("eo", 0), this.val("eo", 1), this.val("en", 0), this.val("en", 1), this.val("jp", 0), this.val("jp", 1), this.val("fa", 0), this.val("fa", 1), this.val("pt", 0), this.val("pt", 1), this.val("ru", 0), this.val("ru", 1), criticalidad, prio, paraBuscar, filtro);
    }

    public String val(String lang, int idx) {
        JTextField[] arr = this.camposIdiomas.get(lang);
        return arr == null ? "" : this.nz(arr[idx].getText());
    }

    public void actualizarSeleccionado() {
        if (!this.validarFormulario()) {
            return;
        }
        VerificacionFirmasV0 nuevo = this.construirDesdeFormulario();
        int idx = this.lista.getSelectedIndex();
        if (idx >= 0) {
            this.modeloLista.set(idx, nuevo);
            this.lista.setSelectedIndex(idx);
        } else {
            this.modeloLista.addElement(nuevo);
            this.lista.setSelectedIndex(this.modeloLista.size() - 1);
        }
        this.actualizarVistaJson();
    }

    public void eliminarSeleccionado() {
        int respuesta;
        if (this.lista.getSelectedValue() == null) {
            return;
        }
        if (this.esFormularioModificado() && (respuesta = JOptionPane.showConfirmDialog(this, MonitorDePID.idioma.descartarCambios(), MonitorDePID.idioma.confirmacion(), 0, 3)) != 0) {
            return;
        }
        int idx = this.lista.getSelectedIndex();
        this.modeloLista.remove(idx);
        this.verificacionCargadaEnFormulario = null;
        if (this.modeloLista.isEmpty()) {
            this.limpiarFormulario();
        } else {
            int nuevoIdx = Math.min(idx, this.modeloLista.size() - 1);
            this.lista.setSelectedIndex(nuevoIdx);
        }
        this.actualizarVistaJson();
    }

    public void guardarTodo() {
        try {
            int i;
            for (i = 0; i < this.modeloLista.size(); ++i) {
                if (this.validarVerificacion(this.modeloLista.get(i))) continue;
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.verificacionInvalida(), "Validaci\u00f3n", 2);
                return;
            }
            for (i = 0; i < this.modeloLista.size(); ++i) {
                String nombreCoreano;
                VerificacionFirmasV0 v = this.modeloLista.get(i);
                String textoCoreano = v.resultado_kp;
                if (textoCoreano != null && !textoCoreano.trim().isEmpty()) {
                    ActaDeProteccionDelIdiomaCulturalDePyongyang.contieneJergaSur(textoCoreano);
                }
                if ((nombreCoreano = v.nombre_kp) == null || nombreCoreano.trim().isEmpty()) continue;
                ActaDeProteccionDelIdiomaCulturalDePyongyang.contieneJergaSur(nombreCoreano);
            }
            ArrayList<VerificacionFirmasV0> arr = new ArrayList<VerificacionFirmasV0>();
            for (int i2 = 0; i2 < this.modeloLista.size(); ++i2) {
                arr.add(this.modeloLista.get(i2));
            }
            FirmasV0.guardar(arr);
            JOptionPane.showMessageDialog(this, MonitorDePID.idioma.guardadoOk(), "OK", 1);
            this.actualizarVistaJson();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error al guardar: " + ex.getMessage(), "Error", 0);
        }
    }

    public void exportarArchivo() {
        try {
            JFileChooser ch = new JFileChooser();
            ch.setSelectedFile(new File("codice.json"));
            if (ch.showSaveDialog(this) == 0) {
                Files.write(ch.getSelectedFile().toPath(), this.vistaJson.getText().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error exportando: " + ex.getMessage(), "Error", 0);
        }
    }

    public boolean validarVerificacion(VerificacionFirmasV0 v) {
        if (this.isEmpty(v.id) || this.isEmpty(v.para_buscar) || v.filtro == null || this.isEmpty(v.filtro.id)) {
            return false;
        }
        if (v.criticalidad == null) {
            return false;
        }
        return !this.isEmpty(v.nombre_es) && !this.isEmpty(v.resultado_es) && !this.isEmpty(v.nombre_en) && !this.isEmpty(v.resultado_en) && !this.isEmpty(v.nombre_ar) && !this.isEmpty(v.resultado_ar) && !this.isEmpty(v.nombre_pt) && !this.isEmpty(v.resultado_pt) && !this.isEmpty(v.nombre_fa) && !this.isEmpty(v.resultado_fa) && !this.isEmpty(v.nombre_ru) && !this.isEmpty(v.resultado_ru) && !this.isEmpty(v.nombre_zh) && !this.isEmpty(v.resultado_zh) && !this.isEmpty(v.nombre_eo) && !this.isEmpty(v.resultado_eo) && !this.isEmpty(v.nombre_jp) && !this.isEmpty(v.resultado_jp) && !this.isEmpty(v.nombre_kp) && !this.isEmpty(v.resultado_kp);
    }

    public void actualizarVistaJson() {
        try {
            ArrayList<VerificacionFirmasV0> arr = new ArrayList<VerificacionFirmasV0>();
            for (int i = 0; i < this.modeloLista.size(); ++i) {
                arr.add(this.modeloLista.get(i));
            }
            this.vistaJson.setText(this.construirJsonPreview(arr));
            this.vistaJson.setCaretPosition(0);
        }
        catch (Exception ex) {
            this.vistaJson.setText("{ \"error\": \"" + ex.getMessage() + "\" }");
        }
    }

    public boolean hayCambiosNoGuardados() {
        try {
            List<VerificacionFirmasV0> enDisco = CargadorDeCodice.cargarVerificaciones();
            if (enDisco.size() != this.modeloLista.size()) {
                return true;
            }
            for (int i = 0; i < this.modeloLista.size(); ++i) {
                VerificacionFirmasV0 enArc;
                VerificacionFirmasV0 enMem = this.modeloLista.get(i);
                if (enMem.equals(enArc = enDisco.get(i))) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return true;
        }
    }

    public boolean confirmarDescartarCambios() {
        if (this.esFormularioModificado()) {
            int respuesta = JOptionPane.showConfirmDialog(this, MonitorDePID.idioma.descartarCambios(), MonitorDePID.idioma.confirmacion(), 0, 3);
            return respuesta == 0;
        }
        return true;
    }

    public String construirJsonPreview(List<VerificacionFirmasV0> arr) {
        String nl = "\n";
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(nl);
        sb.append("  \"schema\": 0,").append(nl);
        sb.append("  \"verificaciones\": [").append(nl);
        for (int i = 0; i < arr.size(); ++i) {
            VerificacionFirmasV0 v = arr.get(i);
            sb.append("    {").append(nl);
            this.w(sb, "id", v.id, 6).append(",").append(nl);
            this.w(sb, "para_buscar", v.para_buscar, 6).append(",").append(nl);
            this.w(sb, "filtro", v.filtro != null ? v.filtro.id : "", 6).append(",").append(nl);
            this.w(sb, "criticalidad", v.criticalidad != null ? v.criticalidad.nombre : "ADVERTENCIA", 6).append(",").append(nl);
            this.wnum(sb, "prioridad", v.prioridad, 6).append(",").append(nl);
            sb.append(this.sp(6)).append("\"nombres\": {").append(nl);
            this.nombres(sb, "ar", v.nombre_ar, 8).append(",").append(nl);
            this.nombres(sb, "zh", v.nombre_zh, 8).append(",").append(nl);
            this.nombres(sb, "kp", v.nombre_kp, 8).append(",").append(nl);
            this.nombres(sb, "es", v.nombre_es, 8).append(",").append(nl);
            this.nombres(sb, "eo", v.nombre_eo, 8).append(",").append(nl);
            this.nombres(sb, "en", v.nombre_en, 8).append(",").append(nl);
            this.nombres(sb, "jp", v.nombre_jp, 8).append(",").append(nl);
            this.nombres(sb, "fa", v.nombre_fa, 8).append(",").append(nl);
            this.nombres(sb, "pt", v.nombre_pt, 8).append(",").append(nl);
            this.nombres(sb, "ru", v.nombre_ru, 8).append(nl);
            sb.append(this.sp(6)).append("},").append(nl);
            sb.append(this.sp(6)).append("\"resultados\": {").append(nl);
            this.nombres(sb, "ar", v.resultado_ar, 8).append(",").append(nl);
            this.nombres(sb, "zh", v.resultado_zh, 8).append(",").append(nl);
            this.nombres(sb, "kp", v.resultado_kp, 8).append(",").append(nl);
            this.nombres(sb, "es", v.resultado_es, 8).append(",").append(nl);
            this.nombres(sb, "eo", v.resultado_eo, 8).append(",").append(nl);
            this.nombres(sb, "en", v.resultado_en, 8).append(",").append(nl);
            this.nombres(sb, "jp", v.resultado_jp, 8).append(",").append(nl);
            this.nombres(sb, "fa", v.resultado_fa, 8).append(",").append(nl);
            this.nombres(sb, "pt", v.resultado_pt, 8).append(",").append(nl);
            this.nombres(sb, "ru", v.resultado_ru, 8).append(nl);
            sb.append(this.sp(6)).append("}").append(nl);
            sb.append("    }");
            if (i < arr.size() - 1) {
                sb.append(",");
            }
            sb.append(nl);
        }
        sb.append("  ]").append(nl);
        sb.append("}").append(nl);
        return sb.toString();
    }

    public StringBuilder w(StringBuilder sb, String k, String v, int sp) {
        return sb.append(this.sp(sp)).append("\"").append(k).append("\": ").append("\"").append(this.escape(this.nz(v))).append("\"");
    }

    public StringBuilder wnum(StringBuilder sb, String k, int v, int sp) {
        return sb.append(this.sp(sp)).append("\"").append(k).append("\": ").append(v);
    }

    public StringBuilder nombres(StringBuilder sb, String k, String v, int sp) {
        return this.w(sb, k, v, sp);
    }

    public String sp(int n) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            s.append(' ');
        }
        return s.toString();
    }

    public String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }

    public boolean vacio(JTextField t) {
        return t.getText() == null || t.getText().trim().isEmpty();
    }

    public boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public String nz(String s) {
        return s == null ? "" : s;
    }

    public void recargarTextosYEstilo() {
        JTextField[] arr;
        int indiceSeleccion = this.lista != null ? this.lista.getSelectedIndex() : -1;
        String sId = this.fId != null ? this.fId.getText() : "";
        String sBuscar = this.fParaBuscar != null ? this.fParaBuscar.getText() : "";
        Object selFiltro = this.cbFiltro != null ? this.cbFiltro.getSelectedItem() : null;
        Object selCrit = this.cbCriticalidad != null ? this.cbCriticalidad.getSelectedItem() : null;
        int prio = this.spPrioridad != null ? ((Number)this.spPrioridad.getValue()).intValue() : 0;
        LinkedHashMap<String, String[]> snapshotIdiomas = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, JTextField[]> entry : this.camposIdiomas.entrySet()) {
            arr = entry.getValue();
            snapshotIdiomas.put(entry.getKey(), new String[]{arr[0].getText(), arr[1].getText()});
        }
        this.getContentPane().removeAll();
        this.setTitle(MonitorDePID.idioma.tituloEditorCodice());
        this.add((Component)this.crearEncabezado(), "North");
        this.add((Component)this.crearSplit(), "Center");
        if (indiceSeleccion >= 0 && indiceSeleccion < this.modeloLista.size()) {
            this.lista.setSelectedIndex(indiceSeleccion);
        }
        if (this.fId != null) {
            this.fId.setText(sId);
        }
        if (this.fParaBuscar != null) {
            this.fParaBuscar.setText(sBuscar);
        }
        if (this.cbFiltro != null && selFiltro != null) {
            this.cbFiltro.setSelectedItem(selFiltro);
        }
        if (this.cbCriticalidad != null && selCrit != null) {
            this.cbCriticalidad.setSelectedItem(selCrit);
        }
        if (this.spPrioridad != null) {
            this.spPrioridad.setValue(prio);
        }
        for (Map.Entry<String, Object> entry : snapshotIdiomas.entrySet()) {
            arr = this.camposIdiomas.get(entry.getKey());
            if (arr == null) continue;
            arr[0].setText(((String[])entry.getValue())[0]);
            arr[1].setText(((String[])entry.getValue())[1]);
        }
        if (this.btnNuevo != null) {
            this.btnNuevo.setText(MonitorDePID.idioma.nuevo());
        }
        if (this.btnActualizar != null) {
            this.btnActualizar.setText(MonitorDePID.idioma.actualizarSeleccionado());
        }
        if (this.btnEliminar != null) {
            this.btnEliminar.setText(MonitorDePID.idioma.eliminarSeleccionado());
        }
        if (this.btnExportar != null) {
            this.btnExportar.setText(MonitorDePID.idioma.exportarJSON());
        }
        if (this.btnGuardar != null) {
            this.btnGuardar.setText(MonitorDePID.idioma.guardarTodo());
        }
        this.actualizarVistaJson();
        this.revalidate();
        this.repaint();
    }
}

