/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.editor_plantilla;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ConfigString;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public abstract class EditorPlantilla
extends JPanel
implements CrashDetectorGUI {
    public static Map<String, Supplier<EditorPlantilla>> GUIS = new HashMap<String, Supplier<EditorPlantilla>>();
    public JTextPane editorHTML;
    public JEditorPane vistaPrevia;
    public JButton botonGuardar;
    public JButton botonRestablecerPlantilla;
    public JButton botonCerrar;
    public JPanel panelConfiguracion;
    public Config configuracion = Config.obtenerInstancia();
    public boolean actualizandoVista = false;
    public File archivoPlantilla;
    public Map<String, ConfigColor> colorMap = new HashMap<String, ConfigColor>();
    public Map<String, ConfigString> enlacesMap = new HashMap<String, ConfigString>();

    public abstract void inicializarComponentes();

    public void cargarContenidoPlantilla() {
        block19: {
            this.archivoPlantilla = Statics.carpeta.resolve("pantilla.htm").toFile();
            if (this.archivoPlantilla.exists()) {
                try {
                    StringBuilder contenido = new StringBuilder();
                    try (BufferedReader reader = new BufferedReader(new FileReader(this.archivoPlantilla));){
                        String linea;
                        while ((linea = reader.readLine()) != null) {
                            contenido.append(linea).append("\n");
                        }
                    }
                    this.editorHTML.setText(contenido.toString());
                    this.resaltarSintaxis();
                    this.actualizarVistaPrevia();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Error al cargar la plantilla desde disco: " + e.getMessage(), "Error", 0);
                }
            } else {
                try {
                    String rutaPlantilla = "pantilla.htm";
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream(rutaPlantilla);
                    if (is == null) break block19;
                    StringBuilder contenido = new StringBuilder();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                        String linea;
                        while ((linea = reader.readLine()) != null) {
                            contenido.append(linea).append("\n");
                        }
                    }
                    this.editorHTML.setText(contenido.toString());
                    this.resaltarSintaxis();
                    this.actualizarVistaPrevia();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "No se encontr\u00f3 la plantilla. Restablezca usando el bot\u00f3n 'Restablecer Plantilla'.", "Error", 0);
                }
            }
        }
    }

    public void resaltarSintaxis() {
        int cierre;
        int abertura;
        SimpleAttributeSet style;
        if (this.actualizandoVista) {
            return;
        }
        this.actualizandoVista = true;
        StyledDocument doc = this.editorHTML.getStyledDocument();
        String text = this.editorHTML.getText();
        SimpleAttributeSet normal = new SimpleAttributeSet();
        doc.setCharacterAttributes(0, text.length(), normal, true);
        int inicio = 0;
        while ((inicio = text.indexOf("{constructor}", inicio)) != -1) {
            style = new SimpleAttributeSet();
            StyleConstants.setForeground(style, new Color(0, 120, 212));
            StyleConstants.setBold(style, true);
            doc.setCharacterAttributes(inicio, 13, style, false);
            inicio += 13;
        }
        inicio = 0;
        while ((inicio = text.indexOf("{mensaje_ayudar}", inicio)) != -1) {
            style = new SimpleAttributeSet();
            StyleConstants.setForeground(style, new Color(153, 0, 153));
            StyleConstants.setBold(style, true);
            doc.setCharacterAttributes(inicio, 16, style, false);
            inicio += 16;
        }
        inicio = 0;
        while (inicio < text.length() && (abertura = text.indexOf("<", inicio)) != -1 && (cierre = text.indexOf(">", abertura)) != -1) {
            SimpleAttributeSet style2 = new SimpleAttributeSet();
            StyleConstants.setForeground(style2, new Color(153, 0, 153));
            doc.setCharacterAttributes(abertura, cierre - abertura + 1, style2, false);
            inicio = cierre + 1;
        }
        this.actualizandoVista = false;
    }

    public void actualizarVistaPrevia() {
        if (this.actualizandoVista) {
            return;
        }
        this.actualizandoVista = true;
        this.vistaPrevia.removeAll();
        String contenido = this.editorHTML.getText();
        String colorError = this.configuracion.obtenerColorError();
        String colorAdvertencia = this.configuracion.obtenerColorAdvertencia();
        String colorInfo = this.configuracion.obtenerColorInfo();
        String colorTitulo = this.configuracion.obtenerColorTitulo();
        String colorTitulosConsolas = this.configuracion.obtenerColorDeTitulosDeConsolas();
        String colorEnlace = this.configuracion.obtenerColorEnlace();
        String ejemploAnalisis = "<div style='color:#" + colorTitulo + "; font-weight: bold; margin-bottom: 10px;'>Ejemplo de An\u00e1lisis</div><div style='color:#" + colorTitulosConsolas + "; font-weight: bold; margin-bottom: 5px;'>T\u00edtulo de Consola de Ejemplo</div><div style='color:#" + colorError + "'>[EJEMPLO] Error cr\u00edtico: No se pudo cargar el mod 'ExampleMod'</div><div style='color:#" + colorAdvertencia + "'>[EJEMPLO] Advertencia: Conflictos entre mods detectados</div><div style='color:#" + colorInfo + "'>[EJEMPLO] Informaci\u00f3n: 5 soluciones potenciales encontradas</div>";
        String ejemploAyuda = "<div style='color:#" + colorEnlace + "; margin-top: 20px;'>\u00bfNecesitas ayuda? Usa el bot\u00f3n Compartir para obtener enlaces a los registros y a los resultados.</div>";
        String contenidoVista = contenido.replace("{constructor}", ejemploAnalisis).replace("{mensaje_ayudar}", ejemploAyuda);
        this.vistaPrevia.setText(contenidoVista);
        this.vistaPrevia.setCaretPosition(0);
        this.actualizandoVista = false;
    }

    public JPanel crearPanelImagen(String nombreImagen) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(nombreImagen);
        label.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add((Component)label, "North");
        JPanel panelContenido = new JPanel();
        panelContenido.setLayout(new BoxLayout(panelContenido, 0));
        panelContenido.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JLabel previewLabel = new JLabel();
        previewLabel.setPreferredSize(new Dimension(100, 56));
        previewLabel.setAlignmentY(0.5f);
        this.actualizarVistaPreviaImagen(nombreImagen, previewLabel);
        JButton botonRestablecer = new JButton(MonitorDePID.idioma.restablecer());
        botonRestablecer.setPreferredSize(new Dimension(80, 25));
        botonRestablecer.setAlignmentY(0.5f);
        botonRestablecer.addActionListener(e -> this.restablecerImagen(nombreImagen, previewLabel));
        panelContenido.add(previewLabel);
        panelContenido.add(Box.createHorizontalStrut(10));
        panelContenido.add(botonRestablecer);
        panel.add((Component)panelContenido, "Center");
        return panel;
    }

    public void inicializarConfiguracionColores(JPanel panelCampos) {
        this.colorMap.put("enlace", ConfigColor.de("color_enlace", Config.convertirAColor(this.configuracion.obtenerColorEnlace())));
        this.colorMap.put("titulosConsolas", ConfigColor.de("color_de_titulos_de_consolas", Config.convertirAColor(this.configuracion.obtenerColorDeTitulosDeConsolas())));
        this.colorMap.put("error", ConfigColor.de("color_error", Config.convertirAColor(this.configuracion.obtenerColorError())));
        this.colorMap.put("advertencia", ConfigColor.de("color_advertencia", Config.convertirAColor(this.configuracion.obtenerColorAdvertencia())));
        this.colorMap.put("info", ConfigColor.de("color_info", Config.convertirAColor(this.configuracion.obtenerColorInfo())));
        this.colorMap.put("titulo", ConfigColor.de("color_titulo", Config.convertirAColor(this.configuracion.obtenerColorTitulo())));
        panelCampos.add(this.crearCampoDeColor(MonitorDePID.idioma.colorEnlace(), this.colorMap.get("enlace")));
        panelCampos.add(this.crearCampoDeColor(MonitorDePID.idioma.colorTitulosConsolas(), this.colorMap.get("titulosConsolas")));
        panelCampos.add(this.crearCampoDeColor(MonitorDePID.idioma.colorError(), this.colorMap.get("error")));
        panelCampos.add(this.crearCampoDeColor(MonitorDePID.idioma.colorAdvertencia(), this.colorMap.get("advertencia")));
        panelCampos.add(this.crearCampoDeColor(MonitorDePID.idioma.colorInfo(), this.colorMap.get("info")));
        panelCampos.add(this.crearCampoDeColor(MonitorDePID.idioma.colorTitulo(), this.colorMap.get("titulo")));
    }

    public void inicializarConfiguracionEnlaces(JPanel panelCampos) {
        this.enlacesMap.put("gura", ConfigString.de("enlace_imagen_gura", "http://asbestosstar.egoism.jp/crash_detector/gura.png"));
        this.enlacesMap.put("mumei", ConfigString.de("enlace_imagen_mumei", "http://asbestosstar.egoism.jp/crash_detector/nanashi_mumei.png"));
        this.enlacesMap.put("shion", ConfigString.de("enlace_imagen_shion", "http://asbestosstar.egoism.jp/crash_detector/shion.png"));
        panelCampos.add(this.crearCampoDeTextoEnlace("Enlace imagen Gura", this.enlacesMap.get("gura")));
        panelCampos.add(this.crearCampoDeTextoEnlace("Enlace imagen Mumei", this.enlacesMap.get("mumei")));
        panelCampos.add(this.crearCampoDeTextoEnlace("Enlace imagen Shion", this.enlacesMap.get("shion")));
    }

    public JPanel crearCampoDeTextoEnlace(String etiqueta, final ConfigString configString) {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(etiqueta);
        label.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add((Component)label, "West");
        final JTextField field = new JTextField(configString.obtener());
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.escribir();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.escribir();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.escribir();
            }

            private void escribir() {
                try {
                    configString.escribir(field.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        panel.add((Component)field, "Center");
        return panel;
    }

    public void actualizarVistaPreviaImagen(String nombreImagen, JLabel previewLabel) {
        File imagenFile = Statics.carpeta.resolve("imagenes").resolve(nombreImagen).toFile();
        if (imagenFile.exists()) {
            try {
                BufferedImage img = ImageIO.read(imagenFile);
                int ancho = 100;
                int alto = (int)((double)ancho * 0.56);
                Image scaledImage = img.getScaledInstance(ancho, alto, 4);
                previewLabel.setIcon(new ImageIcon(scaledImage));
            }
            catch (IOException e) {
                previewLabel.setText("Error");
            }
        } else {
            previewLabel.setText("No existe");
        }
    }

    public void restablecerImagen(String nombreImagen, JLabel previewLabel) {
        int confirmacion = JOptionPane.showConfirmDialog(this, MonitorDePID.idioma.restablecerImagenMensjae(nombreImagen), MonitorDePID.idioma.restablecer(), 0);
        if (confirmacion != 0) {
            return;
        }
        String rutaRecurso = "/imagenes/" + nombreImagen;
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(rutaRecurso);){
            if (is == null) {
                JOptionPane.showMessageDialog(this, "No se encontr\u00f3 la imagen en el recurso: " + rutaRecurso, "Error", 0);
                return;
            }
            File destino = Statics.carpeta.resolve("imagenes").resolve(nombreImagen).toFile();
            destino.getParentFile().mkdirs();
            try (FileOutputStream os = new FileOutputStream(destino);){
                int length;
                byte[] buffer = new byte[4096];
                while ((length = is.read(buffer)) > 0) {
                    ((OutputStream)os).write(buffer, 0, length);
                }
            }
            JOptionPane.showMessageDialog(this, "Imagen restablecida: " + nombreImagen, "\u00c9xito", 1);
            this.actualizarVistaPreviaImagen(nombreImagen, previewLabel);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error al restablecer la imagen: " + e.getMessage(), "Error", 0);
        }
    }

    public JPanel crearCampoDeColor(String nombre, ConfigColor configColor) {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(nombre);
        label.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add((Component)label, "West");
        JPanel inputPanel = new JPanel(new BorderLayout(5, 0));
        JTextField textField = this.crearCampoTextoConfiguracion(Config.colorAHexHtml(configColor.obtener()), configColor);
        textField.setPreferredSize(new Dimension(80, 25));
        inputPanel.add((Component)textField, "Center");
        PanelPrevisualizacionColor colorPreview = new PanelPrevisualizacionColor(textField, configColor);
        inputPanel.add((Component)colorPreview, "East");
        panel.add((Component)inputPanel, "Center");
        return panel;
    }

    public JTextField crearCampoTextoConfiguracion(String valorInicial, final ConfigColor configColor) {
        final JTextField field = new JTextField(valorInicial);
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.procesarCambio();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.procesarCambio();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.procesarCambio();
            }

            private void procesarCambio() {
                String texto = field.getText();
                if (texto == null || texto.isEmpty()) {
                    return;
                }
                try {
                    if (texto.startsWith("#")) {
                        texto = texto.substring(1);
                    }
                    if ((texto.length() == 3 || texto.length() == 6) && texto.matches("[0-9A-Fa-f]+")) {
                        Color color = Color.decode("#" + texto);
                        configColor.escribir(color);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return field;
    }

    public void guardarPlantilla() {
        if (this.archivoPlantilla == null || !this.archivoPlantilla.exists()) {
            this.archivoPlantilla = Statics.carpeta.resolve("pantilla.htm").toFile();
        }
        try {
            try (FileWriter writer = new FileWriter(this.archivoPlantilla);){
                writer.write(this.editorHTML.getText());
            }
            JOptionPane.showMessageDialog(this, "Plantilla guardada en: " + this.archivoPlantilla.getAbsolutePath(), "\u00c9xito", 1);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error al guardar: " + e.getMessage(), "Error", 0);
        }
    }

    public void restablecerPlantilla() {
        block14: {
            int confirmacion = JOptionPane.showConfirmDialog(this, MonitorDePID.idioma.restablecerPlantillaMensaje(), MonitorDePID.idioma.confirmacion(), 0, 2);
            if (confirmacion == 0) {
                try {
                    String rutaPlantilla = "pantilla.htm";
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream(rutaPlantilla);
                    if (is == null) break block14;
                    StringBuilder contenido = new StringBuilder();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                        String linea;
                        while ((linea = reader.readLine()) != null) {
                            contenido.append(linea).append("\n");
                        }
                    }
                    try (FileWriter writer = new FileWriter(this.archivoPlantilla);){
                        writer.write(contenido.toString());
                    }
                    this.editorHTML.setText(contenido.toString());
                    this.resaltarSintaxis();
                    this.actualizarVistaPrevia();
                    JOptionPane.showMessageDialog(this, "Plantilla restablecida correctamente.", "\u00c9xito", 1);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Error al restablecer: " + e.getMessage(), "Error", 0);
                }
            }
        }
    }

    public void cerrarEditor() {
        if (SwingUtilities.getWindowAncestor(this) instanceof Dialog) {
            ((Dialog)SwingUtilities.getWindowAncestor(this)).dispose();
        }
    }

    @Override
    public TipoGUI tipo() {
        return TipoGUI.EDITOR_PLANTILLA;
    }

    @Override
    public void init() {
        this.inicializarComponentes();
        this.cargarContenidoPlantilla();
    }

    public List<String> obtenerNombresIm\u00e1genesVTuber() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("gura.png");
        ret.add("nanashi_mumei.png");
        ret.add("shion.png");
        return ret;
    }

    public class PanelPrevisualizacionColor
    extends JPanel {
        private JTextField textField;
        private ConfigColor configColor;

        public PanelPrevisualizacionColor(JTextField textField, final ConfigColor configColor) {
            this.textField = textField;
            this.configColor = configColor;
            this.setPreferredSize(new Dimension(25, 25));
            this.setBorder(BorderFactory.createLineBorder(new Color(120, 120, 120), 1));
            this.setBackground(configColor.obtener());
            this.setOpaque(true);
            SwingUtilities.invokeLater(() -> {
                this.setBackground(configColor.obtener());
                this.repaint();
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Color nuevoColor = JColorChooser.showDialog(PanelPrevisualizacionColor.this, "Seleccionar Color", configColor.obtener());
                    if (nuevoColor != null) {
                        PanelPrevisualizacionColor.this.actualizarColor(nuevoColor);
                    }
                }
            });
        }

        public void actualizarColor(Color color) {
            this.configColor.escribir(color);
            this.setBackground(color);
            this.repaint();
            String hexColor = String.format("%06X", 0xFFFFFF & color.getRGB());
            this.textField.setText(hexColor);
            EditorPlantilla.this.actualizarVistaPrevia();
        }

        public void actualizarPrevisualizacion() {
            this.setBackground(this.configColor.obtener());
            this.repaint();
        }
    }
}

