/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.editor_plantilla;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ConfigString;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.editor_plantilla.EditorPlantilla;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class EditorPlantillaModioNoche
extends EditorPlantilla {
    public static final String ID = "editor_plantilla_modio_noche";
    private Map<String, ConfigColor> coloresEditor = new HashMap<String, ConfigColor>();

    public EditorPlantillaModioNoche() {
        this.inicializarColoresEditor();
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void inicializarComponentes() {
        this.setLayout(new BorderLayout());
        this.inicializarColoresEditor();
        JPanel panelSuperior = new JPanel(new FlowLayout(2));
        panelSuperior.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        panelSuperior.setBackground(this.coloresEditor.get("fondo").obtener());
        this.botonGuardar = new JButton(MonitorDePID.idioma.guardarTodo());
        this.configurarBoton(this.botonGuardar);
        this.botonGuardar.addActionListener(e -> this.guardarPlantilla());
        panelSuperior.add(this.botonGuardar);
        this.botonRestablecerPlantilla = new JButton(MonitorDePID.idioma.restablecerPlantilla());
        this.configurarBoton(this.botonRestablecerPlantilla);
        this.botonRestablecerPlantilla.addActionListener(e -> this.restablecerPlantilla());
        panelSuperior.add(this.botonRestablecerPlantilla);
        this.botonCerrar = new JButton(MonitorDePID.idioma.omitirYCerrar());
        this.configurarBoton(this.botonCerrar);
        this.botonCerrar.addActionListener(e -> this.cerrarEditor());
        panelSuperior.add(this.botonCerrar);
        this.add((Component)panelSuperior, "North");
        JSplitPane splitPanePrincipal = new JSplitPane(1);
        splitPanePrincipal.setBackground(this.coloresEditor.get("borde").obtener());
        JSplitPane splitPaneEditor = new JSplitPane(0);
        splitPaneEditor.setDividerLocation(0.75);
        splitPaneEditor.setBackground(this.coloresEditor.get("borde").obtener());
        JPanel panelEditor = new JPanel(new BorderLayout());
        panelEditor.setBorder(BorderFactory.createTitledBorder("Editor HTML"));
        panelEditor.setBackground(this.coloresEditor.get("fondo").obtener());
        this.editorHTML = new JTextPane();
        this.editorHTML.setFont(new Font("Monospaced", 0, 13));
        this.editorHTML.setCaretColor(this.coloresEditor.get("texto").obtener());
        this.editorHTML.setForeground(this.coloresEditor.get("texto").obtener());
        this.editorHTML.setBackground(this.coloresEditor.get("caja_texto").obtener());
        JScrollPane scrollEditor = new JScrollPane(this.editorHTML);
        scrollEditor.setBorder(BorderFactory.createLineBorder(this.coloresEditor.get("borde").obtener(), 1));
        panelEditor.add((Component)scrollEditor, "Center");
        JPanel panelVistaPrevia = new JPanel(new BorderLayout());
        panelVistaPrevia.setBorder(BorderFactory.createTitledBorder("Vista Previa"));
        panelVistaPrevia.setBackground(this.coloresEditor.get("fondo").obtener());
        this.vistaPrevia = new JEditorPane();
        this.vistaPrevia.setEditable(false);
        this.vistaPrevia.setContentType("text/html");
        this.vistaPrevia.setBackground(this.coloresEditor.get("fondo_vista_previa").obtener());
        this.vistaPrevia.setForeground(this.coloresEditor.get("texto").obtener());
        JScrollPane scrollVistaPrevia = new JScrollPane(this.vistaPrevia);
        scrollVistaPrevia.setBorder(BorderFactory.createLineBorder(this.coloresEditor.get("borde").obtener(), 1));
        panelVistaPrevia.add((Component)scrollVistaPrevia, "Center");
        splitPaneEditor.setTopComponent(panelEditor);
        splitPaneEditor.setBottomComponent(panelVistaPrevia);
        this.panelConfiguracion = new JPanel(new BorderLayout());
        this.panelConfiguracion.setBorder(BorderFactory.createTitledBorder("Configuraci\u00f3n de Colores e Im\u00e1genes"));
        this.panelConfiguracion.setBackground(this.coloresEditor.get("fondo").obtener());
        JPanel panelColores = new JPanel(new GridLayout(0, 1, 5, 5));
        panelColores.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panelColores.setBackground(this.coloresEditor.get("fondo").obtener());
        this.inicializarConfiguracionColores(panelColores);
        JPanel panelImagenes = new JPanel(new BorderLayout());
        String rutaFormateada = Statics.carpeta.resolve("imagenes").toString().replace("\\", "/");
        panelImagenes.setBorder(BorderFactory.createTitledBorder("Im\u00e1genes (" + rutaFormateada + ")"));
        panelImagenes.setBackground(this.coloresEditor.get("fondo").obtener());
        JPanel panelContenidoImagenes = new JPanel(new GridLayout(0, 1, 5, 5));
        panelContenidoImagenes.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panelContenidoImagenes.setBackground(this.coloresEditor.get("fondo").obtener());
        for (String imagen : this.obtenerNombresIm\u00e1genesVTuber()) {
            panelContenidoImagenes.add(this.crearPanelImagen(imagen));
        }
        panelImagenes.add((Component)panelContenidoImagenes, "Center");
        JPanel panelEnlaces = new JPanel(new GridLayout(0, 1, 6, 6));
        panelEnlaces.setBorder(BorderFactory.createTitledBorder("Enlaces de im\u00e1genes (reportes compartidos)"));
        panelEnlaces.setBackground(this.coloresEditor.get("fondo").obtener());
        ConfigString cfgGura = ConfigString.de("enlace_imagen_gura", "http://asbestosstar.egoism.jp/crash_detector/gura.png");
        ConfigString cfgMumei = ConfigString.de("enlace_imagen_mumei", "http://asbestosstar.egoism.jp/crash_detector/nanashi_mumei.png");
        ConfigString cfgShion = ConfigString.de("enlace_imagen_shion", "http://asbestosstar.egoism.jp/crash_detector/shion.png");
        panelEnlaces.add(this.crearFilaEnlace("Gura", cfgGura));
        panelEnlaces.add(this.crearFilaEnlace("Nanashi Mumei", cfgMumei));
        panelEnlaces.add(this.crearFilaEnlace("Shion", cfgShion));
        JPanel derechaArriba = new JPanel(new BorderLayout());
        derechaArriba.setBackground(this.coloresEditor.get("fondo").obtener());
        derechaArriba.add((Component)panelColores, "Center");
        JPanel derechaAbajo = new JPanel(new BorderLayout());
        derechaAbajo.setBackground(this.coloresEditor.get("fondo").obtener());
        derechaAbajo.add((Component)panelImagenes, "Center");
        derechaAbajo.add((Component)panelEnlaces, "South");
        JPanel derecha = new JPanel(new BorderLayout());
        derecha.setBackground(this.coloresEditor.get("fondo").obtener());
        derecha.add((Component)derechaArriba, "Center");
        derecha.add((Component)derechaAbajo, "South");
        JScrollPane scrollDerecha = new JScrollPane(derecha);
        scrollDerecha.setBorder(BorderFactory.createEmptyBorder());
        this.panelConfiguracion.add((Component)scrollDerecha, "Center");
        splitPanePrincipal.setLeftComponent(splitPaneEditor);
        splitPanePrincipal.setRightComponent(this.panelConfiguracion);
        splitPanePrincipal.setContinuousLayout(true);
        splitPanePrincipal.setResizeWeight(0.5);
        this.panelConfiguracion.setMinimumSize(new Dimension(340, 200));
        splitPaneEditor.setMinimumSize(new Dimension(420, 200));
        this.add((Component)splitPanePrincipal, "Center");
        SwingUtilities.invokeLater(() -> splitPanePrincipal.setDividerLocation(0.5));
        this.editorHTML.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditorPlantillaModioNoche.this.actualizarVistaPrevia();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditorPlantillaModioNoche.this.actualizarVistaPrevia();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditorPlantillaModioNoche.this.actualizarVistaPrevia();
            }
        });
        this.editorHTML.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                EditorPlantillaModioNoche.this.resaltarSintaxis();
            }
        });
        this.resaltarSintaxis();
    }

    private void inicializarColoresEditor() {
        this.coloresEditor.put("fondo", ConfigColor.de("color_fondo_editor_plantilla_modio_noche", new Color(30, 30, 30)));
        this.coloresEditor.put("texto", ConfigColor.de("color_texto_editor_plantilla_modio_noche", new Color(224, 224, 224)));
        this.coloresEditor.put("caja_texto", ConfigColor.de("color_caja_texto_editor_plantilla_modio_noche", new Color(45, 45, 45)));
        this.coloresEditor.put("boton", ConfigColor.de("color_boton_editor_plantilla_modio_noche", new Color(42, 42, 42)));
        this.coloresEditor.put("borde", ConfigColor.de("color_borde_editor_plantilla_modio_noche", new Color(64, 64, 64)));
        this.coloresEditor.put("fondo_vista_previa", ConfigColor.de("color_fondo_vista_previa_modio_noche", new Color(30, 30, 30)));
        this.coloresEditor.put("sintaxis_constructor", ConfigColor.de("color_sintaxis_constructor_modio_noche", new Color(0, 204, 255)));
        this.coloresEditor.put("sintaxis_mensaje_ayudar", ConfigColor.de("color_sintaxis_mensaje_ayudar_modio_noche", new Color(255, 102, 255)));
        this.coloresEditor.put("sintaxis_etiquetas_html", ConfigColor.de("color_sintaxis_etiquetas_html_modio_noche", new Color(255, 204, 0)));
    }

    private void configurarBoton(JButton boton) {
        boton.setForeground(this.coloresEditor.get("texto").obtener());
        boton.setBackground(this.coloresEditor.get("boton").obtener());
        boton.setFont(new Font("Segoe UI", 0, 12));
        boton.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        boton.setFocusPainted(false);
        boton.setOpaque(true);
    }

    @Override
    public void recargarApariencia() {
        SwingUtilities.updateComponentTreeUI(this);
        this.inicializarColoresEditor();
        if (this.getParent() != null) {
            this.inicializarComponentes();
            this.repaint();
        }
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> configs = new ArrayList<ElementoConfig>();
        ConfigColor fondo = this.coloresEditor.get("fondo");
        fondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        configs.add(fondo);
        ConfigColor texto = this.coloresEditor.get("texto");
        texto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        configs.add(texto);
        ConfigColor cajaTexto = this.coloresEditor.get("caja_texto");
        cajaTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorCajaTexto());
        configs.add(cajaTexto);
        ConfigColor boton = this.coloresEditor.get("boton");
        boton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        configs.add(boton);
        ConfigColor borde = this.coloresEditor.get("borde");
        borde.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
        configs.add(borde);
        ConfigColor fondoVistaPrevia = this.coloresEditor.get("fondo_vista_previa");
        fondoVistaPrevia.establecerNombreParaMostrar(() -> MonitorDePID.idioma.fondoVistaPrevia());
        configs.add(fondoVistaPrevia);
        ConfigColor sintaxisConstructor = this.coloresEditor.get("sintaxis_constructor");
        sintaxisConstructor.establecerNombreParaMostrar(() -> MonitorDePID.idioma.sintaxisConstructor());
        configs.add(sintaxisConstructor);
        ConfigColor sintaxisMensajeAyudar = this.coloresEditor.get("sintaxis_mensaje_ayudar");
        sintaxisMensajeAyudar.establecerNombreParaMostrar(() -> MonitorDePID.idioma.sintaxisMensajeAyudar());
        configs.add(sintaxisMensajeAyudar);
        ConfigColor sintaxisEtiquetasHtml = this.coloresEditor.get("sintaxis_etiquetas_html");
        sintaxisEtiquetasHtml.establecerNombreParaMostrar(() -> MonitorDePID.idioma.sintaxisEtiquetasHtml());
        configs.add(sintaxisEtiquetasHtml);
        return configs;
    }

    @Override
    public void resaltarSintaxis() {
        int cierre;
        int abertura;
        SimpleAttributeSet style;
        if (this.actualizandoVista) {
            return;
        }
        this.actualizandoVista = true;
        StyledDocument doc = this.editorHTML.getStyledDocument();
        String text = this.editorHTML.getText();
        SimpleAttributeSet normal = new SimpleAttributeSet();
        StyleConstants.setForeground(normal, this.coloresEditor.get("texto").obtener());
        doc.setCharacterAttributes(0, text.length(), normal, true);
        int inicio = 0;
        while ((inicio = text.indexOf("{constructor}", inicio)) != -1) {
            style = new SimpleAttributeSet();
            StyleConstants.setForeground(style, this.coloresEditor.get("sintaxis_constructor").obtener());
            StyleConstants.setBold(style, true);
            doc.setCharacterAttributes(inicio, 13, style, false);
            inicio += 13;
        }
        inicio = 0;
        while ((inicio = text.indexOf("{mensaje_ayudar}", inicio)) != -1) {
            style = new SimpleAttributeSet();
            StyleConstants.setForeground(style, this.coloresEditor.get("sintaxis_mensaje_ayudar").obtener());
            StyleConstants.setBold(style, true);
            doc.setCharacterAttributes(inicio, 16, style, false);
            inicio += 16;
        }
        inicio = 0;
        while (inicio < text.length() && (abertura = text.indexOf("<", inicio)) != -1 && (cierre = text.indexOf(">", abertura)) != -1) {
            SimpleAttributeSet style2 = new SimpleAttributeSet();
            StyleConstants.setForeground(style2, this.coloresEditor.get("sintaxis_etiquetas_html").obtener());
            doc.setCharacterAttributes(abertura, cierre - abertura + 1, style2, false);
            inicio = cierre + 1;
        }
        this.actualizandoVista = false;
    }

    @Override
    public void actualizarVistaPrevia() {
        if (this.actualizandoVista) {
            return;
        }
        this.actualizandoVista = true;
        this.vistaPrevia.removeAll();
        String contenido = this.editorHTML.getText();
        String colorError = this.configuracion.obtenerColorError();
        String colorAdvertencia = this.configuracion.obtenerColorAdvertencia();
        String colorInfo = this.configuracion.obtenerColorInfo();
        String colorTitulo = this.configuracion.obtenerColorTitulo();
        String colorTitulosConsolas = this.configuracion.obtenerColorDeTitulosDeConsolas();
        String colorEnlace = this.configuracion.obtenerColorEnlace();
        String ejemploAnalisis = "<div style='color:#" + colorTitulo + "; font-weight: bold; margin-bottom: 10px;'>Ejemplo de An\u00e1lisis</div><div style='color:#" + colorTitulosConsolas + "; font-weight: bold; margin-bottom: 5px;'>T\u00edtulo de Consola de Ejemplo</div><div style='color:#" + colorError + "'>[EJEMPLO] Error cr\u00edtico: No se pudo cargar el mod 'ExampleMod'</div><div style='color:#" + colorAdvertencia + "'>[EJEMPLO] Advertencia: Conflictos entre mods detectados</div><div style='color:#" + colorInfo + "'>[EJEMPLO] Informaci\u00f3n: 5 soluciones potenciales encontradas</div>";
        String ejemploAyuda = "<div style='color:#" + colorEnlace + "; margin-top: 20px;'>\u00bfNecesitas ayuda? Usa el bot\u00f3n Compartir para obtener enlaces a los registros y a los resultados.</div>";
        String contenidoVista = contenido.replace("{constructor}", ejemploAnalisis).replace("{mensaje_ayudar}", ejemploAyuda);
        String htmlConEstilos = "<html><head><meta charset='UTF-8'><style>body { background-color: " + Config.colorAHexHtml(this.coloresEditor.get("fondo_vista_previa").obtener()) + "; color: " + Config.colorAHexHtml(this.coloresEditor.get("texto").obtener()) + "; }a { color: " + colorEnlace + "; text-decoration: underline; }</style></head><body>" + contenidoVista + "</body></html>";
        this.vistaPrevia.setText(htmlConEstilos);
        this.vistaPrevia.setCaretPosition(0);
        this.actualizandoVista = false;
    }

    private JPanel crearFilaEnlace(String etiqueta, final ConfigString cfg) {
        JPanel fila = new JPanel(new BorderLayout(8, 0));
        fila.setBackground(this.coloresEditor.get("fondo").obtener());
        JLabel lbl = new JLabel(etiqueta + ":");
        lbl.setForeground(this.coloresEditor.get("texto").obtener());
        lbl.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        final JTextField campo = new JTextField(cfg.obtener());
        campo.setForeground(this.coloresEditor.get("texto").obtener());
        campo.setBackground(this.coloresEditor.get("caja_texto").obtener());
        campo.setCaretColor(this.coloresEditor.get("texto").obtener());
        campo.setToolTipText("URL usada en reportes compartidos");
        campo.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.escribir();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.escribir();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.escribir();
            }

            private void escribir() {
                try {
                    cfg.escribir(campo.getText());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        fila.add((Component)lbl, "West");
        fila.add((Component)campo, "Center");
        return fila;
    }
}

