/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.editor_plantilla;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.editor_plantilla.EditorPlantilla;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditorPlantillaPredeterminado
extends EditorPlantilla {
    public static final String ID = "editor_plantilla_predeterminado";
    private Map<String, ConfigColor> coloresEditor = new HashMap<String, ConfigColor>();

    public EditorPlantillaPredeterminado() {
        this.inicializarColoresEditor();
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void inicializarComponentes() {
        this.setLayout(new BorderLayout());
        this.inicializarColoresEditor();
        JPanel panelSuperior = new JPanel(new FlowLayout(2));
        panelSuperior.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        panelSuperior.setBackground(this.coloresEditor.get("fondo").obtener());
        this.botonGuardar = new JButton(MonitorDePID.idioma.guardarTodo());
        this.configurarBoton(this.botonGuardar);
        this.botonGuardar.addActionListener(e -> this.guardarPlantilla());
        panelSuperior.add(this.botonGuardar);
        this.botonRestablecerPlantilla = new JButton(MonitorDePID.idioma.restablecerPlantilla());
        this.configurarBoton(this.botonRestablecerPlantilla);
        this.botonRestablecerPlantilla.addActionListener(e -> this.restablecerPlantilla());
        panelSuperior.add(this.botonRestablecerPlantilla);
        this.botonCerrar = new JButton(MonitorDePID.idioma.omitirYCerrar());
        this.configurarBoton(this.botonCerrar);
        this.botonCerrar.addActionListener(e -> this.cerrarEditor());
        panelSuperior.add(this.botonCerrar);
        this.add((Component)panelSuperior, "North");
        JSplitPane splitPanePrincipal = new JSplitPane(1);
        splitPanePrincipal.setDividerLocation(0.65);
        splitPanePrincipal.setBackground(this.coloresEditor.get("borde").obtener());
        JSplitPane splitPaneEditor = new JSplitPane(0);
        splitPaneEditor.setDividerLocation(0.75);
        splitPaneEditor.setBackground(this.coloresEditor.get("borde").obtener());
        JPanel panelEditor = new JPanel(new BorderLayout());
        panelEditor.setBorder(BorderFactory.createTitledBorder("Editor HTML"));
        panelEditor.setBackground(this.coloresEditor.get("fondo").obtener());
        this.editorHTML = new JTextPane();
        this.editorHTML.setFont(new Font("Monospaced", 0, 13));
        this.editorHTML.setCaretColor(this.coloresEditor.get("texto").obtener());
        this.editorHTML.setForeground(this.coloresEditor.get("texto").obtener());
        this.editorHTML.setBackground(this.coloresEditor.get("caja_texto").obtener());
        JScrollPane scrollEditor = new JScrollPane(this.editorHTML);
        scrollEditor.setBorder(BorderFactory.createLineBorder(this.coloresEditor.get("borde").obtener(), 1));
        panelEditor.add((Component)scrollEditor, "Center");
        JPanel panelVistaPrevia = new JPanel(new BorderLayout());
        panelVistaPrevia.setBorder(BorderFactory.createTitledBorder("Vista Previa"));
        panelVistaPrevia.setBackground(this.coloresEditor.get("fondo").obtener());
        this.vistaPrevia = new JEditorPane();
        this.vistaPrevia.setEditable(false);
        this.vistaPrevia.setContentType("text/html");
        this.vistaPrevia.setBackground(Color.WHITE);
        JScrollPane scrollVistaPrevia = new JScrollPane(this.vistaPrevia);
        scrollVistaPrevia.setBorder(BorderFactory.createLineBorder(this.coloresEditor.get("borde").obtener(), 1));
        panelVistaPrevia.add((Component)scrollVistaPrevia, "Center");
        splitPaneEditor.setTopComponent(panelEditor);
        splitPaneEditor.setBottomComponent(panelVistaPrevia);
        this.panelConfiguracion = new JPanel(new BorderLayout());
        this.panelConfiguracion.setBorder(BorderFactory.createTitledBorder("Configuraci\u00f3n de Colores e Im\u00e1genes"));
        this.panelConfiguracion.setBackground(this.coloresEditor.get("fondo").obtener());
        splitPanePrincipal.setContinuousLayout(true);
        splitPanePrincipal.setResizeWeight(0.5);
        this.panelConfiguracion.setMinimumSize(new Dimension(340, 200));
        splitPaneEditor.setMinimumSize(new Dimension(420, 200));
        JPanel panelColores = new JPanel(new GridLayout(0, 1, 5, 5));
        panelColores.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panelColores.setBackground(this.coloresEditor.get("fondo").obtener());
        this.inicializarConfiguracionColores(panelColores);
        JPanel panelEnlaces = new JPanel(new GridLayout(0, 1, 5, 5));
        panelEnlaces.setBorder(BorderFactory.createTitledBorder("Enlaces de im\u00e1genes (reporte compartido)"));
        panelEnlaces.setBackground(this.coloresEditor.get("fondo").obtener());
        this.inicializarConfiguracionEnlaces(panelEnlaces);
        JPanel panelImagenes = new JPanel(new BorderLayout());
        String rutaFormateada = Statics.carpeta.resolve("imagenes").toString().replace("\\", "/");
        panelImagenes.setBorder(BorderFactory.createTitledBorder("Im\u00e1genes (" + rutaFormateada + ")"));
        panelImagenes.setBackground(this.coloresEditor.get("fondo").obtener());
        JPanel panelContenidoImagenes = new JPanel(new GridLayout(0, 1, 5, 5));
        panelContenidoImagenes.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panelContenidoImagenes.setBackground(this.coloresEditor.get("fondo").obtener());
        for (String imagen : this.obtenerNombresIm\u00e1genesVTuber()) {
            panelContenidoImagenes.add(this.crearPanelImagen(imagen));
        }
        panelImagenes.add((Component)panelContenidoImagenes, "Center");
        JPanel derechaStack = new JPanel(new GridLayout(0, 1, 8, 8));
        derechaStack.setBackground(this.coloresEditor.get("fondo").obtener());
        derechaStack.add(panelColores);
        derechaStack.add(panelEnlaces);
        derechaStack.add(panelImagenes);
        this.panelConfiguracion.add((Component)derechaStack, "Center");
        splitPanePrincipal.setLeftComponent(splitPaneEditor);
        splitPanePrincipal.setRightComponent(this.panelConfiguracion);
        this.add((Component)splitPanePrincipal, "Center");
        this.editorHTML.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditorPlantillaPredeterminado.this.actualizarVistaPrevia();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditorPlantillaPredeterminado.this.actualizarVistaPrevia();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditorPlantillaPredeterminado.this.actualizarVistaPrevia();
            }
        });
        this.editorHTML.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                EditorPlantillaPredeterminado.this.resaltarSintaxis();
            }
        });
        this.resaltarSintaxis();
    }

    private void inicializarColoresEditor() {
        this.coloresEditor.put("fondo", ConfigColor.de("color_fondo_editor_plantilla", new Color(240, 240, 245)));
        this.coloresEditor.put("texto", ConfigColor.de("color_texto_editor_plantilla", new Color(50, 50, 50)));
        this.coloresEditor.put("caja_texto", ConfigColor.de("color_caja_texto_editor_plantilla", new Color(255, 255, 255)));
        this.coloresEditor.put("boton", ConfigColor.de("color_boton_editor_plantilla", new Color(220, 220, 230)));
        this.coloresEditor.put("borde", ConfigColor.de("color_borde_editor_plantilla", new Color(180, 180, 200)));
    }

    private void configurarBoton(JButton boton) {
        boton.setForeground(this.coloresEditor.get("texto").obtener());
        boton.setBackground(this.coloresEditor.get("boton").obtener());
        boton.setFont(new Font("Segoe UI", 0, 12));
        boton.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        boton.setFocusPainted(false);
    }

    @Override
    public void recargarApariencia() {
        SwingUtilities.updateComponentTreeUI(this);
        this.inicializarColoresEditor();
        if (this.getParent() != null) {
            this.inicializarComponentes();
            this.repaint();
        }
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ConfigColor borde;
        ConfigColor boton;
        ConfigColor cajaTexto;
        ConfigColor texto;
        ArrayList<ElementoConfig> configs = new ArrayList<ElementoConfig>();
        ConfigColor fondo = this.coloresEditor.get("fondo");
        if (fondo != null) {
            fondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
            configs.add(fondo);
        }
        if ((texto = this.coloresEditor.get("texto")) != null) {
            texto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
            configs.add(texto);
        }
        if ((cajaTexto = this.coloresEditor.get("caja_texto")) != null) {
            cajaTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorCajaTexto());
            configs.add(cajaTexto);
        }
        if ((boton = this.coloresEditor.get("boton")) != null) {
            boton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
            configs.add(boton);
        }
        if ((borde = this.coloresEditor.get("borde")) != null) {
            borde.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
            configs.add(borde);
        }
        if (this.enlacesMap != null && !this.enlacesMap.isEmpty()) {
            configs.addAll(this.enlacesMap.values());
        }
        return configs;
    }
}

