/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.editorgui;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.config.ConfigBoolean;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ConfigDouble;
import com.asbestosstar.crashdetector.config.ConfigString;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.editor.BotonRedondeadoTL;
import com.asbestosstar.crashdetector.gui.tipos.editorgui.EditorGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CDSkinCape
extends EditorGUI {
    public static String ID = "cdskincape";
    private static final Color TL_FONDO_IZQ = new Color(245, 249, 253);
    private static final Color TL_TEXTO = new Color(40, 40, 40);
    private static final Color TL_BOTON_PRIMARIO = new Color(76, 175, 80);
    private static final Color TL_BOTON_SECUNDARIO = new Color(220, 228, 236);
    private static final Color TL_BORDE = new Color(190, 200, 210);
    public ConfigColor tlBlanco = ConfigColor.de("tema.tl.color.blanco", Color.WHITE);
    public ConfigColor tlAzul = ConfigColor.de("tema.tl.color.azul", new Color(66, 133, 244));
    public ConfigColor tlRojo = ConfigColor.de("tema.tl.color.rojo", new Color(220, 53, 69));
    public ConfigColor tlFondoIzquierdo = ConfigColor.de("tema.tl.color.fondo_izquierdo", new Color(245, 248, 251));
    public ConfigColor colorFondo = ConfigColor.de("tema.cdskincape.editor.color.fondo", TL_FONDO_IZQ);
    public ConfigColor colorTexto = ConfigColor.de("tema.cdskincape.editor.color.texto", TL_TEXTO);
    public ConfigColor colorBoton = ConfigColor.de("tema.cdskincape.editor.color.boton", TL_BOTON_PRIMARIO);
    public ConfigColor colorCajaTexto = ConfigColor.de("tema.cdskincape.editor.color.caja_texto", Color.WHITE);
    public ConfigColor colorBorde = ConfigColor.de("tema.cdskincape.editor.color.borde", TL_BORDE);
    private JPanel panelConfiguracionGUI;

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void init() {
        this.inicializarInterfaz();
        this.setVisible(true);
    }

    private void inicializarInterfaz() {
        this.setTitle("CDSkinCape");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(1000, 650));
        this.setMinimumSize(new Dimension(900, 550));
        JPanel panelIzquierdo = new JPanel();
        panelIzquierdo.setLayout(new BoxLayout(panelIzquierdo, 1));
        panelIzquierdo.setPreferredSize(new Dimension(260, 0));
        panelIzquierdo.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        panelIzquierdo.setBackground(new Color(245, 248, 251));
        this.panelEdicion = new JPanel(new BorderLayout());
        this.panelEdicion.setPreferredSize(new Dimension(220, 260));
        this.panelEdicion.setMaximumSize(new Dimension(220, 260));
        this.panelEdicion.setBorder(BorderFactory.createLineBorder(this.colorBorde.obtener()));
        this.panelEdicion.setBackground(Color.WHITE);
        panelIzquierdo.add(this.panelEdicion);
        panelIzquierdo.add(Box.createVerticalStrut(12));
        JLabel lblTipo = new JLabel(MonitorDePID.idioma.tipo());
        panelIzquierdo.add(lblTipo);
        this.comboTipoGUI = new JComboBox();
        this.comboTipoGUI.setMaximumSize(new Dimension(Integer.MAX_VALUE, 28));
        this.comboTipoGUI.addActionListener(e -> this.actualizarComboGUI());
        panelIzquierdo.add(this.comboTipoGUI);
        panelIzquierdo.add(Box.createVerticalStrut(8));
        JLabel lblGui = new JLabel(MonitorDePID.idioma.gui());
        panelIzquierdo.add(lblGui);
        this.comboGUI = new JComboBox();
        this.comboGUI.setMaximumSize(new Dimension(Integer.MAX_VALUE, 28));
        this.comboGUI.addActionListener(e -> this.cargarGUISeleccionada());
        panelIzquierdo.add(this.comboGUI);
        panelIzquierdo.add(Box.createVerticalStrut(14));
        BotonRedondeadoTL botonMostrar = new BotonRedondeadoTL(MonitorDePID.idioma.botonMostrarGUI(), this.tlBlanco.obtener(), this.tlRojo.obtener(), this.tlRojo.obtener(), false);
        botonMostrar.setAlignmentX(0.5f);
        botonMostrar.addActionListener(e -> this.mostrarGUI());
        panelIzquierdo.add(botonMostrar);
        panelIzquierdo.add(Box.createVerticalStrut(8));
        BotonRedondeadoTL guardarTodo = new BotonRedondeadoTL(MonitorDePID.idioma.botonGuardarTodo(), this.tlBlanco.obtener(), this.tlAzul.obtener(), this.tlAzul.obtener(), false);
        guardarTodo.setAlignmentX(0.5f);
        guardarTodo.addActionListener(e -> this.guardarTodo());
        panelIzquierdo.add(guardarTodo);
        panelIzquierdo.add(Box.createVerticalStrut(8));
        BotonRedondeadoTL resetearTodo = new BotonRedondeadoTL(MonitorDePID.idioma.botonRestablecerTodo(), this.tlBlanco.obtener(), this.tlAzul.obtener(), this.tlAzul.obtener(), false);
        resetearTodo.setAlignmentX(0.5f);
        resetearTodo.addActionListener(e -> this.resetearTodo());
        panelIzquierdo.add(resetearTodo);
        this.add((Component)panelIzquierdo, "West");
        this.panelConfiguracionGUI = new JPanel(new BorderLayout());
        this.panelConfiguracionGUI.setBorder(BorderFactory.createTitledBorder("Configuraci\u00f3n"));
        this.panelConfiguracionGUI.setBackground(Color.WHITE);
        this.add((Component)this.panelConfiguracionGUI, "Center");
        for (TipoGUI tipo : TipoGUI.TIPOS_DE_GUI) {
            this.comboTipoGUI.addItem(tipo.id());
        }
    }

    private Object guardarTodo() {
        return null;
    }

    private JButton crearBotonTL(String texto, Color fondo, Color textoColor) {
        JButton b = new JButton(texto);
        b.setBackground(fondo);
        b.setForeground(textoColor);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setOpaque(true);
        b.setPreferredSize(new Dimension(180, 34));
        b.setMaximumSize(new Dimension(Integer.MAX_VALUE, 34));
        b.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(fondo.darker(), 1, true), BorderFactory.createEmptyBorder(6, 18, 6, 18)));
        return b;
    }

    @Override
    public void cargarGUISeleccionada() {
        super.cargarGUISeleccionada();
        this.actualizarPanelConfiguracionGUI();
    }

    private void actualizarPanelConfiguracionGUI() {
        this.panelConfiguracionGUI.removeAll();
        List<ElementoConfig> elementos = this.obtenerElementosConfigSeleccionados();
        if (elementos != null && !elementos.isEmpty()) {
            JPanel contenido = new JPanel();
            contenido.setLayout(new BoxLayout(contenido, 1));
            contenido.setBackground(Color.WHITE);
            for (ElementoConfig e : elementos) {
                JPanel fila = new JPanel(new BorderLayout(8, 0));
                fila.setBackground(Color.WHITE);
                JLabel nombre = new JLabel(e.obtenerNombreParaMostrar());
                fila.add((Component)nombre, "West");
                Component editor = this.crearComponenteEditable(e);
                if (editor != null) {
                    fila.add(editor, "Center");
                }
                JPanel acciones = new JPanel();
                acciones.setBackground(Color.WHITE);
                BotonRedondeadoTL reset = new BotonRedondeadoTL(MonitorDePID.idioma.restablecer(), this.tlAzul.obtener(), this.tlAzul.obtener(), Color.WHITE, true);
                reset.addActionListener(x -> {
                    e.resetearAPorDefecto();
                    this.actualizarPanelConfiguracionGUI();
                });
                acciones.add(reset);
                fila.add((Component)acciones, "East");
                contenido.add(fila);
                contenido.add(Box.createVerticalStrut(6));
            }
            this.panelConfiguracionGUI.add((Component)new JScrollPane(contenido), "Center");
        } else {
            this.panelConfiguracionGUI.add((Component)new JLabel(MonitorDePID.idioma.sinOpciones()), "Center");
        }
        this.panelConfiguracionGUI.revalidate();
        this.panelConfiguracionGUI.repaint();
    }

    private void resetearTodo() {
        if (JOptionPane.showConfirmDialog(this, MonitorDePID.idioma.confirmacionReEstablarTodos(), MonitorDePID.idioma.aceptar(), 0) != 0) {
            return;
        }
        List<ElementoConfig> elementos = this.obtenerElementosConfigSeleccionados();
        if (elementos == null) {
            return;
        }
        for (ElementoConfig e : elementos) {
            e.resetearAPorDefecto();
        }
        this.actualizarPanelConfiguracionGUI();
    }

    private Component crearComponenteEditable(final ElementoConfig<?> elemento) {
        if (elemento instanceof ConfigBoolean) {
            JCheckBox cb = new JCheckBox();
            cb.setSelected((Boolean)elemento.obtener());
            cb.addActionListener(e -> ((ConfigBoolean)elemento).escribir(cb.isSelected()));
            return cb;
        }
        if (elemento instanceof ConfigColor) {
            JPanel p = new JPanel(new BorderLayout(6, 0));
            final JTextField tf = new JTextField("#" + Integer.toHexString(((ConfigColor)elemento).obtener().getRGB()).substring(2));
            final JPanel preview = new JPanel();
            preview.setPreferredSize(new Dimension(18, 18));
            preview.setBackground(((ConfigColor)elemento).obtener());
            preview.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            preview.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Color nuevo = JColorChooser.showDialog(CDSkinCape.this, MonitorDePID.idioma.seleccionaColor(), ((ConfigColor)elemento).obtener());
                    if (nuevo != null) {
                        ((ConfigColor)elemento).escribir(nuevo);
                        preview.setBackground(nuevo);
                        tf.setText("#" + Integer.toHexString(nuevo.getRGB()).substring(2));
                    }
                }
            });
            tf.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.aplicar();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.aplicar();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.aplicar();
                }

                private void aplicar() {
                    try {
                        Color c = Color.decode(tf.getText());
                        ((ConfigColor)elemento).escribir(c);
                        preview.setBackground(c);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            p.add((Component)preview, "West");
            p.add((Component)tf, "Center");
            return p;
        }
        if (elemento instanceof ConfigDouble) {
            final JTextField tf = new JTextField(elemento.obtener().toString());
            tf.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.aplicar();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.aplicar();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.aplicar();
                }

                private void aplicar() {
                    try {
                        ((ConfigDouble)elemento).escribir(Double.parseDouble(tf.getText()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return tf;
        }
        if (elemento instanceof ConfigString) {
            final JTextField tf = new JTextField((String)elemento.obtener());
            tf.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ((ConfigString)elemento).escribir(tf.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ((ConfigString)elemento).escribir(tf.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ((ConfigString)elemento).escribir(tf.getText());
                }
            });
            return tf;
        }
        return new JLabel(String.valueOf(elemento.obtener()));
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> l = new ArrayList<ElementoConfig>();
        this.colorFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        this.colorCajaTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorCajaTexto());
        this.colorBorde.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
        l.add(this.colorFondo);
        l.add(this.colorTexto);
        l.add(this.colorBoton);
        l.add(this.colorCajaTexto);
        l.add(this.colorBorde);
        return l;
    }

    @Override
    public void recargarApariencia() {
        this.aplicarApariencia();
    }

    private void aplicarApariencia() {
        this.getContentPane().setBackground(this.colorFondo.obtener());
        this.revalidate();
        this.repaint();
    }

    @Override
    public void editarElemento(ElementoConfig<?> elemento) {
    }
}

