/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.editorgui;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.compartir.DialogoCompartir;
import com.asbestosstar.crashdetector.gui.tipos.no_registro_lanzador.NoRegistroLanzadorGUI;
import com.asbestosstar.crashdetector.gui.tipos.principal.PrincipalGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class EditorGUI
extends JFrame
implements CrashDetectorGUI {
    public static Map<String, Supplier<EditorGUI>> GUIS = new HashMap<String, Supplier<EditorGUI>>();
    public JComboBox<String> comboTipoGUI;
    public JComboBox<String> comboGUI;
    public JPanel panelEdicion;

    protected void inicializarComponentesBase() {
        this.comboTipoGUI = new JComboBox();
        this.comboTipoGUI.addActionListener(e -> this.actualizarComboGUI());
        this.comboGUI = new JComboBox();
        this.comboGUI.addActionListener(e -> this.cargarGUISeleccionada());
        this.panelEdicion = new JPanel();
        this.panelEdicion.setLayout(new BorderLayout());
    }

    protected void actualizarComboGUI() {
        long inicioTotal = System.currentTimeMillis();
        String tipoSeleccionado = (String)this.comboTipoGUI.getSelectedItem();
        if (tipoSeleccionado == null) {
            return;
        }
        CrashDetectorLogger.log("EditorGUI: cambiando tipo de GUI a: " + tipoSeleccionado);
        this.comboGUI.removeAllItems();
        long t0 = System.currentTimeMillis();
        TipoGUI<?> tipo = this.obtenerTipoGUI(tipoSeleccionado);
        long t1 = System.currentTimeMillis();
        CrashDetectorLogger.log("EditorGUI: obtenerTipoGUI tard\u00f3 " + (t1 - t0) + " ms");
        if (tipo != null) {
            long t2 = System.currentTimeMillis();
            Map<String, Supplier<?>> guis = tipo.obtenerGUIs();
            long t3 = System.currentTimeMillis();
            CrashDetectorLogger.log("EditorGUI: tipo.obtenerGUIs() tard\u00f3 " + (t3 - t2) + " ms");
            CrashDetectorLogger.log("EditorGUI: cantidad de GUIs encontradas: " + guis.size());
            for (String id : guis.keySet()) {
                long ti = System.currentTimeMillis();
                CrashDetectorLogger.log("EditorGUI: agregando GUI: " + id);
                this.comboGUI.addItem(id);
                long tf = System.currentTimeMillis();
                if (tf - ti <= 50L) continue;
                CrashDetectorLogger.log("EditorGUI: agregar GUI '" + id + "' tard\u00f3 " + (tf - ti) + " ms");
            }
        }
        long finTotal = System.currentTimeMillis();
        CrashDetectorLogger.log("EditorGUI: actualizaci\u00f3n completa del combo en " + (finTotal - inicioTotal) + " ms");
    }

    public void cargarGUISeleccionada() {
        CrashDetectorGUI gui;
        Supplier<?> supplier;
        String tipoSeleccionado = (String)this.comboTipoGUI.getSelectedItem();
        String guiSeleccionada = (String)this.comboGUI.getSelectedItem();
        if (tipoSeleccionado == null || guiSeleccionada == null) {
            return;
        }
        TipoGUI<?> tipo = this.obtenerTipoGUI(tipoSeleccionado);
        if (tipo != null && (supplier = tipo.obtenerGUIs().get(guiSeleccionada)) != null && (gui = (CrashDetectorGUI)supplier.get()) != null) {
            this.panelEdicion.removeAll();
            if (gui instanceof JFrame) {
                JFrame frame = (JFrame)((Object)gui);
                frame.setDefaultCloseOperation(3);
                this.panelEdicion.add((Component)frame.getContentPane(), "Center");
            } else if (gui instanceof JPanel) {
                JPanel panel = (JPanel)((Object)gui);
                this.panelEdicion.add((Component)panel, "Center");
            } else if (gui instanceof JDialog) {
                JDialog dialog = (JDialog)((Object)gui);
                this.panelEdicion.add((Component)dialog.getContentPane(), "Center");
            } else {
                this.panelEdicion.add((Component)((Object)gui), "Center");
            }
            this.panelEdicion.revalidate();
            this.panelEdicion.repaint();
        }
    }

    protected TipoGUI<?> obtenerTipoGUI(String nombre) {
        CrashDetectorLogger.log("EditorGUI: buscando TipoGUI: " + nombre);
        for (TipoGUI tipo : TipoGUI.TIPOS_DE_GUI) {
            if (!tipo.id().equals(nombre)) continue;
            return tipo;
        }
        return null;
    }

    protected void mostrarGUI() {
        String tipoSeleccionado = (String)this.comboTipoGUI.getSelectedItem();
        String guiSeleccionada = (String)this.comboGUI.getSelectedItem();
        if (tipoSeleccionado == null || guiSeleccionada == null) {
            return;
        }
        TipoGUI<?> tipo = this.obtenerTipoGUI(tipoSeleccionado);
        if (tipo != null) {
            CrashDetectorGUI gui = tipo.obtenerGUIPredeterminado(guiSeleccionada, () -> {
                throw new RuntimeException("No se pudo crear la GUI: " + guiSeleccionada);
            });
            if (gui instanceof PrincipalGUI || gui instanceof DialogoCompartir || gui instanceof NoRegistroLanzadorGUI) {
                return;
            }
            gui.init();
        }
    }

    protected List<ElementoConfig> obtenerElementosConfigSeleccionados() {
        CrashDetectorGUI gui;
        Supplier<?> supplier;
        String tipoSeleccionado = (String)this.comboTipoGUI.getSelectedItem();
        String guiSeleccionada = (String)this.comboGUI.getSelectedItem();
        if (tipoSeleccionado == null || guiSeleccionada == null) {
            return null;
        }
        TipoGUI<?> tipo = this.obtenerTipoGUI(tipoSeleccionado);
        if (tipo != null && (supplier = tipo.obtenerGUIs().get(guiSeleccionada)) != null && (gui = (CrashDetectorGUI)supplier.get()) != null) {
            try {
                List<ElementoConfig> elementos = gui.obtenerElementosConfigs();
                if (elementos != null) {
                    CrashDetectorLogger.log("No Null listo de elementos " + String.valueOf(elementos.size()));
                    ArrayList<ElementoConfig> elementosFiltrados = new ArrayList<ElementoConfig>();
                    for (ElementoConfig elem : elementos) {
                        if (elem == null) continue;
                        elementosFiltrados.add(elem);
                    }
                    CrashDetectorLogger.log("filtrados " + String.valueOf(elementosFiltrados.size()));
                    return elementosFiltrados;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public abstract void editarElemento(ElementoConfig<?> var1);

    @Override
    public TipoGUI tipo() {
        return TipoGUI.EDITOR_GUI;
    }

    @Override
    public abstract void init();

    @Override
    public abstract String id();

    @Override
    public abstract void recargarApariencia();
}

