/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.grepr;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.grepr.BusquedaArchivos;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;

public abstract class GrepRGUI
extends JFrame
implements CrashDetectorGUI,
BotonDeBarraLateralDerecha {
    public static Map<String, Supplier<GrepRGUI>> GUIS = new HashMap<String, Supplier<GrepRGUI>>();
    public JTextField campoDirectorio;
    public JTextField campoCadena;
    public JCheckBox chkRegex;
    public JCheckBox chkIgnorarMayus;
    public JCheckBox chkBuscarEnComprimidos;
    public JTextArea areaResultados;
    public ConfigColor colorFondoVentana;
    public ConfigColor colorPanel;
    public ConfigColor colorTexto;
    public ConfigColor colorBoton;
    public ConfigColor colorBotonTexto;
    public ConfigColor colorCampo;
    public ConfigColor colorBordeDestacado;
    public ConfigColor colorSeleccionTexto;
    public ConfigColor colorTextoSeleccionado;

    public JLabel crearImagenEscalada(String ruta, int w, int h) {
        File f = new File(ruta);
        if (!f.isAbsolute()) {
            f = new File(System.getProperty("user.dir"), ruta);
        }
        if (f.exists() && f.isFile()) {
            ImageIcon base = new ImageIcon(f.getAbsolutePath());
            Image esc = base.getImage().getScaledInstance(w, h, 4);
            return new JLabel(new ImageIcon(esc));
        }
        URL url = this.getClass().getClassLoader().getResource(ruta);
        if (url != null) {
            ImageIcon base = new ImageIcon(url);
            Image esc = base.getImage().getScaledInstance(w, h, 4);
            return new JLabel(new ImageIcon(esc));
        }
        JLabel fallo = new JLabel("imagen no encontrada " + ruta);
        fallo.setForeground(this.colorTexto.obtener());
        return fallo;
    }

    public void estilizarBoton(JButton b) {
        b.setBackground(this.colorBoton.obtener());
        b.setForeground(this.colorBotonTexto.obtener());
        b.setFocusPainted(false);
        b.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.colorBordeDestacado.obtener(), 1), BorderFactory.createEmptyBorder(6, 12, 6, 12)));
    }

    public void estilizarCampo(JTextField f) {
        f.setBackground(this.colorCampo.obtener());
        f.setForeground(this.colorTexto.obtener());
        f.setCaretColor(this.colorTexto.obtener());
        f.setSelectionColor(this.colorSeleccionTexto.obtener());
        f.setSelectedTextColor(this.colorTextoSeleccionado.obtener());
        f.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.colorBordeDestacado.obtener(), 1), BorderFactory.createEmptyBorder(4, 8, 4, 8)));
    }

    public void estilizarCheck(JCheckBox c) {
        c.setBackground(this.colorPanel.obtener());
        c.setForeground(this.colorTexto.obtener());
        c.setFocusPainted(false);
    }

    public void seleccionarCarpeta() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            this.campoDirectorio.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void iniciarBusqueda() {
        String dirCrudo = this.campoDirectorio.getText().trim();
        final String directorio = dirCrudo.replace(" ", "").isEmpty() ? System.getProperty("user.dir") : dirCrudo;
        final String cadena = this.campoCadena.getText().trim();
        final boolean usarRegex = this.chkRegex.isSelected();
        final boolean ignorarMayus = this.chkIgnorarMayus.isSelected();
        final boolean buscarEnComprimidos = this.chkBuscarEnComprimidos.isSelected();
        this.areaResultados.setText(MonitorDePID.idioma.busquedaEnProgreso() + "\n");
        new SwingWorker<List<String>, Void>(){

            @Override
            protected List<String> doInBackground() {
                return BusquedaArchivos.buscar(directorio, cadena, usarRegex, ignorarMayus, buscarEnComprimidos);
            }

            @Override
            protected void done() {
                try {
                    List resultados = (List)this.get();
                    GrepRGUI.this.areaResultados.setText("");
                    if (resultados.isEmpty()) {
                        GrepRGUI.this.areaResultados.append(MonitorDePID.idioma.noSeEncontraronResultados());
                    } else {
                        for (String r : resultados) {
                            GrepRGUI.this.areaResultados.append(r + "\n");
                        }
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    GrepRGUI.this.areaResultados.append(MonitorDePID.idioma.errorBusqueda() + e.getMessage());
                }
            }
        }.execute();
    }

    @Override
    public TipoGUI tipo() {
        return TipoGUI.GREPR;
    }

    @Override
    public void recargarApariencia() {
    }

    public void aplicarEstilos() {
        this.setTitle("grepr/fgrepr");
        this.setLayout(new BorderLayout(10, 10));
        this.getContentPane().setBackground(this.colorFondoVentana.obtener());
        GridBagLayout gbl = new GridBagLayout();
        JPanel panelEntrada = new JPanel(gbl);
        panelEntrada.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panelEntrada.setBackground(this.colorPanel.obtener());
        GridBagConstraints L = new GridBagConstraints();
        L.insets = new Insets(0, 0, 0, 8);
        L.fill = 2;
        L.weightx = 0.4;
        L.anchor = 17;
        GridBagConstraints R = new GridBagConstraints();
        R.insets = new Insets(5, 8, 5, 0);
        R.fill = 2;
        R.weightx = 0.6;
        R.anchor = 17;
        this.campoDirectorio = new JTextField();
        this.estilizarCampo(this.campoDirectorio);
        L.gridx = 0;
        L.gridy = 0;
        panelEntrada.add((Component)this.campoDirectorio, L);
        JButton btnExaminar = new JButton(MonitorDePID.idioma.seleccionarCarpeta());
        this.estilizarBoton(btnExaminar);
        btnExaminar.addActionListener(e -> this.seleccionarCarpeta());
        R.gridx = 1;
        R.gridy = 0;
        panelEntrada.add((Component)btnExaminar, R);
        JLabel lblCadena = new JLabel(MonitorDePID.idioma.cadenaBusqueda());
        lblCadena.setForeground(this.colorTexto.obtener());
        L.gridx = 0;
        L.gridy = 1;
        panelEntrada.add((Component)lblCadena, L);
        this.campoCadena = new JTextField();
        this.estilizarCampo(this.campoCadena);
        R.gridx = 1;
        R.gridy = 1;
        panelEntrada.add((Component)this.campoCadena, R);
        this.chkRegex = new JCheckBox(MonitorDePID.idioma.usarRegex());
        this.estilizarCheck(this.chkRegex);
        L.gridx = 0;
        L.gridy = 2;
        panelEntrada.add((Component)this.chkRegex, L);
        this.chkIgnorarMayus = new JCheckBox(MonitorDePID.idioma.ignorarMayusculas());
        this.estilizarCheck(this.chkIgnorarMayus);
        R.gridx = 1;
        R.gridy = 2;
        panelEntrada.add((Component)this.chkIgnorarMayus, R);
        this.chkBuscarEnComprimidos = new JCheckBox(MonitorDePID.idioma.buscarDentroDeComprimidos());
        this.estilizarCheck(this.chkBuscarEnComprimidos);
        L.gridx = 0;
        L.gridy = 3;
        panelEntrada.add((Component)this.chkBuscarEnComprimidos, L);
        JLabel lblImagen = this.crearImagenEscalada(Statics.carpeta.resolve("imagenes/saliormoongrep.png").toString(), 150, 100);
        lblImagen.setOpaque(true);
        lblImagen.setBackground(this.colorPanel.obtener());
        lblImagen.setPreferredSize(new Dimension(150, 100));
        R.gridx = 1;
        R.gridy = 3;
        panelEntrada.add((Component)lblImagen, R);
        JButton btnBuscar = new JButton(MonitorDePID.idioma.buscar());
        this.estilizarBoton(btnBuscar);
        btnBuscar.addActionListener(e -> this.iniciarBusqueda());
        L.gridx = 0;
        L.gridy = 4;
        panelEntrada.add((Component)btnBuscar, L);
        R.gridx = 1;
        R.gridy = 4;
        R.weightx = 0.6;
        panelEntrada.add((Component)new JLabel(), R);
        this.areaResultados = new JTextArea();
        this.areaResultados.setEditable(false);
        this.areaResultados.setBackground(this.colorCampo.obtener());
        this.areaResultados.setForeground(this.colorTexto.obtener());
        this.areaResultados.setCaretColor(this.colorTexto.obtener());
        this.areaResultados.setSelectionColor(this.colorSeleccionTexto.obtener());
        this.areaResultados.setSelectedTextColor(this.colorTextoSeleccionado.obtener());
        JScrollPane scroll = new JScrollPane(this.areaResultados);
        scroll.getViewport().setBackground(this.colorCampo.obtener());
        scroll.setBackground(this.colorPanel.obtener());
        scroll.setBorder(BorderFactory.createLineBorder(this.colorBordeDestacado.obtener(), 1));
        this.add((Component)panelEntrada, "North");
        this.add((Component)scroll, "Center");
        this.revalidate();
        this.repaint();
    }
}

