/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.historia;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.historia.HistoriaDeModsGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;

public class ClioOfficeGUI
extends HistoriaDeModsGUI {
    public static String ID = "cliosoffice";
    private static final long serialVersionUID = 1L;
    private BufferedImage imagenFondo;
    private int anchoDiseno = 1200;
    private int altoDiseno = 800;
    public ConfigColor colorEstadoExito;
    public ConfigColor colorEstadoFallo;
    public ConfigColor colorEstadoInstantanea;
    public ConfigColor colorResultadoAnadido;
    public ConfigColor colorResultadoEliminado;
    public ConfigColor colorBordeScroll;
    public ConfigColor colorFondoPanel;
    public ConfigColor colorBeigeListas;
    public ConfigColor colorTextoListas;
    public ConfigColor colorBordeListas;
    public ConfigColor colorBotonFondo;
    public ConfigColor colorBotonTexto;
    public ConfigColor colorBordeBoton;
    public ConfigColor colorDoradoTexto;
    private JPanel panelLista1;
    private JPanel panelLista2;
    private JPanel panelResultados;
    private JPanel panelDescripcion;
    private JPanel panelBotones;
    private JPanel panelLista2Contenido;
    private JButton botonComparar;
    private JButton botonInstantanea;
    private JScrollPane scrollLista1;
    private JScrollPane scrollLista2;
    private JScrollPane scrollResultados;
    private static final double[] R_LISTA1 = new double[]{0.03, 0.03, 0.142, 0.69};
    private static final double[] R_LISTA2 = new double[]{0.274, 0.035, 0.142, 0.69};
    private static final double[] R_RESULT = new double[]{0.675, 0.17, 0.315, 0.58};
    private static final double[] R_BOTONES = new double[]{0.025, 0.89, 0.3, 0.07};
    private static final double[] R_DESC = new double[]{0.33, 0.89, 0.645, 0.07};

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void init() {
        this.colorEstadoExito = ConfigColor.de("tema.cliosoffice.color.estado.exito", new Color(76, 175, 80));
        this.colorEstadoFallo = ConfigColor.de("tema.cliosoffice.color.estado.fallo", new Color(244, 67, 54));
        this.colorEstadoInstantanea = ConfigColor.de("tema.cliosoffice.color.estado.instantanea", new Color(33, 150, 243));
        this.colorResultadoAnadido = ConfigColor.de("tema.cliosoffice.color.resultado.anadido", new Color(46, 125, 50));
        this.colorResultadoEliminado = ConfigColor.de("tema.cliosoffice.color.resultado.eliminado", new Color(198, 40, 40));
        this.colorBordeScroll = ConfigColor.de("tema.cliosoffice.color.borde.scroll", new Color(221, 221, 221));
        this.colorFondoPanel = ConfigColor.de("tema.cliosoffice.color.fondo.panel", new Color(255, 255, 255));
        this.colorBeigeListas = ConfigColor.de("tema.cliosoffice.color.beige.listas", new Color(235, 215, 192));
        this.colorTextoListas = ConfigColor.de("tema.cliosoffice.color.texto.listas", Color.DARK_GRAY);
        this.colorBordeListas = ConfigColor.de("tema.cliosoffice.color.borde.listas", new Color(204, 188, 165));
        this.colorBotonFondo = ConfigColor.de("tema.cliosoffice.color.boton.fondo", new Color(233, 216, 196));
        this.colorBotonTexto = ConfigColor.de("tema.cliosoffice.color.boton.texto", new Color(43, 33, 31));
        this.colorBordeBoton = ConfigColor.de("tema.cliosoffice.color.boton.borde", new Color(183, 166, 147));
        this.colorDoradoTexto = ConfigColor.de("tema.cliosoffice.color.dorado.texto", new Color(201, 160, 68));
        this.cargarImagenFondo();
        this.setTitle(MonitorDePID.idioma.historialDeMods());
        this.setSize(1200, 800);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.construirEstructuraBase();
        this.cargarArchivosHistoricos();
        this.aplicarApariencia();
        this.panelPrincipal.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ClioOfficeGUI.this.relayout();
            }
        });
        this.setVisible(true);
        this.relayout();
    }

    private void cargarImagenFondo() {
        try {
            Path ruta = Statics.carpeta.resolve("imagenes/cliosoffice.png");
            if (!Files.exists(ruta, new LinkOption[0])) {
                MonitorDePID.copiarACarpetaDesdeJar("/imagenes/cliosoffice.png", ruta.toFile());
            }
            if (Files.exists(ruta, new LinkOption[0])) {
                this.imagenFondo = ImageIO.read(ruta.toFile());
                this.anchoDiseno = this.imagenFondo.getWidth();
                this.altoDiseno = this.imagenFondo.getHeight();
            } else {
                CrashDetectorLogger.log("No se encontr\u00f3 la imagen de fondo cliosoffice.png");
            }
        }
        catch (IOException e) {
            CrashDetectorLogger.log("Error cargando imagen de fondo: " + e.getMessage());
            this.imagenFondo = null;
        }
    }

    @Override
    protected void construirEstructuraBase() {
        this.panelPrincipal = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (ClioOfficeGUI.this.imagenFondo != null) {
                    g.drawImage(ClioOfficeGUI.this.imagenFondo, 0, 0, this.getWidth(), this.getHeight(), this);
                }
            }
        };
        this.panelPrincipal.setLayout(null);
        this.add((Component)this.panelPrincipal, "Center");
        this.panelLista1 = new JPanel(new BorderLayout());
        this.panelLista1.setOpaque(false);
        this.panelLista1.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.panelPrincipal.add(this.panelLista1);
        this.panelLista2 = new JPanel(new BorderLayout());
        this.panelLista2.setOpaque(false);
        this.panelLista2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.panelPrincipal.add(this.panelLista2);
        this.panelResultados = new JPanel(new BorderLayout());
        this.panelResultados.setOpaque(false);
        this.panelResultados.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.panelPrincipal.add(this.panelResultados);
        this.panelDescripcion = new JPanel(new BorderLayout());
        this.panelDescripcion.setOpaque(false);
        this.panelDescripcion.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.panelPrincipal.add(this.panelDescripcion);
        this.panelBotones = new JPanel(new FlowLayout(0, 14, 6));
        this.panelBotones.setOpaque(false);
        this.panelPrincipal.add(this.panelBotones);
        this.scrollLista1 = this.crearScrollConFondoListas();
        this.panelLista1.add((Component)this.scrollLista1, "Center");
        this.scrollLista2 = this.crearScrollConFondoListas();
        this.panelLista2.add((Component)this.scrollLista2, "Center");
        this.scrollResultados = ClioOfficeGUI.crearScrollTransparenteSinBorde();
        this.panelResultados.add((Component)this.scrollResultados, "Center");
        this.resultadoPanel = new JTextPane();
        this.resultadoPanel.setContentType("text/html");
        this.resultadoPanel.setEditable(false);
        this.resultadoPanel.setOpaque(false);
        this.scrollResultados.setViewportView(this.resultadoPanel);
        this.botonComparar = new JButton(MonitorDePID.idioma.comparar());
        this.botonInstantanea = new JButton(MonitorDePID.idioma.instantanea());
        this.estilizarBoton(this.botonComparar);
        this.estilizarBoton(this.botonInstantanea);
        this.panelBotones.add(this.botonComparar);
        this.panelBotones.add(this.botonInstantanea);
        this.descripcionHTML = new JTextPane();
        this.descripcionHTML.setContentType("text/html");
        this.descripcionHTML.setEditable(false);
        this.descripcionHTML.setOpaque(false);
        this.descripcionHTML.setBorder(null);
        this.actualizarDescripcion();
        this.panelDescripcion.add((Component)this.descripcionHTML, "Center");
        this.botonComparar.addActionListener(e -> this.compararArchivosSeleccionados());
        this.botonInstantanea.addActionListener(e -> this.crearInstantanea());
        this.grupoIzquierdo = new ButtonGroup();
        this.grupoDerecho = new ButtonGroup();
        this.panelIzquierdo = new JPanel();
        this.panelIzquierdo.setLayout(new BoxLayout(this.panelIzquierdo, 1));
        this.panelIzquierdo.setOpaque(true);
        this.panelIzquierdo.setBackground(this.colorBeigeListas.obtener());
        this.scrollLista1.setViewportView(this.panelIzquierdo);
        this.panelLista2Contenido = new JPanel();
        this.panelLista2Contenido.setLayout(new BoxLayout(this.panelLista2Contenido, 1));
        this.panelLista2Contenido.setOpaque(true);
        this.panelLista2Contenido.setBackground(this.colorBeigeListas.obtener());
        this.scrollLista2.setViewportView(this.panelLista2Contenido);
    }

    private static JScrollPane crearScrollTransparenteSinBorde() {
        JScrollPane sp = new JScrollPane();
        sp.setHorizontalScrollBarPolicy(31);
        sp.setVerticalScrollBarPolicy(20);
        sp.setOpaque(false);
        sp.setBorder(BorderFactory.createEmptyBorder());
        JViewport vp = sp.getViewport();
        if (vp != null) {
            vp.setOpaque(false);
        }
        return sp;
    }

    private JScrollPane crearScrollConFondoListas() {
        JScrollPane sp = new JScrollPane();
        sp.setHorizontalScrollBarPolicy(31);
        sp.setVerticalScrollBarPolicy(20);
        sp.setOpaque(true);
        sp.getViewport().setOpaque(true);
        sp.getViewport().setBackground(this.colorBeigeListas.obtener());
        sp.setBorder(BorderFactory.createLineBorder(this.colorBordeListas.obtener()));
        return sp;
    }

    private void estilizarBoton(JButton b) {
        b.setFont(new Font("SansSerif", 1, 14));
        b.setBackground(this.colorBotonFondo.obtener());
        b.setForeground(this.colorBotonTexto.obtener());
        b.setOpaque(true);
        b.setBorder(BorderFactory.createLineBorder(this.colorBordeBoton.obtener(), 2));
        b.setFocusPainted(false);
        b.setPreferredSize(new Dimension(140, 38));
        b.setMargin(new Insets(6, 12, 6, 12));
    }

    private void relayout() {
        int W = this.panelPrincipal.getWidth();
        int H = this.panelPrincipal.getHeight();
        if (W <= 0 || H <= 0) {
            return;
        }
        ClioOfficeGUI.setBoundsNorm(this.panelLista1, R_LISTA1, W, H);
        ClioOfficeGUI.setBoundsNorm(this.panelLista2, R_LISTA2, W, H);
        ClioOfficeGUI.setBoundsNorm(this.panelResultados, R_RESULT, W, H);
        ClioOfficeGUI.setBoundsNorm(this.panelBotones, R_BOTONES, W, H);
        ClioOfficeGUI.setBoundsNorm(this.panelDescripcion, R_DESC, W, H);
        this.panelPrincipal.revalidate();
        this.panelPrincipal.repaint();
    }

    private static void setBoundsNorm(JPanel p, double[] r, int W, int H) {
        int x = (int)Math.round(r[0] * (double)W);
        int y = (int)Math.round(r[1] * (double)H);
        int w = (int)Math.round(r[2] * (double)W);
        int h = (int)Math.round(r[3] * (double)H);
        p.setBounds(x, y, w, h);
    }

    @Override
    protected void estilizarRadioArchivo(JRadioButton radio) {
        radio.setFont(new Font("SansSerif", 0, 12));
        radio.setOpaque(true);
        radio.setBackground(this.colorBeigeListas.obtener());
        radio.setForeground(this.colorTextoListas.obtener());
    }

    @Override
    protected void estilizarEstadoArchivo(JLabel estado) {
        estado.setFont(new Font("SansSerif", 0, 11));
        estado.setOpaque(false);
    }

    @Override
    protected void aplicarApariencia() {
        if (this.descripcionHTML != null) {
            this.descripcionHTML.setMargin(new Insets(2, 6, 2, 6));
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> l = new ArrayList<ElementoConfig>();
        this.colorEstadoExito.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorEstadoExito());
        this.colorEstadoFallo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorEstadoFallo());
        this.colorEstadoInstantanea.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorEstadoInstantanea());
        this.colorResultadoAnadido.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorResultadoAnadido());
        this.colorResultadoEliminado.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorResultadoEliminado());
        this.colorBordeScroll.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBordeScroll());
        this.colorFondoPanel.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoPanel());
        this.colorBeigeListas.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBeigeListas());
        this.colorTextoListas.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTextoListas());
        this.colorBordeListas.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBordeListas());
        this.colorBotonFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBotonFondo());
        this.colorBotonTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBotonTexto());
        this.colorBordeBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBordeBoton());
        this.colorDoradoTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorDoradoTexto());
        l.add(this.colorEstadoExito);
        l.add(this.colorEstadoFallo);
        l.add(this.colorEstadoInstantanea);
        l.add(this.colorResultadoAnadido);
        l.add(this.colorResultadoEliminado);
        l.add(this.colorBordeScroll);
        l.add(this.colorFondoPanel);
        l.add(this.colorBeigeListas);
        l.add(this.colorTextoListas);
        l.add(this.colorBordeListas);
        l.add(this.colorBotonFondo);
        l.add(this.colorBotonTexto);
        l.add(this.colorBordeBoton);
        l.add(this.colorDoradoTexto);
        return l;
    }

    @Override
    protected void cargarArchivosHistoricos() {
        try {
            File[] archivos;
            Path dir = Statics.carpeta.resolve("historia_mods");
            if (Files.exists(dir, new LinkOption[0]) && (archivos = dir.toFile().listFiles((d, name) -> name.matches("\\d{6}\\.falla") || name.matches("\\d{6}\\.exito") || name.matches("\\d{6}\\.instantanea"))) != null && archivos.length > 0) {
                JPanel fila;
                Arrays.sort(archivos, (f1, f2) -> {
                    int n1 = Integer.parseInt(f1.getName().substring(0, 6));
                    int n2 = Integer.parseInt(f2.getName().substring(0, 6));
                    return Integer.compare(n2, n1);
                });
                if (this.panelIzquierdo != null) {
                    this.panelIzquierdo.removeAll();
                }
                if (this.panelLista2Contenido != null) {
                    this.panelLista2Contenido.removeAll();
                }
                this.grupoIzquierdo = new ButtonGroup();
                this.grupoDerecho = new ButtonGroup();
                for (File f : archivos) {
                    fila = this.crearLineaArchivo(f, this.grupoIzquierdo);
                    this.formatearFilaNombre(fila, f);
                    if (this.panelIzquierdo == null) continue;
                    this.panelIzquierdo.add(fila);
                }
                for (File f : archivos) {
                    fila = this.crearLineaArchivo(f, this.grupoDerecho);
                    this.formatearFilaNombre(fila, f);
                    if (this.panelLista2Contenido == null) continue;
                    this.panelLista2Contenido.add(fila);
                }
                if (this.panelIzquierdo != null) {
                    this.panelIzquierdo.revalidate();
                }
                if (this.panelLista2Contenido != null) {
                    this.panelLista2Contenido.revalidate();
                }
            }
        }
        catch (Exception e) {
            CrashDetectorLogger.log("Error cargando archivos hist\u00f3ricos: " + e.getMessage());
        }
    }

    private void formatearFilaNombre(JPanel fila, File f) {
        JRadioButton rb = null;
        JLabel lbl = null;
        for (Component c : fila.getComponents()) {
            if (c instanceof JRadioButton) {
                rb = (JRadioButton)c;
            }
            if (!(c instanceof JLabel)) continue;
            lbl = (JLabel)c;
        }
        if (rb != null) {
            String nombre = f.getName();
            int i = nombre.lastIndexOf(46);
            String base = i > 0 ? nombre.substring(0, i) : nombre;
            String numero = base.replaceFirst("^0+(?!$)", "");
            rb.setText(numero);
        }
        if (lbl != null) {
            String ext = "";
            String n = f.getName();
            int p = n.lastIndexOf(46);
            if (p > 0) {
                ext = n.substring(p + 1);
            }
            switch (ext) {
                case "exito": {
                    lbl.setText(" (\u00c9xito)");
                    break;
                }
                case "instantanea": {
                    lbl.setText(" (Instant\u00e1nea)");
                    break;
                }
                default: {
                    lbl.setText(" (Fall\u00f3)");
                }
            }
        }
    }

    private void actualizarDescripcion() {
        String html = "<html><body style='font-family:sans-serif;font-size:12px;color:" + ClioOfficeGUI.aHex(this.colorDoradoTexto.obtener()) + ";'>" + MonitorDePID.idioma.historaDeModsDesc() + "</body></html>";
        if (this.descripcionHTML != null) {
            this.descripcionHTML.setText(html);
        }
    }

    private static String aHex(Color c) {
        return String.format("#%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
    }

    @Override
    public void recargarApariencia() {
        this.aplicarApariencia();
        this.actualizarDescripcion();
        this.relayout();
    }
}

