/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.historia;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import java.awt.Color;
import java.awt.FlowLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public abstract class HistoriaDeModsGUI
extends JFrame
implements CrashDetectorGUI,
BotonDeBarraLateralDerecha {
    private static final long serialVersionUID = 1L;
    public static Map<String, Supplier<HistoriaDeModsGUI>> GUIS = new HashMap<String, Supplier<HistoriaDeModsGUI>>();
    public ConfigColor colorEstadoExito = ConfigColor.de("tema.base.historia_mods.color.estado.exito", Color.GREEN);
    public ConfigColor colorEstadoFallo = ConfigColor.de("tema.base.historia_mods.color.estado.fallo", Color.RED);
    public ConfigColor colorEstadoInstantanea = ConfigColor.de("tema.base.historia_mods.color.estado.instantanea", Color.BLUE);
    public ConfigColor colorResultadoAnadido = ConfigColor.de("tema.base.historia_mods.color.resultado.anadido", Color.GREEN);
    public ConfigColor colorResultadoEliminado = ConfigColor.de("tema.base.historia_mods.color.resultado.eliminado", Color.RED);
    public ConfigColor colorBordeScroll = ConfigColor.de("tema.base.historia_mods.color.borde.scroll", Color.LIGHT_GRAY);
    public ConfigColor colorFondoPanel = ConfigColor.de("tema.base.historia_mods.color.fondo.panel", Color.WHITE);
    public JPanel panelPrincipal;
    public JPanel panelSuperior;
    public JPanel panelIzquierdo;
    public JPanel panelDerecho;
    public ButtonGroup grupoIzquierdo;
    public ButtonGroup grupoDerecho;
    public JTextPane resultadoPanel;
    public JButton botonComparar;
    public JButton botonInstantanea;
    public JScrollPane scrollIzquierdo;
    public JScrollPane scrollDerecho;
    public JScrollPane scrollResultado;
    public JPanel panelInferior;
    public JTextPane descripcionHTML;

    protected abstract void construirEstructuraBase();

    protected void cargarArchivosHistoricos() {
        try {
            File[] archivos;
            Path directorioHistorial = Statics.carpeta.resolve("historia_mods");
            if (Files.exists(directorioHistorial, new LinkOption[0]) && (archivos = directorioHistorial.toFile().listFiles((dir, name) -> name.matches("\\d{6}\\.falla") || name.matches("\\d{6}\\.exito") || name.matches("\\d{6}\\.instantanea"))) != null && archivos.length > 0) {
                Arrays.sort(archivos, (f1, f2) -> {
                    int num1 = Integer.parseInt(f1.getName().substring(0, 6));
                    int num2 = Integer.parseInt(f2.getName().substring(0, 6));
                    return Integer.compare(num2, num1);
                });
                if (this.panelIzquierdo != null) {
                    this.panelIzquierdo.removeAll();
                }
                if (this.panelDerecho != null) {
                    this.panelDerecho.removeAll();
                }
                this.grupoIzquierdo = new ButtonGroup();
                this.grupoDerecho = new ButtonGroup();
                for (File f : archivos) {
                    if (this.panelIzquierdo == null) continue;
                    this.panelIzquierdo.add(this.crearLineaArchivo(f, this.grupoIzquierdo));
                }
                for (File f : archivos) {
                    if (this.panelDerecho == null) continue;
                    this.panelDerecho.add(this.crearLineaArchivo(f, this.grupoDerecho));
                }
                if (this.panelIzquierdo != null) {
                    this.panelIzquierdo.revalidate();
                }
                if (this.panelDerecho != null) {
                    this.panelDerecho.revalidate();
                }
                this.scrollHastaFinal(this.scrollIzquierdo);
                this.scrollHastaFinal(this.scrollDerecho);
            }
        }
        catch (Exception e) {
            CrashDetectorLogger.log("Error cargando archivos hist\u00f3ricos: " + e.getMessage());
        }
    }

    protected JPanel crearLineaArchivo(File archivo, ButtonGroup grupo) {
        JPanel linea = new JPanel(new FlowLayout(0, 5, 0));
        linea.setOpaque(false);
        JRadioButton radio = new JRadioButton(archivo.getName());
        radio.setOpaque(false);
        radio.setActionCommand(archivo.getName());
        grupo.add(radio);
        JLabel estado = new JLabel();
        if (archivo.getName().endsWith(".exito")) {
            estado.setText(" (" + MonitorDePID.idioma.exito() + ")");
            if (this.colorEstadoExito != null) {
                estado.setForeground(this.colorEstadoExito.obtener());
            }
        } else if (archivo.getName().endsWith(".falla")) {
            estado.setText(" (" + MonitorDePID.idioma.fallo() + ")");
            if (this.colorEstadoFallo != null) {
                estado.setForeground(this.colorEstadoFallo.obtener());
            }
        } else if (archivo.getName().endsWith(".instantanea")) {
            estado.setText(" (" + MonitorDePID.idioma.instantanea() + ")");
            if (this.colorEstadoInstantanea != null) {
                estado.setForeground(this.colorEstadoInstantanea.obtener());
            }
        }
        this.estilizarRadioArchivo(radio);
        this.estilizarEstadoArchivo(estado);
        linea.add(radio);
        linea.add(estado);
        return linea;
    }

    protected void crearInstantanea() {
        block6: {
            String archivoSeleccionado;
            String string = archivoSeleccionado = this.grupoIzquierdo == null || this.grupoIzquierdo.getSelection() == null ? null : this.grupoIzquierdo.getSelection().getActionCommand();
            if (archivoSeleccionado == null) {
                if (this.resultadoPanel != null) {
                    this.resultadoPanel.setText("<html><body><font color='red'>" + MonitorDePID.idioma.seleccionarUnArchivo() + "</font></body></html>");
                }
                return;
            }
            try {
                Path directorio = Statics.carpeta.resolve("historia_mods");
                Path rutaOriginal = directorio.resolve(archivoSeleccionado);
                if (!Files.exists(rutaOriginal, new LinkOption[0])) {
                    throw new IOException("Archivo original no encontrado: " + rutaOriginal);
                }
                String base = archivoSeleccionado.replaceFirst("\\.[^.]+$", "");
                String nuevoNombre = this.generarNombreInstantaneaDesdeBase(base);
                Path rutaNueva = directorio.resolve(nuevoNombre);
                Files.copy(rutaOriginal, rutaNueva, new CopyOption[0]);
                CrashDetectorLogger.log("Instant\u00e1nea creada: " + rutaNueva);
                this.cargarArchivosHistoricos();
                if (this.resultadoPanel != null) {
                    this.resultadoPanel.setText("<html><body><font color='green'>" + MonitorDePID.idioma.instantaneaCreadaCorrectamente() + "</font></body></html>");
                }
            }
            catch (Exception e) {
                CrashDetectorLogger.log("Error creando instant\u00e1nea: " + e.getMessage());
                if (this.resultadoPanel == null) break block6;
                this.resultadoPanel.setText("<html><body><font color='red'>" + MonitorDePID.idioma.errorCreandoInstantanea() + "</font></body></html>");
            }
        }
    }

    private String generarNombreInstantaneaDesdeBase(String base) {
        Path directorio = Statics.carpeta.resolve("historia_mods");
        String nombre = base + ".instantanea";
        Path ruta = directorio.resolve(nombre);
        int i = 1;
        while (Files.exists(ruta, new LinkOption[0])) {
            nombre = base + "_" + String.format("%02d", i) + ".instantanea";
            ruta = directorio.resolve(nombre);
            ++i;
        }
        return nombre;
    }

    protected void compararArchivosSeleccionados() {
        block4: {
            String archivoDer;
            String archivoIzq = this.grupoIzquierdo == null || this.grupoIzquierdo.getSelection() == null ? null : this.grupoIzquierdo.getSelection().getActionCommand();
            String string = archivoDer = this.grupoDerecho == null || this.grupoDerecho.getSelection() == null ? null : this.grupoDerecho.getSelection().getActionCommand();
            if (archivoIzq == null || archivoDer == null || archivoIzq.equals(archivoDer)) {
                if (this.resultadoPanel != null) {
                    this.resultadoPanel.setText("<html><body><font color='red'>" + MonitorDePID.idioma.seleccionarDosArchivos() + "</font></body></html>");
                }
                return;
            }
            try {
                Path directorio = Statics.carpeta.resolve("historia_mods");
                Path rutaIzquierda = directorio.resolve(archivoIzq);
                Path rutaDerecha = directorio.resolve(archivoDer);
                Map<String, String> modsIzquierda = this.leerModsNormalizados(rutaIzquierda);
                Map<String, String> modsDerecha = this.leerModsNormalizados(rutaDerecha);
                List<String> diferencias = this.compararModsNormalizados(modsIzquierda, modsDerecha);
                this.generarHTMLResultado(archivoIzq, archivoDer, diferencias);
            }
            catch (Exception e) {
                CrashDetectorLogger.log("Error comparando archivos: " + e.getMessage());
                if (this.resultadoPanel == null) break block4;
                this.resultadoPanel.setText("<html><body><font color='red'>" + MonitorDePID.idioma.errorComparandoArchivos() + "</font></body></html>");
            }
        }
    }

    protected Map<String, String> leerModsNormalizados(Path rutaArchivo) throws IOException {
        HashMap<String, String> mods = new HashMap<String, String>();
        try (BufferedReader lector = new BufferedReader(new InputStreamReader(Files.newInputStream(rutaArchivo, new OpenOption[0]), StandardCharsets.UTF_8));){
            String linea;
            while ((linea = lector.readLine()) != null) {
                if (linea.trim().isEmpty()) continue;
                String nombreNormalizado = this.normalizarNombreMod(linea.trim());
                mods.put(nombreNormalizado, linea.trim());
            }
        }
        return mods;
    }

    protected String normalizarNombreMod(String ruta) {
        String nombre = new File(ruta).getName().toLowerCase();
        int indicePunto = nombre.lastIndexOf(46);
        if (indicePunto > 0) {
            nombre = nombre.substring(0, indicePunto);
        }
        return nombre;
    }

    protected List<String> compararModsNormalizados(Map<String, String> modsAnt, Map<String, String> modsNuevos) {
        ArrayList<String> difs = new ArrayList<String>();
        TreeSet<String> eliminados = new TreeSet<String>(modsAnt.keySet());
        eliminados.removeAll(modsNuevos.keySet());
        TreeSet<String> anadidos = new TreeSet<String>(modsNuevos.keySet());
        anadidos.removeAll(modsAnt.keySet());
        for (String mod : eliminados) {
            difs.add("- " + modsAnt.get(mod));
        }
        for (String mod : anadidos) {
            difs.add("+ " + modsNuevos.get(mod));
        }
        return difs;
    }

    protected void generarHTMLResultado(String archivo1, String archivo2, List<String> diferencias) {
        StringBuilder html = new StringBuilder();
        html.append("<html><body>");
        html.append("<div style='margin:10px 0;padding:10px;border:1px solid #ccc'>").append("<h3>").append(MonitorDePID.idioma.comparando()).append(" ").append(archivo1).append(" ").append(MonitorDePID.idioma.con()).append(" ").append(archivo2).append(":</h3>");
        if (diferencias.isEmpty()) {
            html.append("<p style='color:green'>").append(MonitorDePID.idioma.noHayCambios()).append("</p>");
        } else {
            html.append("<ul>");
            for (String linea : diferencias) {
                String color = linea.startsWith("+") ? (this.colorResultadoAnadido != null ? this.colorResultadoAnadido.obtener().toString() : "#000000") : (this.colorResultadoEliminado != null ? this.colorResultadoEliminado.obtener().toString() : "#000000");
                html.append("<li style='color:").append(color).append("'>").append(linea).append("</li>");
            }
            html.append("</ul>");
        }
        html.append("</div></body></html>");
        if (this.resultadoPanel != null) {
            this.resultadoPanel.setText(html.toString());
        }
    }

    protected void scrollHastaFinal(JScrollPane sp) {
        if (sp != null && sp.getVerticalScrollBar() != null) {
            sp.getVerticalScrollBar().setValue(sp.getVerticalScrollBar().getMaximum());
        }
    }

    protected abstract void estilizarRadioArchivo(JRadioButton var1);

    protected abstract void estilizarEstadoArchivo(JLabel var1);

    protected abstract void aplicarApariencia();

    @Override
    public void recargarApariencia() {
        this.aplicarApariencia();
    }

    @Override
    public boolean puedeEditarApariencia() {
        return true;
    }

    @Override
    public TipoGUI<HistoriaDeModsGUI> tipo() {
        return TipoGUI.HISTORIA_DE_MODS;
    }

    @Override
    public abstract void init();

    @Override
    public abstract String id();
}

