/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.historia;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.historia.HistoriaDeModsGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class HistoriaModsGUILegacy
extends HistoriaDeModsGUI {
    public static String ID = "historia_mods_legacy";
    private static final long serialVersionUID = 1L;
    public Font fuenteEtiqueta = new Font("SansSerif", 1, 14);
    public Font fuenteRadio = new Font("SansSerif", 0, 12);
    public Font fuenteEstado = new Font("SansSerif", 0, 10);
    public ConfigColor colorEstadoExito = ConfigColor.de("tema.historia_mods.color.estado.exito", new Color(76, 175, 80));
    public ConfigColor colorEstadoFallo = ConfigColor.de("tema.historia_mods.color.estado.fallo", new Color(244, 67, 54));
    public ConfigColor colorEstadoInstantanea = ConfigColor.de("tema.historia_mods.color.estado.instantanea", new Color(33, 150, 243));
    public ConfigColor colorResultadoAnadido = ConfigColor.de("tema.historia_mods.color.resultado.anadido", new Color(46, 125, 50));
    public ConfigColor colorResultadoEliminado = ConfigColor.de("tema.historia_mods.color.resultado.eliminado", new Color(198, 40, 40));
    public ConfigColor colorBordeScroll = ConfigColor.de("tema.historia_mods.color.borde.scroll", new Color(221, 221, 221));
    public ConfigColor colorFondoPanel = ConfigColor.de("tema.historia_mods.color.fondo.panel", new Color(255, 255, 255));

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void init() {
        this.colorEstadoExito = ConfigColor.de("tema.historia_mods.color.estado.exito", new Color(76, 175, 80));
        this.colorEstadoFallo = ConfigColor.de("tema.historia_mods.color.estado.fallo", new Color(244, 67, 54));
        this.colorEstadoInstantanea = ConfigColor.de("tema.historia_mods.color.estado.instantanea", new Color(33, 150, 243));
        this.colorResultadoAnadido = ConfigColor.de("tema.historia_mods.color.resultado.anadido", new Color(46, 125, 50));
        this.colorResultadoEliminado = ConfigColor.de("tema.historia_mods.color.resultado.eliminado", new Color(198, 40, 40));
        this.colorBordeScroll = ConfigColor.de("tema.historia_mods.color.borde.scroll", new Color(221, 221, 221));
        this.colorFondoPanel = ConfigColor.de("tema.historia_mods.color.fondo.panel", new Color(255, 255, 255));
        this.setTitle(MonitorDePID.idioma.historialDeMods());
        this.setSize(800, 700);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.construirEstructuraBase();
        this.cargarArchivosHistoricos();
        this.aplicarApariencia();
        this.setVisible(true);
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorEstadoExito.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorEstadoExito());
        this.colorEstadoFallo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorEstadoFallo());
        this.colorEstadoInstantanea.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorEstadoInstantanea());
        this.colorResultadoAnadido.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorResultadoAnadido());
        this.colorResultadoEliminado.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorResultadoEliminado());
        this.colorBordeScroll.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBordeScroll());
        this.colorFondoPanel.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoPanel());
        elementos.add(this.colorEstadoExito);
        elementos.add(this.colorEstadoFallo);
        elementos.add(this.colorEstadoInstantanea);
        elementos.add(this.colorResultadoAnadido);
        elementos.add(this.colorResultadoEliminado);
        elementos.add(this.colorBordeScroll);
        elementos.add(this.colorFondoPanel);
        return elementos;
    }

    @Override
    protected void construirEstructuraBase() {
        this.panelPrincipal = new JPanel(new BorderLayout(10, 10));
        this.panelPrincipal.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.panelPrincipal, "Center");
        this.panelSuperior = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        JLabel etiquetaIzquierda = new JLabel(MonitorDePID.idioma.archivo0());
        this.panelSuperior.add((Component)etiquetaIzquierda, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        JLabel etiquetaDerecha = new JLabel(MonitorDePID.idioma.archivo1());
        this.panelSuperior.add((Component)etiquetaDerecha, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.panelIzquierdo = new JPanel();
        this.panelIzquierdo.setLayout(new BoxLayout(this.panelIzquierdo, 1));
        this.scrollIzquierdo = new JScrollPane(this.panelIzquierdo);
        this.scrollIzquierdo.setPreferredSize(new Dimension(350, 300));
        this.panelSuperior.add((Component)this.scrollIzquierdo, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.panelDerecho = new JPanel();
        this.panelDerecho.setLayout(new BoxLayout(this.panelDerecho, 1));
        this.scrollDerecho = new JScrollPane(this.panelDerecho);
        this.scrollDerecho.setPreferredSize(new Dimension(350, 300));
        this.panelSuperior.add((Component)this.scrollDerecho, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        JPanel panelBotones = new JPanel(new FlowLayout(1, 10, 0));
        this.botonComparar = new JButton(MonitorDePID.idioma.comparar());
        panelBotones.add(this.botonComparar);
        this.botonInstantanea = new JButton(MonitorDePID.idioma.instantanea());
        panelBotones.add(this.botonInstantanea);
        this.panelSuperior.add((Component)panelBotones, gbc);
        this.resultadoPanel = new JTextPane();
        this.resultadoPanel.setContentType("text/html");
        this.resultadoPanel.setEditable(false);
        this.scrollResultado = new JScrollPane(this.resultadoPanel);
        this.botonComparar.addActionListener(e -> this.compararArchivosSeleccionados());
        this.botonInstantanea.addActionListener(e -> this.crearInstantanea());
        this.panelPrincipal.add((Component)this.panelSuperior, "North");
        this.panelPrincipal.add((Component)this.scrollResultado, "Center");
        this.aplicarApariencia();
    }

    @Override
    protected void estilizarRadioArchivo(JRadioButton radio) {
        radio.setFont(this.fuenteRadio);
    }

    @Override
    protected void estilizarEstadoArchivo(JLabel estado) {
        estado.setFont(this.fuenteEstado);
    }

    @Override
    protected void aplicarApariencia() {
        if (this.panelPrincipal != null) {
            this.panelPrincipal.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        if (this.scrollIzquierdo != null) {
            this.scrollIzquierdo.setBorder(BorderFactory.createLineBorder(this.colorBordeScroll.obtener()));
        }
        if (this.scrollDerecho != null) {
            this.scrollDerecho.setBorder(BorderFactory.createLineBorder(this.colorBordeScroll.obtener()));
        }
        if (this.scrollResultado != null) {
            this.scrollResultado.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        }
        if (this.panelSuperior != null && this.panelSuperior.getComponentCount() >= 2) {
            if (this.panelSuperior.getComponent(0) instanceof JLabel) {
                JLabel lbl0 = (JLabel)this.panelSuperior.getComponent(0);
                lbl0.setFont(this.fuenteEtiqueta);
            }
            if (this.panelSuperior.getComponent(1) instanceof JLabel) {
                JLabel lbl1 = (JLabel)this.panelSuperior.getComponent(1);
                lbl1.setFont(this.fuenteEtiqueta);
            }
        }
        if (this.botonComparar != null) {
            this.botonComparar.setFont(new Font("SansSerif", 1, 12));
        }
        if (this.botonInstantanea != null) {
            this.botonInstantanea.setFont(new Font("SansSerif", 1, 12));
        }
        if (this.resultadoPanel != null) {
            this.resultadoPanel.setMargin(new Insets(6, 6, 6, 6));
        }
        this.instalarPanelInferiorConImagenYTexto();
        this.revalidate();
        this.repaint();
    }

    private void instalarPanelInferiorConImagenYTexto() {
        if (this.panelInferior != null) {
            this.panelPrincipal.remove(this.panelInferior);
            this.panelInferior = null;
        }
        this.panelInferior = new JPanel(new BorderLayout());
        this.panelInferior.setOpaque(false);
        String ayudaNoLocalizada = String.format(MonitorDePID.idioma.historaDeModsDesc(), this.colorResultadoAnadido.obtener().toString(), this.colorResultadoEliminado.obtener().toString());
        this.descripcionHTML = new JTextPane();
        this.descripcionHTML.setContentType("text/html");
        this.descripcionHTML.setEditable(false);
        this.descripcionHTML.setText(ayudaNoLocalizada);
        JScrollPane scrollDescripcion = new JScrollPane(this.descripcionHTML);
        scrollDescripcion.setHorizontalScrollBarPolicy(31);
        scrollDescripcion.setVerticalScrollBarPolicy(20);
        scrollDescripcion.setPreferredSize(new Dimension(600, 100));
        scrollDescripcion.setBorder(BorderFactory.createEmptyBorder());
        JPanel textoPanel = new JPanel(new BorderLayout());
        textoPanel.setOpaque(false);
        textoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textoPanel.add((Component)scrollDescripcion, "Center");
        JPanel contenedor = new JPanel(new FlowLayout(0, 0, 0));
        contenedor.setOpaque(false);
        contenedor.add(textoPanel);
        try {
            Path rutaImagen = Statics.carpeta.resolve("imagenes/clio.png");
            if (!Files.exists(rutaImagen, new LinkOption[0])) {
                MonitorDePID.copiarACarpetaDesdeJar("/imagenes/clio.png", rutaImagen.toFile());
            }
            if (Files.exists(rutaImagen, new LinkOption[0])) {
                ImageIcon icono = new ImageIcon(rutaImagen.toAbsolutePath().toString());
                Image escalado = icono.getImage().getScaledInstance(100, 100, 4);
                JLabel etiquetaImagen = new JLabel(new ImageIcon(escalado));
                contenedor.add(etiquetaImagen);
            }
        }
        catch (Exception e) {
            CrashDetectorLogger.log("Error cargando clio.png: " + e.getMessage());
        }
        this.panelInferior.add((Component)contenedor, "Center");
        this.panelInferior.setMinimumSize(new Dimension(100, 100));
        this.panelPrincipal.add((Component)this.panelInferior, "Last");
    }
}

