/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.lanzeresbuenos;

import com.asbestosstar.crashdetector.analizador.general.LanzerNoAnimado;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorLanzer;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.json.Json;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JDialog;

public abstract class LanzerBuenoGUI
extends JDialog
implements CrashDetectorGUI,
BotonDeBarraLateralDerecha {
    private static final long serialVersionUID = 1L;
    public static Map<String, Supplier<LanzerBuenoGUI>> GUIS = new HashMap<String, Supplier<LanzerBuenoGUI>>();
    protected List<DetectorLanzer> lanzadores;
    protected Set<String> recomendados;
    protected Path archivoRecomendados = LanzerNoAnimado.ARCHIVO_ANIMADOS;

    public static boolean nosotrosDiceEsBueno(DetectorLanzer lanzer) {
        return lanzer.animado();
    }

    @Override
    public TipoGUI tipo() {
        return TipoGUI.LANZER_BUENO;
    }

    protected void cargarDatos() {
        this.lanzadores = DetectorLanzer.DETECTORES_DE_LANZERES;
        this.recomendados = new HashSet<String>();
        this.cargarRecomendadosDesdeArchivo();
    }

    private void cargarRecomendadosDesdeArchivo() {
        if (this.archivoRecomendados == null || !this.archivoRecomendados.toFile().exists() || this.archivoRecomendados.toFile().length() <= 0L) {
            return;
        }
        try {
            String contenido = new String(Files.readAllBytes(this.archivoRecomendados), StandardCharsets.UTF_8);
            if (contenido == null || contenido.trim().isEmpty()) {
                return;
            }
            Json.Nodo raiz = Json.leer(contenido);
            if (raiz == null || !raiz.esArreglo()) {
                return;
            }
            int tam = raiz.tamano();
            for (int i = 0; i < tam; ++i) {
                String id;
                Json.Nodo item = raiz.en(i);
                if (item == null || item.esObjeto() || item.esArreglo() || (id = item.comoCadena()) == null || (id = id.trim()).isEmpty()) continue;
                this.recomendados.add(id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void guardarDatos() {
        try {
            Json.Nodo raiz = Json.leer("[]");
            for (String id : this.recomendados) {
                String limpio;
                if (id == null || (limpio = id.trim()).isEmpty()) continue;
                raiz.agregar(limpio);
            }
            Files.write(this.archivoRecomendados, raiz.escribir().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<String> obtenerNombresLanzadores() {
        ArrayList<String> nombres = new ArrayList<String>();
        for (DetectorLanzer lanzador : this.lanzadores) {
            nombres.add(lanzador.id());
        }
        return nombres;
    }

    public void agregarARecomendados(String id) {
        if (id == null) {
            return;
        }
        String limpio = id.trim();
        if (!limpio.isEmpty()) {
            this.recomendados.add(limpio);
        }
    }

    public void quitarDeRecomendados(String id) {
        if (id == null) {
            return;
        }
        this.recomendados.remove(id.trim());
    }

    public boolean esRecomendadoPorCrashDetector(String id) {
        if (id == null) {
            return false;
        }
        for (DetectorLanzer lanzador : this.lanzadores) {
            if (lanzador == null || !id.equals(lanzador.id())) continue;
            return LanzerBuenoGUI.nosotrosDiceEsBueno(lanzador);
        }
        return false;
    }
}

