/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.lanzeresbuenos;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.lanzeresbuenos.LanzerBuenoGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class LanzerBuenoGUIMaidMint
extends LanzerBuenoGUI {
    private static final long serialVersionUID = 1L;
    public static String ID = "maid_mint";
    public static File imagen = Statics.carpeta.resolve("imagenes/maid_mint.png").toFile();
    private JTable tablaRecomendados;
    private DefaultTableModel modeloRecomendados;
    private JButton botonAgregar;
    private JButton botonQuitar;
    private JButton botonGuardar;
    private JButton botonCancelar;
    private JLabel imagenLabel;
    private JLabel etiquetaAviso;
    private JPanel panelPrincipal;
    private JLabel etiquetaTitulo;
    private JComboBox<String> comboLanzadores;
    private ConfigColor colorFondoVentana = ConfigColor.de("tema.maid_mint.color.fondo.ventana", new Color(218, 253, 249));
    private ConfigColor colorTexto = ConfigColor.de("tema.maid_mint.color.texto", new Color(98, 101, 105));
    private ConfigColor colorBoton = ConfigColor.de("tema.maid_mint.color.boton", new Color(161, 220, 215));
    private ConfigColor colorTabla = ConfigColor.de("tema.maid_mint.color.tabla", new Color(252, 245, 238));
    private ConfigColor colorResaltoRecomendado = ConfigColor.de("tema.maid_mint.color.resalto.recomendado", new Color(110, 210, 160));
    private ConfigColor colorBordePanel = ConfigColor.de("tema.maid_mint.color.borde.panel", new Color(153, 183, 184));

    @Override
    public void init() {
        this.setTitle(MonitorDePID.idioma.lanzadoresRecomendados());
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(true);
        this.setSize(900, 650);
        this.setAlwaysOnTop(false);
        this.cargarDatos();
        this.modeloRecomendados = new DefaultTableModel(new Object[]{MonitorDePID.idioma.nombreLanzador()}, 0);
        this.tablaRecomendados = new JTable(this.modeloRecomendados);
        this.configurarTabla(this.tablaRecomendados);
        this.panelPrincipal = new JPanel(new GridBagLayout());
        this.panelPrincipal.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panelPrincipal.setOpaque(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        JPanel panelIzquierdo = new JPanel(new BorderLayout());
        panelIzquierdo.setPreferredSize(new Dimension(220, 0));
        panelIzquierdo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        panelIzquierdo.setOpaque(true);
        this.imagenLabel = new JLabel();
        this.imagenLabel.setHorizontalAlignment(0);
        this.imagenLabel.setVerticalAlignment(1);
        this.cargarImagen();
        this.etiquetaAviso = this.crearEtiquetaAvisoBajoImagen();
        panelIzquierdo.add((Component)this.imagenLabel, "North");
        panelIzquierdo.add((Component)this.etiquetaAviso, "South");
        this.aplicarFondoPanelIzquierdo(panelIzquierdo);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 6;
        gbc.weightx = 0.25;
        gbc.weighty = 1.0;
        this.panelPrincipal.add((Component)panelIzquierdo, gbc);
        this.etiquetaTitulo = new JLabel(MonitorDePID.idioma.lanzadoresRecomendados());
        this.etiquetaTitulo.setFont(new Font("Segoe UI", 1, 16));
        this.comboLanzadores = new JComboBox();
        this.comboLanzadores.setPreferredSize(new Dimension(280, 30));
        this.configurarComboLanzadores();
        JPanel panelAcciones = new JPanel(new FlowLayout(0, 10, 5));
        panelAcciones.setOpaque(true);
        this.botonAgregar = new JButton(MonitorDePID.idioma.agregarLanzador());
        this.botonQuitar = new JButton(MonitorDePID.idioma.quitarLanzador());
        panelAcciones.add(this.botonAgregar);
        panelAcciones.add(this.botonQuitar);
        JScrollPane scroll = new JScrollPane(this.tablaRecomendados);
        JPanel panelGuardado = new JPanel(new FlowLayout(2));
        panelGuardado.setOpaque(true);
        this.botonGuardar = new JButton(MonitorDePID.idioma.guardarCambios());
        this.botonCancelar = new JButton(MonitorDePID.idioma.cancelar());
        panelGuardado.add(this.botonGuardar);
        panelGuardado.add(this.botonCancelar);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.75;
        gbc.weighty = 0.06;
        this.panelPrincipal.add((Component)this.etiquetaTitulo, gbc);
        gbc.gridy = 1;
        gbc.weighty = 0.08;
        this.panelPrincipal.add(this.comboLanzadores, gbc);
        gbc.gridy = 2;
        gbc.weighty = 0.08;
        this.panelPrincipal.add((Component)panelAcciones, gbc);
        gbc.gridy = 3;
        gbc.weighty = 0.68;
        this.panelPrincipal.add((Component)scroll, gbc);
        gbc.gridy = 4;
        gbc.weighty = 0.1;
        this.panelPrincipal.add((Component)panelGuardado, gbc);
        this.getContentPane().add((Component)this.panelPrincipal, "Center");
        this.cargarComboLanzadores();
        this.cargarDatosEnTabla();
        this.agregarListeners();
        this.setLocationRelativeTo(null);
        this.recargarApariencia();
        this.setVisible(true);
    }

    private JLabel crearEtiquetaAvisoBajoImagen() {
        JLabel lbl = new JLabel("<html><div style='width:200px; text-align:center;'>" + MonitorDePID.idioma.lanzadoresRecomendadosAviso() + "</div></html>");
        lbl.setFont(new Font("Segoe UI", 0, 11));
        lbl.setHorizontalAlignment(0);
        lbl.setForeground(this.colorTexto.obtener());
        lbl.setOpaque(false);
        return lbl;
    }

    private void aplicarFondoPanelIzquierdo(JPanel panelIzquierdo) {
        if (panelIzquierdo != null) {
            panelIzquierdo.setBackground(this.colorFondoVentana.obtener());
        }
        if (this.imagenLabel != null) {
            this.imagenLabel.setOpaque(true);
            this.imagenLabel.setBackground(this.colorFondoVentana.obtener());
        }
    }

    private void cargarImagen() {
        try {
            if (imagen.exists()) {
                ImageIcon icon = new ImageIcon(imagen.getAbsolutePath());
                Image img = icon.getImage();
                int newWidth = 200;
                int newHeight = (int)((double)img.getHeight(null) / (double)img.getWidth(null) * (double)newWidth);
                img = img.getScaledInstance(newWidth, newHeight, 4);
                this.imagenLabel.setIcon(new ImageIcon(img));
            } else {
                this.imagenLabel.setText(MonitorDePID.idioma.imagenNoEncontrada());
                this.imagenLabel.setForeground(this.colorTexto.obtener());
            }
        }
        catch (Exception e) {
            this.imagenLabel.setText(MonitorDePID.idioma.errorCargandoImagen());
            this.imagenLabel.setForeground(this.colorTexto.obtener());
        }
    }

    private void configurarTabla(JTable tabla) {
        tabla.setFillsViewportHeight(true);
        tabla.setSelectionMode(0);
        tabla.setRowHeight(26);
        tabla.setFont(new Font("Segoe UI", 0, 13));
        tabla.getColumnModel().getColumn(0).setPreferredWidth(380);
        tabla.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String id = value == null ? "" : value.toString();
                JLabel label = new JLabel(id);
                label.setOpaque(true);
                label.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
                label.setFont(new Font("Segoe UI", 0, 13));
                Color fondo = isSelected ? LanzerBuenoGUIMaidMint.this.colorBoton.obtener() : LanzerBuenoGUIMaidMint.this.colorTabla.obtener();
                label.setBackground(fondo);
                boolean bueno = LanzerBuenoGUIMaidMint.this.esRecomendadoPorCrashDetector(id);
                label.setForeground(bueno ? LanzerBuenoGUIMaidMint.this.colorResaltoRecomendado.obtener() : LanzerBuenoGUIMaidMint.this.colorTexto.obtener());
                return label;
            }
        });
    }

    private void configurarComboLanzadores() {
        this.comboLanzadores.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            String id = value == null ? "" : value.toString();
            JLabel label = new JLabel(id);
            label.setOpaque(true);
            label.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
            label.setFont(new Font("Segoe UI", 0, 13));
            Color fondo = isSelected ? this.colorBoton.obtener() : this.colorTabla.obtener();
            label.setBackground(fondo);
            boolean bueno = this.esRecomendadoPorCrashDetector(id);
            label.setForeground(bueno ? this.colorResaltoRecomendado.obtener() : this.colorTexto.obtener());
            return label;
        });
    }

    private void cargarComboLanzadores() {
        this.comboLanzadores.removeAllItems();
        ArrayList<String> recomendadosPorCD = new ArrayList<String>();
        ArrayList<String> normales = new ArrayList<String>();
        List<String> todos = this.obtenerNombresLanzadores();
        for (String id : todos) {
            if (id == null || this.recomendados.contains(id)) continue;
            if (this.esRecomendadoPorCrashDetector(id)) {
                recomendadosPorCD.add(id);
                continue;
            }
            normales.add(id);
        }
        for (String id : recomendadosPorCD) {
            this.comboLanzadores.addItem(id);
        }
        for (String id : normales) {
            this.comboLanzadores.addItem(id);
        }
        if (this.botonAgregar != null) {
            this.botonAgregar.setEnabled(this.comboLanzadores.getItemCount() > 0);
        }
    }

    private void cargarDatosEnTabla() {
        this.modeloRecomendados.setRowCount(0);
        for (String id : this.recomendados) {
            this.modeloRecomendados.addRow(new Object[]{id});
        }
        this.botonQuitar.setEnabled(this.modeloRecomendados.getRowCount() > 0);
    }

    private void agregarListeners() {
        this.botonAgregar.addActionListener(e -> {
            String id = (String)this.comboLanzadores.getSelectedItem();
            if (id != null && !id.trim().isEmpty()) {
                this.agregarARecomendados(id);
                this.cargarComboLanzadores();
                this.cargarDatosEnTabla();
            }
        });
        this.botonQuitar.addActionListener(e -> {
            int fila = this.tablaRecomendados.getSelectedRow();
            if (fila >= 0) {
                String id = (String)this.modeloRecomendados.getValueAt(fila, 0);
                this.quitarDeRecomendados(id);
                this.cargarComboLanzadores();
                this.cargarDatosEnTabla();
            } else {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.seleccionaLanzadorQuitar(), MonitorDePID.idioma.informacion(), 1);
            }
        });
        this.botonGuardar.addActionListener(e -> {
            this.guardarDatos();
            JOptionPane.showMessageDialog(this, MonitorDePID.idioma.cambiosGuardadosExitosamente(), MonitorDePID.idioma.informacion(), 1);
        });
        this.botonCancelar.addActionListener(e -> this.dispose());
    }

    @Override
    public void recargarApariencia() {
        this.getContentPane().setBackground(this.colorFondoVentana.obtener());
        this.panelPrincipal.setBackground(this.colorFondoVentana.obtener());
        this.etiquetaTitulo.setForeground(this.colorTexto.obtener());
        if (this.etiquetaAviso != null) {
            this.etiquetaAviso.setForeground(this.colorTexto.obtener());
        }
        if (this.imagenLabel != null) {
            this.imagenLabel.setBackground(this.colorFondoVentana.obtener());
        }
        this.tablaRecomendados.setBackground(this.colorTabla.obtener());
        this.tablaRecomendados.setForeground(this.colorTexto.obtener());
        this.tablaRecomendados.setGridColor(this.colorBordePanel.obtener());
        this.estilizarBoton(this.botonAgregar);
        this.estilizarBoton(this.botonQuitar);
        this.estilizarBoton(this.botonGuardar);
        this.estilizarBoton(this.botonCancelar);
        this.estilizarCombo(this.comboLanzadores);
        for (Component c : this.panelPrincipal.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            c.setBackground(this.colorFondoVentana.obtener());
        }
        this.revalidate();
        this.repaint();
    }

    private void estilizarBoton(JButton btn) {
        btn.setBackground(this.colorBoton.obtener());
        btn.setForeground(Color.WHITE);
        btn.setFocusPainted(false);
        btn.setBorder(BorderFactory.createLineBorder(this.colorBordePanel.obtener(), 1));
        btn.setFont(new Font("Segoe UI", 1, 13));
    }

    private void estilizarCombo(JComboBox<?> combo) {
        combo.setBackground(this.colorTabla.obtener());
        combo.setForeground(this.colorTexto.obtener());
        combo.setFont(new Font("Segoe UI", 0, 13));
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> ret = new ArrayList<ElementoConfig>();
        this.colorFondoVentana.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        ret.add(this.colorFondoVentana);
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        ret.add(this.colorTexto);
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        ret.add(this.colorBoton);
        this.colorTabla.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBordeListas());
        ret.add(this.colorTabla);
        this.colorResaltoRecomendado.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorResultadoCorrecto());
        ret.add(this.colorResaltoRecomendado);
        this.colorBordePanel.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
        ret.add(this.colorBordePanel);
        return ret;
    }
}

