/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.lanzeresmalos;

import com.asbestosstar.crashdetector.analizador.general.LanzerDesAnimado;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorLanzer;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.json.Json;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JDialog;

public abstract class LanzerMaloGUI
extends JDialog
implements CrashDetectorGUI,
BotonDeBarraLateralDerecha {
    public static Map<String, Supplier<LanzerMaloGUI>> GUIS = new HashMap<String, Supplier<LanzerMaloGUI>>();
    protected List<DetectorLanzer> lanzadores;
    protected Map<String, Map<String, String>> noRecomendados;
    protected Path archivoNoRecomendados = LanzerDesAnimado.ARCHIVO_DESANIMADOS;

    public static boolean nosotrosDiceEsMalo(DetectorLanzer lanzer) {
        return lanzer.desanimado();
    }

    @Override
    public TipoGUI tipo() {
        return TipoGUI.LANZER_MALO;
    }

    protected void cargarDatos() {
        this.lanzadores = DetectorLanzer.DETECTORES_DE_LANZERES;
        this.noRecomendados = new HashMap<String, Map<String, String>>();
        this.cargarNoRecomendados();
    }

    private void cargarNoRecomendados() {
        if (this.archivoNoRecomendados.toFile().exists() && this.archivoNoRecomendados.toFile().length() > 0L) {
            try {
                Json.Nodo raiz;
                String contenido = new String(Files.readAllBytes(this.archivoNoRecomendados), StandardCharsets.UTF_8);
                if (contenido != null && !contenido.trim().isEmpty() && (raiz = Json.leer(contenido)).esObjeto()) {
                    for (String key : this.obtenerClaves(raiz)) {
                        Json.Nodo valor = raiz.obtener(key);
                        if (!valor.esObjeto()) continue;
                        HashMap<String, String> motivos = new HashMap<String, String>();
                        for (String lang : this.obtenerClaves(valor)) {
                            String motivo;
                            Json.Nodo motivoNode = valor.obtener(lang);
                            if (motivoNode == null || motivoNode.esObjeto() || motivoNode.esArreglo() || (motivo = motivoNode.comoCadena()) == null || motivo.trim().isEmpty()) continue;
                            motivos.put(lang, motivo);
                        }
                        if (this.noRecomendados.containsKey(key)) continue;
                        this.noRecomendados.put(key, motivos);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected List<String> obtenerClaves(Json.Nodo nodo) {
        return nodo.claves();
    }

    protected void guardarDatos() {
        this.guardarNoRecomendados();
    }

    private void guardarNoRecomendados() {
        try {
            Json.Nodo raiz = Json.crearObjeto();
            for (Map.Entry<String, Map<String, String>> entry : this.noRecomendados.entrySet()) {
                String id = entry.getKey();
                Map<String, String> motivos = entry.getValue();
                Json.Nodo objetoLanzador = Json.crearObjeto();
                for (Map.Entry<String, String> motivoEntry : motivos.entrySet()) {
                    String lang = motivoEntry.getKey();
                    String motivo = motivoEntry.getValue();
                    objetoLanzador.obtener(lang).poner(motivo);
                }
                raiz.obtener(id).poner(objetoLanzador);
            }
            Files.write(this.archivoNoRecomendados, raiz.escribir().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<String> obtenerNombresLanzadores() {
        ArrayList<String> nombres = new ArrayList<String>();
        for (DetectorLanzer lanzador : this.lanzadores) {
            nombres.add(lanzador.id());
        }
        return nombres;
    }

    public Map<String, Map<String, String>> obtenerNoRecomendados() {
        return new HashMap<String, Map<String, String>>(this.noRecomendados);
    }

    public void agregarANoRecomendados(String id, Map<String, String> motivos) {
        this.noRecomendados.put(id, motivos);
    }

    public void quitarDeNoRecomendados(String id) {
        this.noRecomendados.remove(id);
    }

    public boolean esDesaconsejadoPorCrashDetector(String id) {
        for (DetectorLanzer lanzador : this.lanzadores) {
            if (!lanzador.id().equals(id)) continue;
            return LanzerMaloGUI.nosotrosDiceEsMalo(lanzador);
        }
        return false;
    }
}

