/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.lanzeresmalos;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.detectorlanzer.DetectorLanzer;
import com.asbestosstar.crashdetector.gui.tipos.lanzeresmalos.LanzerMaloGUI;
import com.asbestosstar.crashdetector.idioma.cumplimiento.ActaDeProteccionDelIdiomaCulturalDePyongyang;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class LanzerMaloGUISylentBell
extends LanzerMaloGUI {
    private static final long serialVersionUID = 1L;
    public static String ID = "sylent_bell";
    public static File imagen = Statics.carpeta.resolve("imagenes/sylent_bell.png").toFile();
    private JTable tablaNoRecomendados;
    private DefaultTableModel modeloNoRecomendados;
    private JButton botonAgregar;
    private JButton botonQuitar;
    private JButton botonEditarRazones;
    private JButton botonGuardar;
    private JButton botonCancelar;
    private JLabel imagenLabel;
    private JPanel panelPrincipal;
    private JLabel etiquetaTitulo;
    private JLabel etiquetaDisclaimer;
    private JComboBox<String> comboLanzadores;
    private ConfigColor colorFondoVentana = ConfigColor.de("tema.sylent_bell.color.fondo.ventana", new Color(15, 18, 28));
    private ConfigColor colorTexto = ConfigColor.de("tema.sylent_bell.color.texto", new Color(236, 232, 235));
    private ConfigColor colorBoton = ConfigColor.de("tema.sylent_bell.color.boton", new Color(61, 72, 93));
    private ConfigColor colorTabla = ConfigColor.de("tema.sylent_bell.color.tabla", new Color(23, 24, 36));
    private ConfigColor colorResaltoDesaconsejado = ConfigColor.de("tema.sylent_bell.color.resalto.desaconsejado", new Color(255, 92, 120));
    private ConfigColor colorBordePanel = ConfigColor.de("tema.sylent_bell.color.borde.panel", new Color(108, 117, 142));

    @Override
    public void init() {
        this.setTitle(MonitorDePID.idioma.lanzadoresNoRecomendados());
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(true);
        this.setSize(900, 650);
        this.setAlwaysOnTop(false);
        this.cargarDatos();
        this.modeloNoRecomendados = new DefaultTableModel(new Object[]{MonitorDePID.idioma.nombreLanzador(), MonitorDePID.idioma.razones()}, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tablaNoRecomendados = new JTable(this.modeloNoRecomendados);
        this.configurarTabla(this.tablaNoRecomendados);
        this.panelPrincipal = new JPanel(new GridBagLayout());
        this.panelPrincipal.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panelPrincipal.setOpaque(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        JPanel panelIzquierdo = new JPanel(new BorderLayout());
        panelIzquierdo.setPreferredSize(new Dimension(200, 0));
        panelIzquierdo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.imagenLabel = new JLabel();
        this.imagenLabel.setHorizontalAlignment(0);
        this.imagenLabel.setVerticalAlignment(1);
        this.cargarImagen();
        JLabel avisoSylentBell = this.crearEtiquetaDisclaimerSylentBellLadoIzquierdo();
        panelIzquierdo.add((Component)this.imagenLabel, "North");
        panelIzquierdo.add((Component)avisoSylentBell, "South");
        this.aplicarFondoPanelIzquierdo(panelIzquierdo);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 7;
        gbc.weightx = 0.25;
        gbc.weighty = 1.0;
        this.panelPrincipal.add((Component)panelIzquierdo, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 7;
        gbc.weightx = 0.25;
        gbc.weighty = 1.0;
        this.panelPrincipal.add((Component)panelIzquierdo, gbc);
        this.etiquetaTitulo = new JLabel(MonitorDePID.idioma.lanzadoresNoRecomendados());
        this.etiquetaTitulo.setFont(new Font("Segoe UI", 1, 16));
        this.etiquetaDisclaimer = this.crearEtiquetaDisclaimerSylentBell();
        this.comboLanzadores = new JComboBox();
        this.comboLanzadores.setPreferredSize(new Dimension(250, 30));
        this.configurarComboLanzadores();
        JPanel panelBotonesAccion = new JPanel(new FlowLayout(0, 10, 5));
        this.botonAgregar = new JButton(MonitorDePID.idioma.agregarLanzador());
        this.botonQuitar = new JButton(MonitorDePID.idioma.quitarLanzador());
        this.botonEditarRazones = new JButton(MonitorDePID.idioma.editarRazones());
        panelBotonesAccion.add(this.botonAgregar);
        panelBotonesAccion.add(this.botonQuitar);
        panelBotonesAccion.add(this.botonEditarRazones);
        this.cargarComboLanzadores();
        JScrollPane scrollNoRecomendados = new JScrollPane(this.tablaNoRecomendados);
        JPanel panelBotonesGuardado = new JPanel(new FlowLayout(2));
        this.botonGuardar = new JButton(MonitorDePID.idioma.guardarCambios());
        this.botonCancelar = new JButton(MonitorDePID.idioma.cancelar());
        panelBotonesGuardado.add(this.botonGuardar);
        panelBotonesGuardado.add(this.botonCancelar);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.75;
        gbc.weighty = 0.05;
        this.panelPrincipal.add((Component)this.etiquetaTitulo, gbc);
        gbc.gridy = 1;
        gbc.weighty = 0.06;
        this.panelPrincipal.add((Component)this.etiquetaDisclaimer, gbc);
        gbc.gridy = 2;
        gbc.weighty = 0.08;
        this.panelPrincipal.add(this.comboLanzadores, gbc);
        gbc.gridy = 3;
        gbc.weighty = 0.08;
        this.panelPrincipal.add((Component)panelBotonesAccion, gbc);
        gbc.gridy = 4;
        gbc.weighty = 0.64;
        this.panelPrincipal.add((Component)scrollNoRecomendados, gbc);
        gbc.gridy = 5;
        gbc.weighty = 0.1;
        this.panelPrincipal.add((Component)panelBotonesGuardado, gbc);
        this.getContentPane().add((Component)this.panelPrincipal, "Center");
        this.cargarDatosEnTabla();
        this.agregarListeners();
        this.setLocationRelativeTo(null);
        this.recargarApariencia();
        this.setVisible(true);
    }

    public static String obtenerCodigoIdioma(String nombreIdioma) {
        switch (nombreIdioma) {
            case "Espa\u00f1ol": {
                return "es";
            }
            case "English": {
                return "en";
            }
            case "\u0627\u0644\u0639\u0631\u0628\u064a\u0629": {
                return "ar";
            }
            case "Portugu\u00eas": {
                return "pt";
            }
            case "\u0641\u0627\u0631\u0633\u06cc": {
                return "fa";
            }
            case "\u0420\u0443\u0441\u0441\u043a\u0438\u0439": {
                return "ru";
            }
            case "\u7b80\u4f53\u4e2d\u6587": {
                return "zh";
            }
            case "Esperanto": {
                return "eo";
            }
            case "\u65e5\u672c\u8a9e": {
                return "ja";
            }
            case "\ud55c\uad6d\uc5b4": {
                return "ko";
            }
        }
        return "es";
    }

    private void cargarImagen() {
        try {
            if (imagen.exists()) {
                ImageIcon icon = new ImageIcon(imagen.getAbsolutePath());
                Image img = icon.getImage();
                int newWidth = 180;
                int newHeight = (int)((double)img.getHeight(null) / (double)img.getWidth(null) * (double)newWidth);
                img = img.getScaledInstance(newWidth, newHeight, 4);
                this.imagenLabel.setIcon(new ImageIcon(img));
            } else {
                this.imagenLabel.setText(MonitorDePID.idioma.imagenNoEncontrada());
                this.imagenLabel.setForeground(this.colorTexto.obtener());
            }
        }
        catch (Exception e) {
            this.imagenLabel.setText(MonitorDePID.idioma.errorCargandoImagen());
            this.imagenLabel.setForeground(this.colorTexto.obtener());
        }
    }

    private JLabel crearEtiquetaDisclaimerSylentBell() {
        JLabel lbl = new JLabel("<html><div style='width:520px;'>Las opiniones y comentarios de Sylent Bell no necesariamente coinciden con los nuestros; solo pensamos que ser\u00eda gracioso ponerla aqu\u00ed.</div></html>");
        lbl.setFont(new Font("Segoe UI", 0, 12));
        lbl.setForeground(this.colorTexto.obtener());
        lbl.setOpaque(false);
        return lbl;
    }

    private void configurarTabla(JTable tabla) {
        tabla.setFillsViewportHeight(true);
        tabla.setSelectionMode(0);
        tabla.setRowHeight(25);
        tabla.setFont(new Font("Segoe UI", 0, 13));
        tabla.getColumnModel().getColumn(0).setPreferredWidth(200);
        tabla.getColumnModel().getColumn(1).setPreferredWidth(400);
        tabla.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = new JLabel(value != null ? value.toString() : "");
                label.setOpaque(true);
                label.setHorizontalAlignment(2);
                label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                if (isSelected) {
                    label.setBackground(LanzerMaloGUISylentBell.this.colorBoton.obtener());
                    label.setForeground(Color.WHITE);
                } else {
                    label.setBackground(LanzerMaloGUISylentBell.this.colorTabla.obtener());
                    label.setForeground(LanzerMaloGUISylentBell.this.colorTexto.obtener());
                }
                return label;
            }
        });
    }

    private void configurarComboLanzadores() {
        this.comboLanzadores.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            String texto = value == null ? "" : value.toString();
            JLabel label = new JLabel(texto);
            label.setOpaque(true);
            label.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
            label.setFont(new Font("Segoe UI", 0, 13));
            Color fondo = isSelected ? this.colorBoton.obtener() : this.colorTabla.obtener();
            label.setBackground(fondo);
            boolean desaconsejado = false;
            if (value != null) {
                desaconsejado = this.esDesaconsejadoPorCrashDetectorConNosotrosDice(value.toString());
            }
            label.setForeground(desaconsejado ? this.colorResaltoDesaconsejado.obtener() : this.colorTexto.obtener());
            return label;
        });
    }

    private boolean esDesaconsejadoPorCrashDetectorConNosotrosDice(String id) {
        if (id == null) {
            return false;
        }
        for (DetectorLanzer lanzer : this.lanzadores) {
            if (lanzer == null || !id.equals(lanzer.id())) continue;
            return LanzerMaloGUI.nosotrosDiceEsMalo(lanzer);
        }
        return false;
    }

    private void cargarComboLanzadores() {
        this.comboLanzadores.removeAllItems();
        ArrayList<String> desaconsejados = new ArrayList<String>();
        ArrayList<String> normales = new ArrayList<String>();
        for (String id : this.obtenerNombresLanzadores()) {
            if (this.noRecomendados.containsKey(id)) continue;
            if (this.esDesaconsejadoPorCrashDetectorConNosotrosDice(id)) {
                desaconsejados.add(id);
                continue;
            }
            normales.add(id);
        }
        for (String id : desaconsejados) {
            this.comboLanzadores.addItem(id);
        }
        for (String id : normales) {
            this.comboLanzadores.addItem(id);
        }
        if (this.botonAgregar != null) {
            this.botonAgregar.setEnabled(this.comboLanzadores.getItemCount() > 0);
        }
    }

    private void cargarDatosEnTabla() {
        this.modeloNoRecomendados.setRowCount(0);
        for (Map.Entry entry : this.noRecomendados.entrySet()) {
            String id = (String)entry.getKey();
            Map motivos = (Map)entry.getValue();
            StringBuilder razones = new StringBuilder();
            boolean primero = true;
            for (Map.Entry motivoEntry : motivos.entrySet()) {
                if (!primero) {
                    razones.append(", ");
                }
                razones.append((String)motivoEntry.getKey()).append(": ").append((String)motivoEntry.getValue());
                primero = false;
            }
            this.modeloNoRecomendados.addRow(new Object[]{id, razones.toString()});
        }
        this.botonQuitar.setEnabled(this.modeloNoRecomendados.getRowCount() > 0);
        this.botonEditarRazones.setEnabled(this.modeloNoRecomendados.getRowCount() > 0);
    }

    private void agregarListeners() {
        this.botonAgregar.addActionListener(e -> {
            String id = (String)this.comboLanzadores.getSelectedItem();
            if (id != null && !id.isEmpty()) {
                HashMap<String, String> motivos = new HashMap<String, String>();
                this.agregarANoRecomendados(id, motivos);
                this.cargarComboLanzadores();
                this.cargarDatosEnTabla();
            }
        });
        this.botonQuitar.addActionListener(e -> {
            int filaSeleccionada = this.tablaNoRecomendados.getSelectedRow();
            if (filaSeleccionada >= 0) {
                String id = (String)this.modeloNoRecomendados.getValueAt(filaSeleccionada, 0);
                this.quitarDeNoRecomendados(id);
                this.cargarComboLanzadores();
                this.cargarDatosEnTabla();
            } else {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.seleccionaLanzadorQuitar(), MonitorDePID.idioma.informacion(), 1);
            }
        });
        this.botonEditarRazones.addActionListener(e -> {
            int filaSeleccionada = this.tablaNoRecomendados.getSelectedRow();
            if (filaSeleccionada >= 0) {
                String id = (String)this.modeloNoRecomendados.getValueAt(filaSeleccionada, 0);
                this.editarRazonesParaLanzador(id);
            } else {
                JOptionPane.showMessageDialog(this, MonitorDePID.idioma.seleccionaLanzadorEditar(), MonitorDePID.idioma.informacion(), 1);
            }
        });
        this.botonGuardar.addActionListener(e -> {
            this.guardarDatos();
            JOptionPane.showMessageDialog(this, MonitorDePID.idioma.cambiosGuardadosExitosamente(), MonitorDePID.idioma.informacion(), 1);
        });
        this.botonCancelar.addActionListener(e -> this.dispose());
    }

    private void editarRazonesParaLanzador(String idLanzador) {
        JDialog dialogo = new JDialog(this, MonitorDePID.idioma.editarRazonesPara(idLanzador), true);
        dialogo.setLayout(new BorderLayout(10, 10));
        dialogo.setSize(650, 420);
        JPanel panelCampos = new JPanel(new GridBagLayout());
        panelCampos.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panelCampos.setOpaque(true);
        panelCampos.setBackground(this.colorFondoVentana.obtener());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.fill = 2;
        Map motivos = this.noRecomendados.getOrDefault(idLanzador, new HashMap());
        LinkedHashMap<String, String> mapaIdiomas = this.mapaParaComboBoxIdiomas();
        HashMap<String, JTextField> camposTexto = new HashMap<String, JTextField>();
        int fila = 0;
        for (Map.Entry<String, String> entry : mapaIdiomas.entrySet()) {
            String nombreVisible = entry.getKey();
            String rutaBandera = entry.getValue();
            String codigo = LanzerMaloGUISylentBell.obtenerCodigoIdioma(nombreVisible);
            JLabel etiqueta = new JLabel(codigo);
            etiqueta.setFont(new Font("Segoe UI", 1, 12));
            etiqueta.setForeground(this.colorTexto.obtener());
            etiqueta.setOpaque(false);
            try {
                File f = Statics.carpeta.resolve(rutaBandera).toFile();
                if (f.exists()) {
                    ImageIcon icon = new ImageIcon(f.getAbsolutePath());
                    Image img = icon.getImage().getScaledInstance(18, 12, 4);
                    etiqueta.setIcon(new ImageIcon(img));
                    etiqueta.setIconTextGap(8);
                }
            }
            catch (Exception f) {
                // empty catch block
            }
            gbc.gridx = 0;
            gbc.gridy = fila++;
            gbc.weightx = 0.25;
            panelCampos.add((Component)etiqueta, gbc);
            gbc.gridx = 1;
            gbc.weightx = 0.75;
            JTextField campo = new JTextField(36);
            campo.setText(motivos.getOrDefault(codigo, ""));
            campo.setBackground(this.colorTabla.obtener());
            campo.setForeground(this.colorTexto.obtener());
            campo.setCaretColor(this.colorTexto.obtener());
            campo.setBorder(BorderFactory.createLineBorder(this.colorBordePanel.obtener(), 1));
            camposTexto.put(codigo, campo);
            panelCampos.add((Component)campo, gbc);
        }
        JPanel panelBotones = new JPanel(new FlowLayout(2));
        panelBotones.setOpaque(true);
        panelBotones.setBackground(this.colorFondoVentana.obtener());
        JButton botonAceptar = new JButton(MonitorDePID.idioma.aceptar());
        JButton botonCancelar = new JButton(MonitorDePID.idioma.cancelar());
        this.estilizarBoton(botonAceptar);
        this.estilizarBoton(botonCancelar);
        panelBotones.add(botonAceptar);
        panelBotones.add(botonCancelar);
        botonAceptar.addActionListener(e -> {
            HashMap<String, String> nuevosMotivos = new HashMap<String, String>();
            for (Map.Entry c : camposTexto.entrySet()) {
                String valor = ((JTextField)c.getValue()).getText();
                if (valor != null) {
                    valor = valor.trim();
                }
                if (valor == null || valor.isEmpty()) continue;
                nuevosMotivos.put((String)c.getKey(), valor);
            }
            String textoCoreano = (String)nuevosMotivos.get("ko");
            if (textoCoreano != null && !textoCoreano.isEmpty()) {
                ActaDeProteccionDelIdiomaCulturalDePyongyang.contieneJergaSur(textoCoreano);
            }
            this.noRecomendados.put(idLanzador, nuevosMotivos);
            this.cargarDatosEnTabla();
            dialogo.dispose();
        });
        botonCancelar.addActionListener(e -> dialogo.dispose());
        dialogo.add((Component)new JScrollPane(panelCampos), "Center");
        dialogo.add((Component)panelBotones, "South");
        dialogo.setLocationRelativeTo(this);
        dialogo.setVisible(true);
    }

    @Override
    public void recargarApariencia() {
        this.getContentPane().setBackground(this.colorFondoVentana.obtener());
        this.panelPrincipal.setBackground(this.colorFondoVentana.obtener());
        this.etiquetaTitulo.setForeground(this.colorTexto.obtener());
        if (this.etiquetaDisclaimer != null) {
            this.etiquetaDisclaimer.setForeground(this.colorTexto.obtener());
        }
        if (this.imagenLabel != null) {
            this.imagenLabel.setBackground(this.colorFondoVentana.obtener());
        }
        this.tablaNoRecomendados.setBackground(this.colorTabla.obtener());
        this.tablaNoRecomendados.setForeground(this.colorTexto.obtener());
        this.tablaNoRecomendados.setGridColor(this.colorBordePanel.obtener());
        this.estilizarBoton(this.botonAgregar);
        this.estilizarBoton(this.botonQuitar);
        this.estilizarBoton(this.botonEditarRazones);
        this.estilizarBoton(this.botonGuardar);
        this.estilizarBoton(this.botonCancelar);
        this.estilizarCombo(this.comboLanzadores);
        for (Component c : this.panelPrincipal.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            c.setBackground(this.colorFondoVentana.obtener());
        }
        this.revalidate();
        this.repaint();
    }

    private void estilizarBoton(JButton btn) {
        btn.setBackground(this.colorBoton.obtener());
        btn.setForeground(Color.WHITE);
        btn.setFocusPainted(false);
        btn.setBorder(BorderFactory.createLineBorder(this.colorBordePanel.obtener(), 1));
        btn.setFont(new Font("Segoe UI", 1, 13));
    }

    private void estilizarCombo(JComboBox<?> combo) {
        combo.setBackground(this.colorTabla.obtener());
        combo.setForeground(this.colorTexto.obtener());
        combo.setFont(new Font("Segoe UI", 0, 13));
    }

    @Override
    public String id() {
        return ID;
    }

    private JLabel crearEtiquetaDisclaimerSylentBellLadoIzquierdo() {
        JLabel lbl = new JLabel(MonitorDePID.idioma.mensajeDeSylentBell());
        lbl.setFont(new Font("Segoe UI", 0, 11));
        lbl.setForeground(this.colorTexto.obtener());
        lbl.setHorizontalAlignment(0);
        lbl.setOpaque(false);
        return lbl;
    }

    private void aplicarFondoPanelIzquierdo(JPanel panelIzquierdo) {
        if (panelIzquierdo != null) {
            panelIzquierdo.setOpaque(true);
            panelIzquierdo.setBackground(this.colorFondoVentana.obtener());
        }
        if (this.imagenLabel != null) {
            this.imagenLabel.setOpaque(true);
            this.imagenLabel.setBackground(this.colorFondoVentana.obtener());
        }
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> ret = new ArrayList<ElementoConfig>();
        this.colorFondoVentana.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        ret.add(this.colorFondoVentana);
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        ret.add(this.colorTexto);
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        ret.add(this.colorBoton);
        this.colorTabla.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBordeListas());
        ret.add(this.colorTabla);
        this.colorResaltoDesaconsejado.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorResultadoEliminado());
        ret.add(this.colorResaltoDesaconsejado);
        this.colorBordePanel.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
        ret.add(this.colorBordePanel);
        return ret;
    }
}

