/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.lectador;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.elementos.NumeradorDeLineas;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public abstract class LectadorDeConsolasGUI
extends JFrame
implements CrashDetectorGUI,
BotonDeBarraLateralDerecha {
    private static final long serialVersionUID = 1L;
    public static Map<String, Supplier<LectadorDeConsolasGUI>> GUIS = new HashMap<String, Supplier<LectadorDeConsolasGUI>>();
    protected final List<Consola> consolas = MonitorDePID.consolas;
    protected final Map<String, List<String>> cacheLineasPorConsola = new ConcurrentHashMap<String, List<String>>();
    protected final int CORES = Runtime.getRuntime().availableProcessors();
    protected final int N_HILOS = Math.min(4, Math.max(2, this.CORES - 1));
    protected final int CAPACIDAD_COLA = this.N_HILOS * 4;
    protected final ThreadPoolExecutor pool = new ThreadPoolExecutor(this.N_HILOS, this.N_HILOS, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.CAPACIDAD_COLA), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "LectadorPool-" + System.nanoTime());
            t.setDaemon(true);
            return t;
        }
    }, new ThreadPoolExecutor.CallerRunsPolicy());
    protected List<String> lineasActuales;
    protected final JList<String> listaRegistros;
    protected final JComboBox<String> cmbConsolas;
    protected final JTextArea txtNombreError;
    public ConfigColor colorFondo;
    public ConfigColor colorTexto;
    public ConfigColor colorError;
    public ConfigColor colorPila;
    public ConfigColor colorFondoPanel;
    public ConfigColor colorTextoPanel;
    public ConfigColor colorTextoNegro;
    public JScrollPane scrollLogs;
    public JPanel pnlInferior;
    public JPanel pnlLeyenda;
    public JComponent pnlSelector;
    public final JTextField txtBuscar;
    protected final List<Integer> posicionesCoincidencias;
    protected int indiceBusquedaActual;
    public final JComboBox<String> cmbModo;
    public final JEditorPane txtDescripcionError;
    public JScrollPane scrollDescripcion;

    protected abstract String textoNormalLeyenda();

    public LectadorDeConsolasGUI() {
        this.pool.allowCoreThreadTimeOut(true);
        this.lineasActuales = Collections.emptyList();
        this.listaRegistros = new JList();
        this.cmbConsolas = new JComboBox();
        this.txtNombreError = new JTextArea();
        this.txtBuscar = new JTextField();
        this.posicionesCoincidencias = new ArrayList<Integer>();
        this.indiceBusquedaActual = -1;
        this.cmbModo = new JComboBox<String>(new String[]{MonitorDePID.idioma.limpiado(), MonitorDePID.idioma.original()});
        this.txtDescripcionError = new JEditorPane();
    }

    public abstract void procesarHipervinculo(String var1);

    protected void configurarVentanaBase() {
        this.setTitle(MonitorDePID.idioma.tituloLectador());
        this.setSize(1280, 720);
        this.setLocationRelativeTo(null);
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.setLayout(null);
        this.setContentPane(layeredPane);
        this.instalarFondoApariencia(layeredPane);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                try {
                    LectadorDeConsolasGUI.this.pool.shutdownNow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LectadorDeConsolasGUI.this.recolocarComponentes();
                LectadorDeConsolasGUI.this.repaint();
            }
        });
    }

    protected void instalarFondoApariencia(JLayeredPane capa) {
    }

    protected void inicializarComponentesBase() {
        JLayeredPane capa = (JLayeredPane)this.getContentPane();
        this.configurarAreaRegistros();
        this.scrollLogs = new JScrollPane(this.listaRegistros);
        this.scrollLogs.setRowHeaderView(new NumeradorDeLineas(this.listaRegistros));
        capa.add((Component)this.scrollLogs, JLayeredPane.PALETTE_LAYER);
        this.pnlInferior = this.crearPanelInformacionErrores();
        this.pnlInferior.setOpaque(false);
        capa.add((Component)this.pnlInferior, JLayeredPane.PALETTE_LAYER);
        this.pnlLeyenda = this.crearPanelLeyenda();
        this.pnlLeyenda.setOpaque(false);
        capa.add((Component)this.pnlLeyenda, JLayeredPane.PALETTE_LAYER);
        this.pnlSelector = this.crearPanelSelector();
        this.pnlSelector.setOpaque(false);
        capa.add((Component)this.pnlSelector, JLayeredPane.PALETTE_LAYER);
        this.inicializarBuscador(capa);
        this.recolocarComponentes();
    }

    protected void recolocarComponentes() {
        int anchoBase = 1280;
        int altoBase = 720;
        int anchoActual = this.getWidth();
        int altoActual = this.getHeight();
        double escX = (double)anchoActual / (double)anchoBase;
        double escY = (double)altoActual / (double)altoBase;
        if (this.scrollLogs != null) {
            this.scrollLogs.setBounds((int)(232.0 * escX), (int)(15.0 * escY), (int)(820.0 * escX), (int)(475.0 * escY));
        }
        if (this.pnlInferior != null) {
            this.pnlInferior.setBounds((int)(375.0 * escX), (int)(533.0 * escY), (int)(535.0 * escX), (int)(140.0 * escY));
        }
        if (this.pnlLeyenda != null) {
            this.pnlLeyenda.setBounds((int)(30.0 * escX), (int)(30.0 * escY), (int)(180.0 * escX), (int)(200.0 * escY));
        }
        if (this.pnlSelector != null) {
            this.pnlSelector.setBounds((int)((double)(anchoBase - 225) * escX), (int)(30.0 * escY), (int)(220.0 * escX), (int)(80.0 * escY));
        }
        this.recolocarBuscador();
        if (this.scrollLogs != null) {
            this.scrollLogs.revalidate();
            this.scrollLogs.repaint();
        }
        this.revalidate();
        this.repaint();
    }

    protected void recolocarBuscador() {
        if (this.pnlSelector != null) {
            int margen = 8;
            int x = this.pnlSelector.getX();
            int y = this.pnlSelector.getY() + this.pnlSelector.getHeight() + margen;
            int w = this.pnlSelector.getWidth();
            int h = 40;
            this.txtBuscar.setBounds(x, y, w, h);
        } else {
            int ancho = 200;
            int alto = 40;
            this.txtBuscar.setBounds(this.getWidth() - ancho - 30, 30, ancho, alto);
        }
        this.txtBuscar.revalidate();
        this.txtBuscar.repaint();
    }

    protected JPanel crearPanelLeyenda() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 1));
        pnl.setBackground(this.colorFondoPanel.obtener());
        pnl.setBorder(BorderFactory.createTitledBorder(MonitorDePID.idioma.obtenerTituloLeyenda()));
        HashSet<Color> coloresMostrados = new HashSet<Color>();
        for (Consola consola : this.consolas) {
            for (ErrorDeLectador err : consola.errores_de_lectadores) {
                Color c = err.obtenerColor();
                if (coloresMostrados.contains(c)) continue;
                JLabel lbl = new JLabel(err.verificacion.nivel_de_criticalidad().nombre);
                lbl.setOpaque(true);
                lbl.setBackground(c);
                lbl.setForeground(this.colorTextoNegro.obtener());
                lbl.setAlignmentX(0.0f);
                pnl.add(lbl);
                pnl.add(Box.createVerticalStrut(8));
                coloresMostrados.add(c);
            }
        }
        JLabel lblPila = new JLabel(MonitorDePID.idioma.obtenerStacktraceEnLeyenda());
        lblPila.setOpaque(true);
        lblPila.setBackground(this.colorPila.obtener());
        lblPila.setForeground(this.colorTextoNegro.obtener());
        lblPila.setAlignmentX(0.0f);
        pnl.add(lblPila);
        JLabel lblNormal = new JLabel(this.textoNormalLeyenda());
        lblNormal.setOpaque(true);
        lblNormal.setBackground(this.colorTextoPanel.obtener());
        lblNormal.setForeground(this.colorTextoNegro.obtener());
        lblNormal.setAlignmentX(0.0f);
        pnl.add(lblNormal);
        return pnl;
    }

    protected void configurarAreaRegistros() {
        this.listaRegistros.setBackground(this.colorFondo.obtener());
        this.listaRegistros.setForeground(this.colorTexto.obtener());
        this.listaRegistros.setSelectionMode(0);
        this.listaRegistros.setFixedCellHeight(16);
        this.listaRegistros.setCellRenderer(new ListCellRenderer<String>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel lbl = new JLabel(value == null ? "" : value);
                lbl.setOpaque(true);
                lbl.setForeground(LectadorDeConsolasGUI.this.colorTexto.obtener());
                lbl.setBackground(LectadorDeConsolasGUI.this.colorFondo.obtener());
                Consola consola = LectadorDeConsolasGUI.this.obtenerConsolaSeleccionada();
                if (consola != null) {
                    List errores = consola.errores_de_lectadores.stream().filter(err -> err.obtenerLinea() == index).collect(Collectors.toList());
                    if (!errores.isEmpty()) {
                        lbl.setBackground(((ErrorDeLectador)errores.get(0)).obtenerColor());
                        lbl.setForeground(LectadorDeConsolasGUI.this.colorTextoNegro.obtener());
                    } else if (value != null && (value.contains("ERROR") || value.contains("EXCEPTION"))) {
                        lbl.setBackground(LectadorDeConsolasGUI.this.colorError.obtener());
                        lbl.setForeground(LectadorDeConsolasGUI.this.colorTextoNegro.obtener());
                    } else if (value != null && (value.contains("STACKTRACE") || value.contains("at "))) {
                        lbl.setBackground(LectadorDeConsolasGUI.this.colorPila.obtener());
                        lbl.setForeground(LectadorDeConsolasGUI.this.colorTextoNegro.obtener());
                    }
                }
                if (isSelected) {
                    lbl.setBackground(lbl.getBackground().darker());
                }
                return lbl;
            }
        });
        this.listaRegistros.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = LectadorDeConsolasGUI.this.listaRegistros.locationToIndex(e.getPoint());
                Consola consola = LectadorDeConsolasGUI.this.obtenerConsolaSeleccionada();
                if (consola != null) {
                    LectadorDeConsolasGUI.this.procesarSeleccionError(index, consola);
                }
            }
        });
    }

    protected JPanel crearPanelInformacionErrores() {
        JPanel pnl = new JPanel(new GridLayout(1, 2, 42, 10));
        this.txtNombreError.setEditable(false);
        this.txtNombreError.setBackground(this.colorFondo.obtener());
        this.txtNombreError.setForeground(this.colorTexto.obtener());
        pnl.add(this.txtNombreError);
        this.txtDescripcionError.setEditable(false);
        this.txtDescripcionError.setContentType("text/html");
        this.txtDescripcionError.setOpaque(true);
        this.txtDescripcionError.setBackground(this.colorFondo.obtener());
        this.txtDescripcionError.setForeground(this.colorTexto.obtener());
        String fondoHex = String.format("#%02x%02x%02x", this.colorFondo.obtener().getRed(), this.colorFondo.obtener().getGreen(), this.colorFondo.obtener().getBlue());
        String textoHex = String.format("#%02x%02x%02x", this.colorTexto.obtener().getRed(), this.colorTexto.obtener().getGreen(), this.colorTexto.obtener().getBlue());
        this.txtDescripcionError.setText("<html><body bgcolor='" + fondoHex + "' text='" + textoHex + "'></body></html>");
        this.scrollDescripcion = new JScrollPane(this.txtDescripcionError, 20, 30);
        pnl.add(this.scrollDescripcion);
        return pnl;
    }

    protected JComponent crearPanelSelector() {
        JPanel pnl = new JPanel(new GridLayout(2, 1, 0, 5));
        pnl.setBackground(this.colorFondoPanel.obtener());
        pnl.add(this.cmbConsolas);
        pnl.add(this.cmbModo);
        this.cmbConsolas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LectadorDeConsolasGUI.this.actualizarConsola();
            }
        });
        this.cmbModo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LectadorDeConsolasGUI.this.actualizarConsola();
            }
        });
        return pnl;
    }

    protected void inicializarBuscador(JLayeredPane capa) {
        this.txtBuscar.setVisible(false);
        this.txtBuscar.setBackground(this.colorFondo.obtener());
        this.txtBuscar.setForeground(this.colorTexto.obtener());
        this.txtBuscar.setBorder(BorderFactory.createTitledBorder("Buscar"));
        capa.add((Component)this.txtBuscar, JLayeredPane.DRAG_LAYER);
        this.txtBuscar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LectadorDeConsolasGUI.this.saltarSiguienteCoincidencia();
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke("control F");
        KeyStroke keyStrokeMac = KeyStroke.getKeyStroke("meta F");
        this.getRootPane().getInputMap(2).put(keyStroke, "abrirBuscador");
        this.getRootPane().getInputMap(2).put(keyStrokeMac, "abrirBuscador");
        this.getRootPane().getActionMap().put("abrirBuscador", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LectadorDeConsolasGUI.this.txtBuscar.setVisible(true);
                LectadorDeConsolasGUI.this.txtBuscar.requestFocus();
                LectadorDeConsolasGUI.this.recolocarBuscador();
            }
        });
    }

    protected void cargarConsolas() {
        for (Consola consola : this.consolas) {
            String nombreArchivo = new File(consola.archivo.toString()).getName();
            this.cmbConsolas.addItem(nombreArchivo);
        }
        if (this.cmbConsolas.getItemCount() > 0) {
            this.cmbConsolas.setSelectedIndex(0);
            this.actualizarConsola();
        }
    }

    protected void precargarLineasEnSegundoPlano() {
        for (final Consola consola : this.consolas) {
            final String nombreArchivo = new File(consola.archivo.toString()).getName();
            if (this.cacheLineasPorConsola.containsKey(nombreArchivo)) continue;
            this.pool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        List<String> lineas = Arrays.asList(consola.contenido_verificar.split(Verificaciones.nl));
                        CrashDetectorLogger.log(consola.archivo.toString() + " linea size " + String.valueOf(lineas.size()));
                        if (lineas.size() == 1) {
                            CrashDetectorLogger.log(String.valueOf(consola.contenido_verificar.length()));
                            CrashDetectorLogger.log(consola.archivo.toString() + " linea 1 " + lineas.get(0));
                        }
                        LectadorDeConsolasGUI.this.cacheLineasPorConsola.put(nombreArchivo, lineas);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (nombreArchivo.equals(LectadorDeConsolasGUI.this.cmbConsolas.getSelectedItem())) {
                                    LectadorDeConsolasGUI.this.refrescarModeloCon(LectadorDeConsolasGUI.this.cacheLineasPorConsola.get(nombreArchivo));
                                }
                            }
                        });
                    }
                    catch (Throwable t) {
                        CrashDetectorLogger.logException(t);
                    }
                }
            });
        }
    }

    protected void actualizarConsola() {
        final Consola consola = this.obtenerConsolaSeleccionada();
        if (consola == null) {
            return;
        }
        final String nombreArchivo = new File(consola.archivo.toString()).getName();
        List<String> cache = this.cacheLineasPorConsola.get(nombreArchivo);
        if (cache != null) {
            this.refrescarModeloCon(cache);
            return;
        }
        this.setLoadingModel("Cargando " + nombreArchivo + " ...");
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.pool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> lineas = Arrays.asList(consola.contenido_verificar.split(Verificaciones.nl));
                    LectadorDeConsolasGUI.this.cacheLineasPorConsola.put(nombreArchivo, lineas);
                    final List<String> lineasFinal = lineas;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (nombreArchivo.equals(LectadorDeConsolasGUI.this.cmbConsolas.getSelectedItem())) {
                                LectadorDeConsolasGUI.this.refrescarModeloCon(lineasFinal);
                            }
                            LectadorDeConsolasGUI.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    });
                }
                catch (Throwable t) {
                    CrashDetectorLogger.logException(t);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LectadorDeConsolasGUI.this.setLoadingModel("Error al cargar " + nombreArchivo + ": " + t.getMessage());
                            LectadorDeConsolasGUI.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    });
                }
            }
        });
    }

    protected Consola obtenerConsolaSeleccionada() {
        String nombreArchivo = (String)this.cmbConsolas.getSelectedItem();
        if (nombreArchivo == null) {
            return null;
        }
        for (Consola c : this.consolas) {
            if (!new File(c.archivo.toString()).getName().equals(nombreArchivo)) continue;
            return c;
        }
        return null;
    }

    protected void setLoadingModel(String mensaje) {
        final List<String> soloMensaje = Collections.singletonList(mensaje);
        this.lineasActuales = soloMensaje;
        this.listaRegistros.setModel((ListModel<String>)new AbstractListModel<String>(){

            @Override
            public int getSize() {
                return soloMensaje.size();
            }

            @Override
            public String getElementAt(int index) {
                return (String)soloMensaje.get(index);
            }
        });
    }

    protected void refrescarModeloCon(List<String> lineas) {
        this.lineasActuales = lineas == null ? Collections.emptyList() : lineas;
        this.listaRegistros.setModel((ListModel<String>)new AbstractListModel<String>(){

            @Override
            public int getSize() {
                return LectadorDeConsolasGUI.this.lineasActuales.size();
            }

            @Override
            public String getElementAt(int index) {
                return LectadorDeConsolasGUI.this.lineasActuales.get(index);
            }
        });
        this.posicionesCoincidencias.clear();
        this.indiceBusquedaActual = -1;
    }

    protected void saltarSiguienteCoincidencia() {
        String texto = this.txtBuscar.getText();
        if (texto == null || texto.isEmpty()) {
            return;
        }
        if (this.posicionesCoincidencias.isEmpty()) {
            this.buscarTexto(texto);
            return;
        }
        this.indiceBusquedaActual = (this.indiceBusquedaActual + 1) % this.posicionesCoincidencias.size();
        this.resaltarCoincidenciaActual();
    }

    protected void buscarTexto(String texto) {
        this.posicionesCoincidencias.clear();
        this.indiceBusquedaActual = -1;
        if (texto == null || texto.isEmpty()) {
            return;
        }
        String t = texto.toLowerCase();
        for (int i = 0; i < this.lineasActuales.size(); ++i) {
            String linea = this.lineasActuales.get(i);
            if (linea == null || !linea.toLowerCase().contains(t)) continue;
            this.posicionesCoincidencias.add(i);
        }
        if (!this.posicionesCoincidencias.isEmpty()) {
            this.indiceBusquedaActual = 0;
            this.resaltarCoincidenciaActual();
        }
        this.listaRegistros.repaint();
    }

    protected void resaltarCoincidenciaActual() {
        if (this.indiceBusquedaActual < 0 || this.indiceBusquedaActual >= this.posicionesCoincidencias.size()) {
            return;
        }
        int pos = this.posicionesCoincidencias.get(this.indiceBusquedaActual);
        this.listaRegistros.setSelectedIndex(pos);
        this.listaRegistros.ensureIndexIsVisible(pos);
    }

    protected static String htmlAPlano(String s) {
        if (s == null) {
            return "";
        }
        String r = s;
        r = r.replaceAll("(?is)<br\\s*/?>", "\n");
        r = r.replaceAll("(?is)</p\\s*>", "\n");
        r = r.replaceAll("(?is)</div\\s*>", "\n");
        r = r.replaceAll("(?is)</li\\s*>", "\n");
        r = r.replaceAll("(?is)</tr\\s*>", "\n");
        r = r.replaceAll("(?is)<[^>]+>", "");
        r = r.replace("&nbsp;", " ");
        r = r.replace("<", "<").replace(">", ">");
        r = r.replace("&quot;", "\"").replace("&#39;", "'");
        r = r.replace("&amp;", "&");
        r = r.replaceAll("\\n{3,}", "\n\n");
        return r.trim();
    }

    protected static String escHtml(String s) {
        if (s == null) {
            return "";
        }
        String r = s;
        r = r.replace("&", "&amp;").replace("<", "<").replace(">", ">").replace("\"", "&quot;").replace("'", "&#39;");
        return r;
    }

    protected void descripcionHtml(String textoPlano) {
        String safe = textoPlano == null ? "" : LectadorDeConsolasGUI.escHtml(textoPlano);
        String html = "<html><body bgcolor='#111111' text='#FFFFFF'><pre>" + safe + "</pre></body></html>";
        this.txtDescripcionError.setText(html);
        this.txtDescripcionError.setCaretPosition(0);
    }

    protected void procesarSeleccionError(int numeroLinea, Consola consola) {
        this.txtNombreError.setText("");
        StringBuilder detallePlano = new StringBuilder();
        List erroresEnLinea = consola.errores_de_lectadores.stream().filter(err -> err.obtenerLinea() == numeroLinea).collect(Collectors.toList());
        if (!erroresEnLinea.isEmpty()) {
            StringBuilder nombres = new StringBuilder();
            for (ErrorDeLectador err2 : erroresEnLinea) {
                if (nombres.length() > 0) {
                    nombres.append("\n");
                }
                nombres.append(err2.verificacion.nombre());
                String tituloPlano = LectadorDeConsolasGUI.htmlAPlano(err2.verificacion.nombre());
                String mensaje = err2.verificacion.mensaje();
                String mensajePlano = LectadorDeConsolasGUI.htmlAPlano(mensaje);
                detallePlano.append(tituloPlano).append("\n");
                detallePlano.append(mensajePlano).append("\n");
                detallePlano.append("--------------------------------------------------").append("\n");
            }
            this.txtNombreError.setText(nombres.toString());
            this.descripcionHtml(detallePlano.toString());
        } else if (numeroLinea >= 0 && numeroLinea < this.lineasActuales.size()) {
            String textoLinea = this.lineasActuales.get(numeroLinea);
            if (textoLinea != null && (textoLinea.contains("ERROR") || textoLinea.contains("EXCEPTION"))) {
                this.txtNombreError.setText(MonitorDePID.idioma.obtenerNombreErrorPorDefecto());
                String porDefectoPlano = LectadorDeConsolasGUI.htmlAPlano(MonitorDePID.idioma.obtenerDescripcionErrorPorDefecto());
                this.descripcionHtml(porDefectoPlano);
            } else {
                this.txtNombreError.setText("");
                this.descripcionHtml("");
            }
        } else {
            this.txtNombreError.setText("");
            this.descripcionHtml("");
        }
    }

    @Override
    public TipoGUI tipo() {
        return TipoGUI.LECTADOR_DE_CONSOLAS;
    }

    @Override
    public void recargarApariencia() {
        this.aplicarApariencia();
    }

    protected abstract void aplicarApariencia();

    @Override
    public void init() {
        this.configurarVentanaBase();
        this.inicializarComponentesBase();
        this.cargarConsolas();
        this.precargarLineasEnSegundoPlano();
        this.setVisible(true);
    }

    public static class ErrorDeLectador {
        public Consola consola;
        public int numero_de_linea;
        public Verificaciones verificacion;

        public ErrorDeLectador(Consola consola, int numero_de_linea, Verificaciones verificacion) {
            this.consola = consola;
            this.numero_de_linea = numero_de_linea;
            this.verificacion = verificacion;
        }

        public Color obtenerColor() {
            return this.verificacion.nivel_de_criticalidad().color;
        }

        public String toString() {
            return "lectador://" + this.consola.archivo.toString() + ":" + String.valueOf(this.numero_de_linea);
        }

        public int obtenerLinea() {
            return this.numero_de_linea;
        }
    }
}

