/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.lectador;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.lectador.LectadorDeConsolasGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.imageio.ImageIO;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LectadorDeConsolasHoloTalk
extends LectadorDeConsolasGUI {
    public static String ID = "holotalk";
    private static final long serialVersionUID = 1L;

    public LectadorDeConsolasHoloTalk() {
        this.colorFondo = ConfigColor.de("tema.holotalk.lectador.color.fondo", Color.BLACK);
        this.colorTexto = ConfigColor.de("tema.holotalk.lectador.color.texto", Color.WHITE);
        this.colorError = ConfigColor.de("tema.holotalk.lectador.color.error", new Color(255, 165, 0));
        this.colorPila = ConfigColor.de("tema.holotalk.lectador.color.pila", Color.BLUE);
        this.colorFondoPanel = ConfigColor.de("tema.holotalk.lectador.color.fondo.panel", new Color(30, 30, 30));
        this.colorTextoPanel = ConfigColor.de("tema.holotalk.lectador.color.texto.panel", new Color(200, 200, 200));
        this.colorTextoNegro = ConfigColor.de("tema.holotalk.lectador.color.texto.negro", Color.BLACK);
    }

    @Override
    protected void aplicarApariencia() {
        if (this.getContentPane() instanceof JLayeredPane) {
            this.instalarFondoApariencia((JLayeredPane)this.getContentPane());
        }
        this.repaint();
    }

    @Override
    protected String textoNormalLeyenda() {
        return "Texto normal";
    }

    @Override
    protected void instalarFondoApariencia(JLayeredPane capa) {
        final FondoPanel fondo = new FondoPanel(Statics.carpeta.resolve("imagenes/kiara_ame.png").toString());
        fondo.setBounds(0, 0, this.getWidth(), this.getHeight());
        capa.add((Component)fondo, JLayeredPane.DEFAULT_LAYER);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (fondo != null) {
                    fondo.setBounds(0, 0, LectadorDeConsolasHoloTalk.this.getWidth(), LectadorDeConsolasHoloTalk.this.getHeight());
                }
            }
        });
        fondo.cargarAsincrono(this.pool, new Runnable(){

            @Override
            public void run() {
                LectadorDeConsolasHoloTalk.this.repaint();
            }
        });
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void init() {
        super.init();
        this.aplicarApariencia();
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.colorError.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorError());
        this.colorPila.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorPila());
        this.colorFondoPanel.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoPanel());
        this.colorTextoPanel.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTextoPanel());
        this.colorTextoNegro.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTextoNegro());
        elementos.add(this.colorFondo);
        elementos.add(this.colorTexto);
        elementos.add(this.colorError);
        elementos.add(this.colorPila);
        elementos.add(this.colorFondoPanel);
        elementos.add(this.colorTextoPanel);
        elementos.add(this.colorTextoNegro);
        return elementos;
    }

    @Override
    public void procesarHipervinculo(String url) {
        try {
            String sinPrefijo = url.substring("lectador://".length());
            CrashDetectorLogger.log("sin prefijo " + sinPrefijo);
            int idx = sinPrefijo.lastIndexOf(":");
            if (idx == -1) {
                CrashDetectorLogger.logException(new IllegalArgumentException("URL de lectador inv\u00e1lida: " + url));
                return;
            }
            String rutaArchivo = sinPrefijo.substring(0, idx);
            final int numeroLinea = Integer.parseInt(sinPrefijo.substring(idx + 1));
            CrashDetectorLogger.log("ruta " + rutaArchivo);
            Consola consolaSeleccionada = null;
            for (Consola c : MonitorDePID.consolas) {
                if (!c.archivo.toString().equals(rutaArchivo)) continue;
                consolaSeleccionada = c;
                break;
            }
            if (consolaSeleccionada == null) {
                JOptionPane.showMessageDialog(null, "No se encontr\u00f3 la consola para el archivo: " + rutaArchivo, "Error", 0);
                return;
            }
            CrashDetectorLogger.log("seleccionada " + consolaSeleccionada.archivo.toString());
            final LectadorDeConsolasHoloTalk lector = new LectadorDeConsolasHoloTalk();
            lector.init();
            lector.setVisible(true);
            final String nombreArchivo = new File(consolaSeleccionada.archivo.toString()).getName();
            lector.cmbConsolas.setSelectedItem(nombreArchivo);
            final Consola consolaFinal = consolaSeleccionada;
            lector.pool.submit(new Runnable(){

                @Override
                public void run() {
                    List<String> lineas = (List<String>)lector.cacheLineasPorConsola.get(nombreArchivo);
                    if (lineas == null) {
                        lineas = Arrays.asList(consolaFinal.contenido_verificar.split(Verificaciones.nl));
                        lector.cacheLineasPorConsola.put(nombreArchivo, lineas);
                    }
                    final List<String> lineasFinal = lineas;
                    final int salto = Math.max(0, Math.min(numeroLinea, lineasFinal.size() - 1));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            lector.refrescarModeloCon(lineasFinal);
                            try {
                                if (salto >= 0 && salto < lector.lineasActuales.size()) {
                                    lector.listaRegistros.setSelectedIndex(salto);
                                    lector.listaRegistros.ensureIndexIsVisible(salto);
                                    lector.listaRegistros.requestFocus();
                                    CrashDetectorLogger.log("l\u00ednea seleccionada en JList: " + salto);
                                }
                            }
                            catch (Exception ex) {
                                CrashDetectorLogger.logException(ex);
                            }
                        }
                    });
                }
            });
        }
        catch (Exception ex) {
            CrashDetectorLogger.logException(ex);
        }
    }

    private static class FondoPanel
    extends JPanel {
        private volatile Image imagen;
        private final String ruta;

        public FondoPanel(String ruta) {
            this.ruta = ruta;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.imagen != null) {
                g.drawImage(this.imagen, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        }

        public void cargarAsincrono(ExecutorService pool, final Runnable whenLoadedOnEDT) {
            pool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        imagen = ImageIO.read(new File(ruta));
                    }
                    catch (Exception ex) {
                        CrashDetectorLogger.log("No se pudo cargar fondo: " + ex.getMessage());
                    }
                    SwingUtilities.invokeLater(whenLoadedOnEDT);
                }
            });
        }
    }
}

