/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.lfpdppp;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.lfpdppp.LeyFederalDeProteccionDeDatosPersonalesEnPosesionDeLosParticularesGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LeyFederalDeProteccionDeDatosPersonalesEnPosesionDeLosParticularesGUIConLogos
extends LeyFederalDeProteccionDeDatosPersonalesEnPosesionDeLosParticularesGUI {
    private static final long serialVersionUID = 1L;
    public static String ID = "lfpdppp_con_logos";
    private ConfigColor colorFondo = ConfigColor.de("tema.lfpdppp.color.fondo", new Color(240, 240, 240));
    private ConfigColor colorTexto = ConfigColor.de("tema.lfpdppp.color.texto", new Color(30, 30, 30));
    private ConfigColor colorBoton = ConfigColor.de("tema.lfpdppp.color.boton", new Color(120, 120, 120));
    private JLabel textoPrincipal;
    private JCheckBox checkPermanente;
    private JButton botonAceptar;
    private JButton botonCancelar;
    private JPanel panelRaiz;

    @Override
    public void init() {
        this.setTitle(MonitorDePID.idioma.tituloLFPDPPP());
        this.setModal(true);
        this.setResizable(false);
        this.setMinimumSize(new Dimension(640, 420));
        this.panelRaiz = new JPanel(new BorderLayout(10, 10));
        this.panelRaiz.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.getContentPane().add(this.panelRaiz);
        JPanel panelLogos = new JPanel(new GridLayout(1, 3, 12, 0));
        panelLogos.setOpaque(false);
        panelLogos.add(this.crearLogo("imagenes/profeco.jpg"));
        panelLogos.add(this.crearLogo("imagenes/edps.png"));
        panelLogos.add(this.crearLogo("imagenes/ppc_jp.png"));
        this.panelRaiz.add((Component)panelLogos, "North");
        this.textoPrincipal = new JLabel("<html><body style='width:560px'>" + MonitorDePID.idioma.arco() + "</body></html>");
        this.panelRaiz.add((Component)this.textoPrincipal, "Center");
        JPanel panelInferior = new JPanel(new BorderLayout());
        this.checkPermanente = new JCheckBox(MonitorDePID.idioma.aceptarPermanentemente());
        panelInferior.add((Component)this.checkPermanente, "North");
        JPanel panelBotones = new JPanel(new FlowLayout(2));
        this.botonAceptar = new JButton(MonitorDePID.idioma.aceptar());
        this.botonCancelar = new JButton(MonitorDePID.idioma.cancelar());
        panelBotones.add(this.botonCancelar);
        panelBotones.add(this.botonAceptar);
        panelInferior.add((Component)panelBotones, "South");
        this.panelRaiz.add((Component)panelInferior, "South");
        this.aplicarApariencia();
        this.agregarListeners();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JLabel crearLogo(String ruta) {
        JLabel l = new JLabel();
        try {
            Image img = new ImageIcon(Statics.carpeta.resolve(ruta).toFile().toURL()).getImage();
            int max = 110;
            int w = img.getWidth(null);
            int h = img.getHeight(null);
            float escala = Math.min((float)max / (float)w, (float)max / (float)h);
            Image esc = img.getScaledInstance((int)((float)w * escala), (int)((float)h * escala), 4);
            l.setIcon(new ImageIcon(esc));
        }
        catch (Exception e) {
            CrashDetectorLogger.logException(e);
        }
        return l;
    }

    private void agregarListeners() {
        this.botonAceptar.addActionListener(e -> {
            if (this.checkPermanente.isSelected()) {
                this.guardarConsentimiento();
            }
            if (this.despuesDeAceptar != null) {
                try {
                    this.despuesDeAceptar.run();
                }
                catch (Throwable t) {
                    CrashDetectorLogger.logException(t);
                }
            }
            this.dispose();
        });
        this.botonCancelar.addActionListener(e -> this.dispose());
    }

    @Override
    public void aplicarApariencia() {
        this.panelRaiz.setBackground(this.colorFondo.obtener());
        this.textoPrincipal.setForeground(this.colorTexto.obtener());
        this.checkPermanente.setForeground(this.colorTexto.obtener());
        this.botonAceptar.setBackground(this.colorBoton.obtener());
        this.botonCancelar.setBackground(this.colorBoton.obtener());
        this.botonAceptar.setFont(new Font("Segoe UI", 0, 14));
        this.botonCancelar.setFont(new Font("Segoe UI", 0, 14));
        this.revalidate();
        this.repaint();
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoVentana());
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        elementos.add(this.colorFondo);
        elementos.add(this.colorTexto);
        elementos.add(this.colorBoton);
        return elementos;
    }
}

