/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.mcreator;

import com.asbestosstar.crashdetector.EscanerMCreator;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import java.awt.BorderLayout;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

public abstract class EscanerMCreatorGUI
extends JFrame
implements CrashDetectorGUI,
BotonDeBarraLateralDerecha {
    private static final long serialVersionUID = 1L;
    public static Map<String, Supplier<EscanerMCreatorGUI>> GUIS = new HashMap<String, Supplier<EscanerMCreatorGUI>>();
    protected JTextArea areaResultados;
    protected JLabel etiquetaEstado;
    protected JButton botonEscanear;
    protected JPanel panelContenido;
    protected JPanel panelContenidoConImagen;
    protected JScrollPane panelDesplazamiento;

    protected void aplicarColor(JLabel label, ConfigColor color) {
        label.setForeground(color.obtener());
    }

    protected void aplicarFondo(JComponent component, ConfigColor color) {
        component.setBackground(color.obtener());
        component.setOpaque(true);
    }

    protected void iniciarEscaneo() {
        this.areaResultados.setText("");
        this.etiquetaEstado.setText(this.textoEstadoCargando());
        this.botonEscanear.setEnabled(false);
        new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() {
                return EscanerMCreator.obtainerMCreatorMods();
            }

            @Override
            protected void done() {
                try {
                    String resultado = (String)this.get();
                    EscanerMCreatorGUI.this.areaResultados.setText(resultado);
                    EscanerMCreatorGUI.this.etiquetaEstado.setText(EscanerMCreatorGUI.this.textoEstadoCompletado());
                }
                catch (Exception ex) {
                    EscanerMCreatorGUI.this.areaResultados.setText("Error: " + ex.getMessage());
                    EscanerMCreatorGUI.this.etiquetaEstado.setText(EscanerMCreatorGUI.this.textoEstadoError());
                }
                finally {
                    EscanerMCreatorGUI.this.botonEscanear.setEnabled(true);
                }
            }
        }.execute();
    }

    protected Font fuenteDescripcion() {
        return new Font("Segoe UI", 0, 14);
    }

    protected Font fuenteResultados() {
        return new Font("Consolas", 0, 12);
    }

    protected Font fuenteBoton() {
        return new Font("Segoe UI", 1, 14);
    }

    protected ImageIcon iconoDecorativo() {
        return null;
    }

    protected String textoEstadoCargando() {
        return "cargando";
    }

    protected String textoEstadoCompletado() {
        return "completado";
    }

    protected String textoEstadoError() {
        return "error";
    }

    protected String tituloVentanaNoLocalizado() {
        return null;
    }

    @Override
    public void recargarApariencia() {
        this.aplicarApariencia();
    }

    @Override
    public void init() {
        this.setTitle("Escaner MCreator");
        this.setSize(800, 600);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout(10, 10));
        this.construirEstructuraBase();
        this.aplicarApariencia();
        this.setVisible(true);
    }

    protected abstract void construirEstructuraBase();

    protected abstract void aplicarApariencia();

    @Override
    public TipoGUI<EscanerMCreatorGUI> tipo() {
        return TipoGUI.ESCANER_MCREATOR;
    }
}

