/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.mcreator;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.mcreator.EscanerMCreatorGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class EscanerMCreatorGUIRosemiLoveLock
extends EscanerMCreatorGUI {
    private static final long serialVersionUID = 1L;
    public static final String ID = "rosemi_lovelock";
    public ConfigColor colorFondoVentana = ConfigColor.de("tema.rosemi_lovelock.mcreator.color.fondo.ventana", new Color(229, 175, 177));
    public ConfigColor colorTextoPrincipal = ConfigColor.de("tema.rosemi_lovelock.mcreator.color.texto.principal", new Color(51, 51, 51));
    public ConfigColor colorFondoResultados = ConfigColor.de("tema.rosemi_lovelock.mcreator.color.fondo.resultados", new Color(255, 230, 237));
    public ConfigColor colorEstado = ConfigColor.de("tema.rosemi_lovelock.mcreator.color.estado", new Color(220, 220, 220));
    public ConfigColor colorBotonFondo = ConfigColor.de("tema.rosemi_lovelock.mcreator.color.boton.fondo", new Color(255, 153, 180));
    public ConfigColor colorBotonTexto = ConfigColor.de("tema.rosemi_lovelock.mcreator.color.boton.texto", Color.WHITE);
    public ConfigColor colorBordeScroll = ConfigColor.de("tema.rosemi_lovelock.mcreator.color.borde.scroll", new Color(255, 193, 208));
    public ConfigColor colorTextoDescripcion = ConfigColor.de("tema.rosemi_lovelock.mcreator.color.texto.descripcion", Color.WHITE);
    public ConfigColor colorTextoExtra;
    public ConfigColor colorTextoEstado;

    @Override
    public void init() {
        super.init();
        this.aplicarAparienciaAdicional();
    }

    private void aplicarAparienciaAdicional() {
        Component[] components;
        for (Component comp : components = this.panelContenido.getComponents()) {
            Component[] panelComponents;
            if (!(comp instanceof JPanel)) continue;
            JPanel panel = (JPanel)comp;
            for (Component panelComp : panelComponents = panel.getComponents()) {
                JLabel label;
                String labelText;
                if (!(panelComp instanceof JLabel) || (labelText = (label = (JLabel)panelComp).getText()) == null || !labelText.contains(MonitorDePID.idioma.descripcionEscanerMCreator())) continue;
                label.setBackground(this.colorBordeScroll.obtener());
                label.setOpaque(true);
                label.setForeground(this.colorTextoDescripcion.obtener());
                label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
        }
        if (this.etiquetaEstado != null) {
            this.etiquetaEstado.setBackground(this.colorEstado.obtener());
            this.etiquetaEstado.setForeground(this.colorTextoEstado.obtener());
            this.etiquetaEstado.setOpaque(true);
            this.etiquetaEstado.setPreferredSize(new Dimension(0, 30));
            this.etiquetaEstado.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(200, 200, 200)));
        }
        if (this.panelDesplazamiento != null) {
            this.panelDesplazamiento.setBorder(BorderFactory.createLineBorder(this.colorBordeScroll.obtener()));
        }
        if (this.areaResultados != null) {
            this.areaResultados.setBorder(BorderFactory.createLineBorder(this.colorBordeScroll.obtener()));
            this.areaResultados.setMargin(new Insets(10, 10, 10, 10));
        }
        if (this.botonEscanear != null) {
            this.botonEscanear.setBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)));
        }
        if (this.panelContenidoConImagen != null) {
            this.panelContenidoConImagen.setMaximumSize(new Dimension(9999, 9999));
        }
    }

    @Override
    protected Font fuenteDescripcion() {
        return new Font("Segoe UI", 1, 16);
    }

    @Override
    protected Font fuenteResultados() {
        return new Font("Segoe UI", 0, 15);
    }

    @Override
    protected Font fuenteBoton() {
        return new Font("Segoe UI", 1, 17);
    }

    @Override
    protected ImageIcon iconoDecorativo() {
        try {
            File archivoImagen = Statics.carpeta.resolve("imagenes/rosemi.png").toFile();
            if (archivoImagen.exists()) {
                BufferedImage originalImage = ImageIO.read(archivoImagen);
                Image image = originalImage.getScaledInstance(200, 250, 4);
                return new ImageIcon(image);
            }
        }
        catch (Exception e) {
            System.err.println("Error al cargar la imagen decorativa: " + e.getMessage());
        }
        return null;
    }

    @Override
    protected String textoEstadoCargando() {
        return "Escaneando archivos...";
    }

    @Override
    protected String textoEstadoCompletado() {
        return "Escaneo completado";
    }

    @Override
    protected String textoEstadoError() {
        return "Error en escaneo";
    }

    @Override
    protected String tituloVentanaNoLocalizado() {
        return "Escaneo MCreator - Rosemi LoveLock";
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorFondoVentana.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoVentana());
        this.colorTextoPrincipal.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTextoPrincipal());
        this.colorFondoResultados.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoResultados());
        this.colorEstado.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorEstado());
        this.colorBotonFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBotonFondo());
        this.colorBotonTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBotonTexto());
        this.colorBordeScroll.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBordeScroll());
        this.colorTextoDescripcion.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTextoDescripcion());
        elementos.add(this.colorFondoVentana);
        elementos.add(this.colorTextoPrincipal);
        elementos.add(this.colorFondoResultados);
        elementos.add(this.colorEstado);
        elementos.add(this.colorBotonFondo);
        elementos.add(this.colorBotonTexto);
        elementos.add(this.colorBordeScroll);
        elementos.add(this.colorTextoDescripcion);
        return elementos;
    }

    @Override
    protected void aplicarApariencia() {
        this.getContentPane().setBackground(this.colorFondoVentana.obtener());
        this.panelContenido.setBackground(this.colorFondoVentana.obtener());
        this.panelContenidoConImagen.setBackground(this.colorFondoVentana.obtener());
        this.setBackground(this.colorFondoVentana.obtener());
        this.areaResultados.setForeground(this.colorTextoPrincipal.obtener());
        this.areaResultados.setBackground(this.colorFondoResultados.obtener());
        this.etiquetaEstado.setForeground(this.colorEstado.obtener());
        if (!System.getProperty("os.name").toLowerCase().contains("mac")) {
            this.botonEscanear.setBackground(this.colorBotonFondo.obtener());
        }
        this.botonEscanear.setForeground(this.colorBotonTexto.obtener());
        String titulo = this.tituloVentanaNoLocalizado();
        if (titulo != null && !titulo.isEmpty()) {
            this.setTitle(titulo);
        }
    }

    @Override
    protected void construirEstructuraBase() {
        this.panelContenido = new JPanel(new BorderLayout(10, 10));
        this.panelContenido.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.add((Component)this.panelContenido, "Center");
        JLabel etiquetaDescripcion = new JLabel("<html><div style='text-align: center;'>" + MonitorDePID.idioma.descripcionEscanerMCreator() + "</div></html>", 0);
        etiquetaDescripcion.setFont(this.fuenteDescripcion());
        this.aplicarColor(etiquetaDescripcion, this.colorTextoDescripcion);
        etiquetaDescripcion.setOpaque(true);
        this.areaResultados = new JTextArea();
        this.areaResultados.setEditable(false);
        this.areaResultados.setFont(this.fuenteResultados());
        this.areaResultados.setLineWrap(true);
        this.areaResultados.setWrapStyleWord(true);
        this.areaResultados.setOpaque(true);
        this.panelDesplazamiento = new JScrollPane(this.areaResultados);
        this.panelDesplazamiento.setBorder(BorderFactory.createLineBorder(this.colorBordeScroll.obtener()));
        JLabel etiquetaImagen = null;
        ImageIcon icono = this.iconoDecorativo();
        if (icono != null && icono.getIconWidth() > 0) {
            Image img = icono.getImage().getScaledInstance(200, 112, 4);
            ImageIcon esc = new ImageIcon(img);
            etiquetaImagen = new JLabel(esc);
            etiquetaImagen.setPreferredSize(new Dimension(200, 112));
            etiquetaImagen.setHorizontalAlignment(0);
            etiquetaImagen.setAlignmentX(0.5f);
        }
        this.panelContenidoConImagen = new JPanel();
        this.panelContenidoConImagen.setLayout(new BoxLayout(this.panelContenidoConImagen, 1));
        this.panelContenidoConImagen.add(this.panelDesplazamiento);
        if (etiquetaImagen != null) {
            this.panelContenidoConImagen.add(etiquetaImagen);
        }
        this.etiquetaEstado = new JLabel(" ");
        this.etiquetaEstado.setHorizontalAlignment(0);
        this.aplicarColor(this.etiquetaEstado, this.colorEstado);
        this.etiquetaEstado.setOpaque(true);
        this.botonEscanear = new JButton(MonitorDePID.idioma.escanear());
        this.botonEscanear.setFocusPainted(false);
        this.botonEscanear.setFont(this.fuenteBoton());
        this.botonEscanear.setPreferredSize(new Dimension(200, 50));
        this.botonEscanear.addActionListener(e -> this.iniciarEscaneo());
        JPanel panelSuperior = new JPanel(new BorderLayout(10, 10));
        panelSuperior.add((Component)etiquetaDescripcion, "Center");
        panelSuperior.add((Component)this.botonEscanear, "Last");
        this.panelContenido.add((Component)panelSuperior, "North");
        this.panelContenido.add((Component)this.panelContenidoConImagen, "Center");
        this.panelContenido.add((Component)this.etiquetaEstado, "South");
    }
}

