/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.miranda;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.idioma.cumplimiento.ActaDeProteccionDelIdiomaCulturalDePyongyang;
import com.asbestosstar.crashdetector.json.Json;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class DerechosPiratasGUI
extends JDialog
implements CrashDetectorGUI,
BotonDeBarraLateralDerecha {
    private static final long serialVersionUID = 1L;
    public static Map<String, Supplier<DerechosPiratasGUI>> GUIS = new HashMap<String, Supplier<DerechosPiratasGUI>>();
    protected final Path archivo = Statics.carpeta.resolve("derechos_piratas.json");
    protected final Map<String, String> derechos = new HashMap<String, String>();

    protected void cargarDatos() {
        this.derechos.clear();
        if (!Files.exists(this.archivo, new LinkOption[0])) {
            return;
        }
        try {
            String json = new String(Files.readAllBytes(this.archivo), StandardCharsets.UTF_8);
            if (json == null || json.trim().isEmpty()) {
                return;
            }
            Json.Nodo raiz = Json.leer(json);
            if (!raiz.esObjeto()) {
                return;
            }
            for (String k : raiz.claves()) {
                String txt;
                Json.Nodo v = raiz.obtener(k);
                if (v == null || v.esObjeto() || v.esArreglo() || (txt = v.comoCadena()) == null || txt.trim().isEmpty()) continue;
                this.derechos.put(k, txt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void guardarDatos() {
        try {
            Json.Nodo raiz = Json.crearObjeto();
            for (Map.Entry<String, String> e : this.derechos.entrySet()) {
                String v;
                if (e.getKey() == null || (v = e.getValue()) == null || (v = v.trim()).isEmpty()) continue;
                raiz.obtener(e.getKey()).poner(v);
            }
            Files.write(this.archivo, raiz.aBytesUtf8(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dispose();
    }

    @Override
    public TipoGUI tipo() {
        return TipoGUI.MIRANDA;
    }

    protected static String obtenerCodigoIdioma(String nombre) {
        if (nombre == null) {
            return "es";
        }
        switch (nombre) {
            case "Espa\u00f1ol": {
                return "es";
            }
            case "English": {
                return "en";
            }
            case "\u0420\u0443\u0441\u0441\u043a\u0438\u0439": {
                return "ru";
            }
            case "\u7b80\u4f53\u4e2d\u6587": {
                return "zh";
            }
            case "\u0641\u0627\u0631\u0633\u06cc": {
                return "fa";
            }
            case "\ud55c\uad6d\uc5b4": {
                return "ko";
            }
            case "\u65e5\u672c\u8a9e": {
                return "ja";
            }
            case "\u0627\u0644\u0639\u0631\u0628\u064a\u0629": {
                return "ar";
            }
        }
        return "es";
    }

    protected void forzarFondo(JComponent c, Color fondo) {
        if (c == null) {
            return;
        }
        c.setOpaque(true);
        c.setBackground(fondo);
    }

    protected void editarDerechosMultilenguaje(String titulo, Color fondo, Color texto, Color caja, Color borde) {
        if (this.derechos == null) {
            return;
        }
        JDialog dialogo = new JDialog(this, titulo, true);
        dialogo.setLayout(new BorderLayout(10, 10));
        dialogo.setSize(760, 520);
        JPanel panelCampos = new JPanel(new GridBagLayout());
        panelCampos.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panelCampos.setBackground(fondo);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.fill = 1;
        LinkedHashMap<String, String> idiomas = this.mapaParaComboBoxIdiomas();
        int fila = 0;
        HashMap<String, JTextArea> campos = new HashMap<String, JTextArea>();
        for (Map.Entry<String, String> entry : idiomas.entrySet()) {
            String nombreVisible = entry.getKey();
            String rutaBandera = entry.getValue();
            String codigo = DerechosPiratasGUI.obtenerCodigoIdioma(nombreVisible);
            JLabel etiqueta = new JLabel(codigo);
            etiqueta.setFont(new Font("Segoe UI", 1, 12));
            etiqueta.setForeground(texto);
            try {
                File f = Statics.carpeta.resolve(rutaBandera).toFile();
                if (f.exists()) {
                    ImageIcon ic = new ImageIcon(f.getAbsolutePath());
                    Image img = ic.getImage().getScaledInstance(18, 12, 4);
                    etiqueta.setIcon(new ImageIcon(img));
                    etiqueta.setIconTextGap(8);
                }
            }
            catch (Exception f) {
                // empty catch block
            }
            gbc.gridx = 0;
            gbc.gridy = fila++;
            gbc.weightx = 0.15;
            panelCampos.add((Component)etiqueta, gbc);
            JTextArea area = new JTextArea(this.derechos.getOrDefault(codigo, ""));
            area.setLineWrap(true);
            area.setWrapStyleWord(true);
            area.setFont(new Font("Segoe UI", 0, 13));
            area.setBackground(caja);
            area.setForeground(texto);
            area.setCaretColor(texto);
            JScrollPane scroll = new JScrollPane(area);
            scroll.setBorder(BorderFactory.createLineBorder(borde, 1));
            gbc.gridx = 1;
            gbc.weightx = 0.85;
            panelCampos.add((Component)scroll, gbc);
            campos.put(codigo, area);
        }
        JPanel botones = new JPanel(new FlowLayout(2));
        botones.setBackground(fondo);
        JButton ok = new JButton(MonitorDePID.idioma.aceptar());
        JButton cancel = new JButton(MonitorDePID.idioma.cancelar());
        ok.setBackground(borde);
        ok.setForeground(Color.BLACK);
        ok.setFont(new Font("Segoe UI", 1, 12));
        cancel.setBackground(borde);
        cancel.setForeground(Color.BLACK);
        cancel.setFont(new Font("Segoe UI", 1, 12));
        ok.addActionListener(e -> {
            this.derechos.clear();
            for (Map.Entry c : campos.entrySet()) {
                String v = ((JTextArea)c.getValue()).getText().trim();
                if (v.isEmpty()) continue;
                this.derechos.put((String)c.getKey(), v);
            }
            String textoCoreano = this.derechos.get("ko");
            if (textoCoreano != null && !textoCoreano.isEmpty()) {
                ActaDeProteccionDelIdiomaCulturalDePyongyang.contieneJergaSur(textoCoreano);
            }
            dialogo.dispose();
        });
        cancel.addActionListener(e -> dialogo.dispose());
        botones.add(ok);
        botones.add(cancel);
        dialogo.add((Component)new JScrollPane(panelCampos), "Center");
        dialogo.add((Component)botones, "South");
        dialogo.setLocationRelativeTo(this);
        dialogo.setVisible(true);
    }
}

