/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.miranda;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.miranda.DerechosPiratasGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DerechosPiratasGUIOnePiece
extends DerechosPiratasGUI {
    private static final long serialVersionUID = 1L;
    public static final String ID = "one_piece";
    public static File imagen = Statics.carpeta.resolve("imagenes/onepeice.png").toFile();
    private ConfigColor fondo = ConfigColor.de("tema.onepiece.fondo", new Color(20, 20, 20));
    private ConfigColor texto = ConfigColor.de("tema.onepiece.texto", Color.WHITE);
    private ConfigColor caja = ConfigColor.de("tema.onepiece.caja", new Color(35, 35, 35));
    private ConfigColor borde = ConfigColor.de("tema.onepiece.borde", new Color(200, 180, 40));
    private JTextArea areaDescripcion;
    private JButton botonEditar;
    private JButton botonGuardar;
    private JLabel labelImagen;

    @Override
    public void init() {
        this.setTitle(MonitorDePID.idioma.infoDeDerechosMiranda());
        this.setSize(920, 680);
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.cargarDatos();
        JPanel izq = new JPanel(new BorderLayout(0, 10));
        izq.setPreferredSize(new Dimension(260, 0));
        izq.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.forzarFondo(izq, this.fondo.obtener());
        this.labelImagen = new JLabel();
        this.labelImagen.setHorizontalAlignment(0);
        this.forzarFondo(this.labelImagen, this.fondo.obtener());
        try {
            if (imagen.exists()) {
                ImageIcon ic = new ImageIcon(imagen.getAbsolutePath());
                Image im = ic.getImage().getScaledInstance(240, -1, 4);
                this.labelImagen.setIcon(new ImageIcon(im));
            } else {
                this.labelImagen.setText(MonitorDePID.idioma.imagenNoEncontrada());
                this.labelImagen.setForeground(this.texto.obtener());
            }
        }
        catch (Exception ignored) {
            this.labelImagen.setText(MonitorDePID.idioma.errorCargandoImagen());
            this.labelImagen.setForeground(this.texto.obtener());
        }
        izq.add((Component)this.labelImagen, "North");
        JPanel panelBotonesLateral = new JPanel();
        panelBotonesLateral.setLayout(new BoxLayout(panelBotonesLateral, 1));
        this.forzarFondo(panelBotonesLateral, this.fondo.obtener());
        this.botonEditar = new JButton(MonitorDePID.idioma.editar());
        this.botonEditar.setAlignmentX(0.5f);
        this.botonEditar.addActionListener(e -> this.editarDerechosMultilenguaje(MonitorDePID.idioma.infoDeDerechosMiranda(), this.fondo.obtener(), this.texto.obtener(), this.caja.obtener(), this.borde.obtener()));
        this.botonGuardar = new JButton(MonitorDePID.idioma.guardarCambios());
        this.botonGuardar.setAlignmentX(0.5f);
        this.botonGuardar.addActionListener(e -> this.guardarDatos());
        panelBotonesLateral.add(this.botonEditar);
        panelBotonesLateral.add(Box.createVerticalStrut(8));
        panelBotonesLateral.add(this.botonGuardar);
        panelBotonesLateral.add(Box.createVerticalGlue());
        izq.add((Component)panelBotonesLateral, "Center");
        this.add((Component)izq, "West");
        JPanel centro = new JPanel(new BorderLayout(8, 8));
        this.forzarFondo(centro, this.fondo.obtener());
        centro.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JLabel tituloDesc = new JLabel(MonitorDePID.idioma.descripcionDerechosPirateria());
        tituloDesc.setFont(new Font("Segoe UI", 1, 13));
        tituloDesc.setForeground(this.texto.obtener());
        JPanel panelTituloDesc = new JPanel(new FlowLayout(0, 0, 0));
        this.forzarFondo(panelTituloDesc, this.fondo.obtener());
        panelTituloDesc.add(tituloDesc);
        centro.add((Component)panelTituloDesc, "North");
        this.areaDescripcion = new JTextArea(MonitorDePID.idioma.descripcionDerechosPirateria());
        this.areaDescripcion.setWrapStyleWord(true);
        this.areaDescripcion.setLineWrap(true);
        this.areaDescripcion.setEditable(false);
        this.areaDescripcion.setFont(new Font("Segoe UI", 0, 13));
        this.areaDescripcion.setBackground(this.caja.obtener());
        this.areaDescripcion.setForeground(this.texto.obtener());
        this.areaDescripcion.setBorder(BorderFactory.createLineBorder(this.borde.obtener(), 1));
        JScrollPane sp = new JScrollPane(this.areaDescripcion);
        sp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        centro.add((Component)sp, "Center");
        this.add((Component)centro, "Center");
        this.setLocationRelativeTo(null);
        this.recargarApariencia();
        this.setVisible(true);
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> l = new ArrayList<ElementoConfig>();
        this.fondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        l.add(this.fondo);
        this.texto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        l.add(this.texto);
        this.caja.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorCajaTexto());
        l.add(this.caja);
        this.borde.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
        l.add(this.borde);
        return l;
    }

    @Override
    public void recargarApariencia() {
        this.getContentPane().setBackground(this.fondo.obtener());
        if (this.labelImagen != null) {
            this.labelImagen.setBackground(this.fondo.obtener());
            this.labelImagen.setForeground(this.texto.obtener());
        }
        if (this.areaDescripcion != null) {
            this.areaDescripcion.setBackground(this.caja.obtener());
            this.areaDescripcion.setForeground(this.texto.obtener());
            this.areaDescripcion.setCaretColor(this.texto.obtener());
            this.areaDescripcion.setBorder(BorderFactory.createLineBorder(this.borde.obtener(), 1));
        }
        JButton[] bs = new JButton[]{this.botonEditar, this.botonGuardar};
        for (JButton b : bs) {
            if (b == null) continue;
            b.setBackground(this.borde.obtener());
            b.setForeground(Color.BLACK);
            b.setFocusPainted(false);
            b.setFont(new Font("Segoe UI", 1, 12));
            b.setBorder(BorderFactory.createEmptyBorder(8, 14, 8, 14));
        }
        for (Component c : this.getContentPane().getComponents()) {
            this.aplicarFondoRecursivo(c);
        }
        this.revalidate();
        this.repaint();
    }

    private void aplicarFondoRecursivo(Component c) {
        if (c instanceof JPanel) {
            c.setBackground(this.fondo.obtener());
            for (Component h : ((JPanel)c).getComponents()) {
                this.aplicarFondoRecursivo(h);
            }
        }
    }
}

